/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.tools;

import com.sun.identity.cli.annotation.DefinitionClassInfo;
import com.sun.identity.cli.annotation.Macro;
import com.sun.identity.cli.annotation.ResourceStrings;
import com.sun.identity.cli.annotation.SubCommandInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CLIDefinitionGenerator {
    private static Map<String, String> mapLongToShortOptionName = new HashMap<String, String>();

    public static void main(String[] argv) {
        String resourceDir = argv[0];
        for (int i = 1; i < argv.length; ++i) {
            String className = argv[i];
            try {
                Class<?> clazz = Class.forName(className);
                Field pdtField = clazz.getDeclaredField("product");
                if (pdtField != null) {
                    DefinitionClassInfo classInfo = pdtField.getAnnotation(DefinitionClassInfo.class);
                    try {
                        PrintStream rbOut = CLIDefinitionGenerator.createResourcePrintStream(resourceDir, classInfo);
                        CLIDefinitionGenerator.getCommonResourceStrings(rbOut, clazz);
                        rbOut.println("product-name=" + classInfo.productName());
                        CLIDefinitionGenerator.getCommands(className, clazz, rbOut);
                        rbOut.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    continue;
                }
                throw new Exception("Incorrect Definiton, class=" + className + " missing product field");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void getCommonResourceStrings(PrintStream rbOut, Class clazz) throws Exception {
        Field field = clazz.getDeclaredField("resourcestrings");
        if (field != null) {
            ResourceStrings resStrings = field.getAnnotation(ResourceStrings.class);
            List list = CLIDefinitionGenerator.toList(resStrings.string());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                rbOut.println((String)i.next());
            }
        }
    }

    private static PrintStream createResourcePrintStream(String resourceDir, DefinitionClassInfo classInfo) throws IOException {
        String filePath = resourceDir + File.separator + classInfo.resourceBundle() + ".properties";
        File rbFile = new File(filePath);
        rbFile.createNewFile();
        FileOutputStream rbStream = new FileOutputStream(rbFile);
        return new PrintStream(rbStream);
    }

    private static void getCommands(String className, Class clazz, PrintStream rbOut) throws Exception {
        Field[] fields;
        for (Field fld : fields = clazz.getDeclaredFields()) {
            SubCommandInfo info = fld.getAnnotation(SubCommandInfo.class);
            if (info == null) continue;
            if (info.implClassName() == null || info.description() == null) {
                throw new Exception("Incorrect Definition, class=" + className + " field=" + fld.toString());
            }
            List mandatoryOptions = CLIDefinitionGenerator.toList(info.mandatoryOptions());
            List optionalOptions = CLIDefinitionGenerator.toList(info.optionalOptions());
            List optionAliases = CLIDefinitionGenerator.toList(info.optionAliases());
            if (info.macro() != null && info.macro().length() > 0) {
                Field fldMarco = clazz.getDeclaredField(info.macro());
                Macro macroInfo = fldMarco.getAnnotation(Macro.class);
                CLIDefinitionGenerator.appendToList(mandatoryOptions, macroInfo.mandatoryOptions());
                CLIDefinitionGenerator.appendToList(optionalOptions, macroInfo.optionalOptions());
                CLIDefinitionGenerator.appendToList(optionAliases, macroInfo.optionAliases());
            }
            CLIDefinitionGenerator.validateOption(mandatoryOptions);
            CLIDefinitionGenerator.validateOption(optionalOptions);
            String subcmdName = fld.getName().replace('_', '-');
            String resPrefix = "subcmd-" + subcmdName;
            String desc = info.description().replaceAll("&#124;", "|");
            rbOut.println(resPrefix + "=" + desc);
            CLIDefinitionGenerator.createResourceForOptions(resPrefix + "-", mandatoryOptions, rbOut);
            CLIDefinitionGenerator.createResourceForOptions(resPrefix + "-", optionalOptions, rbOut);
            CLIDefinitionGenerator.addResourceStrings(CLIDefinitionGenerator.toList(info.resourceStrings()), rbOut);
        }
    }

    private static void validateOption(List options) {
        for (String option : options) {
            int idx = option.indexOf(124);
            String longName = option.substring(0, idx);
            String shortName = option.substring(idx + 1, idx + 2);
            String test = mapLongToShortOptionName.get(longName);
            if (test == null) {
                mapLongToShortOptionName.put(longName, shortName);
                continue;
            }
            if (test.equals(shortName)) continue;
            throw new RuntimeException("Mismatched names: " + longName + "-> " + test + ", " + shortName);
        }
    }

    private static void addResourceStrings(List res, PrintStream rbOut) {
        for (String s : res) {
            rbOut.println(s);
        }
    }

    private static void createResourceForOptions(String prefix, List options, PrintStream rbOut) {
        for (String option : options) {
            String opt = option.substring(0, option.indexOf(124));
            String description = option.substring(option.lastIndexOf(124) + 1);
            Object webDescription = null;
            int idxWeb = description.indexOf("<web>");
            if (idxWeb != -1) {
                rbOut.println(prefix + "__web__-" + opt + "=" + description.substring(idxWeb + 5));
                description = description.substring(0, idxWeb);
            }
            rbOut.println(prefix + opt + "=" + description);
        }
    }

    public static List toList(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
        return list;
    }

    public static void appendToList(List list, String[] array) {
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
    }
}

