/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

public class AddSiteFailoverURLs
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String siteName = this.getStringOptionValue("sitename");
        List secondaryURLs = rc.getOption("secondaryurls");
        String[] params = new String[]{siteName};
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SITE_FAILOVER_URLS", params);
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                SiteConfiguration.addSiteSecondaryURLs(adminSSOToken, siteName, secondaryURLs);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-site-secondary-urls-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-site-secondary-urls-no-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_SITE_FAILOVER_URLS", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteFailoverURLs.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_FAILOVER_URLS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteFailoverURLs.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_FAILOVER_URLS", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteFailoverURLs.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_FAILOVER_URLS", args);
            throw new CLIException(e, 127);
        }
    }
}

