/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetServiceSchemaI18nKey
extends SchemaCommand {
    static final String ARGUMENT_I18N_KEY = "i18nkey";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String i18nKey = this.getStringOptionValue(ARGUMENT_I18N_KEY);
        ServiceSchemaManager ssm = this.getServiceSchemaManager();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, i18nKey};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SERVICE_SCHEMA_I18N_KEY", params);
            ssm.setI18NKey(i18nKey);
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SERVICE_SCHEMA_I18N_KEY", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("service-schema-set-i18n-key-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, i18nKey, e.getMessage()};
            this.debugError("SetServiceSchemaI18nKey.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_SCHEMA_I18N_KEY", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, i18nKey, e.getMessage()};
            this.debugError("SetServiceSchemaI18nKey.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_SCHEMA_I18N_KEY", args);
            throw new CLIException(e, 127);
        }
    }
}

