/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetServiceRevisionNumber
extends SchemaCommand {
    static final String ARGUMENT_VERSION = "revisionnumber";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String rev = this.getStringOptionValue(ARGUMENT_VERSION);
        ServiceSchemaManager ssm = this.getServiceSchemaManager();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, rev};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SERVICE_REVISION_NUMBER", params);
            ssm.setRevisionNumber(Integer.parseInt(rev));
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SERVICE_REVISION_NUMBER", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("service-schema-set-revision-number-succeed"), params));
        }
        catch (NumberFormatException e) {
            String[] args = new String[]{serviceName, rev, e.getMessage()};
            this.debugError("SetServiceRevisionNumber.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_REVISION_NUMBER", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, rev, e.getMessage()};
            this.debugError("SetServiceRevisionNumber.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_REVISION_NUMBER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, rev, e.getMessage()};
            this.debugError("SetServiceRevisionNumber.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_REVISION_NUMBER", args);
            throw new CLIException(e, 127);
        }
    }
}

