/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetAttributeSchemaEndRange
extends SchemaCommand {
    static final String ARGUMENT_RANGE = "range";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeSchemaName = this.getStringOptionValue("attributeschema");
        String range = this.getStringOptionValue(ARGUMENT_RANGE);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, range};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_ATTRIBUTE_SCHEMA_END_RANGE", params);
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeSchemaName);
            attrSchema.setEndRange(range);
            this.writeLog(0, Level.INFO, "SUCCEED_SET_ATTRIBUTE_SCHEMA_END_RANGE", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-set-end-range-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, range, e.getMessage()};
            this.debugError("SetAttributeSchemaEndRange.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_ATTRIBUTE_SCHEMA_END_RANGE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, range, e.getMessage()};
            this.debugError("SetAttributeSchemaEndRange.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_ATTRIBUTE_SCHEMA_END_RANGE", args);
            throw new CLIException(e, 127);
        }
    }
}

