/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RemoveAttributeSchemaDefaultValues
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeSchemaName = this.getStringOptionValue("attributeschema");
        List defaultValues = rc.getOption("defaultvalues");
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String defaultValue = null;
        try {
            Iterator i = defaultValues.iterator();
            while (i.hasNext()) {
                defaultValue = (String)i.next();
                String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, defaultValue};
                this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_ATTRIBUTE_SCHEMA_DEFAULT_VALUE", params);
                AttributeSchema attrSchema = ss.getAttributeSchema(attributeSchemaName);
                attrSchema.removeDefaultValue(defaultValue);
                this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_ATTRIBUTE_SCHEMA_DEFAULT_VALUE", params);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-remove-default-values-succeed"), params));
            }
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, defaultValue, e.getMessage()};
            this.debugError("RemoveAttributeSchemaDefaultValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA_DEFAULT_VALUE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, defaultValue, e.getMessage()};
            this.debugError("RemoveAttributeSchemaDefaultValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA_DEFAULT_VALUE", args);
            throw new CLIException(e, 127);
        }
    }
}

