/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ModifySubConfiguration
extends SchemaCommand {
    static final String ARGUMENT_OPERATION = "operation";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String subConfigName = this.getStringOptionValue("subconfigname");
        String realmName = this.getStringOptionValue("realm");
        String operation = this.getStringOptionValue(ARGUMENT_OPERATION);
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        if (realmName == null || realmName.length() == 0) {
            this.modifySubConfigRoot(serviceName, subConfigName, attributeValues, operation);
        } else {
            this.modifySubConfigToRealm(realmName, serviceName, subConfigName, attributeValues, operation);
        }
    }

    private void modifySubConfigToRealm(String realmName, String serviceName, String subConfigName, Map attrValues, String operation) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{realmName, subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_SUB_CONFIGURATION_IN_REALM", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getOrganizationConfig(realmName, null);
            if (sc == null) {
                sc = scm.createOrganizationConfig(realmName, null);
            }
            this.modifySubConfig(sc, subConfigName, attrValues, operation);
            this.writeLog(0, Level.INFO, "SUCCEED_MODIFY_SUB_CONFIGURATION_IN_REALM", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("modify-sub-configuration-to-realm-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("ModifySubConfiguration.modifySubConfigToRealm", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_SUB_CONFIGURATIONT_IN_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("ModifySubConfiguration.modifySubConfigToRealm", e);
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_SUB_CONFIGURATIONT_IN_REALM", args);
            throw new CLIException(e, 127);
        }
    }

    private void modifySubConfigRoot(String serviceName, String subConfigName, Map attrValues, String operation) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_MODIFY_SUB_CONFIGURATION", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getGlobalConfig(null);
            this.modifySubConfig(sc, subConfigName, attrValues, operation);
            this.writeLog(0, Level.INFO, "SUCCEED_MODIFY_SUB_CONFIGURATION", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("modify-sub-configuration-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("ModifySubConfiguration.addSubConfigToRoot", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_SUB_CONFIGURATION", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("ModifySubConfiguration.addSubConfigToRoot", e);
            this.writeLog(1, Level.INFO, "FAILED_MODIFY_SUB_CONFIGURATION", args);
            throw new CLIException(e, 127);
        }
    }

    private void modifySubConfig(ServiceConfig sc, String subConfigName, Map attrValues, String operation) throws SSOException, SMSException, CLIException {
        StringTokenizer st = new StringTokenizer(subConfigName, "/");
        int tokenCount = st.countTokens();
        for (int i = 1; i <= tokenCount; ++i) {
            String scn = SMSSchema.unescapeName(st.nextToken());
            sc = sc.getSubConfig(scn);
        }
        if (operation.equals("set")) {
            sc.setAttributes(attrValues);
        } else if (operation.equals("add")) {
            Iterator i = attrValues.keySet().iterator();
            while (i.hasNext()) {
                String attrName = (String)i.next();
                sc.addAttribute(attrName, (Set)attrValues.get(attrName));
            }
        } else if (operation.equals("delete")) {
            Iterator i = attrValues.keySet().iterator();
            while (i.hasNext()) {
                sc.removeAttribute((String)i.next());
            }
        } else {
            throw new CLIException(this.getResourceString("modify-sub-configuration-invalid-operation"), 127);
        }
    }
}

