/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.DNUtils;
import com.sun.identity.log.Level;
import com.sun.identity.security.EncodeAction;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class CreateServerConfigXML
extends AuthenticatedCommand {
    static final String DS_HOST = "dshost";
    static final String DS_PORT = "dsport";
    static final String DS_ADMIN = "dsadmin";
    static final String DS_BASEDN = "basedn";
    private static final String DS_PWD_FILE = "dspassword-file";
    private String dsHost;
    private String dsPort;
    private String dsAdmin;
    private String dsPassword;
    private String basedn;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String outputFile = this.getStringOptionValue("outfile");
        FileOutputStream fout = null;
        String[] param = new String[]{"tty"};
        String[] paramException = new String[]{"tty", ""};
        this.dsHost = this.getStringOptionValue(DS_HOST);
        this.dsPort = this.getStringOptionValue(DS_PORT);
        this.dsAdmin = this.getStringOptionValue(DS_ADMIN);
        String dsPasswordFile = this.getStringOptionValue(DS_PWD_FILE);
        this.basedn = this.getStringOptionValue(DS_BASEDN);
        if (this.dsHost == null || this.dsHost.length() == 0) {
            this.dsHost = "ds.opensso.java.net";
        }
        if (this.dsPort == null || this.dsPort.length() == 0) {
            this.dsPort = "389";
        }
        if (this.dsAdmin == null || this.dsAdmin.length() == 0) {
            this.dsAdmin = "cn=Directory Manager";
        }
        this.dsPassword = dsPasswordFile == null || dsPasswordFile.length() == 0 ? "11111111" : CLIUtil.getFileContent(dsPasswordFile);
        if (this.basedn == null || this.basedn.length() == 0) {
            this.basedn = "dc=opensso,dc=java,dc=net";
        }
        this.dsPassword = (String)AccessController.doPrivileged(new EncodeAction(this.dsPassword));
        try {
            if (outputFile != null && outputFile.length() > 0) {
                fout = new FileOutputStream(outputFile);
                param[0] = outputFile;
                paramException[0] = outputFile;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_SERVERCONFIG_XML", param);
            String template = CreateServerConfigXML.getResource("serverconfig.xml");
            String modified = this.modifyXML(template);
            if (fout != null) {
                fout.write(modified.getBytes());
            } else {
                this.getOutputWriter().printlnMessage(modified);
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_SERVERCONFIG_XML", param);
        }
        catch (IOException e) {
            paramException[1] = e.getMessage();
            this.writeLog(0, Level.INFO, "FAILED_CREATE_SERVERCONFIG_XML", paramException);
            throw new CLIException(e, 127);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResource(String file) throws IOException {
        InputStreamReader fin = null;
        StringBuffer sbuf = new StringBuffer();
        try {
            int len;
            fin = new InputStreamReader(ClassLoader.getSystemResourceAsStream(file));
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
        }
        return sbuf.toString();
    }

    private String modifyXML(String xml) throws CLIException {
        String amadminPwds = CLIUtil.getFileContent(this.getStringOptionValue("password-file"), true);
        amadminPwds = (String)AccessController.doPrivileged(new EncodeAction(amadminPwds));
        String canRootSuffix = this.canonicalize(this.basedn);
        xml = xml.replaceAll("@DIRECTORY_SERVER@", this.dsHost);
        xml = xml.replaceAll("@DIRECTORY_PORT@", this.dsPort);
        xml = xml.replaceAll("@NORMALIZED_ORGBASE@", DNUtils.normalizeDN(this.basedn));
        xml = xml.replaceAll("@DS_DIRMGRDN@", this.dsAdmin);
        xml = xml.replaceAll("@ENCADMINPASSWD@", this.dsPassword);
        xml = xml.replaceAll("@ENCADADMINPASSWD@", amadminPwds);
        xml = xml.replaceAll("@SM_CONFIG_BASEDN@", canRootSuffix);
        xml = xml.replaceAll("@ORG_BASE@", canRootSuffix);
        return xml;
    }

    private String canonicalize(String nSuffix) {
        StringBuffer buff = new StringBuffer(1024);
        DN dn = new DN(nSuffix);
        Vector rdns = dn.getRDNs();
        int sz = rdns.size();
        for (int i = 0; i < sz; ++i) {
            RDN rdn = (RDN)rdns.get(i);
            buff.append(LDAPDN.escapeRDN((String)rdn.toString()));
            if (i >= sz - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }
}

