/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class AddAttributeDefaults
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String attributeName = null;
        try {
            Map mapOldValues = ss.getAttributeDefaults();
            Iterator i = attributeValues.keySet().iterator();
            while (i.hasNext()) {
                attributeName = (String)i.next();
                String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeName};
                this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SCHEMA_ATTR_DEFAULTS", params);
                Set oldValues = (Set)mapOldValues.get(attributeName);
                HashSet newValues = oldValues == null || oldValues.isEmpty() ? new HashSet() : new HashSet(oldValues);
                newValues.addAll((Set)attributeValues.get(attributeName));
                ss.setAttributeDefaults(attributeName, newValues);
                this.writeLog(0, Level.INFO, "SUCCEED_ADD_SCHEMA_ATTR_DEFAULTS", params);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("schema-add-attribute-defaults-succeed"), params));
            }
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("AddAttributeDefaults.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SCHEMA_ATTR_DEFAULTS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("AddAttributeDefaults.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SCHEMA_ATTR_DEFAULTS", args);
            throw new CLIException(e, 127);
        }
    }
}

