/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SearchRealms
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        String strRecursive;
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String pattern = this.getStringOptionValue("filter");
        boolean recursive = this.isOptionSet("recursive");
        String string = strRecursive = recursive ? "recursive" : "non recursive";
        if (pattern == null || pattern.trim().length() == 0) {
            pattern = "*";
        }
        String[] params = new String[]{realm, pattern, strRecursive};
        this.writeLog(0, Level.INFO, "ATTEMPT_SEARCH_REALM", params);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Set results = ocm.getSubOrganizationNames(pattern, recursive);
            IOutput outputWriter = this.getOutputWriter();
            if (results != null && !results.isEmpty()) {
                String template = this.getResourceString("search-realm-results");
                String[] arg = new String[1];
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    arg[0] = (String)i.next();
                    outputWriter.printlnMessage(MessageFormat.format(template, arg));
                }
                outputWriter.printlnMessage(this.getResourceString("search-realm-succeed"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("search-realm-no-results"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SEARCH_REALM", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, strRecursive, e.getMessage()};
            this.debugError("SearchRealms.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SEARCH_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

