/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SearchIdentities
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String type = this.getStringOptionValue("idtype");
        String filter = this.getStringOptionValue("filter");
        String[] params = new String[]{realm, type, filter};
        this.writeLog(0, Level.INFO, "ATTEMPT_SEARCH_IDENTITIES", params);
        try {
            new OrganizationConfigManager(adminSSOToken, realm);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, type, filter, e.getMessage()};
            this.debugError("SearchIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SEARCH_IDENTITIES", args);
            Object[] msgArg = new Object[]{realm};
            throw new CLIException(MessageFormat.format(this.getResourceString("realm-does-not-exist"), msgArg), 127);
        }
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdType idType = this.convert2IdType(type);
            IdSearchResults isr = amir.searchIdentities(idType, filter, new IdSearchControl());
            Set results = isr.getSearchResults();
            if (results != null && !results.isEmpty()) {
                if (idType.equals(IdType.USER)) {
                    IdSearchResults specialUsersResults = amir.getSpecialIdentities(IdType.USER);
                    results.removeAll(specialUsersResults.getSearchResults());
                }
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    AMIdentity amid = (AMIdentity)i.next();
                    String[] args = new String[]{amid.getName(), amid.getUniversalId()};
                    outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("format-search-identities-results"), args));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("search-identities-no-entries"));
            }
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("search-identities-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_SEARCH_IDENTITIES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, filter, e.getMessage()};
            this.debugError("SearchIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SEARCH_IDENTITIES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, filter, e.getMessage()};
            this.debugError("SearchIdentities.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SEARCH_IDENTITIES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

