/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class GetPrivileges
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName};
        try {
            DelegationManager mgr = new DelegationManager(adminSSOToken, realm);
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_GET_PRIVILEGES", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            Set results = mgr.getPrivileges(amid.getUniversalId());
            if (results != null && !results.isEmpty()) {
                String[] param = new String[]{""};
                String msg = this.getResourceString("privilege-result");
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    DelegationPrivilege p = (DelegationPrivilege)i.next();
                    param[0] = p.getName();
                    outputWriter.printlnMessage(MessageFormat.format(msg, param));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("no-privileges"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_GET_PRIVILEGES", params);
        }
        catch (DelegationException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetPrivileges.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_PRIVILEGES", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetPrivileges.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_PRIVILEGES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("GetPrivileges.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_PRIVILEGES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

