/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class CreateIdentity
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        Map attributeValues = Collections.EMPTY_MAP;
        if (datafile != null || attrValues != null) {
            attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        }
        String[] params = new String[]{realm, type, idName};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_IDENTITY", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdType idType = this.convert2IdType(type);
            Set set = amir.getAllowedIdOperations(idType);
            if (!set.contains(IdOperation.CREATE)) {
                String[] args = new String[]{realm, type};
                throw new CLIException(MessageFormat.format(this.getResourceString("does-not-support-creation"), args), 127);
            }
            amir.createIdentity(idType, idName, attributeValues);
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-identity-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_IDENTITY", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("CreateIdentity.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_IDENTITY", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, e.getMessage()};
            this.debugError("CreateIdentity.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_IDENTITY", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

