/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.util.Iterator;
import java.util.Set;

public class ListAuthConfigurations
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_AUTH_CONFIGURATIONS", params);
        try {
            Set configurations = AMAuthConfigUtils.getAllNamedConfig(realm, adminSSOToken);
            if (configurations != null && !configurations.isEmpty()) {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-list-auth-configurations-succeeded"));
                Iterator i = configurations.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    this.getOutputWriter().printlnMessage(name);
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-list-auth-configurations-no-configurations"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_LIST_AUTH_CONFIGURATIONS", params);
        }
        catch (SMSException e) {
            this.debugError("ListAuthConfigurations.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_LIST_AUTH_CONFIGURATIONS", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("ListAuthConfigurations.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_LIST_AUTH_CONFIGURATIONS", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

