/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;

public class CreateAuthConfiguration
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String name = this.getStringOptionValue("name");
        String[] params = new String[]{realm, name};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_AUTH_CONFIGURATION", params);
        try {
            AMAuthConfigUtils.createNamedConfig(name, 0, new HashMap(), realm, adminSSOToken);
            this.getOutputWriter().printlnMessage(this.getResourceString("authentication-created-auth-configuration-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_AUTH_CONFIGURATION", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("CreateAuthConfiguration.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_CREATE_AUTH_CONFIGURATION", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SSOException e) {
            this.debugError("CreateAuthConfiguration.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_CREATE_AUTH_CONFIGURATION", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("CreateAuthConfiguration.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_CREATE_AUTH_CONFIGURATION", params);
            throw new CLIException(e, 127);
        }
    }
}

