/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ListAgentGroupMembers
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String pattern = this.getStringOptionValue("filter");
        String agentGroupName = this.getStringOptionValue("agentgroupname");
        String[] params = new String[]{realm, agentGroupName};
        if (pattern == null || pattern.trim().length() == 0) {
            pattern = "*";
        }
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_AGENT_GROUP_MEMBERS", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, agentGroupName, IdType.AGENTGROUP, realm, null);
            if (!amid.isExists()) {
                String[] args = new String[]{realm, agentGroupName, "agent group did not exist"};
                this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP_MEMBERS", args);
                Object[] p = new Object[]{agentGroupName};
                String msg = MessageFormat.format(this.getResourceString("list-agent-group-member-group-does-not-exist"), p);
                throw new CLIException(msg, 127);
            }
            Set members = amid.getMembers(IdType.AGENT);
            if (members != null && !members.isEmpty()) {
                String msg = this.getResourceString("format-list-agent-group-members-results");
                String[] arg = new String[]{"", ""};
                Iterator i = members.iterator();
                while (i.hasNext()) {
                    AMIdentity a = (AMIdentity)i.next();
                    if (!DisplayUtils.wildcardMatch(a.getName(), pattern)) continue;
                    arg[0] = a.getName();
                    arg[1] = a.getUniversalId();
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("list-agent-group-members-no-members"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SHOW_AGENT_GROUP_MEMBERS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("ListAgentGroupMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP_MEMBERS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("ListAgentGroupMembers.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP_MEMBERS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

