/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.Authenticator;
import com.sun.identity.cli.CLICommandBase;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.LogWriter;
import com.sun.identity.cli.RequestContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class AuthenticatedCommand
extends CLICommandBase {
    private String adminUserID;
    private String adminID;
    private String adminPassword;
    private SSOToken ssoToken;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ssoToken = rc.getCLIRequest().getSSOToken();
        if (this.ssoToken == null) {
            this.adminUserID = this.getUserID();
            this.adminPassword = this.getPassword();
        }
    }

    private String getUserID() {
        String namingAttr;
        String strUID;
        int idx;
        String userId = null;
        this.adminID = this.getStringOptionValue("adminid");
        StringTokenizer st = new StringTokenizer(this.adminID, ",");
        if (st.hasMoreTokens() && (idx = (strUID = st.nextToken()).indexOf(61)) != -1 && (namingAttr = strUID.substring(0, idx)).equals("uid")) {
            userId = strUID.substring(idx + 1);
        }
        return userId;
    }

    private String getPassword() throws CLIException {
        String fileName = this.getStringOptionValue("password-file");
        String password = CLIUtil.getFileContent(fileName, true);
        this.validatePwdFilePermissions(fileName);
        return password;
    }

    private void validatePwdFilePermissions(String fileName) throws CLIException {
        if (System.getProperty("path.separator").equals(":")) {
            try {
                String permission;
                int idx;
                String[] parameter = new String[]{"/bin/ls", "-l", fileName};
                Process p = Runtime.getRuntime().exec(parameter);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String s = stdInput.readLine();
                if (s != null && (idx = s.indexOf(" ")) != -1 && !(permission = s.substring(0, idx)).equals("-r--------")) {
                    String msg = this.getCommandManager().getResourceBundle().getString("error-message-password-file-not-readonly");
                    Object[] param = new Object[]{fileName};
                    throw new CLIException(MessageFormat.format(msg, param), 127);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getAdminUserID() {
        return this.adminUserID;
    }

    protected String getAdminPassword() {
        return this.adminPassword;
    }

    protected String getAdminID() {
        return this.adminID;
    }

    protected SSOToken getAdminSSOToken() {
        return this.ssoToken;
    }

    protected void ldapLogin() throws CLIException {
        if (this.ssoToken == null) {
            Authenticator auth = Authenticator.getInstance();
            String bindUser = this.getAdminUserID();
            if (bindUser == null) {
                bindUser = this.getAdminID();
            }
            this.ssoToken = auth.ldapLogin(this.getCommandManager(), bindUser, this.getAdminPassword());
        }
    }

    protected void writeLog(int type, Level level, String msgid, String[] msgdata) throws CLIException {
        CommandManager mgr = this.getCommandManager();
        LogWriter.log(mgr, type, level, msgid, msgdata, this.getAdminSSOToken());
    }
}

