/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ReplayPasswd
implements AMPostAuthProcessInterface {
    private static final String CIPHER_INSTANCE_NAME = "DES/ECB/NoPadding";
    private static final String PASSWORD_TOKEN = "IDToken2";
    private static final String REPLAY_PASSWORD_KEY = "com.sun.am.replaypasswd.key";
    private static final String SUN_IDENTITY_USER_PASSWORD = "sunIdentityUserPassword";
    private static final String IIS_OWA_ENABLED = "com.sun.am.iis_owa_enabled";
    private static final String OWA_AUTH_COOKIE = "owaAuthCookie";
    private static final String OWA_AUTH_COOKIE_VALUE = "amOwaValue";
    private static final String SHAREPOINT_LOGIN_ATTR_NAME = "com.sun.am.sharepoint_login_attr_name";
    private static final String SHAREPOINT_LOGIN_ATTR_VALUE = "sharepoint_login_attr_value";
    private static Debug debug = Debug.getInstance("ReplayPasswd");

    public void onLoginSuccess(Map requestParamsMap, HttpServletRequest request, HttpServletResponse response, SSOToken ssoToken) throws AuthenticationException {
        if (debug.messageEnabled()) {
            debug.message("ReplayPasswd.onLoginSuccess called: Req:" + request.getRequestURL());
        }
        String userpasswd = request.getParameter(PASSWORD_TOKEN);
        String deskeystr = SystemProperties.get(REPLAY_PASSWORD_KEY);
        String iisOwaEnabled = SystemProperties.get(IIS_OWA_ENABLED);
        String strAttributeName = SystemProperties.get(SHAREPOINT_LOGIN_ATTR_NAME);
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] desKey = decoder.decodeBuffer(deskeystr);
            SecretKeySpec keySpec = new SecretKeySpec(desKey, "DES");
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE_NAME);
            cipher.init(1, keySpec);
            byte[] data = new byte[16];
            System.arraycopy(userpasswd.getBytes(), 0, data, 0, userpasswd.length());
            byte[] ciphertext = cipher.doFinal(data);
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedpasswd = encoder.encodeBuffer(ciphertext);
            if (encodedpasswd != null) {
                ssoToken.setProperty(SUN_IDENTITY_USER_PASSWORD, encodedpasswd);
            }
            if (iisOwaEnabled != null && iisOwaEnabled.trim().equalsIgnoreCase("true")) {
                Cookie owaAuthCookie = new Cookie(OWA_AUTH_COOKIE, OWA_AUTH_COOKIE_VALUE);
                Set domains = AuthUtils.getCookieDomains();
                if (!domains.isEmpty()) {
                    Iterator it = domains.iterator();
                    while (it.hasNext()) {
                        String domain = (String)it.next();
                        owaAuthCookie.setDomain(domain);
                        owaAuthCookie.setPath("/");
                        response.addCookie(owaAuthCookie);
                    }
                }
            }
            if (strAttributeName != null && !strAttributeName.trim().equals("")) {
                AMIdentity amIdentityUser = IdUtils.getIdentity(ssoToken);
                Map attrMap = amIdentityUser.getAttributes();
                String strAttributeValue = Misc.getMapAttr(attrMap, strAttributeName, null);
                if (strAttributeValue != null) {
                    ssoToken.setProperty(SHAREPOINT_LOGIN_ATTR_VALUE, strAttributeValue);
                }
                if (debug.messageEnabled()) {
                    debug.message("ReplayPasswd.onLoginSuccess: " + strAttributeName + "=" + strAttributeValue);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("ReplayPasswd.onLoginSuccess: Replay password concluded successfully");
            }
        }
        catch (IdRepoException ire) {
            debug.error("ReplayPasswd.onLoginSuccess: IOException while fetching user attributes: " + ire);
        }
        catch (IOException ioe) {
            debug.error("ReplayPasswd.onLoginSuccess: IOException while setting session password property: " + ioe);
        }
        catch (NoSuchAlgorithmException noe) {
            debug.error("ReplayPasswd.onLoginSuccess: NoSuchAlgorithmException while setting session password property: " + noe);
        }
        catch (InvalidKeyException ike) {
            debug.error("ReplayPasswd.onLoginSuccess: InvalidKeyException while setting session password property: " + ike);
        }
        catch (IllegalBlockSizeException ibe) {
            debug.error("ReplayPasswd.onLoginSuccess:IllegalBlockSizeException while setting session password property: " + ibe);
        }
        catch (NoSuchPaddingException npe) {
            debug.error("ReplayPasswd.onLoginSuccess: NoSuchPaddingException while setting session password property: " + npe);
        }
        catch (BadPaddingException bpe) {
            debug.error("ReplayPasswd.onLoginSuccess: BadPaddingException while setting session password property: " + bpe);
        }
        catch (SSOException sse) {
            debug.error("ReplayPasswd.onLoginSuccess: SSOException while setting session password property: " + (Object)((Object)sse));
        }
    }

    public void onLoginFailure(Map requestParamsMap, HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        debug.message("ReplayPasswd.onLoginFailure: called");
    }

    public void onLogout(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken) throws AuthenticationException {
        debug.message("ReplayPasswd.onLogout called");
    }
}

