/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.share;

import com.sun.identity.authentication.share.AuthenticationCallbackXMLHelper;
import com.sun.identity.authentication.share.AuthenticationCallbackXMLHelperFactory;
import com.sun.identity.authentication.spi.DSAMECallbackInterface;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.authentication.spi.X509CertificateCallback;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthXMLUtils {
    static Debug debug = Debug.getInstance((String)"amAuthXMLUtils");

    public static Callback[] getCallbacks(Node callbackNode, boolean noFilter) {
        try {
            return AuthXMLUtils.getCallbacks(callbackNode, noFilter, null);
        }
        catch (Exception e) {
            debug.message("Exception . ", (Throwable)e);
            return null;
        }
    }

    public static Callback[] getCallbacks(Node callbackNode, boolean noFilter, Callback[] callbacks) {
        if (callbackNode == null) {
            return null;
        }
        String lenString = XMLUtils.getNodeAttributeValue((Node)callbackNode, (String)"length");
        int length = Integer.parseInt(lenString);
        if (debug.messageEnabled()) {
            debug.message("Callbacks length is : " + length);
            if (callbacks != null) {
                for (int k = 0; k < callbacks.length; ++k) {
                    debug.message("callback is : " + callbacks[k]);
                }
            }
        }
        Callback[] answer = new Callback[]{};
        ArrayList<Callback> callbackList = new ArrayList<Callback>();
        Object callback = null;
        NodeList childNodes = callbackNode.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        int nameIndex = 0;
        int passIndex = 0;
        int ccIndex = 0;
        int concIndex = 0;
        int tiIndex = 0;
        int toIndex = 0;
        int lcIndex = 0;
        int ppIndex = 0;
        int diIndex = 0;
        int authCallbackIndex = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String childNodeName = childNode.getNodeName();
            if (childNodeName.equals("NameCallback")) {
                if (callbacks != null) {
                    if ((nameIndex = AuthXMLUtils.getNameCallbackIndex(callbacks, nameIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createNameCallback(childNode, callbacks[nameIndex]));
                    }
                    ++nameIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createNameCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("PasswordCallback")) {
                if (callbacks != null) {
                    if ((passIndex = AuthXMLUtils.getPasswordCallbackIndex(callbacks, passIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createPasswordCallback(childNode, callbacks[passIndex]));
                    }
                    ++passIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createPasswordCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("ChoiceCallback")) {
                if (callbacks != null) {
                    if ((ccIndex = AuthXMLUtils.getChoiceCallbackIndex(callbacks, ccIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createChoiceCallback(childNode, callbacks[ccIndex]));
                    }
                    ++ccIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createChoiceCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("ConfirmationCallback")) {
                if (callbacks != null) {
                    if ((concIndex = AuthXMLUtils.getConfCallbackIndex(callbacks, concIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createConfirmationCallback(childNode, callbacks[concIndex]));
                    }
                    ++concIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createConfirmationCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("TextInputCallback")) {
                if (callbacks != null) {
                    if ((tiIndex = AuthXMLUtils.getTextInputIndex(callbacks, tiIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createTextInputCallback(childNode, callbacks[tiIndex]));
                    }
                    ++tiIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createTextInputCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("TextOutputCallback")) {
                if (callbacks != null) {
                    if ((toIndex = AuthXMLUtils.getTextOutputIndex(callbacks, toIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createTextOutputCallback(childNode, callbacks[toIndex]));
                    }
                    ++toIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createTextOutputCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("PagePropertiesCallback") && noFilter) {
                if (callbacks != null) {
                    if ((ppIndex = AuthXMLUtils.getPagePropertiesIndex(callbacks, ppIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createPagePropertiesCallback(childNode, callbacks[ppIndex]));
                    }
                    ++ppIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createPagePropertiesCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("LanguageCallback")) {
                if (callbacks != null) {
                    if ((lcIndex = AuthXMLUtils.getLanguageCallbackIndex(callbacks, lcIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createLanguageCallback(childNode, callbacks[lcIndex]));
                    }
                    ++lcIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createLanguageCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("SAMLCallback")) {
                AuthenticationCallbackXMLHelper callbackXMLHelper = AuthenticationCallbackXMLHelperFactory.getCallbackXMLHelper();
                if (callbackXMLHelper == null) continue;
                if (callbacks != null) {
                    if ((authCallbackIndex = callbackXMLHelper.getAuthenticationCallbackIndex(callbacks, authCallbackIndex)) >= 0) {
                        callbackList.add(callbackXMLHelper.createAuthenticationCallback(childNode, callbacks[authCallbackIndex]));
                    }
                    ++authCallbackIndex;
                    continue;
                }
                callbackList.add(callbackXMLHelper.createAuthenticationCallback(childNode, null));
                continue;
            }
            if (childNodeName.equals("X509CertificateCallback")) {
                if (callbacks != null) {
                    if ((lcIndex = AuthXMLUtils.getX509CertificateCallbackIndex(callbacks, lcIndex)) >= 0) {
                        callbackList.add(AuthXMLUtils.createX509CertificateCallback(childNode, callbacks[lcIndex]));
                    }
                    ++lcIndex;
                    continue;
                }
                callbackList.add(AuthXMLUtils.createX509CertificateCallback(childNode, null));
                continue;
            }
            if (!childNodeName.equals("CustomCallback")) continue;
            if (callbacks != null) {
                diIndex = AuthXMLUtils.getCustomCallbackIndex(callbacks, ppIndex);
                if (diIndex >= 0) {
                    callbackList.add(AuthXMLUtils.createCustomCallback(childNode, callbacks[diIndex]));
                }
                ++diIndex;
                continue;
            }
            callbackList.add(AuthXMLUtils.createCustomCallback(childNode, null));
        }
        return callbackList.toArray(answer);
    }

    public static String getXMLForCallbacks(Callback[] callbacks) {
        if (callbacks == null) {
            return "";
        }
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<Callbacks").append(" ").append("length").append("=").append("\"").append(callbacks.length).append("\"").append(">");
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getNameCallbackXML(nameCallback));
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getPasswordCallbackXML(passwordCallback));
                continue;
            }
            if (callbacks[i] instanceof ChoiceCallback) {
                ChoiceCallback choiceCallback = (ChoiceCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getChoiceCallbackXML(choiceCallback));
                continue;
            }
            if (callbacks[i] instanceof ConfirmationCallback) {
                ConfirmationCallback conCallback = (ConfirmationCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getConfirmationCallbackXML(conCallback));
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback textInputCallback = (TextInputCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getTextInputCallbackXML(textInputCallback));
                continue;
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback textOutputCallback = (TextOutputCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getTextOutputCallbackXML(textOutputCallback));
                continue;
            }
            if (callbacks[i] instanceof PagePropertiesCallback) {
                PagePropertiesCallback pagePCallback = (PagePropertiesCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getPagePropertiesCallbackXML(pagePCallback));
                continue;
            }
            if (callbacks[i] instanceof LanguageCallback) {
                LanguageCallback lc = (LanguageCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getLanguageCallbackXML(lc));
                continue;
            }
            if (callbacks[i] instanceof X509CertificateCallback) {
                X509CertificateCallback xc = (X509CertificateCallback)callbacks[i];
                xmlString.append(AuthXMLUtils.getX509CertificateCallbackXML(xc));
                continue;
            }
            if (callbacks[i] instanceof DSAMECallbackInterface) {
                DSAMECallbackInterface dsameCallback = (DSAMECallbackInterface)callbacks[i];
                xmlString.append(AuthXMLUtils.getCustomCallbackXML(dsameCallback));
                continue;
            }
            AuthenticationCallbackXMLHelper callbackXMLHelper = AuthenticationCallbackXMLHelperFactory.getCallbackXMLHelper();
            if (callbackXMLHelper == null) continue;
            xmlString.append(callbackXMLHelper.getAuthenticationCallbackXML(callbacks[i]));
        }
        xmlString.append("</Callbacks>");
        return xmlString.toString();
    }

    static NameCallback createNameCallback(Node childNode, Callback callback) {
        String prompt = AuthXMLUtils.getPrompt(childNode);
        NameCallback nameCallback = null;
        if (callback != null && callback instanceof NameCallback) {
            nameCallback = (NameCallback)callback;
        }
        if (nameCallback == null) {
            String defaultValue = AuthXMLUtils.getDefaultValue(childNode);
            nameCallback = defaultValue == null ? new NameCallback(prompt) : new NameCallback(prompt, defaultValue);
        }
        String value = AuthXMLUtils.getValue(childNode);
        if (debug.messageEnabled()) {
            debug.message("Value is : " + value);
        }
        if (value != null) {
            nameCallback.setName(value);
        }
        return nameCallback;
    }

    static PasswordCallback createPasswordCallback(Node childNode, Callback callback) {
        String value;
        String prompt = AuthXMLUtils.getPrompt(childNode);
        boolean echoPassword = false;
        String echoPasswordAttr = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"echoPassword");
        if (echoPasswordAttr != null && echoPasswordAttr.equals("true")) {
            echoPassword = true;
        }
        PasswordCallback passwordCallback = null;
        if (callback != null && callback instanceof PasswordCallback) {
            passwordCallback = (PasswordCallback)callback;
        }
        if (passwordCallback == null) {
            passwordCallback = new PasswordCallback(prompt, echoPassword);
        }
        if ((value = AuthXMLUtils.getValueNoTrim(childNode)) != null) {
            passwordCallback.setPassword(value.toCharArray());
        }
        return passwordCallback;
    }

    static ChoiceCallback createChoiceCallback(Node childNode, Callback callback) {
        Node selectedNode;
        ChoiceCallback choiceCallback = null;
        if (callback != null && callback instanceof ChoiceCallback) {
            choiceCallback = (ChoiceCallback)callback;
        }
        if (choiceCallback == null) {
            String prompt = AuthXMLUtils.getPrompt(childNode);
            boolean multiSelect = false;
            String multiSelectAttr = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"multipleSelectionsAllowed");
            if (multiSelectAttr != null && multiSelectAttr.equals("true")) {
                multiSelect = true;
            }
            String[] choices = null;
            int defaultChoice = 0;
            Node choicesNode = XMLUtils.getChildNode((Node)childNode, (String)"ChoiceValues");
            NodeList choicesChildNodes = choicesNode.getChildNodes();
            choices = new String[choicesChildNodes.getLength()];
            for (int j = 0; j < choicesChildNodes.getLength(); ++j) {
                String choiceValue;
                Node choiceValueNode = choicesChildNodes.item(j);
                String isDefaultAttr = XMLUtils.getNodeAttributeValue((Node)choiceValueNode, (String)"isDefault");
                if (isDefaultAttr != null && isDefaultAttr.equals("yes")) {
                    defaultChoice = j;
                }
                choices[j] = choiceValue = AuthXMLUtils.getValue(choiceValueNode);
            }
            choiceCallback = new ChoiceCallback(prompt, choices, defaultChoice, multiSelect);
        }
        if ((selectedNode = XMLUtils.getChildNode((Node)childNode, (String)"SelectedValues")) != null) {
            NodeList selectChildNodes = selectedNode.getChildNodes();
            int[] selectedIndexes = new int[selectChildNodes.getLength()];
            for (int j = 0; j < selectChildNodes.getLength(); ++j) {
                Node selectValueNode = selectChildNodes.item(j);
                selectedIndexes[j] = Integer.parseInt(XMLUtils.getValueOfValueNode((Node)selectValueNode));
            }
            if (choiceCallback.allowMultipleSelections()) {
                choiceCallback.setSelectedIndexes(selectedIndexes);
            } else {
                choiceCallback.setSelectedIndex(selectedIndexes[0]);
            }
        }
        return choiceCallback;
    }

    static ConfirmationCallback createConfirmationCallback(Node childNode, Callback callback) {
        Node selectedNode;
        ConfirmationCallback conCallback = null;
        if (callback != null && callback instanceof ConfirmationCallback) {
            conCallback = (ConfirmationCallback)callback;
        }
        if (conCallback == null) {
            String prompt = AuthXMLUtils.getPrompt(childNode);
            int messageType = 0;
            String msgType = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"messageType");
            if (msgType.equals("information")) {
                messageType = 0;
            } else if (msgType.equals("error")) {
                messageType = 2;
            } else if (msgType.equals("warning")) {
                messageType = 1;
            }
            boolean bOptions = false;
            int optionType = 0;
            String optType = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"optionType");
            if (optType != null) {
                if (optType.equals("yes_no")) {
                    optionType = 0;
                } else if (optType.equals("yes_no_cancel")) {
                    optionType = 1;
                } else if (optType.equals("ok_cancel")) {
                    optionType = 2;
                } else if (optType.equals("unspecified")) {
                    optionType = -1;
                    bOptions = true;
                }
            }
            String[] options = null;
            Node optionsNode = XMLUtils.getChildNode((Node)childNode, (String)"OptionValues");
            if (optionsNode != null) {
                NodeList optionsChildNodes = optionsNode.getChildNodes();
                options = new String[optionsChildNodes.getLength()];
                for (int j = 0; j < optionsChildNodes.getLength(); ++j) {
                    String optionValue;
                    Node optionValueNode = optionsChildNodes.item(j);
                    options[j] = optionValue = AuthXMLUtils.getValue(optionValueNode);
                }
            }
            Node defaultNode = XMLUtils.getChildNode((Node)childNode, (String)"DefaultOptionValue");
            String defaultValue = AuthXMLUtils.getValue(defaultNode);
            int defaultOption = Integer.parseInt(defaultValue);
            conCallback = prompt != null ? (bOptions ? new ConfirmationCallback(prompt, messageType, options, defaultOption) : new ConfirmationCallback(prompt, messageType, optionType, defaultOption)) : (bOptions ? new ConfirmationCallback(messageType, options, defaultOption) : new ConfirmationCallback(messageType, optionType, defaultOption));
        }
        if ((selectedNode = XMLUtils.getChildNode((Node)childNode, (String)"SelectedValue")) != null) {
            String selectedValue = AuthXMLUtils.getValue(selectedNode);
            int selectedOption = Integer.parseInt(selectedValue);
            conCallback.setSelectedIndex(selectedOption);
        }
        return conCallback;
    }

    static TextInputCallback createTextInputCallback(Node childNode, Callback callback) {
        String value;
        TextInputCallback textInputCallback = null;
        if (callback != null && callback instanceof TextInputCallback) {
            textInputCallback = (TextInputCallback)callback;
        }
        if (textInputCallback == null) {
            String prompt = AuthXMLUtils.getPrompt(childNode);
            String defaultValue = AuthXMLUtils.getDefaultValue(childNode);
            textInputCallback = defaultValue == null ? new TextInputCallback(prompt) : new TextInputCallback(prompt, defaultValue);
        }
        if ((value = AuthXMLUtils.getValue(childNode)) != null) {
            textInputCallback.setText(value);
        }
        return textInputCallback;
    }

    static TextOutputCallback createTextOutputCallback(Node childNode, Callback callback) {
        TextOutputCallback textOutputCallback = null;
        if (callback != null && callback instanceof TextOutputCallback) {
            textOutputCallback = (TextOutputCallback)callback;
        }
        if (textOutputCallback == null) {
            String value = AuthXMLUtils.getValue(childNode);
            int messageType = 0;
            String msgType = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"messageType");
            if (msgType.equals("information")) {
                messageType = 0;
            } else if (msgType.equals("error")) {
                messageType = 2;
            } else if (msgType.equals("warning")) {
                messageType = 1;
            }
            textOutputCallback = new TextOutputCallback(messageType, value);
        }
        return textOutputCallback;
    }

    static PagePropertiesCallback createPagePropertiesCallback(Node childNode, Callback callback) {
        PagePropertiesCallback pagePropertiesCallback = null;
        if (callback != null && callback instanceof PagePropertiesCallback) {
            pagePropertiesCallback = (PagePropertiesCallback)callback;
        }
        if (pagePropertiesCallback == null) {
            boolean errState = false;
            String errStateAttr = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"isErrorState");
            if (errStateAttr != null && errStateAttr.equals("true")) {
                errState = true;
            }
            String moduleName = AuthXMLUtils.getValueOfChildNode(childNode, "ModuleName");
            String pageState = AuthXMLUtils.getValueOfChildNode(childNode, "PageState");
            String header = AuthXMLUtils.getValueOfChildNode(childNode, "HeaderValue");
            String image = AuthXMLUtils.getValueOfChildNode(childNode, "ImageName");
            int timeOut = Integer.parseInt(AuthXMLUtils.getValueOfChildNode(childNode, "PageTimeOutValue"));
            String template = AuthXMLUtils.getValueOfChildNode(childNode, "TemplateName");
            pagePropertiesCallback = new PagePropertiesCallback(moduleName, header, image, timeOut, template, errState, pageState);
        }
        return pagePropertiesCallback;
    }

    static X509CertificateCallback createX509CertificateCallback(Node childNode, Callback callback) {
        String certificate;
        X509CertificateCallback certCallback = null;
        if (callback != null && callback instanceof X509CertificateCallback) {
            certCallback = (X509CertificateCallback)callback;
        }
        if (certCallback == null) {
            certCallback = new X509CertificateCallback(AuthXMLUtils.getPrompt(childNode));
        }
        boolean signReq = true;
        String strSignReq = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"SignatureRequired");
        if (strSignReq.equals("false")) {
            signReq = false;
        }
        certCallback.setReqSignature(signReq);
        Node pNode = XMLUtils.getChildNode((Node)childNode, (String)"X509Certificate");
        if (pNode != null && (certificate = XMLUtils.getValueOfValueNode((Node)pNode)) != null) {
            byte[] certbytes = Base64.decode((String)certificate);
            ByteArrayInputStream carray = new ByteArrayInputStream(certbytes);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate userCert = (X509Certificate)cf.generateCertificate(carray);
                certCallback.setCertificate(userCert);
            }
            catch (CertificateException e) {
                debug.error("createX509CertificateCallback : ", (Throwable)e);
            }
        }
        return certCallback;
    }

    static String getNameCallbackXML(NameCallback nameCallback) {
        String name;
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<NameCallback>").append("<Prompt>").append(nameCallback.getPrompt()).append("</Prompt>");
        String defaultName = nameCallback.getDefaultName();
        if (defaultName != null) {
            xmlString.append("<DefaultValue>").append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)defaultName)).append("</Value>").append("</DefaultValue>");
        }
        if ((name = nameCallback.getName()) != null) {
            xmlString.append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)name)).append("</Value>");
        }
        xmlString.append("</NameCallback>");
        return xmlString.toString();
    }

    static String getPasswordCallbackXML(PasswordCallback passwordCallback) {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<PasswordCallback").append(" ").append("echoPassword").append("=").append("\"");
        if (passwordCallback.isEchoOn()) {
            xmlString.append("true");
        } else {
            xmlString.append("false");
        }
        xmlString.append("\"").append(">").append("<Prompt>").append(passwordCallback.getPrompt()).append("</Prompt>");
        if (passwordCallback.getPassword() != null) {
            xmlString.append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)new String(passwordCallback.getPassword())).toCharArray()).append("</Value>");
        }
        xmlString.append("</PasswordCallback>");
        return xmlString.toString();
    }

    static String getChoiceCallbackXML(ChoiceCallback choiceCallback) {
        int[] selectIndexes;
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<ChoiceCallback").append(" ").append("multipleSelectionsAllowed").append("=").append("\"");
        if (choiceCallback.allowMultipleSelections()) {
            xmlString.append("true");
        } else {
            xmlString.append("false");
        }
        xmlString.append("\"").append(">").append("<Prompt>").append(choiceCallback.getPrompt()).append("</Prompt>");
        String[] choices = choiceCallback.getChoices();
        int checked = choiceCallback.getDefaultChoice();
        if (choices != null) {
            xmlString.append("<ChoiceValues>");
            for (int j = 0; j < choices.length; ++j) {
                xmlString.append("<ChoiceValue");
                if (j == checked) {
                    xmlString.append(" ").append("isDefault").append("=").append("\"").append("yes").append("\"");
                }
                xmlString.append(">").append("<Value>").append(choices[j]).append("</Value>").append("</ChoiceValue>");
            }
            xmlString.append("</ChoiceValues>");
        }
        if ((selectIndexes = choiceCallback.getSelectedIndexes()) != null) {
            xmlString.append("<SelectedValues>");
            for (int j = 0; j < selectIndexes.length; ++j) {
                xmlString.append("<Value>").append(Integer.toString(selectIndexes[j])).append("</Value>");
            }
            xmlString.append("</SelectedValues>");
        }
        xmlString.append("</ChoiceCallback>");
        return xmlString.toString();
    }

    static String getConfirmationCallbackXML(ConfirmationCallback conCallback) {
        String[] options;
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<ConfirmationCallback").append(" ").append("messageType").append("=").append("\"");
        switch (conCallback.getMessageType()) {
            case 0: {
                xmlString.append("information");
                break;
            }
            case 2: {
                xmlString.append("error");
                break;
            }
            case 1: {
                xmlString.append("warning");
            }
        }
        xmlString.append("\"");
        xmlString.append(" ").append("optionType").append("=").append("\"");
        switch (conCallback.getOptionType()) {
            case 0: {
                xmlString.append("yes_no");
                break;
            }
            case 1: {
                xmlString.append("yes_no_cancel");
                break;
            }
            case 2: {
                xmlString.append("ok_cancel");
                break;
            }
            case -1: {
                xmlString.append("unspecified");
            }
        }
        xmlString.append("\"").append(">");
        if (conCallback.getPrompt() != null) {
            xmlString.append("<Prompt>").append(conCallback.getPrompt()).append("</Prompt>");
        }
        if ((options = conCallback.getOptions()) != null) {
            xmlString.append("<OptionValues>");
            for (int j = 0; j < options.length; ++j) {
                xmlString.append("<OptionValue>").append("<Value>").append(options[j]).append("</Value>").append("</OptionValue>");
            }
            xmlString.append("</OptionValues>");
        }
        int defaultOption = conCallback.getDefaultOption();
        xmlString.append("<DefaultOptionValue>").append("<Value>").append(Integer.toString(defaultOption)).append("</Value>").append("</DefaultOptionValue>");
        int selectedValue = conCallback.getSelectedIndex();
        xmlString.append("<SelectedValue>").append("<Value>").append(Integer.toString(selectedValue)).append("</Value>").append("</SelectedValue>");
        xmlString.append("</ConfirmationCallback>");
        return xmlString.toString();
    }

    static String getTextInputCallbackXML(TextInputCallback textInputCallback) {
        String setText;
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<TextInputCallback>").append("<Prompt>").append(textInputCallback.getPrompt()).append("</Prompt>");
        String defaultText = textInputCallback.getDefaultText();
        if (defaultText != null) {
            xmlString.append("<DefaultValue>").append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)defaultText)).append("</Value>").append("</DefaultValue>");
        }
        if ((setText = textInputCallback.getText()) != null) {
            xmlString.append("<Value>").append(XMLUtils.escapeSpecialCharacters((String)setText)).append("</Value>");
        }
        xmlString.append("</TextInputCallback>");
        return xmlString.toString();
    }

    static String getTextOutputCallbackXML(TextOutputCallback textOutputCallback) {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<TextOutputCallback").append(" ").append("messageType").append("=").append("\"");
        switch (textOutputCallback.getMessageType()) {
            case 0: {
                xmlString.append("information");
                break;
            }
            case 2: {
                xmlString.append("error");
                break;
            }
            case 1: {
                xmlString.append("warning");
            }
        }
        xmlString.append("\"").append(">").append("<Value>").append(textOutputCallback.getMessage()).append("</Value>");
        xmlString.append("</TextOutputCallback>");
        return xmlString.toString();
    }

    static String getPagePropertiesCallbackXML(PagePropertiesCallback pagePCallback) {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<PagePropertiesCallback").append(" ").append("isErrorState").append("=").append("\"");
        if (pagePCallback.getErrorState()) {
            xmlString.append("true");
        } else {
            xmlString.append("false");
        }
        xmlString.append("\"").append(">").append("<ModuleName>").append(pagePCallback.getModuleName()).append("</ModuleName>").append("<HeaderValue>").append(pagePCallback.getHeader()).append("</HeaderValue>").append("<ImageName>").append(pagePCallback.getImage()).append("</ImageName>").append("<PageTimeOutValue>").append(Integer.toString(pagePCallback.getTimeOutValue())).append("</PageTimeOutValue>").append("<TemplateName>").append(pagePCallback.getTemplateName()).append("</TemplateName>").append("<PageState>").append(pagePCallback.getPageState()).append("</PageState>");
        xmlString.append("</PagePropertiesCallback>");
        return xmlString.toString();
    }

    static String getX509CertificateCallbackXML(X509CertificateCallback certCallback) {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<X509CertificateCallback").append(" ").append("SignatureRequired").append("=").append("\"").append(certCallback.getReqSignature()).append("\"").append(">");
        xmlString.append("<Prompt>").append(certCallback.getPrompt()).append("</Prompt>");
        X509Certificate cert = certCallback.getCertificate();
        if (cert != null) {
            try {
                xmlString.append("<X509Certificate>").append(Base64.encode((byte[])cert.getEncoded())).append("</X509Certificate>");
            }
            catch (CertificateEncodingException e) {
                debug.error("getX509CertificateCallbackXML : ", (Throwable)e);
            }
        }
        xmlString.append("</X509CertificateCallback>");
        return xmlString.toString();
    }

    protected static String getPrompt(Node node) {
        Node pNode = XMLUtils.getChildNode((Node)node, (String)"Prompt");
        if (pNode != null) {
            return XMLUtils.getValueOfValueNode((Node)pNode);
        }
        return null;
    }

    protected static String getValue(Node node) {
        Node pNode = XMLUtils.getChildNode((Node)node, (String)"Value");
        if (pNode != null) {
            return XMLUtils.getValueOfValueNode((Node)pNode);
        }
        return null;
    }

    protected static String getValueNoTrim(Node node) {
        Node pNode = XMLUtils.getChildNode((Node)node, (String)"Value");
        if (pNode != null) {
            return XMLUtils.getValueOfValueNodeNoTrim((Node)pNode);
        }
        return null;
    }

    protected static String getValueOfChildNode(Node node, String childNode) {
        Node pNode = XMLUtils.getChildNode((Node)node, (String)childNode);
        if (pNode != null) {
            return XMLUtils.getValueOfValueNode((Node)pNode);
        }
        return null;
    }

    static DSAMECallbackInterface createCustomCallback(Node childNode, Callback customCallback) {
        debug.message("in create custom callback");
        String className = XMLUtils.getNodeAttributeValue((Node)childNode, (String)"className");
        try {
            DSAMECallbackInterface callback = null;
            if (customCallback != null && customCallback instanceof DSAMECallbackInterface && (callback = (DSAMECallbackInterface)customCallback) != null) {
                String clName = callback.getClass().getName();
                if (debug.messageEnabled()) {
                    debug.message("Class Name is : " + clName);
                }
                if (clName == null || !clName.equals(className)) {
                    callback = null;
                }
            }
            if (callback == null && className != null && className.length() != 0) {
                Class<?> xmlClass = Class.forName(className);
                callback = (DSAMECallbackInterface)xmlClass.newInstance();
            }
            HashMap map = new HashMap();
            String value = null;
            String attributeName = null;
            HashSet<String> valueSet = null;
            NodeList childNodesList = childNode.getChildNodes();
            for (int i = 0; i < childNodesList.getLength(); ++i) {
                Node cNode = childNodesList.item(i);
                NodeList childNodeIList = cNode.getChildNodes();
                for (int j = 0; j < childNodeIList.getLength(); ++j) {
                    Node childNodeI = childNodeIList.item(j);
                    String localName = childNodeI.getLocalName();
                    if (debug.messageEnabled()) {
                        debug.message("child node local name : " + localName);
                    }
                    if (localName.equals("Attribute")) {
                        attributeName = XMLUtils.getNodeAttributeValue((Node)childNodeI, (String)"name");
                    }
                    if (!childNodeI.getLocalName().equals("Value")) continue;
                    valueSet = new HashSet<String>();
                    value = XMLUtils.getValueOfValueNode((Node)childNodeI);
                    valueSet.add(value);
                }
                map.put(attributeName, valueSet);
            }
            if (debug.messageEnabled()) {
                debug.message("MAP is : " + map);
            }
            callback.setConfig(map);
            return callback;
        }
        catch (Exception e) {
            debug.message("Error creating callback ", (Throwable)e);
            return null;
        }
    }

    static String getCustomCallbackXML(DSAMECallbackInterface dsameCallback) {
        try {
            StringBuffer xmlString = new StringBuffer();
            String className = dsameCallback.getClass().getName();
            if (debug.messageEnabled()) {
                debug.message("Custom Callback Class name : " + className);
            }
            xmlString.append("<CustomCallback").append(" ").append("className").append("=").append("\"").append(className).append("\"").append(">");
            Map map = dsameCallback.getConfig();
            if (debug.messageEnabled()) {
                debug.message("map is : " + map);
            }
            Set keysSet = map.keySet();
            Iterator keys = keysSet.iterator();
            if (debug.messageEnabled()) {
                debug.message("keyset is : " + keysSet);
            }
            while (keys.hasNext()) {
                xmlString.append("<AttributeValuePair>");
                String keyName = (String)keys.next();
                if (debug.messageEnabled()) {
                    debug.message("KEY IS : " + keyName);
                }
                xmlString.append("<Attribute").append(" ").append("name").append("=").append("\"").append(keyName).append("\"").append(">").append("</Attribute>");
                Set valueSet = (Set)map.get(keyName);
                if (debug.messageEnabled()) {
                    debug.message("Value Set : " + valueSet);
                }
                Iterator vIterator = valueSet.iterator();
                while (vIterator.hasNext()) {
                    String value = (String)vIterator.next();
                    xmlString.append("<Value>").append(value).append("</Value>");
                }
                xmlString.append("</AttributeValuePair>");
            }
            xmlString.append("</CustomCallback>");
            return xmlString.toString();
        }
        catch (Exception e) {
            debug.message("Error creating customCallback :", (Throwable)e);
            return null;
        }
    }

    public static String getSerializedSubject(Subject subject) {
        byte[] sSerialized = null;
        String encodedString = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream objOutStream = new ObjectOutputStream(byteOut);
            objOutStream.writeObject(subject);
            sSerialized = byteOut.toByteArray();
            encodedString = (String)AccessController.doPrivileged(new EncodeAction(Base64.encode((byte[])sSerialized).trim()));
            if (debug.messageEnabled()) {
                debug.message("encoded Subject is : " + encodedString);
            }
        }
        catch (Exception e) {
            debug.message("Exception  : ", (Throwable)e);
        }
        return encodedString;
    }

    public static Subject getDeSerializedSubject(String subjectSerialized) throws Exception {
        String decStr = (String)AccessController.doPrivileged(new DecodeAction(subjectSerialized));
        byte[] sSerialized = Base64.decode((String)decStr);
        if (sSerialized == null) {
            return null;
        }
        ObjectInputStream objInStream = null;
        Object tempObject = null;
        try {
            byte[] byteDecrypted = sSerialized;
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteDecrypted);
            objInStream = new ObjectInputStream(byteIn);
            tempObject = objInStream.readObject();
        }
        catch (Exception e) {
            debug.message("Exception Message in decrypt: ", (Throwable)e);
        }
        if (tempObject == null) {
            return null;
        }
        Subject subjectObj = (Subject)tempObject;
        if (debug.messageEnabled()) {
            debug.message("returning temp" + subjectObj);
        }
        return subjectObj;
    }

    static int getNameCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof NameCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getPasswordCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof PasswordCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getConfCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof ConfirmationCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getChoiceCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof ChoiceCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getTextInputIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof TextInputCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getTextOutputIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof TextOutputCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getPagePropertiesIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof PagePropertiesCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getCustomCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof DSAMECallbackInterface)) continue;
            return i;
        }
        return -1;
    }

    static int getLanguageCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof LanguageCallback)) continue;
            return i;
        }
        return -1;
    }

    static int getX509CertificateCallbackIndex(Callback[] callbacks, int startIndex) {
        int i = 0;
        for (i = startIndex; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof X509CertificateCallback)) continue;
            return i;
        }
        return -1;
    }

    static LanguageCallback createLanguageCallback(Node childNode, Callback callback) {
        LanguageCallback languageCallback = null;
        if (callback != null && callback instanceof LanguageCallback) {
            languageCallback = (LanguageCallback)callback;
        }
        if (languageCallback == null) {
            languageCallback = new LanguageCallback();
        }
        Node localeNode = XMLUtils.getChildNode((Node)childNode, (String)"Locale");
        String language = XMLUtils.getNodeAttributeValue((Node)localeNode, (String)"language");
        String country = XMLUtils.getNodeAttributeValue((Node)localeNode, (String)"country");
        String variant = XMLUtils.getNodeAttributeValue((Node)localeNode, (String)"variant");
        if (debug.messageEnabled()) {
            debug.message("Language is " + language);
            debug.message("Country is " + country);
            debug.message("Variant is " + variant);
        }
        if (language != null && country != null) {
            Locale locale = null;
            locale = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
            languageCallback.setLocale(locale);
        }
        return languageCallback;
    }

    static String getLanguageCallbackXML(LanguageCallback languageCallback) {
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<LanguageCallback>").append("<Locale>");
        Locale locale = languageCallback.getLocale();
        if (locale != null) {
            String variant;
            String country;
            String language = locale.getLanguage();
            if (language != null && language.length() != 0) {
                xmlString.append(" ").append("language").append("=").append("\"").append(language).append("\"");
            }
            if ((country = locale.getCountry()) != null && country.length() != 0) {
                xmlString.append(" ").append("country").append("=").append("\"").append(country).append("\"");
            }
            if ((variant = locale.getVariant()) != null && variant.length() != 0) {
                xmlString.append(" ").append("variant").append("=").append("\"").append(variant).append("\"");
            }
        }
        xmlString.append(">");
        xmlString.append("</Locale>");
        xmlString.append("</LanguageCallback>");
        if (debug.messageEnabled()) {
            debug.message("LANGUAGE CALLBACK xmlString : " + xmlString.toString());
        }
        return xmlString.toString();
    }

    private static String getDefaultValue(Node childNode) {
        Node defaultNode = XMLUtils.getChildNode((Node)childNode, (String)"DefaultValue");
        String defaultValue = null;
        if (defaultNode != null) {
            defaultValue = AuthXMLUtils.getValue(defaultNode);
        }
        return defaultValue;
    }
}

