/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.common.ResourceLookup;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthUtils
extends AuthClientUtils {
    public static final String BUNDLE_NAME = "amAuth";
    public static final int REALM = 1;
    public static final int SERVICE = 2;
    public static final int MODULE = 3;
    private static ArrayList pureJAASModuleClasses = new ArrayList();
    private static ArrayList ISModuleClasses = new ArrayList();
    private static Hashtable moduleService = new Hashtable();
    private static ResourceBundle bundle;
    static Debug utilDebug;

    private AuthUtils() {
    }

    public static InternalSession getSession(AuthContextLocal authContext) {
        InternalSession sess = AuthUtils.getLoginState(authContext).getSession();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("returning session : " + sess);
        }
        return sess;
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest request, HttpServletResponse response, SessionID sid, boolean isSessionUpgrade, boolean isBackPost) throws AuthException {
        return AuthUtils.getAuthContext(request, response, sid, isSessionUpgrade, isBackPost, false);
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest request, HttpServletResponse response, SessionID sid, boolean isSessionUpgrade, boolean isBackPost, boolean isLogout) throws AuthException {
        AuthContextLocal authContext;
        block15: {
            utilDebug.message("In AuthUtils:getAuthContext");
            authContext = null;
            LoginState loginState = null;
            AuthD ad = AuthD.getAuth();
            try {
                Hashtable dataHash = AuthUtils.parseRequestParameters(request);
                authContext = AuthUtils.retrieveAuthContext(request, sid);
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthUtil:getAuthContext:sid is.. .: " + sid);
                    utilDebug.message("AuthUtil:getAuthContext:authContext is..: " + authContext);
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("isSessionUpgrade  :" + isSessionUpgrade);
                    utilDebug.message("BACK with Request method POST : " + isBackPost);
                }
                if (authContext == null && isLogout) {
                    return null;
                }
                if (authContext == null || isSessionUpgrade || isBackPost) {
                    try {
                        loginState = new LoginState();
                        InternalSession oldSession = null;
                        if (sid != null) {
                            oldSession = AuthD.getSession(sid);
                            loginState.setOldSession(oldSession);
                        }
                        if (isSessionUpgrade) {
                            loginState.setOldSession(oldSession);
                            loginState.setSessionUpgrade(isSessionUpgrade);
                        } else if (isBackPost) {
                            loginState.setOldSession(oldSession);
                        }
                        authContext = loginState.createAuthContext(request, response, sid, dataHash);
                        authContext.setLoginState(loginState);
                        String queryOrg = AuthUtils.getQueryOrgName(request, AuthUtils.getOrgParam(dataHash));
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("query org is .. : " + queryOrg);
                        }
                        loginState.setQueryOrg(queryOrg);
                        break block15;
                    }
                    catch (AuthException ae) {
                        utilDebug.message("Error creating AuthContextLocal : ");
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("Exception ", (Throwable)((Object)ae));
                        }
                        throw new AuthException((Throwable)((Object)ae));
                    }
                }
                utilDebug.message("getAuthContext: found existing request.");
                authContext = AuthUtils.processAuthContext(authContext, request, response, dataHash, sid);
                loginState = AuthUtils.getLoginState(authContext);
                loginState.setRequestType(false);
            }
            catch (Exception ee) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Error creating AuthContextLocal : " + ee.getMessage());
                }
                throw new AuthException(ee);
            }
        }
        return authContext;
    }

    static AuthContextLocal processAuthContext(AuthContextLocal authContext, HttpServletRequest request, HttpServletResponse response, Hashtable dataHash, SessionID sid) throws AuthException {
        AuthD ad = AuthD.getAuth();
        LoginState loginState = AuthUtils.getLoginState(authContext);
        InternalSession sess = null;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("in processAuthContext authcontext : " + authContext);
            utilDebug.message("in processAuthContext request : " + request);
            utilDebug.message("in processAuthContext response : " + response);
            utilDebug.message("in processAuthContext sid : " + sid);
        }
        if (AuthUtils.newSessionArgExists(dataHash, sid) && loginState.getLoginStatus() == 3) {
            utilDebug.message("newSession arg exists");
            AuthUtils.destroySession(loginState);
            try {
                loginState = new LoginState();
                authContext = loginState.createAuthContext(request, response, sid, dataHash);
                authContext.setLoginState(loginState);
                String queryOrg = AuthUtils.getQueryOrgName(request, AuthUtils.getOrgParam(dataHash));
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("query org is .. : " + queryOrg);
                }
                loginState.setQueryOrg(queryOrg);
            }
            catch (AuthException ae) {
                utilDebug.message("Error creating AuthContextLocal");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Exception ", (Throwable)((Object)ae));
                }
                throw new AuthException("102", null);
            }
        } else {
            if (authContext.submittedRequirements()) {
                AuthD.debug.error("Currently processing submit Requirements");
                throw new AuthException("121", null);
            }
            utilDebug.message("new session arg does not exist");
            loginState.setHttpServletRequest(request);
            loginState.setHttpServletResponse(response);
            loginState.setParamHash(dataHash);
            sess = AuthD.getSession(sid);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtil :Session is .. : " + sess);
            }
            loginState.setSession(sess);
            loginState.persistentCookieArgExists();
            loginState.setRequestLocale(request);
            if (AuthUtils.checkForCookies(request)) {
                loginState.setCookieDetect(false);
            }
        }
        return authContext;
    }

    public static LoginState getLoginState(AuthContextLocal authContext) {
        LoginState loginState = null;
        if (authContext != null) {
            loginState = authContext.getLoginState();
        }
        return loginState;
    }

    public static Hashtable getRequestParameters(AuthContextLocal authContext) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState != null) {
            return loginState.getRequestParamHash();
        }
        return new Hashtable();
    }

    public static String getSidString(AuthContextLocal authContext) throws AuthException {
        Object sess = null;
        String sidString = null;
        try {
            SessionID sid;
            LoginState loginState;
            if (authContext != null && (loginState = authContext.getLoginState()) != null && (sid = loginState.getSid()) != null) {
                sidString = sid.toString();
            }
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error retreiving sid.. :" + e.getMessage());
            }
            throw new AuthException("noSid", new Object[]{e.getMessage()});
        }
        return sidString;
    }

    public static Cookie getCookieString(AuthContextLocal ac, String cookieDomain) {
        Cookie cookie;
        block4: {
            cookie = null;
            String cookieName = AuthUtils.getCookieName();
            try {
                String sidString = AuthUtils.getSidString(ac);
                LoginState loginState = AuthUtils.getLoginState(ac);
                if (loginState != null && loginState.isSessionInvalid()) {
                    cookieName = AuthUtils.getAuthCookieName();
                    utilDebug.message("Create AM AUTH cookie");
                }
                cookie = AuthUtils.createCookie(cookieName, sidString, cookieDomain);
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error getting sid : " + e.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie is : " + cookie);
        }
        return cookie;
    }

    public static Cookie getLogoutCookie(AuthContextLocal ac, String cookieDomain) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        SessionID sid = loginState.getSid();
        String logoutCookieString = AuthUtils.getLogoutCookieString(sid);
        Cookie logoutCookie = AuthUtils.createCookie(logoutCookieString, cookieDomain);
        logoutCookie.setMaxAge(0);
        return logoutCookie;
    }

    public static boolean isNewRequest(AuthContextLocal ac) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState.isNewRequest()) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("this is a newRequest");
            }
            return true;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("this is an existing request");
        }
        return false;
    }

    public static String getLoginSuccessURL(AuthContextLocal authContext) {
        String successURL = null;
        LoginState loginState = AuthUtils.getLoginState(authContext);
        successURL = loginState == null ? AuthD.getAuth().defaultSuccessURL : AuthUtils.getLoginState(authContext).getSuccessLoginURL();
        return successURL;
    }

    public static String getLoginFailedURL(AuthContextLocal authContext) {
        try {
            LoginState loginState = AuthUtils.getLoginState(authContext);
            if (loginState == null) {
                return AuthD.getAuth().defaultFailureURL;
            }
            String loginFailedURL = loginState.getFailureLoginURL();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtils: getLoginFailedURL " + loginFailedURL);
            }
            return loginFailedURL;
        }
        catch (Exception e) {
            utilDebug.message("Exception ", e);
            return null;
        }
    }

    public static String getFileName(AuthContextLocal authContext, String fileName) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        String relFileName = null;
        if (loginState != null) {
            relFileName = AuthUtils.getLoginState(authContext).getFileName(fileName);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getFileName:AuthUtilsFile name is :" + relFileName);
        }
        return relFileName;
    }

    public static boolean getInetDomainStatus(AuthContextLocal authContext) {
        return AuthUtils.getLoginState(authContext).getInetDomainStatus();
    }

    public static boolean newSessionArgExists(Hashtable dataHash, SessionID sid) {
        String arg = (String)dataHash.get("arg");
        if (arg != null && arg.equals("newsession")) {
            return AuthUtils.retrieveAuthContext(sid) != null;
        }
        return false;
    }

    public static String encodeURL(String url, AuthContextLocal authContext, HttpServletResponse response) {
        LoginState loginState;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:input url is :" + url);
        }
        String encodedURL = (loginState = AuthUtils.getLoginState(authContext)) == null ? url : loginState.encodeURL(url, response);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:encoded url is :" + encodedURL);
        }
        return encodedURL;
    }

    public static String getLocale(AuthContextLocal authContext) {
        AuthD ad = AuthD.getAuth();
        if (authContext == null) {
            return ad.getPlatformLocale();
        }
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState == null) {
            return ad.getPlatformLocale();
        }
        return loginState.getLocale();
    }

    static void destroySession(LoginState loginState) {
        try {
            if (loginState != null) {
                loginState.destroySession();
            }
        }
        catch (Exception e) {
            utilDebug.message("Error destroySEssion : ", e);
        }
    }

    public static void destroySession(AuthContextLocal authContext) {
        if (authContext != null) {
            LoginState loginState = AuthUtils.getLoginState(authContext);
            AuthUtils.destroySession(loginState);
        }
    }

    public static boolean sessionTimedOut(AuthContextLocal authContext) {
        boolean timedOut = false;
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState != null) {
            timedOut = loginState.isTimedOut();
            if (!timedOut) {
                InternalSession sess = loginState.getSession();
                if (sess == null && AuthD.isHttpSessionUsed()) {
                    HttpSession hsess = loginState.getHttpSession();
                    timedOut = hsess == null;
                } else if (sess != null) {
                    timedOut = sess.isTimedOut();
                }
                loginState.setTimedOut(timedOut);
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtils.sessionTimedOut: " + timedOut);
            }
        }
        return timedOut;
    }

    public static boolean isPersistentCookieOn(AuthContextLocal authContext) {
        return AuthUtils.getLoginState(authContext).isPersistentCookieOn();
    }

    public static boolean getPersistentCookieMode(AuthContextLocal authContext) {
        return AuthUtils.getLoginState(authContext).getPersistentCookieMode();
    }

    public static Cookie getPersistentCookieString(AuthContextLocal authContext, String cookieDomain) {
        return null;
    }

    public static String searchPersistentCookie(AuthContextLocal authContext) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        return loginState.searchPersistentCookie();
    }

    public static Cookie createPersistentCookie(AuthContextLocal authContext, String cookieDomain) throws AuthException {
        Cookie pCookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + cookieDomain);
            }
            LoginState loginState = AuthUtils.getLoginState(authContext);
            pCookie = loginState.setPersistentCookie(cookieDomain);
            return pCookie;
        }
        catch (Exception e) {
            utilDebug.message("Unable to create persistent Cookie");
            throw new AuthException("102", null);
        }
    }

    public static Cookie createlbCookie(AuthContextLocal authContext, String cookieDomain, boolean persist) throws AuthException {
        Cookie lbCookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + cookieDomain);
            }
            LoginState loginState = AuthUtils.getLoginState(authContext);
            lbCookie = loginState.setlbCookie(cookieDomain, persist);
            return lbCookie;
        }
        catch (Exception e) {
            utilDebug.message("Unable to create Load Balance Cookie");
            throw new AuthException("102", null);
        }
    }

    public static void setlbCookie(AuthContextLocal authContext, HttpServletResponse response) throws AuthException {
        String cookieName = AuthUtils.getlbCookieName();
        if (cookieName != null && cookieName.length() != 0) {
            Set domains = AuthUtils.getCookieDomains();
            if (!domains.isEmpty()) {
                Iterator it = domains.iterator();
                while (it.hasNext()) {
                    String domain = (String)it.next();
                    Cookie cookie = AuthUtils.createlbCookie(authContext, domain, false);
                    response.addCookie(cookie);
                }
            } else {
                response.addCookie(AuthUtils.createlbCookie(authContext, null, false));
            }
        }
    }

    public static Cookie clearPersistentCookie(String cookieDomain, AuthContextLocal authContext) {
        String pCookieValue = LoginState.encodePCookie();
        int maxAge = 0;
        Cookie clearPCookie = AuthUtils.createPersistentCookie(AuthUtils.getPersistentCookieName(), pCookieValue, maxAge, cookieDomain);
        return clearPCookie;
    }

    public static int getCompositeAdviceType(AuthContextLocal authContext) {
        int type;
        block4: {
            type = 0;
            try {
                LoginState loginState = AuthUtils.getLoginState(authContext);
                if (loginState != null) {
                    type = loginState.getCompositeAdviceType();
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("in getCompositeAdviceType, type : " + type);
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error in getCompositeAdviceType : " + e.toString());
            }
        }
        return type;
    }

    public static AuthContext.IndexType getIndexType(AuthContextLocal authContext) {
        try {
            AuthContext.IndexType indexType = null;
            LoginState loginState = AuthUtils.getLoginState(authContext);
            if (loginState != null) {
                indexType = loginState.getIndexType();
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("in getIndexType, index type : " + indexType);
            }
            return indexType;
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getIndexType : " + e.toString());
            }
            return null;
        }
    }

    public static String getIndexName(AuthContextLocal authContext) {
        try {
            String indexName = null;
            LoginState loginState = AuthUtils.getLoginState(authContext);
            if (loginState != null) {
                indexName = loginState.getIndexName();
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("in getIndexName, index Name : " + indexName);
            }
            return indexName;
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getIndexName : " + e.toString());
            }
            return null;
        }
    }

    public static Callback[] getRecdCallback(AuthContextLocal authContext) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        Callback[] recdCallback = null;
        if (loginState != null) {
            recdCallback = loginState.getRecdCallback();
        }
        if (recdCallback != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < recdCallback.length; ++i) {
                    utilDebug.message("in getRecdCallback, recdCallback[" + i + "] :" + recdCallback[i]);
                }
            }
        } else {
            utilDebug.message("in getRecdCallback, recdCallback is null");
        }
        return recdCallback;
    }

    public static String getDefaultFileName(HttpServletRequest request, String fileName) {
        AuthD ad = AuthD.getAuth();
        String locale = ad.getPlatformLocale();
        String filePath = AuthUtils.getFilePath(AuthUtils.getClientType(request));
        String fileRoot = "default";
        String templateFile = null;
        try {
            templateFile = ResourceLookup.getFirstExisting(ad.getServletContext(), fileRoot, locale, null, filePath, fileName, templatePath, true);
        }
        catch (Exception e) {
            templateFile = templatePath + fileRoot + "/" + fileName;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getDefaultFileName:templateFile is :" + templateFile);
        }
        return templateFile;
    }

    public static String getOrgDN(AuthContextLocal authContext) {
        String orgDN = null;
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState != null) {
            orgDN = loginState.getOrgDN();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is : " + orgDN);
        }
        return orgDN;
    }

    public static AuthContextLocal getAuthContext(String orgName) throws AuthException {
        return AuthUtils.getAuthContext(orgName, "0", false, null);
    }

    public static AuthContextLocal getAuthContext(String orgName, String sessionID) throws AuthException {
        return AuthUtils.getAuthContext(orgName, sessionID, false, null);
    }

    public static AuthContextLocal getAuthContext(String orgName, HttpServletRequest req) throws AuthException {
        return AuthUtils.getAuthContext(orgName, "0", false, req);
    }

    public static AuthContextLocal getAuthContext(String orgName, String sessionID, boolean logout) throws AuthException {
        return AuthUtils.getAuthContext(orgName, sessionID, logout, null);
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest req, String sessionID) throws AuthException {
        return AuthUtils.getAuthContext(null, sessionID, false, req);
    }

    public static AuthContextLocal getAuthContext(String orgName, String sessionID, boolean isLogout, HttpServletRequest req) throws AuthException {
        return AuthUtils.getAuthContext(orgName, sessionID, false, req, null, null);
    }

    public static AuthContextLocal getAuthContext(String orgName, String sessionID, boolean isLogout, HttpServletRequest req, String indexType, AuthXMLRequest xmlReq) throws AuthException {
        return AuthUtils.getAuthContext(orgName, sessionID, false, req, indexType, xmlReq, false);
    }

    public static AuthContextLocal getAuthContext(String orgName, String sessionID, boolean isLogout, HttpServletRequest req, String indexType, AuthXMLRequest xmlReq, boolean forceAuth) throws AuthException {
        AuthContextLocal authContext = null;
        SessionID sid = null;
        InternalSession sess = null;
        LoginState loginState = null;
        boolean sessionUpgrade = false;
        AuthD ad = AuthD.getAuth();
        int sessionState = -1;
        SSOToken ssot = null;
        String indexName = null;
        if (xmlReq != null) {
            indexName = xmlReq.getIndexName();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgName : " + orgName);
            utilDebug.message("sessionID is " + sessionID);
            utilDebug.message("sessionID is " + sessionID.length());
            utilDebug.message("isLogout : " + isLogout);
        }
        try {
            if (sessionID != null && !sessionID.equals("0")) {
                sid = new SessionID(sessionID);
                authContext = AuthUtils.retrieveAuthContext(req, sid);
                loginState = AuthUtils.getLoginState(authContext);
                sess = loginState != null ? loginState.getSession() : AuthD.getSession(sessionID);
                if (sess == null) {
                    sessionUpgrade = false;
                } else {
                    sessionState = sess.getState();
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("sid from sess is : " + sess.getID());
                        utilDebug.message("sess is : " + sessionState);
                    }
                    if (sessionState != 0 && !isLogout) {
                        ssot = AuthUtils.getExistingValidSSOToken(sid);
                        if (indexType != null && indexName != null) {
                            Hashtable<String, String> indexTable = new Hashtable<String, String>();
                            indexTable.put(indexType, indexName);
                            sessionUpgrade = forceAuth ? true : AuthUtils.checkSessionUpgrade(ssot, indexTable);
                        } else {
                            sessionUpgrade = true;
                        }
                    }
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("session upgrade is : " + sessionUpgrade);
                    }
                }
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtil:getAuthContext:sid is.. .: " + sid);
                utilDebug.message("AuthUtil:getAuthContext:authContext is.. .: " + authContext);
                utilDebug.message("AuthUtil:getAuthContext:sessionUpgrade is.. .: " + sessionUpgrade);
                utilDebug.message("AuthUtil:getAuthContext:ForceAuth is.. .: " + forceAuth);
            }
            if (orgName == null && sess == null) {
                utilDebug.error("Cannot create authcontext with null org ");
                throw new AuthException("102", null);
            }
            if (orgName == null) {
                orgName = sess.getClientDomain();
            }
            if (ssot != null && !sessionUpgrade) {
                xmlReq.setValidSessionNoUpgrade(true);
                return null;
            }
            if (ssot == null && loginState == null || sessionUpgrade) {
                try {
                    loginState = new LoginState();
                    InternalSession oldSession = null;
                    if (sid != null) {
                        oldSession = AuthD.getSession(sid);
                        loginState.setOldSession(oldSession);
                    }
                    if (sessionUpgrade) {
                        loginState.setOldSession(oldSession);
                        loginState.setSessionUpgrade(sessionUpgrade);
                    }
                    authContext = loginState.createAuthContext(sid, orgName, req);
                    authContext.setLoginState(loginState);
                    String queryOrg = AuthUtils.getQueryOrgName(null, orgName);
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("query org is .. : " + queryOrg);
                    }
                    loginState.setQueryOrg(queryOrg);
                }
                catch (AuthException ae) {
                    utilDebug.message("Error creating AuthContextLocal 2: ");
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("Exception ", (Throwable)((Object)ae));
                    }
                    throw new AuthException((Throwable)((Object)ae));
                }
            }
            try {
                InternalSession requestSess = AuthD.getSession(sessionID);
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthUtil :Session is .. : " + requestSess);
                }
                if ((loginState = AuthUtils.getLoginState(authContext)) != null) {
                    loginState.setSession(requestSess);
                    loginState.setRequestType(false);
                }
            }
            catch (Exception ae) {
                utilDebug.message("Error Retrieving AuthContextLocal");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Exception ", ae);
                }
                throw new AuthException("102", null);
            }
            if (forceAuth) {
                loginState.setForceAuth(forceAuth);
            }
        }
        catch (Exception ee) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Creating AuthContextLocal 2: ", ee);
            }
            throw new AuthException(ee);
        }
        return authContext;
    }

    public static Set getAuthModules(int authLevel, String organizationDN, String clientType) {
        return AMAuthLevelManager.getInstance().getModulesForLevel(authLevel, organizationDN, clientType);
    }

    public static InternalSession getOldSession(AuthContextLocal authContext) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        InternalSession oldSession = loginState.getOldSession();
        return oldSession;
    }

    public static AuthContextLocal getOrigAuthContext(SessionID sid) throws AuthException {
        AuthContextLocal authContext = null;
        AuthD ad = AuthD.getAuth();
        try {
            authContext = AuthUtils.retrieveAuthContext(sid);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtil:getOrigAuthContext:sid is.:" + sid);
                utilDebug.message("AuthUtil:getOrigAuthContext:authContext is:" + authContext);
            }
            InternalSession sess = AuthUtils.getLoginState(authContext).getSession();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Session is : " + sess);
                if (sess != null) {
                    utilDebug.message("Session State is : " + sess.getState());
                }
                utilDebug.message("Returning Orig AuthContext:" + authContext);
            }
            if (sess == null) {
                return null;
            }
            int status = sess.getState();
            if (status == 0) {
                return null;
            }
            return authContext;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSessionActive(AuthContextLocal oldAuthContext) {
        try {
            InternalSession sess = AuthUtils.getSession(oldAuthContext);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Sess is : " + sess);
            }
            boolean sessionValid = false;
            if (sess != null) {
                if (sess.getState() == 1) {
                    sessionValid = true;
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Sess State is : " + sess.getState());
                    utilDebug.message("Is Session Active : " + sessionValid);
                }
            }
            return sessionValid;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSessionProperty(String property, AuthContextLocal oldAuthContext) {
        String value = null;
        try {
            InternalSession sess = AuthUtils.getSession(oldAuthContext);
            if (sess != null) {
                value = sess.getProperty(property);
            }
        }
        catch (Exception e) {
            utilDebug.message("Error : ", e);
        }
        return value;
    }

    public static boolean isSessionUpgrade(AuthContextLocal authContext) {
        boolean isSessionUpgrade = false;
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState != null) {
            isSessionUpgrade = loginState.isSessionUpgrade();
        }
        return isSessionUpgrade;
    }

    public static void setCookieSupported(AuthContextLocal ac, boolean flag) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState == null) {
            return;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("set cookieSupported to : " + flag);
            utilDebug.message("set cookieDetect to false");
        }
        loginState.setCookieSupported(flag);
    }

    public static boolean isCookieSupported(AuthContextLocal ac) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSupported();
    }

    public static boolean isCookieSet(AuthContextLocal ac) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSet();
    }

    public static boolean checkForCookies(HttpServletRequest req, AuthContextLocal ac) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState != null) {
            utilDebug.message("set cookieSet to false.");
            loginState.setCookieSet(false);
            loginState.setCookieDetect(false);
        }
        return CookieUtils.getCookieValueFromReq(req, AuthUtils.getAuthCookieName()) != null || CookieUtils.getCookieValueFromReq(req, AuthUtils.getCookieName()) != null;
    }

    public static String getLoginURL(AuthContextLocal authContext) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState == null) {
            return null;
        }
        return loginState.getLoginURL();
    }

    public static AuthContextLocal getAuthContextFromHash(SessionID sid) {
        AuthContextLocal authContext = null;
        if (sid != null) {
            authContext = AuthUtils.retrieveAuthContext(sid);
        }
        return authContext;
    }

    public static Callback[] getCallbacksPerState(AuthContextLocal authContext, String pageState) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        Callback[] recdCallback = null;
        if (loginState != null) {
            recdCallback = loginState.getCallbacksPerState(pageState);
        }
        if (recdCallback != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < recdCallback.length; ++i) {
                    utilDebug.message("in getCallbacksPerState, recdCallback[" + i + "] :" + recdCallback[i]);
                }
            }
        } else {
            utilDebug.message("in getCallbacksPerState, recdCallback is null");
        }
        return recdCallback;
    }

    public static void setCallbacksPerState(AuthContextLocal authContext, String pageState, Callback[] callbacks) {
        LoginState loginState = AuthUtils.getLoginState(authContext);
        if (loginState != null) {
            loginState.setCallbacksPerState(pageState, callbacks);
        }
        if (callbacks != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < callbacks.length; ++i) {
                    utilDebug.message("in setCallbacksPerState, callbacks[" + i + "] :" + callbacks[i]);
                }
            }
        } else {
            utilDebug.message("in setCallbacksPerState, callbacks is null");
        }
    }

    public static SessionID getSidValue(AuthContextLocal authContext, HttpServletRequest request) {
        SessionID sessionId = null;
        if (authContext != null) {
            utilDebug.message("AuthContext is not null");
            try {
                String sid = AuthUtils.getSidString(authContext);
                if (sid != null) {
                    sessionId = new SessionID(sid);
                }
            }
            catch (Exception e) {
                utilDebug.message("Exception getting sid", e);
            }
        }
        if (sessionId == null) {
            utilDebug.message("Sid from AuthContext is null");
            sessionId = new SessionID(request);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("sid is : " + sessionId);
        }
        return sessionId;
    }

    public static boolean isCookieSupported(AuthContextLocal authContext, HttpServletRequest request) {
        boolean cookieSupported;
        if (authContext != null) {
            utilDebug.message("AuthContext is not null");
            cookieSupported = AuthUtils.isCookieSupported(authContext);
        } else {
            cookieSupported = AuthUtils.checkForCookies(request, null);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie supported" + cookieSupported);
        }
        return cookieSupported;
    }

    public static AuthContext.IndexType getPrevIndexType(AuthContextLocal ac) {
        LoginState loginState = AuthUtils.getLoginState(ac);
        if (loginState != null) {
            return loginState.getPreviousIndexType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isPureJAASModulePresent(String configName, AMLoginContext amlc) throws AuthLoginException {
        if (AuthD.enforceJAASThread) {
            return 1;
        }
        int returnValue = -1;
        Configuration ISConfiguration = null;
        try {
            ISConfiguration = Configuration.getConfiguration();
        }
        catch (Exception e) {
            return 1;
        }
        AppConfigurationEntry[] entries = ISConfiguration.getAppConfigurationEntry(configName);
        if (entries == null) {
            throw new AuthLoginException(BUNDLE_NAME, "105", null);
        }
        amlc.setConfigEntries(entries);
        for (int i = 0; i < entries.length; ++i) {
            ArrayList arrayList;
            String className = entries[i].getLoginModuleName();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("config entry: " + className);
            }
            if (pureJAASModuleClasses.contains(className)) {
                returnValue = 1;
                break;
            }
            if (ISModuleClasses.contains(className)) continue;
            try {
                Object classObject = Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                if (classObject instanceof AMLoginModule) {
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message(className + " is instance of AMLoginModule");
                    }
                    arrayList = ISModuleClasses;
                    synchronized (arrayList) {
                        if (!ISModuleClasses.contains(className)) {
                            ISModuleClasses.add(className);
                        }
                        continue;
                    }
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message(className + " is a pure jaas module");
                }
                arrayList = pureJAASModuleClasses;
                synchronized (arrayList) {
                    if (!pureJAASModuleClasses.contains(className)) {
                        pureJAASModuleClasses.add(className);
                    }
                }
                returnValue = 1;
            }
            catch (Exception e) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("fail to instantiate class for " + className);
                }
                arrayList = pureJAASModuleClasses;
                synchronized (arrayList) {
                    if (!pureJAASModuleClasses.contains(className)) {
                        pureJAASModuleClasses.add(className);
                    }
                }
                returnValue = 1;
            }
            break;
        }
        return returnValue;
    }

    public static String getModuleServiceName(String moduleName) {
        String serviceName = (String)moduleService.get(moduleName);
        if (serviceName == null) {
            serviceName = AMAuthConfigUtils.getModuleServiceName(moduleName);
            try {
                SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                new ServiceSchemaManager(serviceName, token);
            }
            catch (Exception e) {
                serviceName = AMAuthConfigUtils.getNewModuleServiceName(moduleName);
            }
            moduleService.put(moduleName, serviceName);
        }
        return serviceName;
    }

    public static int getAuthRevisionNumber() {
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", token);
            return scm.getRevisionNumber();
        }
        catch (Exception e) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("getAuthRevisionNumber error", e);
            }
            return 0;
        }
    }

    public static String getSuccessURL(HttpServletRequest request, AuthContextLocal authContext) {
        String successURL = null;
        if (request != null) {
            successURL = request.getParameter("goto");
        }
        if (successURL == null || successURL.length() == 0 || successURL.equalsIgnoreCase("null")) {
            LoginState loginState = AuthUtils.getLoginState(authContext);
            successURL = loginState == null ? AuthUtils.getSessionProperty("successURL", authContext) : AuthUtils.getLoginState(authContext).getConfiguredSuccessLoginURL();
        } else {
            String encoded = request.getParameter("encoded");
            if (encoded != null && encoded.equals("true")) {
                successURL = AuthUtils.getBase64DecodedValue(successURL);
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getSuccessURL : " + successURL);
        }
        return successURL;
    }

    public static Map processCompositeAdviceXML(String xmlCompositeAdvice, String orgDN, String clientType) {
        HashMap<String, Set> returnAuthInstances;
        block10: {
            returnAuthInstances = null;
            HashSet returnModuleInstances = null;
            try {
                String decodedAdviceXML = URLEncDec.decode((String)xmlCompositeAdvice);
                Map adviceMap = PolicyUtils.parseAdvicesXML(decodedAdviceXML);
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("processCompositeAdviceXML - decoded XML : " + decodedAdviceXML);
                    utilDebug.message("processCompositeAdviceXML - result Map : " + adviceMap);
                }
                if (adviceMap != null && !adviceMap.isEmpty()) {
                    returnAuthInstances = new HashMap<String, Set>();
                    returnModuleInstances = new HashSet();
                    Set keySet = adviceMap.keySet();
                    Iterator keyIter = keySet.iterator();
                    while (keyIter.hasNext()) {
                        String name = (String)keyIter.next();
                        Set values = (Set)adviceMap.get(name);
                        if (name.equals("AuthenticateToRealmConditionAdvice")) {
                            returnAuthInstances.put(name, values);
                            break;
                        }
                        if (name.equals("AuthenticateToServiceConditionAdvice")) {
                            returnAuthInstances.put(name, values);
                            continue;
                        }
                        if (name.equals("AuthSchemeConditionAdvice")) {
                            returnModuleInstances.addAll(values);
                            continue;
                        }
                        if (!name.equals("AuthLevelConditionAdvice")) continue;
                        Set newAuthLevelModules = AuthUtils.processAuthLevelCondition(values, orgDN, clientType);
                        returnModuleInstances.addAll(newAuthLevelModules);
                    }
                    if (returnAuthInstances.isEmpty()) {
                        returnAuthInstances.put("AuthSchemeConditionAdvice", returnModuleInstances);
                    }
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block10;
                utilDebug.message("Error in processCompositeAdviceXML : ", e);
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("processCompositeAdviceXML - returnAuthInstances : " + returnAuthInstances);
        }
        return returnAuthInstances;
    }

    private static Set processAuthLevelCondition(Set authLevelvalues, String orgDN, String clientType) {
        HashSet<String> returnModuleInstances;
        block14: {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("processAuthLevelCondition - authLevelvalues : " + authLevelvalues);
            }
            returnModuleInstances = Collections.EMPTY_SET;
            try {
                if (authLevelvalues != null && !authLevelvalues.isEmpty()) {
                    int minAuthlevel = Integer.MAX_VALUE;
                    String qualifiedRealm = null;
                    String qualifiedOrgDN = null;
                    Iterator iter = authLevelvalues.iterator();
                    while (iter.hasNext()) {
                        String realmQualifiedAuthLevel = (String)iter.next();
                        String strAuthLevel = AMAuthUtils.getDataFromRealmQualifiedData(realmQualifiedAuthLevel);
                        try {
                            int authLevel = Integer.parseInt(strAuthLevel);
                            if (authLevel >= minAuthlevel) continue;
                            minAuthlevel = authLevel;
                            qualifiedRealm = AMAuthUtils.getRealmFromRealmQualifiedData(realmQualifiedAuthLevel);
                            qualifiedOrgDN = null;
                            if (qualifiedRealm != null && qualifiedRealm.length() != 0) {
                                qualifiedOrgDN = DNMapper.orgNameToDN(qualifiedRealm);
                            }
                            if (!utilDebug.messageEnabled()) continue;
                            utilDebug.message("qualifiedRealm : " + qualifiedRealm);
                            utilDebug.message("qualifiedOrgDN : " + qualifiedOrgDN);
                        }
                        catch (Exception nex) {}
                    }
                    if (qualifiedOrgDN != null && qualifiedOrgDN.length() != 0) {
                        Set moduleInstances = AuthUtils.getAuthModules(minAuthlevel, qualifiedOrgDN, clientType);
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("moduleInstances : " + moduleInstances);
                        }
                        if (moduleInstances != null && !moduleInstances.isEmpty()) {
                            returnModuleInstances = new HashSet<String>();
                            Iterator iterInstances = moduleInstances.iterator();
                            while (iterInstances.hasNext()) {
                                String moduleInstance = (String)iterInstances.next();
                                String realmQualifiedModuleInstance = AMAuthUtils.toRealmQualifiedAuthnData(qualifiedRealm, moduleInstance);
                                returnModuleInstances.add(realmQualifiedModuleInstance);
                            }
                        }
                    } else {
                        returnModuleInstances = AuthUtils.getAuthModules(minAuthlevel, orgDN, clientType);
                    }
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("processAuthLevelCondition - returnModuleInstances : " + returnModuleInstances + " for auth level : " + minAuthlevel);
                    }
                }
            }
            catch (Exception e) {
                if (!utilDebug.messageEnabled()) break block14;
                utilDebug.message("Error in processAuthLevelCondition : ", e);
            }
        }
        return returnModuleInstances;
    }

    private static AuthContextLocal retrieveAuthContext(HttpServletRequest req, SessionID sid) {
        AuthContextLocal acLocal = null;
        if (req != null && AuthD.isHttpSessionUsed()) {
            HttpSession hs = req.getSession(false);
            if (hs != null) {
                acLocal = (AuthContextLocal)hs.getAttribute("authContextObject");
                if (utilDebug.messageEnabled() && acLocal != null) {
                    utilDebug.message("authContext from httpsession: " + acLocal);
                }
            }
        } else if (sid != null) {
            acLocal = AuthUtils.retrieveAuthContext(sid);
        }
        return acLocal;
    }

    private static AuthContextLocal retrieveAuthContext(SessionID sid) {
        InternalSession is = AuthD.getSession(sid);
        AuthContextLocal localAC = null;
        if (is != null) {
            localAC = (AuthContextLocal)is.getObject("authContextObject");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("retrieveAuthContext - InternalSession = " + is);
            utilDebug.message("retrieveAuthContext - aclocal = " + localAC);
        }
        return localAC;
    }

    public static void removeAuthContext(SessionID sid) {
        InternalSession is = AuthD.getSession(sid);
        if (is != null) {
            is.removeObject("authContextObject");
        }
    }

    public static String getOrgConfiguredAuthenticationChain(String orgDN) {
        AuthD ad = AuthD.getAuth();
        return ad.getOrgConfiguredAuthenticationChain(orgDN);
    }

    public static String getRemoteSecurityEnabled() throws AuthException {
        ServiceSchema schema = null;
        try {
            SSOToken dUserToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", dUserToken);
            schema = scm.getGlobalSchema();
        }
        catch (Exception exp) {
            utilDebug.error("Cannot get global schema", exp);
            throw new AuthException("102", null);
        }
        Map attrs = null;
        if (schema != null) {
            attrs = schema.getAttributeDefaults();
        }
        String securityEnabled = Misc.getMapAttr(attrs, "sunRemoteAuthSecurityEnabled");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Security Enabled = " + securityEnabled);
        }
        return securityEnabled;
    }

    public static boolean isForwardSuccess(AuthContextLocal authContext, HttpServletRequest req) {
        LoginState loginState;
        boolean isForward = AuthUtils.forwardSuccessExists(req);
        if (!isForward && (loginState = AuthUtils.getLoginState(authContext)) != null) {
            isForward = loginState.isForwardSuccess();
        }
        return isForward;
    }

    public static boolean forwardSuccessExists(HttpServletRequest req) {
        boolean isForward;
        String forward = req.getParameter("forward");
        boolean bl = isForward = forward != null && forward.equals("true");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("forwardSuccessExists : " + isForward);
        }
        return isForward;
    }

    public static Map getGlobalAttributes(String serviceName) {
        Map attrs = null;
        try {
            SSOToken dUserToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, dUserToken);
            ServiceSchema schema = scm.getGlobalSchema();
            if (schema != null) {
                attrs = schema.getAttributeDefaults();
            }
        }
        catch (SMSException smsExp) {
            utilDebug.error("AuthUtils.getGlobalAttributes: SMS Error", smsExp);
        }
        catch (SSOException ssoExp) {
            utilDebug.error("AuthUtils.getGlobalAttributes: SSO Error", (Throwable)((Object)ssoExp));
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils.getGlobalAttributes: attrs=" + attrs);
        }
        return attrs;
    }

    static {
        utilDebug = Debug.getInstance("amAuthUtils");
    }
}

