/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AllowedModulesChoiceValues
extends ChoiceValues {
    Map choiceValues = null;
    private static final String NAME = "name";
    private static final String GLOBAL = "Global";
    private static final String SCHEMA_ATTRIBUTE = "AttributeSchema";
    private static final String ATTRIBUTE_DEFAULT_ELEMENT = "DefaultValues";
    private static final String ATTRIBUTE_VALUE = "Value";
    private static final String AUTHENTICATORS = "iplanet-am-auth-authenticators";
    private static final String APPLICATION_MODULE = "Application";
    private static HashMap orgMap = new HashMap();

    public Map getChoiceValues() {
        HashMap<String, String> answer = new HashMap<String, String>();
        Node attributeSchemaNode = this.getAttributeSchemaNode();
        Node orgNode = attributeSchemaNode.getParentNode();
        Node schemaNode = orgNode.getParentNode();
        Node globalNode = XMLUtils.getChildNode((Node)schemaNode, (String)GLOBAL);
        Node attrNode = XMLUtils.getNamedChildNode((Node)globalNode, (String)SCHEMA_ATTRIBUTE, (String)NAME, (String)AUTHENTICATORS);
        Node defaultsNode = XMLUtils.getChildNode((Node)attrNode, (String)ATTRIBUTE_DEFAULT_ELEMENT);
        NodeList children = defaultsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String defaultValue;
            String choiceValue;
            Node n = children.item(i);
            if (!n.getNodeName().equals(ATTRIBUTE_VALUE) || (choiceValue = (defaultValue = XMLUtils.getValueOfValueNode((Node)n)).substring(defaultValue.lastIndexOf(46) + 1)).equals(APPLICATION_MODULE)) continue;
            answer.put(choiceValue, choiceValue);
        }
        this.choiceValues = answer;
        return this.choiceValues;
    }

    public Map getChoiceValues(Map envParams) {
        this.getChoiceValues();
        Set serviceNames = null;
        String orgDN = null;
        HashMap<String, String> registeredServices = new HashMap<String, String>();
        if (envParams != null) {
            orgDN = (String)envParams.get("organization_name");
        }
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = SMSEntry.getRootSuffix();
        }
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            OrganizationConfigManager orgConfig = this.getOrgConfigManager(orgDN, adminToken);
            serviceNames = orgConfig.getAssignedServices();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (serviceNames != null) {
            Iterator ite = this.choiceValues.keySet().iterator();
            while (ite.hasNext()) {
                String value = (String)ite.next();
                if (this.serviceRegistered(value, serviceNames)) {
                    registeredServices.put(value, value);
                    continue;
                }
                String serviceName = AuthUtils.getModuleServiceName(value);
                try {
                    new ServiceConfigManager(serviceName, adminToken);
                }
                catch (SMSException e) {
                    registeredServices.put(value, value);
                }
                catch (Exception e) {}
            }
        }
        return registeredServices;
    }

    private boolean serviceRegistered(String name, Set serviceSet) {
        Iterator ite = serviceSet.iterator();
        while (ite.hasNext()) {
            String serviceName = (String)ite.next();
            if (serviceName.indexOf(name) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrganizationConfigManager getOrgConfigManager(String orgDN, SSOToken adminToken) {
        OrganizationConfigManager orgConfigMgr = null;
        try {
            if (orgMap != null && !orgMap.isEmpty()) {
                orgConfigMgr = (OrganizationConfigManager)orgMap.get(orgDN);
            }
            HashMap hashMap = orgMap;
            synchronized (hashMap) {
                if (orgConfigMgr == null) {
                    orgConfigMgr = new OrganizationConfigManager(adminToken, orgDN);
                    orgMap.put(orgDN, orgConfigMgr);
                }
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        return orgConfigMgr;
    }
}

