/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.ISAccountLockout;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.util.DN;

class AMAccountLockout {
    LoginState loginState = null;
    private static AuthD ad = AuthD.getAuth();
    private static Debug debug = AuthD.debug;
    public boolean loginFailureLockoutMode = false;
    public boolean loginFailureLockoutStoreInDS = true;
    private long loginFailureLockoutTime = 300L;
    private int loginFailureLockoutCount = 5;
    private String loginLockoutNotification = null;
    private int loginLockoutUserWarning = 3;
    private long loginFailureLockoutDuration = 0L;
    private int loginFailureLockoutMultiplier = 0;
    public String loginLockoutAttrValue = null;
    public String loginLockoutAttrName = null;
    private ISAccountLockout isAccountLockout;
    private int warnUser = -1;
    static String bundleName = "amAuth";
    String token = null;
    private static final String USER_ACTIVE = "active";
    private static final String USER_INACTIVE = "inactive";
    private static final String FALSE_VALUE = "false";
    private static final String INETUSERSTATUS_ATTR = "inetuserstatus";
    private static final String LOGIN_STATUS_ATTR = "iplanet-am-user-login-status";
    private static final String NSACCOUNTLOCK_ATTR = "nsaccountlock";
    private AccountLockoutInfo acInfo = null;

    public AMAccountLockout(LoginState loginState) {
        this.loginState = loginState;
        this.loginFailureLockoutTime = loginState.getLoginFailureLockoutTime();
        this.loginFailureLockoutCount = loginState.getLoginFailureLockoutCount();
        this.loginLockoutNotification = loginState.getLoginLockoutNotification();
        this.loginLockoutUserWarning = loginState.getLoginLockoutUserWarning();
        this.loginLockoutAttrName = loginState.getLoginLockoutAttrName();
        this.loginLockoutAttrValue = loginState.getLoginLockoutAttrValue();
        this.loginFailureLockoutDuration = loginState.getLoginFailureLockoutDuration();
        this.loginFailureLockoutMultiplier = loginState.getLoginFailureLockoutMultiplier();
        this.loginFailureLockoutMode = loginState.getLoginFailureLockoutMode();
        this.loginFailureLockoutStoreInDS = loginState.getLoginFailureLockoutStoreInDS();
        this.isAccountLockout = new ISAccountLockout(this.loginFailureLockoutMode, this.loginFailureLockoutTime, this.loginFailureLockoutCount, this.loginLockoutNotification, this.loginLockoutUserWarning, this.loginLockoutAttrName, this.loginLockoutAttrValue, this.loginFailureLockoutDuration, this.loginFailureLockoutMultiplier, bundleName);
        this.isAccountLockout.setStoreInvalidAttemptsInDS(this.loginFailureLockoutStoreInDS);
    }

    public void invalidPasswd(String token) {
        block8: {
            try {
                if (debug.messageEnabled()) {
                    debug.message("AMAccountLockout::invalidPasswd : " + token);
                }
                this.token = token;
                if (!this.isAccountLockout.isLockoutEnabled()) {
                    debug.message("Failure lockout mode disabled");
                } else {
                    String userDN = null;
                    AMIdentity amIdentity = null;
                    if (this.isAccountLockout.getStoreInvalidAttemptsInDS() || !this.isAccountLockout.isMemoryLocking()) {
                        amIdentity = AuthD.getAuth().getIdentity(IdType.USER, token, this.loginState.getOrgDN());
                        userDN = this.normalizeDN(IdUtils.getDN(amIdentity));
                    } else {
                        userDN = this.normalizeDN(token);
                    }
                    if (this.acInfo == null) {
                        this.acInfo = this.isAccountLockout.getAcInfo(userDN, amIdentity);
                    }
                    this.warnUser = this.isAccountLockout.invalidPasswd(userDN, token, amIdentity, this.acInfo);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block8;
                debug.message("invalidPasswd:Error : " + e.toString());
            }
        }
    }

    public boolean isAccountExpired() {
        debug.message("in AMAccountLockout::isAccountExpired");
        String accountLife = this.loginState.getAccountLife();
        if (accountLife == null) {
            if (debug.messageEnabled()) {
                debug.message("EXIT accountLife is null :" + accountLife);
            }
            return false;
        }
        Date exprDate = Locale.parseNormalizedDateString((String)accountLife);
        if (debug.messageEnabled()) {
            debug.message("exprDate = " + exprDate);
        }
        if (exprDate != null) {
            return exprDate.before(new Date());
        }
        return false;
    }

    public int getWarnUserCount() {
        return this.warnUser;
    }

    public void sendLockOutNotice(String userDN) {
        this.isAccountLockout.sendLockOutNotice(userDN);
    }

    public void resetPasswdLockout(String token, boolean resetDuration) {
        try {
            String userDN = null;
            if (token != null) {
                AMIdentity amIdentity = null;
                if (this.isAccountLockout.getStoreInvalidAttemptsInDS()) {
                    amIdentity = AuthD.getAuth().getIdentity(IdType.USER, token, this.loginState.getOrgDN());
                    userDN = this.normalizeDN(IdUtils.getDN(amIdentity));
                } else {
                    userDN = this.normalizeDN(token);
                }
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(userDN, amIdentity);
                }
                this.isAccountLockout.resetLockoutAttempts(userDN, amIdentity, this.acInfo, resetDuration);
                this.warnUser = 0;
            }
            if (debug.messageEnabled()) {
                debug.message("resetPasswordFailCount: token=" + token + "  userDN=" + userDN);
            }
        }
        catch (Exception exp) {
            debug.message("Exception in resetPasswordLockout");
        }
    }

    public boolean isLockoutEnabled() {
        return this.isAccountLockout.isLockoutEnabled();
    }

    public boolean isLockedOut() {
        String userDN = this.loginState.getUserDN();
        return this.isLockedOut(userDN);
    }

    public boolean isLockedOut(String userName) {
        boolean locked;
        block3: {
            String normUserDN = this.normalizeDN(userName);
            locked = false;
            try {
                if (this.isAccountLockout.isMemoryLocking()) {
                    locked = this.isMemoryLockout(normUserDN);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("isLockedOut:Exception : ", (Throwable)e);
            }
        }
        return locked;
    }

    private boolean isMemoryLockout(String aUserName) {
        boolean locked;
        block8: {
            locked = false;
            try {
                String userDN = null;
                AMIdentity amIdentity = null;
                if (this.isAccountLockout.getStoreInvalidAttemptsInDS()) {
                    amIdentity = AuthD.getAuth().getIdentity(IdType.USER, aUserName, this.loginState.getOrgDN());
                    userDN = this.normalizeDN(IdUtils.getDN(amIdentity));
                } else {
                    userDN = aUserName;
                }
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(userDN, amIdentity);
                }
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut:userDN=" + userDN);
                    debug.message("isLockedOut:acInfo=" + this.acInfo);
                }
                if (this.acInfo != null && !(locked = this.isAccountLockout.isLockedOut(this.acInfo)) && this.acInfo.isLockout()) {
                    this.resetPasswdLockout(aUserName, false);
                }
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut :" + locked);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block8;
                debug.message("isLockedOut:Exception : ", (Throwable)e);
            }
        }
        return locked;
    }

    public boolean isAccountLocked(String aUserName) {
        boolean locked;
        block10: {
            locked = false;
            try {
                AMIdentity amIdentity = AuthD.getAuth().getIdentity(IdType.USER, aUserName, this.loginState.getOrgDN());
                String userDN = this.normalizeDN(IdUtils.getDN(amIdentity));
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(userDN, amIdentity);
                }
                if (debug.messageEnabled()) {
                    debug.message("userDN=" + userDN);
                    debug.message("acInfo=" + this.acInfo);
                }
                if (this.isAccountLockout.isMemoryLocking() && this.acInfo != null) {
                    locked = this.acInfo.isLockout();
                } else if (this.isAccountValid(amIdentity)) {
                    locked = this.isAccountLockout.isAccountLocked(amIdentity);
                    if (locked) {
                        this.resetPasswdLockout(aUserName, false);
                    }
                } else {
                    locked = true;
                    this.resetPasswdLockout(aUserName, false);
                }
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut :" + locked);
                }
            }
            catch (Exception e) {
                if (!AuthD.debug.messageEnabled()) break block10;
                AuthD.debug.message("isAccountLocked:Exception : " + e.toString());
            }
        }
        return locked;
    }

    boolean isAccountValid(AMIdentity amIdentity) {
        boolean userEnabled;
        block10: {
            userEnabled = true;
            try {
                Iterator attrSet = null;
                String userActive = amIdentity.isActive() ? USER_ACTIVE : USER_INACTIVE;
                Set loginStatusSet = amIdentity.getAttribute(LOGIN_STATUS_ATTR);
                String loginStatus = null;
                if (loginStatusSet == null || loginStatusSet.isEmpty()) {
                    loginStatus = USER_ACTIVE;
                } else {
                    attrSet = loginStatusSet.iterator();
                    loginStatus = (String)attrSet.next();
                    if (loginStatus == null || loginStatus.length() == 0) {
                        loginStatus = USER_ACTIVE;
                    }
                }
                Set nsAccountValSet = amIdentity.getAttribute(NSACCOUNTLOCK_ATTR);
                String nsAccountVal = null;
                if (nsAccountValSet == null || nsAccountValSet.isEmpty()) {
                    nsAccountVal = FALSE_VALUE;
                } else {
                    attrSet = nsAccountValSet.iterator();
                    nsAccountVal = (String)attrSet.next();
                    if (nsAccountVal == null || nsAccountVal.length() == 0) {
                        nsAccountVal = FALSE_VALUE;
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("inetuserstatus : " + userActive);
                    debug.message("loginStatus : " + loginStatus);
                    debug.message("nsAccountLockVal : " + nsAccountVal);
                }
                userEnabled = userActive.equalsIgnoreCase(USER_ACTIVE) && loginStatus.equalsIgnoreCase(USER_ACTIVE) && nsAccountVal.equalsIgnoreCase(FALSE_VALUE);
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block10;
                debug.message("isAccountValid:Error :" + e.toString());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("User enabled..." + userEnabled);
        }
        return userEnabled;
    }

    private String normalizeDN(String userDN) {
        String normalizedDN = userDN;
        if (userDN != null && DN.isDN((String)userDN)) {
            normalizedDN = DNUtils.normalizeDN(userDN);
        }
        if (debug.messageEnabled()) {
            debug.message("Original DN is:" + userDN);
            debug.message("Normalized DN is:" + normalizedDN);
        }
        return normalizedDN;
    }
}

