/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.nt;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.nt.NTPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class NT
extends AMLoginModule {
    private static boolean hasInitialized = false;
    private static String baseDir;
    private static Debug debug;
    private static String smbPath;
    private static final String charSet = "ISO8859_1";
    private static final String amAuthNT = "amAuthNT";
    private ResourceBundle bundle = null;
    private Map options;
    private Map sharedState;
    private String host;
    private String domain;
    private NTPrincipal userPrincipal;
    private String userTokenId = "";
    private String userName = null;
    private String smbConfFileName;
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthNT, locale);
        if (debug.messageEnabled()) {
            debug.message("NT resbundle locale=" + locale);
        }
        this.sharedState = sharedState;
        this.options = options;
        if (options != null) {
            this.host = CollectionHelper.getServerMapAttr((Map)options, (String)"iplanet-am-auth-nt-host");
            this.domain = CollectionHelper.getServerMapAttr((Map)options, (String)"iplanet-am-auth-nt-domain");
            this.smbConfFileName = CollectionHelper.getServerMapAttr((Map)options, (String)"iplanet-am-auth-samba-config-file-name");
            String authLevel = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-nt-auth-level");
            if (authLevel != null) {
                try {
                    this.setAuthLevel(Integer.parseInt(authLevel));
                }
                catch (Exception e) {
                    debug.error("Unable to set auth level " + authLevel);
                }
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        if (!hasInitialized) {
            throw new AuthLoginException(amAuthNT, "NTSMB", null);
        }
        if (this.host == null || this.host.length() == 0) {
            debug.message("NT Host cannot be null ");
            throw new AuthLoginException(amAuthNT, "Hosterror", null);
        }
        if (this.domain == null || this.domain.length() == 0) {
            debug.message("NT Domain cannot be null ");
            throw new AuthLoginException(amAuthNT, "Domainerror", null);
        }
        try {
            if (!this.host.equals(new String(this.host.getBytes("ASCII"), "ASCII"))) {
                throw new AuthLoginException(amAuthNT, "NTHostnameNotASCII", null);
            }
            if (!this.domain.equals(new String(this.domain.getBytes("ASCII"), "ASCII"))) {
                throw new AuthLoginException(amAuthNT, "NTDomainnameNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException ueex) {
            throw new AuthLoginException(amAuthNT, "NTInputNotASCII", null);
        }
        String userPassword = null;
        if (callbacks != null && callbacks.length == 0) {
            this.userName = (String)this.sharedState.get(this.getUserKey());
            userPassword = (String)this.sharedState.get(this.getPwdKey());
            if (this.userName == null || userPassword == null) {
                return 1;
            }
            this.getCredentialsFromSharedState = true;
        } else {
            this.userName = ((NameCallback)callbacks[0]).getName();
            userPassword = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
            if (this.userName == null || this.userName.length() == 0) {
                debug.message("UserId cannot be null");
                throw new AuthLoginException(amAuthNT, "UserIderror", null);
            }
            if (userPassword == null || userPassword.length() == 0) {
                debug.message("Password cannot be null");
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "Passworderror", null);
            }
        }
        this.storeUsernamePasswd(this.userName, userPassword);
        try {
            if (!this.userName.equals(new String(this.userName.getBytes("ASCII"), "ASCII"))) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                throw new AuthLoginException(amAuthNT, "NTUsernameNotASCII", null);
            }
            if (!userPassword.equals(new String(userPassword.getBytes("ASCII"), "ASCII"))) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTPasswordNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException ueex) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            throw new AuthLoginException(amAuthNT, "NTInputNotASCII", null);
        }
        if (debug.messageEnabled()) {
            debug.message("userName='" + this.userName + "' host='" + this.host + "'");
            debug.message("domain='" + this.domain + "'");
        }
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = null;
            if (this.smbConfFileName != null && this.smbConfFileName.length() > 0) {
                progarr = new String[9];
                progarr[7] = "-s";
                progarr[8] = this.smbConfFileName;
            } else {
                progarr = new String[]{smbPath, "-W", this.domain, "-L", this.host, "-U", this.userName + "%" + userPassword};
            }
            Process smbconn = rt.exec(progarr);
            BufferedReader smbout = new BufferedReader(new InputStreamReader(smbconn.getInputStream(), charSet));
            while ((c = smbout.read()) > -1) {
                char chtxt = (char)c;
                buftxt.append(chtxt);
            }
            smbout.close();
            String out = buftxt.toString();
            if (out.indexOf("Usage:") != -1) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                if (debug.messageEnabled()) {
                    debug.message("smbclient usage error");
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTSMBUsage", null);
            }
            if (out.indexOf("failed") != -1) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                if (debug.messageEnabled()) {
                    debug.message("NT authentication failed" + out);
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTLoginFailed", null);
            }
            if (out.indexOf("timeout") != -1) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                if (debug.messageEnabled()) {
                    debug.message("smbclient timeout error");
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTSMBTimeout", null);
            }
            int exitValue = smbconn.waitFor();
            if (debug.messageEnabled()) {
                debug.message("Exit value of samba client: " + exitValue);
            }
            if (exitValue != 0) {
                if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTAuthFailed", null);
            }
            this.userTokenId = this.userName;
            return -1;
        }
        catch (Exception ex) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            if (debug.messageEnabled()) {
                debug.message("NT authentication failed" + ex.getMessage());
            }
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthNT, "NTAuthFailed", null, ex);
        }
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new NTPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.options = null;
        this.sharedState = null;
        this.host = null;
        this.domain = null;
        this.userName = null;
        this.smbConfFileName = null;
    }

    static {
        debug = null;
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthNT);
            debug.message("NT constructor called");
        }
        String base = SystemProperties.get("com.iplanet.services.configpath");
        String deployURL = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
        baseDir = base + "/" + deployURL;
        smbPath = baseDir + "/bin/smbclient";
        File file = new File(smbPath);
        if (!file.exists()) {
            debug.error("smbclient file not found");
            hasInitialized = false;
        }
        hasInitialized = true;
    }
}

