/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal.server;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.DNUtils;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;

public class SMSAuthModule
implements LoginModule {
    private static boolean initialized;
    private static boolean loadedInternalUsers;
    private static boolean registeredCallbackHandler;
    private static Map users;
    private static Map userNameToDN;
    private static Debug debug;
    AuthSubject subject;
    String userDN;
    CallbackHandler cb;
    Map sharedState;
    Map options;
    private static final String IDREPO_SERVICE = "sunIdentityRepositoryService";
    private static final String USERS = "users";
    private static final String DN = "dn";
    private static final String PASSWORD = "userPassword";

    public SMSAuthModule() {
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule constructor called");
        }
    }

    public void initialize(AuthSubject subject, CallbackHandler cb, Map isharedstate, Map ioptions) {
        this.subject = subject;
        this.cb = cb;
        this.sharedState = isharedstate != null ? isharedstate : Collections.EMPTY_MAP;
        Map map = this.options = ioptions != null ? ioptions : Collections.EMPTY_MAP;
        if (debug.messageEnabled()) {
            HashMap ss = new HashMap(this.sharedState);
            boolean passwordPresent = ss.remove("javax.security.auth.login.password") != null;
            debug.message("SMSAuthModule::initialize called \nPrincipals: " + (subject != null ? subject.getPrincipals().toString() : "null") + "\nSharedState: " + ss + "\n" + (passwordPresent ? "<Password Present> " : "<Password Absent>") + "\nOptions: " + this.options);
        }
        if (!initialized) {
            SMSAuthModule.initialize();
        }
    }

    public static void initialize() {
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule.initialize() Initializing Username and password from serverconfig.xml");
        }
        loadedInternalUsers = false;
        users = new CaseInsensitiveHashMap();
        userNameToDN = new CaseInsensitiveHashMap();
        String name = (String)AccessController.doPrivileged(new AdminDNAction());
        String passwd = (String)AccessController.doPrivileged(new AdminPasswordAction());
        SMSAuthModule.addUserToCache(name, Hash.hash((String)passwd));
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule.initialize() Username serviceconfig.xml: " + name);
        }
        initialized = true;
    }

    public boolean login() throws LoginException {
        String username = (String)this.sharedState.get("javax.security.auth.login.name");
        String password = (String)this.sharedState.get("javax.security.auth.login.password");
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule::login() From shared state: Username: " + username + " Password: " + (password == null ? "<not present>" : "<present>"));
        }
        if (username == null || password == null) {
            Callback[] cbs = new Callback[]{new NameCallback("User name: "), new PasswordCallback("Password: ", false)};
            try {
                if (debug.messageEnabled()) {
                    debug.message("SMSAuthModule::login() Sending Name & Password Callback");
                }
                this.cb.handle(cbs);
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException(e.getMessage());
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            username = ((NameCallback)cbs[0]).getName();
            char[] passwd = ((PasswordCallback)cbs[1]).getPassword();
            if (passwd != null) {
                password = new String(password);
            }
        }
        boolean authenticated = false;
        if (username != null && password != null) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModule::login() For authentication: Username: " + username + " Password: <present>");
            }
            if (netscape.ldap.util.DN.isDN((String)username)) {
                this.userDN = username;
                username = new DN(this.userDN).explodeDN(true)[0];
            } else {
                this.userDN = (String)userNameToDN.get(username);
                if (this.userDN == null && !loadedInternalUsers) {
                    SMSAuthModule.loadInternalUsers();
                    this.userDN = (String)userNameToDN.get(username);
                }
            }
            if (this.userDN != null) {
                String normalizedUserDN;
                String hash = (String)users.get(username);
                String cachedUserDN = (String)userNameToDN.get(username);
                if (!(cachedUserDN == null || (normalizedUserDN = DNUtils.normalizeDN(this.userDN)) != null && normalizedUserDN.equals(DNUtils.normalizeDN(cachedUserDN)))) {
                    debug.message("SMSAuthModule::login() Invalid User DN");
                    return false;
                }
                boolean invalidPassword = false;
                if (hash != null && hash.equals(Hash.hash((String)password))) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSAuthModule::login() Success AuthN");
                    }
                    authenticated = true;
                } else if (!loadedInternalUsers && hash == null) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSAuthModule::login() Loading internal users");
                    }
                    SMSAuthModule.loadInternalUsers();
                    cachedUserDN = (String)userNameToDN.get(username);
                    if (cachedUserDN != null) {
                        String normalizedUserDN2 = DNUtils.normalizeDN(this.userDN);
                        if (normalizedUserDN2 == null || !normalizedUserDN2.equals(DNUtils.normalizeDN(cachedUserDN))) {
                            if (debug.messageEnabled()) {
                                debug.message("SMSAuthModule::login() Invalid User DN");
                            }
                            return false;
                        }
                    } else {
                        return false;
                    }
                    hash = (String)users.get(username);
                    if (hash != null && hash.equals(Hash.hash((String)password))) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSAuthModule::login() Success AuthN");
                        }
                        authenticated = true;
                    } else if (hash != null) {
                        invalidPassword = true;
                    }
                } else if (hash != null) {
                    invalidPassword = true;
                }
                if (invalidPassword) {
                    throw new InvalidPasswordException("invalid password", this.userDN);
                }
            }
        }
        return authenticated;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        Set principals;
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule::commit() Adding Principal: " + this.userDN + " to Subject");
        }
        if ((principals = this.subject.getPrincipals()).size() == 0) {
            principals.add(new AuthPrincipal(this.userDN));
        }
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private static synchronized void loadInternalUsers() {
        if (loadedInternalUsers) {
            return;
        }
        try {
            SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager scm = new ServiceConfigManager(IDREPO_SERVICE, ssoToken);
            ServiceConfig sc = scm.getGlobalConfig(null);
            sc = sc.getSubConfig(USERS);
            Iterator items = sc.getSubConfigNames().iterator();
            while (items.hasNext()) {
                String scName = (String)items.next();
                ServiceConfig s = sc.getSubConfig(scName);
                Map attrs = s.getAttributes();
                String name = null;
                Set set = (Set)attrs.get(DN);
                if (set != null && !set.isEmpty()) {
                    name = (String)set.iterator().next();
                }
                String hash = null;
                set = (Set)attrs.get(PASSWORD);
                if (set != null && !set.isEmpty()) {
                    hash = (String)set.iterator().next();
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSAuthModule::loadInternalUsers() Added user: " + name);
                }
                SMSAuthModule.addUserToCache(name, hash);
            }
            loadedInternalUsers = true;
            if (!registeredCallbackHandler) {
                scm.addListener(new SMSAuthModuleListener());
                registeredCallbackHandler = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addUserToCache(String name, String hash) {
        users.put(name, hash);
        String[] rdns = new DN(name).explodeDN(true);
        users.put(rdns[0], hash);
        userNameToDN.put(rdns[0], name);
    }

    static {
        debug = Debug.getInstance((String)"amAuthInternalSMModule");
    }

    static class SMSAuthModuleListener
    implements ServiceListener {
        SMSAuthModuleListener() {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::init called");
            }
        }

        public void schemaChanged(String serviceName, String version) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::schemaChanged called");
            }
        }

        public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::globalConfigChanged");
            }
            if (serviceName.equalsIgnoreCase(SMSAuthModule.IDREPO_SERVICE)) {
                loadedInternalUsers = false;
            }
        }

        public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::orgConfigChanged");
            }
        }
    }
}

