/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceSchema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMAuthenticationSchema {
    private ServiceSchema serviceSchema;

    protected AMAuthenticationSchema(ServiceSchema schema) {
        this.serviceSchema = schema;
    }

    public String getName() {
        return this.serviceSchema.getName();
    }

    public String getServiceName() {
        return this.serviceSchema.getServiceName();
    }

    public Set getRequiredAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator it = this.getAttributeNames().iterator();
        while (it.hasNext()) {
            String attr = (String)it.next();
            AttributeSchema as = this.getAttributeSchema(attr);
            String anyValue = as.getAny();
            if (anyValue == null || anyValue.indexOf("required") == -1) continue;
            names.add(attr);
        }
        return names;
    }

    public Set getAttributeNames() {
        return this.serviceSchema.getAttributeSchemaNames();
    }

    public AttributeSchema getAttributeSchema(String attr) {
        return this.serviceSchema.getAttributeSchema(attr);
    }

    public Set getAttributeSchemas() {
        return this.serviceSchema.getAttributeSchemas();
    }

    public Map getAttributeValues() {
        return this.serviceSchema.getAttributeDefaults();
    }

    public Map getAttributeValues(Set names) {
        Map allAttrs = this.getAttributeValues();
        HashMap attrs = new HashMap();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!allAttrs.containsKey(key)) continue;
            attrs.put(key, allAttrs.get(key));
        }
        return attrs;
    }

    public void setAttributeValues(Map values) throws SchemaException, SMSException, SSOException {
        this.serviceSchema.setAttributeDefaults(values);
    }

    public void setAttribute(String attrName, Set values) throws SchemaException, SMSException, SSOException {
        this.serviceSchema.setAttributeDefaults(attrName, values);
    }
}

