/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMAuthConfigType;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfiguration;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.Configuration;

public class AMAuthLevelManager
implements ServiceListener {
    private static AMAuthLevelManager instance = null;
    private Map listenerMap = new HashMap();
    private static Map authLevelMap = new HashMap();
    private static Map supportedModulesMap = new HashMap();
    private static Map moduleServiceMap = new HashMap();
    private static Map globalAuthLevelMap = new HashMap();
    private static Map authConfigListenerMap = new HashMap();
    private static String CORE_AUTH = "iPlanetAMAuthService";
    private Debug debug = Debug.getInstance((String)"amAuthConfig");

    public AMAuthLevelManager() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMAuthLevelManager getInstance() {
        if (instance == null) {
            Class clazz = AMAuthLevelManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new AMAuthLevelManager();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(String serviceName, Map newMap) {
        List list = (List)this.listenerMap.get(serviceName);
        if (list != null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("initialize, existing " + serviceName);
            }
            newMap.put(serviceName, list);
            Map map = this.listenerMap;
            synchronized (map) {
                this.listenerMap.remove(serviceName);
            }
        }
        try {
            list = this.addServiceListener(serviceName);
            if (list != null) {
                newMap.put(serviceName, list);
            }
        }
        catch (Exception e) {
            this.debug.error("can't add listener for " + serviceName, (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        HashMap<String, List> newMap = new HashMap<String, List>();
        this.registerListener(CORE_AUTH, newMap);
        this.registerListener("iPlanetAMAuthConfiguration", newMap);
        Iterator it = AuthD.getAuth().getAuthenticators();
        if (it != null) {
            while (it.hasNext()) {
                String moduleServiceName;
                String moduleName;
                block18: {
                    moduleName = (String)it.next();
                    moduleServiceName = AuthUtils.getModuleServiceName(moduleName);
                    List list = (List)this.listenerMap.get(moduleName);
                    if (list != null) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("initialize, existing " + moduleName);
                        }
                        newMap.put(moduleName, list);
                        Map map = this.listenerMap;
                        synchronized (map) {
                            this.listenerMap.remove(moduleName);
                        }
                    }
                    try {
                        list = this.addServiceListener(moduleServiceName);
                        if (list != null) {
                            newMap.put(moduleName, list);
                        }
                    }
                    catch (Exception e) {
                        if (!this.debug.messageEnabled()) break block18;
                        this.debug.message("authlevel, add service listener," + e.getMessage());
                    }
                }
                if (moduleServiceMap != null && !moduleServiceMap.containsKey(moduleServiceName)) {
                    moduleServiceMap.put(moduleServiceName, moduleName);
                }
                this.updateGlobalAuthLevelMap(moduleServiceName);
            }
        }
        if (!this.listenerMap.isEmpty()) {
            it = this.listenerMap.values().iterator();
            while (it.hasNext()) {
                List list = (List)it.next();
                ServiceSchemaManager ssm = (ServiceSchemaManager)list.get(0);
                String ssmListener = (String)list.get(1);
                ServiceConfigManager scm = (ServiceConfigManager)list.get(2);
                String scmListener = (String)list.get(3);
                try {
                    ssm.removeListener(ssmListener);
                    scm.removeListener(scmListener);
                }
                catch (Exception e) {
                    this.debug.error("remove listeners ", (Throwable)e);
                }
            }
        }
        Map map = this.listenerMap;
        synchronized (map) {
            this.listenerMap = newMap;
        }
    }

    private List addServiceListener(String service) throws SMSException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("addServiceListener for " + service);
        }
        ServiceSchemaManager ssm = null;
        try {
            ssm = new ServiceSchemaManager(service, AuthD.getAuth().getSSOAuthSession());
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        String id = ssm.addListener(this);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ssm);
        list.add(id);
        ServiceConfigManager scm = null;
        try {
            scm = new ServiceConfigManager(service, AuthD.getAuth().getSSOAuthSession());
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        id = scm.addListener(this);
        list.add(scm);
        list.add(id);
        return list;
    }

    public Set getModulesForLevel(int level, String orgDN, String clientType) {
        Map map = (Map)authLevelMap.get(orgDN);
        if (map == null) {
            map = this.initOrgAuthLevel(orgDN);
        }
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set set = this.getModuleForLevel(level, map);
        if (this.debug.messageEnabled()) {
            this.debug.message("getModuleForLevel " + level + ", org=" + orgDN + ", modules=" + set);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("getModuleForLevel, modules=" + set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map initOrgAuthLevel(String orgDN) {
        Map map;
        Set allowedModules;
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        AMAuthenticationManager manager = null;
        try {
            manager = new AMAuthenticationManager(AuthD.getAuth().getSSOAuthSession(), orgDN);
            allowedModules = manager.getAllowedModuleNames();
            map = supportedModulesMap;
            synchronized (map) {
                supportedModulesMap.put(orgDN, allowedModules);
            }
        }
        catch (Exception e) {
            this.debug.error("initOrgAuthLevel " + orgDN, (Throwable)e);
            return map2;
        }
        if (!allowedModules.isEmpty()) {
            Iterator modules = allowedModules.iterator();
            while (modules.hasNext()) {
                AMAuthenticationInstance instance;
                String module = (String)modules.next();
                if (this.debug.messageEnabled()) {
                    this.debug.message("initOrgAuthLevel process " + module);
                }
                if ((instance = manager.getAuthenticationInstance(module)) == null) continue;
                Map attrs = instance.getAttributeValues();
                String attrName = AMAuthConfigUtils.getAuthLevelAttribute(attrs, instance.getType());
                String authLevel = CollectionHelper.getMapAttr((Map)attrs, (String)attrName);
                Integer level = null;
                if (authLevel != null && authLevel.length() != 0) {
                    try {
                        level = Integer.valueOf(authLevel);
                    }
                    catch (Exception e) {
                        this.debug.error("initOrgAuthLevel, invalid level", (Throwable)e);
                    }
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("globalAuthLevel MAP " + globalAuthLevelMap);
                    this.debug.message("initOrgAuthLevel add " + module);
                    this.debug.message("level is... " + level);
                }
                if (level == null) continue;
                map2.put(module, level);
            }
        }
        map = authLevelMap;
        synchronized (map) {
            authLevelMap.put(orgDN, map2);
        }
        return map2;
    }

    private Set getModuleForLevel(int level, Map map) {
        Iterator modules = map.keySet().iterator();
        HashSet<String> set = new HashSet<String>();
        while (modules.hasNext()) {
            String module = (String)modules.next();
            if ((Integer)map.get(module) < level) continue;
            set.add(module);
        }
        return set;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : globalConfigChanged " + serviceName + ", ver=" + version + ", group=" + groupName + ", componnet=" + serviceComponent + ", type=" + type);
        }
        if (serviceName.equals("iPlanetAMAuthService")) {
            AMAuthenticationManager.reInitializeAuthServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : orgConfigChanged " + serviceName + ", ver=" + version + ", org=" + orgName + ", group=" + groupName + ", componnet=" + serviceComponent + ", type=" + type);
        }
        Map map = authLevelMap;
        synchronized (map) {
            authLevelMap.remove(orgName);
        }
        if (AuthD.revisionNumber < 30 && serviceName.equals(CORE_AUTH)) {
            map = supportedModulesMap;
            synchronized (map) {
                supportedModulesMap.remove(orgName);
            }
        }
        AMAuthenticationManager.buildModuleInstanceForService(orgName, serviceName);
        this.updateAuthConfiguration(serviceName, orgName, serviceComponent);
    }

    public void schemaChanged(String serviceName, String version) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : schemaChanged " + serviceName + ", ver=" + version);
        }
        if (serviceName.equals(CORE_AUTH)) {
            this.initialize();
        }
        this.updateAuthConfiguration(serviceName, "", "");
        this.updateGlobalAuthLevelMap(serviceName);
    }

    public int getLevelForModule(String moduleName, String orgDN, String defaultAuthLevel) {
        Map map;
        if (this.debug.messageEnabled()) {
            this.debug.message("moduleName : " + moduleName);
            this.debug.message("orgDN : " + orgDN);
            this.debug.message("defaultAuthLevel: " + defaultAuthLevel);
        }
        if ((map = (Map)authLevelMap.get(orgDN)) == null) {
            map = this.initOrgAuthLevel(orgDN);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Map is : " + map);
        }
        Integer authLevel = null;
        if (map != null && !map.isEmpty()) {
            authLevel = (Integer)map.get(moduleName);
        }
        if (authLevel == null) {
            authLevel = (Integer)globalAuthLevelMap.get(moduleName);
            authLevel = authLevel == null ? Integer.valueOf(defaultAuthLevel) : authLevel;
        }
        int level = authLevel;
        if (this.debug.messageEnabled()) {
            this.debug.message("authLevel : " + level);
        }
        return level;
    }

    protected Set getSupportedModule(String orgDN) {
        Set modules;
        if (this.debug.messageEnabled()) {
            this.debug.message("getSupportedModules=" + orgDN);
        }
        if ((modules = (Set)supportedModulesMap.get(orgDN)) == null) {
            this.initOrgAuthLevel(orgDN);
            modules = (Set)supportedModulesMap.get(orgDN);
            if (modules == null) {
                return Collections.EMPTY_SET;
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("supported modules are : " + modules);
        }
        return modules;
    }

    protected void removeAuthConfigListener(String configName) {
        HashSet<String> set = new HashSet<String>();
        set.add(configName);
        this.removeConfigListenerEntry(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthConfigListener(String service, String name) {
        HashSet<String> set = (HashSet<String>)authConfigListenerMap.get(service);
        if (set == null) {
            set = new HashSet<String>();
            set.add(name);
            Map map = authConfigListenerMap;
            synchronized (map) {
                authConfigListenerMap.put(service, set);
            }
        }
        HashSet<String> hashSet = set;
        synchronized (hashSet) {
            set.add(name);
        }
    }

    private synchronized void updateAuthConfiguration(String serviceName, String orgName, String componentName) {
        Set set = (Set)authConfigListenerMap.get(serviceName);
        if (set == null || set.isEmpty()) {
            return;
        }
        HashSet<String> updatedEntries = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String configName = (String)it.next();
            if (!this.processAuthConfigEntry(serviceName, orgName, componentName, configName)) continue;
            if (updatedEntries == null) {
                updatedEntries = new HashSet<String>();
            }
            updatedEntries.add(configName);
        }
        if (updatedEntries == null) {
            return;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("updateAuthConfiguration, updated=" + updatedEntries);
        }
        this.removeConfigListenerEntry(updatedEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConfigListenerEntry(Set updatedEntries) {
        Map map = authConfigListenerMap;
        synchronized (map) {
            Iterator services = authConfigListenerMap.keySet().iterator();
            while (services.hasNext()) {
                String service = (String)services.next();
                Set entries = (Set)authConfigListenerMap.get(service);
                if (this.debug.messageEnabled()) {
                    this.debug.message("updateAuthConfiguration, check " + service + ", entries=" + entries);
                }
                if (entries == null || entries.isEmpty()) continue;
                entries.removeAll(updatedEntries);
            }
        }
    }

    private boolean processAuthConfigEntry(String serviceName, String orgName, String componentName, String configName) {
        boolean needUpdate = false;
        if (componentName.length() == 0) {
            needUpdate = true;
        } else if (serviceName.equals(CORE_AUTH) || (serviceName.startsWith("iPlanetAMAuth") || serviceName.startsWith("sunAMAuth")) && serviceName.endsWith("Service")) {
            AMAuthConfigType type = new AMAuthConfigType(configName);
            if (type.getOrganization().equals(orgName)) {
                needUpdate = true;
            }
        } else if (serviceName.equals("iPlanetAMAuthConfiguration")) {
            int i = componentName.lastIndexOf("/");
            String temp = "";
            temp = i != -1 ? componentName.substring(i + 1) : componentName;
            AMAuthConfigType type = new AMAuthConfigType(configName);
            if (type.getOrganization().equals(orgName) && (AuthD.revisionNumber >= 30 || type.getIndexType() == 4 && type.getIndexName().equalsIgnoreCase(temp))) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(configName + " matches " + temp);
                }
                needUpdate = true;
            }
        }
        if (needUpdate) {
            if (this.debug.messageEnabled()) {
                this.debug.message("processSMNotification, name=" + configName);
            }
            ((AMConfiguration)Configuration.getConfiguration()).processListenerEvent(configName);
        }
        return needUpdate;
    }

    private void updateGlobalAuthLevelMap(String serviceName) {
        block7: {
            if (this.debug.messageEnabled()) {
                this.debug.message("updateGlobalAuthLevelMap for " + serviceName);
            }
            try {
                String module;
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, AuthD.getAuth().getSSOAuthSession());
                ServiceSchema schema = ssm.getOrganizationSchema();
                Map attrs = null;
                if (schema != null) {
                    attrs = schema.getAttributeDefaults();
                }
                if ((module = (String)moduleServiceMap.get(serviceName)) != null && module.length() > 0) {
                    String attrName = AMAuthConfigUtils.getAuthLevelAttribute(attrs, module);
                    String authLevel = CollectionHelper.getMapAttr((Map)attrs, (String)attrName);
                    Integer level = null;
                    if (authLevel != null && authLevel.length() > 0) {
                        level = Integer.valueOf(authLevel);
                    }
                    globalAuthLevelMap.put(module, level);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("authLevel is :" + authLevel);
                        this.debug.message("globalAuthLevelMap is :" + globalAuthLevelMap);
                    }
                }
            }
            catch (Exception e) {
                if (!this.debug.messageEnabled()) break block7;
                this.debug.message("Error retrieving service schema ", (Throwable)e);
            }
        }
    }
}

