/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMAuthConfigUtils {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private static DocumentBuilderFactory factory = null;
    protected static final String SERVICE_NAME = "iPlanetAMAuthConfiguration";
    protected static final String NAMED_CONFIGURATION = "Configurations";
    protected static final String NAMED_CONFIGURATION_ID = "NamedConfiguration";
    protected static final String SERVICE_VERSION = "1.0";
    protected static final String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    protected static final String ATTR_VALUE_NODE = "Value";
    public static final String ATTR_NAME = "iplanet-am-auth-configuration";
    protected static final String MODULE_KEY = "MODULE";
    protected static final String USER_KEY = "USER";
    protected static final String ORG_KEY = "ORGANIZATION";
    protected static final String SERVICE_KEY = "SERVICE";
    protected static final String ROLE_KEY = "ROLE";
    protected static final String CLIENT_KEY = "CLIENT";
    private static final String AUTH_SERVICE = "iPlanetAMAuthService";
    private static final String AUTH_MODULES_ATTR = "iplanet-am-auth-allowed-modules";
    private static final String AUTH_AUTHENTICATOR_ATTR = "iplanet-am-auth-authenticators";
    private static final String APPLICATION_CLASS_NAME = "com.sun.identity.authentication.modules.application.Application";
    protected static String bundleName = "amAuthConfig";

    public static AppConfigurationEntry[] parseValues(String xmlValue) {
        Document document;
        if (debug.messageEnabled()) {
            debug.message("AuthConfigUtil.AppConfigurationEntry, xml=" + xmlValue);
        }
        if ((document = XMLUtils.toDOMDocument((String)xmlValue, (Debug)debug)) == null) {
            AppConfigurationEntry[] entries = new AppConfigurationEntry[]{};
            return entries;
        }
        Element valuePair = document.getDocumentElement();
        NodeList children = valuePair.getChildNodes();
        int number = children.getLength();
        AppConfigurationEntry[] entries = new AppConfigurationEntry[number];
        for (int i = 0; i < number; ++i) {
            entries[i] = AMAuthConfigUtils.processValue(children.item(i));
        }
        return entries;
    }

    private static AppConfigurationEntry processValue(Node node) {
        String value;
        if (debug.messageEnabled()) {
            debug.message("ConfigUtils.processValue, value=" + node.toString());
        }
        if ((value = node.getFirstChild().getNodeValue()) == null || value.length() == 0) {
            debug.error("ConfigUtils.processValue, invalid value=" + value);
            return null;
        }
        StringTokenizer st = new StringTokenizer(value);
        int len = st.countTokens();
        if (len < 2) {
            debug.error("ConfigUtils.processValue, wrong config : " + value);
            return null;
        }
        String moduleName = st.nextToken();
        String flag = st.nextToken();
        HashMap options = new HashMap();
        AppConfigurationEntry.LoginModuleControlFlag cFlag = null;
        if (flag.equals("REQUIRED")) {
            cFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (flag.equals("OPTIONAL")) {
            cFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else if (flag.equals("REQUISITE")) {
            cFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (flag.equals("SUFFICIENT")) {
            cFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else {
            debug.error("ConfigUtils.processValue, invalid flag : " + value);
            return null;
        }
        while (st.hasMoreElements()) {
            String opt = st.nextToken();
            int k = opt.indexOf("=");
            if (k == -1) continue;
            HashSet<String> set = new HashSet<String>();
            set.add(opt.substring(k + 1));
            options.put(opt.substring(0, k), set);
        }
        return new AppConfigurationEntry(moduleName, cFlag, options);
    }

    public static String getAuthConfigName(AuthContext.IndexType indexType, String indexName, String organizationDN, String clientType) throws AMConfigurationException {
        if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
            return "MODULE=" + indexName + ";" + ORG_KEY + "=" + organizationDN.toLowerCase() + ";" + CLIENT_KEY + "=" + clientType;
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            return "ROLE=" + indexName + ";" + ORG_KEY + "=" + organizationDN.toLowerCase() + ";" + CLIENT_KEY + "=" + clientType;
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            return "SERVICE=" + indexName + ";" + ORG_KEY + "=" + organizationDN.toLowerCase() + ";" + CLIENT_KEY + "=" + clientType;
        }
        if (indexType == AuthContext.IndexType.USER) {
            return "USER=" + indexName + ";" + ORG_KEY + "=" + organizationDN.toLowerCase() + ";" + CLIENT_KEY + "=" + clientType;
        }
        throw new AMConfigurationException(bundleName, "invalidIndexType");
    }

    public static String getAuthConfigName(String organizationDN, String clientType) {
        return "ORGANIZATION=" + organizationDN + ";" + CLIENT_KEY + "=" + clientType;
    }

    public static String convertToXMLString(List configs) {
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : " + configs.toString());
        }
        StringBuffer sb = new StringBuffer(100);
        Iterator it = configs.iterator();
        if (it != null) {
            sb.append("<AttributeValuePair>");
            while (it.hasNext()) {
                sb.append("<Value>" + it.next() + "</" + ATTR_VALUE_NODE + ">");
            }
            sb.append("</AttributeValuePair>");
        }
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : return " + sb.toString());
        }
        return sb.toString();
    }

    public static void createNamedConfig(String configName, int priority, Map attributeDataMap, String orgName, SSOToken token) throws SMSException, SSOException, AMConfigurationException {
        ServiceConfig authConfig;
        if (debug.messageEnabled()) {
            debug.message("createNamedConfig name=" + configName + ", value=" + attributeDataMap);
        }
        if (configName == null || configName.length() == 0) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager scm = new ServiceConfigManager(token, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig orgConfig = scm.getOrganizationConfig(orgName, null);
        if (orgConfig == null) {
            orgConfig = scm.createOrganizationConfig(orgName, null);
        }
        if ((authConfig = orgConfig.getSubConfig(NAMED_CONFIGURATION)) == null) {
            orgConfig.addSubConfig(NAMED_CONFIGURATION, null, 0, null);
            authConfig = orgConfig.getSubConfig(NAMED_CONFIGURATION);
        }
        debug.message("Got auth config");
        authConfig.addSubConfig(configName, NAMED_CONFIGURATION_ID, priority, attributeDataMap);
    }

    public static void replaceNamedConfig(String configName, int priority, Map attributeDataMap, String orgName, SSOToken token) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("replaceNamedConfig name=" + configName + ", value=" + attributeDataMap + ",org=" + orgName);
        }
        if (configName == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager scm = new ServiceConfigManager(token, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig oConfig = scm.getOrganizationConfig(orgName, null);
        if (oConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig namedConfig = oConfig.getSubConfig(NAMED_CONFIGURATION);
        if (namedConfig == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig pConfig = namedConfig.getSubConfig(configName);
        if (pConfig == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        pConfig.setAttributes(attributeDataMap);
    }

    public static void removeNamedConfig(String configName, String orgName, SSOToken token) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("removeNamedConfig name=" + configName + ",org=" + orgName);
        }
        if (configName == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager scm = new ServiceConfigManager(SERVICE_NAME, token);
        ServiceConfig oConfig = scm.getOrganizationConfig(orgName, null);
        if (oConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig namedConfig = oConfig.getSubConfig(NAMED_CONFIGURATION);
        if (namedConfig == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig pConfig = namedConfig.getSubConfig(configName);
        if (pConfig == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        namedConfig.removeSubConfig(configName);
    }

    public static Set getAllNamedConfig(String orgName, SSOToken token) throws SMSException, SSOException {
        ServiceConfigManager scm;
        ServiceConfig oConfig;
        if (orgName != null && orgName.length() != 0) {
            orgName = orgName.toLowerCase();
        }
        if (debug.messageEnabled()) {
            debug.message("getAllNamedConfig org=" + orgName);
        }
        if ((oConfig = (scm = new ServiceConfigManager(token, SERVICE_NAME, SERVICE_VERSION)).getOrganizationConfig(orgName, null)) == null) {
            return Collections.EMPTY_SET;
        }
        ServiceConfig namedConfig = oConfig.getSubConfig(NAMED_CONFIGURATION);
        if (namedConfig == null) {
            return Collections.EMPTY_SET;
        }
        return namedConfig.getSubConfigNames("*");
    }

    public static Map getNamedConfig(String configName, String orgName, SSOToken token) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("getNamedConfig name=" + configName + ",org=" + orgName);
        }
        if (configName == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager scm = new ServiceConfigManager(token, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig orgConfig = scm.getOrganizationConfig(orgName, null);
        if (orgConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig authConfig = orgConfig.getSubConfig(NAMED_CONFIGURATION);
        if (authConfig == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig conf = authConfig.getSubConfig(configName);
        if (conf == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        Map attributeDataMap = conf.getAttributes();
        return attributeDataMap;
    }

    public static String getModuleName(String className) {
        int dot = className.lastIndexOf(".");
        if (dot == -1) {
            return className;
        }
        if (dot == className.length() - 1) {
            return "";
        }
        return className.substring(dot + 1);
    }

    public static String getModuleServiceName(String module) {
        if (module.equals("RADIUS")) {
            return "iPlanetAMAuthRadiusService";
        }
        return "iPlanetAMAuth" + module + "Service";
    }

    public static String getNewModuleServiceName(String module) {
        return "sunAMAuth" + module + "Service";
    }

    public static String getAuthLevelAttribute(Map attrs, String module) {
        String attrName = "iplanet-am-auth-" + module.toLowerCase() + "-auth-level";
        if (attrs.get(attrName) == null) {
            attrName = "sunAMAuth" + module + "AuthLevel";
        }
        return attrName;
    }

    public static ServiceSchema getServiceSchema(SSOToken token) throws AMConfigurationException {
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(SERVICE_NAME, token);
            ServiceSchema orgSchema = scm.getOrganizationSchema();
            ServiceSchema schema = orgSchema.getSubSchema(NAMED_CONFIGURATION);
            ServiceSchema configSchema = schema.getSubSchema(NAMED_CONFIGURATION_ID);
            return configSchema;
        }
        catch (Exception e) {
            debug.error("getServiceSubSchema", (Throwable)e);
            throw new AMConfigurationException(e);
        }
    }

    public static Map getAllAuthModules(SSOToken token) {
        HashMap<String, String> modules = new HashMap<String, String>();
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(AUTH_SERVICE, token);
            ServiceSchema global = scm.getGlobalSchema();
            Map attrs = global.getAttributeDefaults();
            Set classes = (Set)attrs.get(AUTH_AUTHENTICATOR_ATTR);
            if (classes == null) {
                return modules;
            }
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                int dot;
                String name = (String)iter.next();
                if (name.equals(APPLICATION_CLASS_NAME)) continue;
                if (debug.messageEnabled()) {
                    debug.message("getAllAuthModules. process " + name);
                }
                if ((dot = name.lastIndexOf(46)) > -1) {
                    String tmp = name.substring(dot + 1, name.length());
                    modules.put(tmp, name);
                    continue;
                }
                modules.put(name, name);
            }
        }
        catch (Exception e) {
            debug.error("getAllAuthModules", (Throwable)e);
        }
        return modules;
    }

    public static Map getAllAuthModules(String orgDN, SSOToken token) {
        Map modules = new HashMap();
        Set authenticators = null;
        try {
            AMStoreConnection dpStore = new AMStoreConnection(token);
            AMOrganization org = dpStore.getOrganization(orgDN);
            AMTemplate template = org.getTemplate(AUTH_SERVICE, 302);
            Map attrs = template.getAttributes();
            authenticators = (Set)attrs.get(AUTH_MODULES_ATTR);
        }
        catch (Exception e) {
            debug.error("getAllAuthModules", (Throwable)e);
        }
        Set globalAuth = AMAuthConfigUtils.getGlobalAuthenticators(token);
        modules = authenticators != null && !authenticators.isEmpty() ? AMAuthConfigUtils.constructModulesList(authenticators, globalAuth) : AMAuthConfigUtils.constructModulesList(globalAuth, null);
        if (debug.messageEnabled()) {
            debug.message("Returning modules : " + modules);
        }
        return modules;
    }

    public static List xmlToAuthConfigurationEntry(String xmlValue) {
        if (debug.messageEnabled()) {
            debug.message("AuthConfUtil.xmltoentries, xml=" + xmlValue);
        }
        ArrayList<AuthConfigurationEntry> entries = new ArrayList<AuthConfigurationEntry>();
        Document document = XMLUtils.toDOMDocument((String)xmlValue, (Debug)debug);
        if (document == null) {
            return entries;
        }
        Element valuePair = document.getDocumentElement();
        NodeList children = valuePair.getChildNodes();
        int number = children.getLength();
        for (int i = 0; i < number; ++i) {
            try {
                entries.add(new AuthConfigurationEntry(children.item(i)));
                continue;
            }
            catch (Exception e) {
                debug.error("parseValue", (Throwable)e);
            }
        }
        return entries;
    }

    public static String authConfigurationEntryToXMLString(List entries) {
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : " + entries);
        }
        if (entries != null) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("<AttributeValuePair>");
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                AuthConfigurationEntry entry = (AuthConfigurationEntry)entries.get(i);
                sb.append("<").append(ATTR_VALUE_NODE).append(">").append(entry.getLoginModuleName()).append(" ").append(entry.getControlFlag().toString()).append(" ");
                String options = entry.getOptions();
                if (options != null) {
                    sb.append(options.toString());
                }
                sb.append("</").append(ATTR_VALUE_NODE).append(">");
            }
            sb.append("</AttributeValuePair>");
            if (debug.messageEnabled()) {
                debug.message("convertToXMLString : return " + sb.toString());
            }
            return sb.toString();
        }
        return "";
    }

    private static Map constructModulesList(Set classes, Set globalAuth) {
        if (debug.messageEnabled()) {
            debug.message("constructModulesList : classes : " + classes);
        }
        Iterator iter = classes.iterator();
        HashMap<String, String> modules = new HashMap<String, String>();
        while (iter.hasNext()) {
            int dot;
            String name = (String)iter.next();
            if (name.equals(APPLICATION_CLASS_NAME)) continue;
            if (debug.messageEnabled()) {
                debug.message("getAllAuthModules. process " + name);
            }
            if ((dot = name.lastIndexOf(46)) > -1) {
                String tmp = name.substring(dot + 1, name.length());
                modules.put(tmp, name);
                continue;
            }
            if (globalAuth != null && !globalAuth.isEmpty()) {
                String className = AMAuthConfigUtils.getAuthenticatorClassName(name, globalAuth);
                if (debug.messageEnabled()) {
                    debug.message("className : " + className);
                }
                modules.put(name, className);
                continue;
            }
            modules.put(name, name);
        }
        return modules;
    }

    private static String getAuthenticatorClassName(String moduleName, Set globalAuth) {
        String fullClassName = null;
        if (globalAuth == null) {
            return moduleName;
        }
        Iterator iter = globalAuth.iterator();
        while (iter.hasNext()) {
            String tmp;
            fullClassName = null;
            String name = (String)iter.next();
            if (name.equals(APPLICATION_CLASS_NAME)) continue;
            int dot = name.lastIndexOf(46);
            if (dot > -1 && (tmp = name.substring(dot + 1, name.length())).equals(moduleName)) {
                fullClassName = name;
            }
            if (fullClassName == null) continue;
            break;
        }
        if (debug.messageEnabled()) {
            debug.message("fullClassName is : " + fullClassName);
        }
        if (fullClassName != null) {
            return fullClassName;
        }
        return moduleName;
    }

    public static Set getGlobalAuthenticators(SSOToken token) {
        Set globalAuth = null;
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(AUTH_SERVICE, token);
            ServiceSchema global = scm.getGlobalSchema();
            Map attrs = global.getAttributeDefaults();
            globalAuth = (Set)attrs.get(AUTH_AUTHENTICATOR_ATTR);
        }
        catch (Exception e) {
            debug.error("getAllAuthModules", (Throwable)e);
        }
        return globalAuth;
    }
}

