/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntityManager;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IMembership;
import com.iplanet.ums.ISearch;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.validation.Validation;
import com.sun.identity.shared.debug.Debug;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class PersistentObject
implements ISearch,
Serializable,
IUMSConstants {
    public static final String COMPUTED_MEMBER_ATTR_NAME = "nsRole";
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance("amSDK");
    private Principal m_principal;
    private Guid m_guid;
    private AttrSet m_attrSet;
    private ArrayList m_nullAttributes;
    private ModSet m_modSet;
    private String m_namingAttribute = null;

    protected PersistentObject() {
    }

    PersistentObject(Principal principal, Guid guid) throws UMSException {
        String dn = guid.getDn();
        if (principal == null || dn == null) {
            String msg = principal == null ? i18n.getString("ums-bad-principal-hdl") : i18n.getString("ums-badguid");
            throw new IllegalArgumentException(msg);
        }
        this.setGuid(guid);
        this.setPrincipal(principal);
        this.read();
    }

    public PersistentObject(CreationTemplate template, AttrSet attrSet) throws UMSException {
        this.m_attrSet = attrSet;
        if (template == null) {
            throw new UMSException("ums-bad-template");
        }
        this.m_namingAttribute = template.getNamingAttribute();
        template.validateAttrSet(attrSet);
        template.validateAttributes(attrSet);
    }

    PersistentObject(CreationTemplate template, AttrSet attrSet, String namingAttribute) throws UMSException {
        this.m_attrSet = attrSet;
        if (template == null) {
            throw new UMSException("ums-bad-template");
        }
        template.validateAttrSet(attrSet);
        template.validateAttributes(attrSet);
        this.m_namingAttribute = namingAttribute;
    }

    public Attr getAttribute(String attrName) {
        Attr attr = this.getAttributeFromCache(attrName);
        if (attr == null && this.isAttributeNotRead(attrName) && this.getGuid() != null && this.getPrincipal() != null) {
            attr = this.readAttributeFromDataStore(attrName);
        }
        return attr;
    }

    public Attr getAttribute(String attrName, Locale locale) throws UMSException {
        if (locale == null) {
            return this.getAttribute(attrName);
        }
        return this.getAttribute(Attr.getName(attrName, locale));
    }

    public AttrSet getAttributes(String[] attrs) throws UMSException {
        return this.getAttributes(attrs, false);
    }

    public AttrSet getAttributes(String[] attrs, boolean cacheOnly) throws UMSException {
        Collection attributesNotInCache;
        if (attrs == null) {
            throw new IllegalArgumentException(i18n.getString("ums-badattrnames"));
        }
        AttrSet attrSet = new AttrSet();
        if (!cacheOnly && (attributesNotInCache = this.findAttributesNotRead(attrs)).size() != 0 && this.getGuid() != null && this.getPrincipal() != null) {
            this.readAttributesFromDataStore(attributesNotInCache);
        }
        int length = attrs.length;
        for (int i = 0; i < length; ++i) {
            Attr attr = this.getAttributeFromCache(attrs[i]);
            if (attr == null) continue;
            attrSet.add(attr);
        }
        return attrSet;
    }

    public AttrSet getAttributes(String[] attrNames, Locale locale) throws UMSException {
        if (locale == null) {
            return this.getAttributes(attrNames);
        }
        String[] namesWithLocale = new String[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            namesWithLocale[i] = Attr.getName(attrNames[i], locale);
        }
        return this.getAttributes(namesWithLocale);
    }

    public void setAttribute(Attr attr) {
        if (attr == null || attr.getName() == null) {
            throw new IllegalArgumentException(i18n.getString("ums-addnullobj"));
        }
        this.checkCache();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_attrSet.contains(attr.getName())) {
            this.modify(attr, 2);
        } else {
            this.modify(attr, 0);
        }
    }

    public void setAttribute(Attr attr, Locale locale) {
        if (locale == null) {
            this.setAttribute(attr);
            return;
        }
        Attr attrWithLocale = new Attr(Attr.getName(attr.getBaseName(), locale));
        attrWithLocale.addValues(attr.getStringValues());
        this.setAttribute(attrWithLocale);
    }

    public void removeAttribute(Attr attr) {
        this.checkCache();
        if (this.m_attrSet == null || this.m_attrSet.size() == 0) {
            return;
        }
        this.modify(attr, 1);
    }

    public String[] getAttributeNames() {
        block4: {
            if (this.m_principal != null && this.m_guid != null && this.m_attrSet == null) {
                try {
                    this.read();
                }
                catch (UMSException e) {
                    if (!debug.messageEnabled()) break block4;
                    debug.message("PersistentObject.getAttributeNames: UMSException: " + e.getMessage());
                }
            }
        }
        if (this.m_attrSet != null) {
            return this.m_attrSet.getAttributeNames();
        }
        return null;
    }

    public void modify(ModSet modSet) {
        this.checkCache();
        if (this.m_modSet == null) {
            this.m_modSet = new ModSet();
        }
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        int nMods = modSet.size();
        LDAPModification mod = null;
        for (int i = 0; i < nMods; ++i) {
            mod = modSet.elementAt(i);
            switch (mod.getOp()) {
                case 0: {
                    this.m_attrSet.add(new Attr(mod.getAttribute()));
                    break;
                }
                case 1: {
                    if (mod.getAttribute().size() == 0) {
                        this.m_attrSet.remove(mod.getAttribute().getName());
                        break;
                    }
                    LDAPAttribute attr = mod.getAttribute();
                    Enumeration en = attr.getStringValues();
                    while (en.hasMoreElements()) {
                        this.m_attrSet.remove(attr.getName(), (String)en.nextElement());
                    }
                    break;
                }
                case 2: {
                    this.m_attrSet.replace(new Attr(mod.getAttribute()));
                    break;
                }
            }
            this.m_modSet.add(mod.getOp(), mod.getAttribute());
        }
    }

    public void modify(Attr attr, int op) {
        ModSet modSet = new ModSet();
        modSet.add(op, attr.toLDAPAttribute());
        this.modify(modSet);
    }

    public void modify(String attrName, String value, int op) {
        ModSet modSet = new ModSet();
        modSet.add(op, new LDAPAttribute(attrName, value));
        this.modify(modSet);
    }

    public Guid getGuid() {
        return this.m_guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String newRDN, boolean deleteOldName) throws AccessRightsException, EntryNotFoundException, UMSException {
        String required = null;
        if (this.m_principal == null) {
            required = "principal";
        } else if (this.m_guid == null) {
            required = "guid";
        }
        if (required != null) {
            Object[] args = new String[]{required};
            String msg = i18n.getString("ums-norequired", args);
            throw new UMSException(msg);
        }
        try {
            DataLayer.getInstance().rename(this.getPrincipal(), this.getGuid(), newRDN, deleteOldName);
        }
        finally {
            RDN rdn = new RDN(newRDN);
            DN parentDN = new DN(this.m_guid.toString()).getParent();
            parentDN.addRDN(rdn);
            this.m_guid.setDn(parentDN.toRFCString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws AccessRightsException, EntryNotFoundException, UMSException {
        String required = null;
        if (this.m_modSet == null) {
            return;
        }
        if (this.m_principal == null) {
            required = "principal";
        } else if (this.m_guid == null) {
            required = "guid";
        }
        if (required != null) {
            Object[] args = new String[]{required};
            String msg = i18n.getString("ums-norequired", args) + " - " + i18n.getString("ums-objectnotpersistent");
            throw new UMSException(msg);
        }
        try {
            DataLayer.getInstance().modify(this.getPrincipal(), this.getGuid(), this.m_modSet);
        }
        finally {
            this.m_modSet = null;
        }
    }

    public String getNamingAttribute() {
        if (this.m_guid == null) {
            return this.m_namingAttribute;
        }
        DN dn = new DN(this.getDN());
        String[] components = dn.explodeDN(false);
        if (components != null && components.length > 0) {
            RDN rdn = new RDN(components[0]);
            return rdn.getTypes()[0];
        }
        return null;
    }

    public PersistentObject getParentObject() throws UMSException {
        if (this.m_guid == null || this.m_principal == null) {
            String msg = this.m_principal == null ? i18n.getString("ums-bad-principal-hdl") : i18n.getString("ums-badguid");
            throw new IllegalArgumentException(msg);
        }
        PersistentObject parent = UMSObject.getObject(this.getPrincipal(), this.getParentGuid());
        return parent;
    }

    public void addChild(PersistentObject object) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        block5: {
            if (object == null) {
                Object[] args = new String[]{this.toString()};
                String msg = i18n.getString("ums-addnullobj", args);
                throw new IllegalArgumentException(msg);
            }
            String idAttr = object.getNamingAttribute();
            String idValue = null;
            Attr idAttrObj = object.getAttribute(idAttr);
            if (idAttrObj == null) {
                throw new UMSException("ums-badnamingattr" + idAttr);
            }
            idValue = idAttrObj.getValue();
            if (idAttr == null || idValue == null || idValue.length() == 0) {
                Object[] args = new String[]{object.toString()};
                String msg = i18n.getString("ums-composeguidfailed", args);
                throw new IllegalArgumentException(msg);
            }
            String childStr = null;
            childStr = this.getGuid().getDn().length() > 0 ? idAttr + "=" + idValue + "," + this.getGuid().getDn() : idAttr + "=" + idValue;
            Guid childGuid = new Guid(childStr);
            object.setGuid(childGuid);
            DataLayer.getInstance().addEntry(this.getPrincipal(), childGuid, object.getAttrSet());
            object.setModSet(null);
            object.setPrincipal(this.getPrincipal());
            EntityManager em = EntityManager.getEntityManager();
            try {
                em.execute(this.getPrincipal(), object, this.m_guid);
            }
            catch (UMSException e) {
                if (!debug.messageEnabled()) break block5;
                debug.message("PersistentObject.addChild : UMSException : " + e.getMessage());
            }
        }
    }

    public void removeChild(PersistentObject object) throws AccessRightsException, EntryNotFoundException, UMSException {
        DN parentEntry;
        DN childEntry;
        if (object == null) {
            Object[] args = new String[]{this.toString()};
            String msg = i18n.getString("ums-delnullobj", args);
            throw new IllegalArgumentException(msg);
        }
        String childStr = object.getGuid().getDn();
        if (childStr == null) {
            String idAttr = object.getNamingAttribute();
            String idValue = object.getAttribute(idAttr).getValue();
            if (idAttr == null || idValue == null || idValue.length() == 0) {
                Object[] args = new String[]{object.toString()};
                String msg = i18n.getString("ums-composeguidfailed", args);
                throw new IllegalArgumentException(msg);
            }
            childStr = this.getGuid().getDn().length() > 0 ? idAttr + "=" + idValue + "," + this.getGuid() : idAttr + "=" + idValue;
        }
        if (!(childEntry = new DN(childStr)).isDescendantOf(parentEntry = new DN(this.getDN()))) {
            String msg = i18n.getString("ums-badchildobj");
            throw new IllegalArgumentException(msg);
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), new Guid(childStr));
        object.setGuid(new Guid("DELETED"));
        object.setPrincipal(null);
    }

    public void removeChild(Guid childGuid) throws AccessRightsException, EntryNotFoundException, UMSException {
        DN parentEntry = new DN(this.getDN());
        DN childEntry = new DN(childGuid.getDn());
        if (!childEntry.isDescendantOf(parentEntry)) {
            String msg = i18n.getString("ums-badchildobj");
            throw new IllegalArgumentException(msg);
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), childGuid);
    }

    public void remove() throws AccessRightsException, EntryNotFoundException, UMSException {
        if (this.m_guid == null || this.m_principal == null) {
            return;
        }
        DataLayer.getInstance().deleteEntry(this.getPrincipal(), this.getGuid());
        this.setGuid(null);
        this.setPrincipal(null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Object ID        :" + this.m_guid + "\n");
        sb.append("Naming attribute :" + this.getNamingAttribute() + "\n");
        sb.append("Class            :" + this.getClass().getName() + "\n");
        sb.append("Principal        :" + this.m_principal + "\n");
        sb.append("Attribute Set    :" + this.m_attrSet + "\n");
        return sb.toString();
    }

    public Guid getParentGuid() {
        if (this.m_guid == null || this.m_principal == null) {
            return null;
        }
        DN dn = new DN(this.getDN());
        return new Guid(dn.getParent().toString());
    }

    public SearchResults getChildren(String filter, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int scope = 1;
        if (searchControl != null) {
            scope = searchControl.getSearchScope(scope);
        }
        SearchResults results = DataLayer.getInstance().searchIDs(this.getPrincipal(), this.getGuid(), scope, filter, searchControl);
        results.setPrincipal(this.getPrincipal());
        return results;
    }

    public SearchResults getChildren(String filter, String[] resultAttributeNames, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int scope = 1;
        if (searchControl != null) {
            scope = searchControl.getSearchScope(scope);
        }
        SearchResults searchResults = DataLayer.getInstance().search(this.getPrincipal(), this.getGuid(), scope, filter, resultAttributeNames, false, searchControl);
        searchResults.setPrincipal(this.getPrincipal());
        return searchResults;
    }

    public SearchResults getChildren(SearchTemplate template, SearchControl searchControl) throws UMSException {
        return this.getChildren(template.getSearchFilter(), template.getAttributeSet().getAttributeNames(), searchControl);
    }

    public SearchResults search(String filter, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int scope = 2;
        if (searchControl != null) {
            scope = searchControl.getSearchScope(scope);
        }
        SearchResults results = DataLayer.getInstance().searchIDs(this.getPrincipal(), this.getGuid(), scope, filter, searchControl);
        results.setPrincipal(this.getPrincipal());
        return results;
    }

    public SearchResults search(String filter, String[] resultAttributeNames, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        int scope = 2;
        if (searchControl != null) {
            scope = searchControl.getSearchScope(scope);
        }
        SearchResults results = DataLayer.getInstance().search(this.getPrincipal(), this.getGuid(), scope, filter, resultAttributeNames, false, searchControl);
        results.setPrincipal(this.getPrincipal());
        return results;
    }

    public SearchResults search(SearchTemplate template, SearchControl searchControl) throws UMSException {
        return this.search(template.getSearchFilter(), template.getAttributeSet().getAttributeNames(), searchControl);
    }

    public String getDN() {
        if (this.m_guid != null) {
            return this.m_guid.getDn();
        }
        return null;
    }

    protected void setGuid(Guid guid) {
        this.m_guid = guid;
    }

    Principal getPrincipal() {
        return this.m_principal;
    }

    void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    protected void setAttrSet(AttrSet attrSet) {
        this.m_attrSet = attrSet;
    }

    protected AttrSet getAttrSet() {
        return this.m_attrSet;
    }

    void verifyClass() throws UMSException {
        Class expectedClass = TemplateManager.getTemplateManager().getJavaClassForEntry(this.getGuid().getDn(), this.getAttrSet());
        if (this.getClass() != expectedClass) {
            String msg = i18n.getString("ums-unmatchedclass");
            throw new IllegalArgumentException(msg);
        }
    }

    public static String idToDN(String namingAttribute, String name, String[] parentID) {
        StringBuffer sb = new StringBuffer();
        sb.append(namingAttribute + "=" + name);
        for (int i = 0; i < parentID.length; ++i) {
            if (parentID[i] == null) continue;
            sb.append(",o=" + parentID[i]);
        }
        return sb.toString();
    }

    static String dnToGuid(String dn) {
        return dn;
    }

    static String guidToDN(String guid) {
        return guid;
    }

    private synchronized void read() throws UMSException {
        if (this.m_principal == null || this.m_guid == null) {
            return;
        }
        this.m_attrSet = DataLayer.getInstance().read(this.getPrincipal(), this.getGuid());
    }

    private void checkCache() {
        block3: {
            if (this.m_principal != null && this.m_guid != null && this.m_attrSet == null) {
                try {
                    this.read();
                }
                catch (UMSException e) {
                    if (!debug.messageEnabled()) break block3;
                    debug.message("PersistentObject.checkCache() : UMSException : " + e.getMessage());
                }
            }
        }
    }

    void setModSet(ModSet modSet) {
        this.m_modSet = modSet;
    }

    public boolean isMemberOf(IMembership im) throws UMSException {
        return im.hasMember(this.getGuid());
    }

    public Collection getRoles() throws UMSException {
        ArrayList<String> roleList = new ArrayList<String>();
        Attr roleAttr = this.getAttribute(COMPUTED_MEMBER_ATTR_NAME);
        if (roleAttr != null && roleAttr.getStringValues() != null) {
            roleList.addAll(Arrays.asList(roleAttr.getStringValues()));
        }
        return roleList;
    }

    public Collection getACI() throws ACIParseException, UMSException {
        ArrayList<ACI> acis = new ArrayList<ACI>();
        Attr aciAttr = this.getAttribute("aci");
        if (aciAttr != null) {
            String[] aciTexts = aciAttr.getStringValues();
            int size = aciTexts.length;
            for (int i = 0; i < size; ++i) {
                acis.add(ACI.valueOf(aciTexts[i]));
            }
        }
        return acis;
    }

    public Collection getACI(String name) throws ACIParseException, UMSException {
        ArrayList<ACI> acis = new ArrayList<ACI>();
        Attr aciAttr = this.getAttribute("aci");
        if (aciAttr != null) {
            String[] aciTexts = aciAttr.getStringValues();
            int size = aciTexts.length;
            for (int i = 0; i < size; ++i) {
                ACI aci = ACI.valueOf(aciTexts[i]);
                if (!aci.getName().equals(name)) continue;
                acis.add(aci);
            }
        }
        return acis;
    }

    public void addACI(ACI aci) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", aci.toString());
        this.modify(attr, 0);
        this.save();
    }

    public void deleteACI(ACI aci) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", aci.getACIText());
        this.modify(attr, 1);
        this.save();
    }

    public void replaceACI(ACI oldACI, ACI newACI) throws AccessRightsException, UMSException {
        Attr attr = new Attr("aci", oldACI.getACIText());
        this.modify(attr, 1);
        attr = new Attr("aci", newACI.toString());
        this.modify(attr, 0);
        this.save();
    }

    public static void addAttributeValue(SSOToken token, Guid guid, String name, String value) throws UMSException {
        if (guid == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        if (token == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        Attr attr = new Attr(name, value);
        attr = null;
        Validation.validateAttribute(attr, UMSObject.getObject(token, guid).getClass(), guid);
        try {
            DataLayer.getInstance().addAttributeValue(token.getPrincipal(), guid, name, value);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), (Throwable)((Object)se));
        }
    }

    public static void removeAttributeValue(SSOToken token, Guid guid, String name, String value) throws UMSException {
        if (guid == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        if (token == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        try {
            DataLayer.getInstance().removeAttributeValue(token.getPrincipal(), guid, name, value);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), (Throwable)((Object)se));
        }
    }

    protected boolean isPersistent() {
        return this.m_principal != null && this.m_guid != null && this.m_guid.getDn().length() > 0;
    }

    private Collection findAttributesNotRead(String[] attrNames) {
        ArrayList<String> attributesNotInCache = new ArrayList<String>();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        int length = attrNames.length;
        for (int i = 0; i < length; ++i) {
            if (this.m_attrSet.getAttribute(attrNames[i]) != null || this.m_nullAttributes.contains(attrNames[i])) continue;
            attributesNotInCache.add(attrNames[i]);
        }
        return attributesNotInCache;
    }

    private boolean isAttributeNotRead(String attrName) {
        boolean attributeNotRead = false;
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        if (this.m_attrSet.getAttribute(attrName) == null && !this.m_nullAttributes.contains(attrName)) {
            attributeNotRead = true;
        }
        return attributeNotRead;
    }

    private Collection readAttributesFromDataStore(Collection attrNames) throws UMSException {
        Collection attributes = DataLayer.getInstance().getAttributes(this.getPrincipal(), this.getGuid(), attrNames);
        if (attributes == null) {
            Object[] args = new String[]{this.getDN()};
            throw new UMSException(i18n.getString("ums-readattributeserror", args));
        }
        ArrayList<String> foundAttributes = new ArrayList<String>();
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            Attr attr = (Attr)iter.next();
            foundAttributes.add(attr.getName());
            this.m_attrSet.replace(attr);
        }
        iter = attrNames.iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            if (foundAttributes.contains(attrName) || this.m_nullAttributes.contains(attrName)) continue;
            this.m_nullAttributes.add(attrName);
        }
        return attributes;
    }

    private Attr readAttributeFromDataStore(String attrName) {
        Attr attr = DataLayer.getInstance().getAttribute(this.getPrincipal(), this.getGuid(), attrName);
        if (this.m_attrSet == null) {
            this.m_attrSet = new AttrSet();
        }
        if (this.m_nullAttributes == null) {
            this.m_nullAttributes = new ArrayList();
        }
        if (attr != null) {
            this.m_attrSet.replace(attr);
        } else if (!this.m_nullAttributes.contains(attrName)) {
            this.m_nullAttributes.add(attrName);
        }
        return attr;
    }

    private Attr getAttributeFromCache(String attrName) {
        Attr attr = null;
        if (this.m_attrSet != null) {
            attr = this.m_attrSet.getAttribute(attrName);
        }
        return attr;
    }
}

