/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Cache;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.CMListener;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.util.GuidUtils;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class ConfigManagerUMS
implements Serializable {
    static final String ERROR_CM_INITIATE = "error-cminitiate";
    static final String ERROR_CM = "error-cm";
    private static I18n i18n = I18n.getInstance("amSDK");
    protected static final String UMS_SRVC = "DAI";
    private static final String UMS_VERSION = "1.0";
    private static final String TEMPLATEPATH = "/templates";
    static final String ENTITYPATH = "/templates/StructureTemplates";
    static final String SEARCHPATH = "/templates/SearchTemplates";
    static final String CREATIONPATH = "/templates/CreationTemplates";
    private static final String OBJECTRESOLVERPATH = "/templates/ObjectResolver";
    private static final String OBJECTRESOLVER = "ObjectResolver";
    private static final String ENTITY = "StructureTemplates";
    private static final String SEARCH = "SearchTemplates";
    private static final String CREATION = "CreationTemplates";
    private static final String CLASS = "class";
    private static final String JAVACLASS = "javaclass";
    private static final String ATTRNAME = "name";
    private static final String OC_JC_MAP = "oc_jc_map";
    private static ConfigManagerUMS _instance = null;
    static Hashtable _cch = null;
    private static Cache _checkListCache = null;
    private static AuthPrincipal _principal;
    private static ServiceConfigManager _smapi;
    private static String _rootDN;
    private static DN _root;
    private static CMListener _listener;
    private static String _lid;
    private static Debug _debug;
    private static String[][] _oc_jc_map;

    public static synchronized ConfigManagerUMS getConfigManager() throws ConfigManagerException {
        if (_instance == null) {
            try {
                _instance = new ConfigManagerUMS();
            }
            catch (Exception e) {
                _debug.error(e.toString());
                Object[] args = new String[]{e.toString()};
                throw new ConfigManagerException(i18n.getString("ums-cminitiate", args));
            }
        }
        return _instance;
    }

    private void loadCache(String org, Set c, String template) {
        Iterator iter = c.iterator();
        String entName = "";
        AttrSet attrSet = null;
        while (iter.hasNext()) {
            String oc_jc_map_string;
            Set<AttrSet> hs;
            entName = iter.next().toString();
            Map entityAttributes = new HashMap();
            attrSet = new AttrSet();
            try {
                entityAttributes = this.getServiceAttributes(org, entName);
            }
            catch (SMSException smse) {
                _debug.error("ConfigManager->loadCache: SMSException: " + smse.toString());
            }
            catch (SSOException ssoe) {
                _debug.error("ConfigManager->loadCache: SSOException: " + ssoe.toString());
            }
            if (entityAttributes.size() == 0) continue;
            Iterator it = entityAttributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = it.next();
                hs = (HashSet<AttrSet>)ent.getValue();
                Iterator itera = hs.iterator();
                itera = hs.iterator();
                while (itera.hasNext()) {
                    attrSet.add(new Attr((String)ent.getKey(), (String)itera.next()));
                }
            }
            String key = org + "/" + template + "/";
            Attr classAttr = null;
            if (template.equals(ENTITY)) {
                classAttr = attrSet.getAttribute(CLASS);
                if (classAttr != null) {
                    hs = new HashSet<AttrSet>();
                    if (_cch.containsKey(key + classAttr.getValue())) {
                        hs = (Set)_cch.get(key + classAttr.getValue());
                        hs.add(attrSet);
                    } else {
                        hs.add(attrSet);
                    }
                    _cch.put(key + classAttr.getValue(), hs);
                    if (_debug.messageEnabled()) {
                        _debug.message("ConfigManager->loadCache KEY:" + key + classAttr.getValue() + " VALUE:" + hs);
                    }
                }
                int l = entName.lastIndexOf("/");
                String cname = entName.substring(l + 1);
                HashSet<AttrSet> hset = new HashSet<AttrSet>();
                hset.add(attrSet);
                _cch.put(key + cname, hset);
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->loadCache KEY:" + key + cname + " VALUE:" + hset);
                }
            }
            if (template.equals(SEARCH) || template.equals(CREATION)) {
                classAttr = attrSet.getAttribute(JAVACLASS);
                if (classAttr != null) {
                    _cch.put(key + classAttr.getValue(), attrSet);
                    if (_debug.messageEnabled()) {
                        _debug.message("ConfigManager->loadCache KEY:" + key + classAttr.getValue() + " VALUE:" + attrSet);
                    }
                }
                if ((classAttr = attrSet.getAttribute(ATTRNAME)) != null) {
                    _cch.put(key + classAttr.getValue(), attrSet);
                    _debug.message("ConfigManager->loadCache KEY:" + key + classAttr.getValue() + " VALUE:" + attrSet);
                }
            }
            if (!template.equals(OBJECTRESOLVER) || (oc_jc_map_string = attrSet.getValue(OC_JC_MAP)) == null) continue;
            _cch.put(OBJECTRESOLVERPATH, this.getOC_JC_MAP(oc_jc_map_string));
            _debug.message("ConfigManager->loadCache KEY:/templates/ObjectResolver VALUE:" + attrSet);
        }
    }

    void updateCache(String org) throws ConfigManagerException {
        int count;
        String t;
        String s;
        HashSet<String> set;
        Iterator it;
        Set cNames;
        Set sNames;
        Set eNames;
        block22: {
            block21: {
                block20: {
                    eNames = new HashSet();
                    sNames = new HashSet();
                    cNames = new HashSet();
                    if (org.equals(_rootDN)) {
                        HashSet<String> oSet = new HashSet<String>();
                        oSet.add(OBJECTRESOLVERPATH);
                        this.loadCache(org, oSet, OBJECTRESOLVER);
                    }
                    try {
                        eNames = this.getServiceComponents(org, ENTITYPATH, true);
                    }
                    catch (SMSException smse) {
                        if (_debug.warningEnabled()) {
                            _debug.warning("ConfigManager->updateCache: SMSException: " + smse.toString());
                        }
                    }
                    catch (SSOException ssoe) {
                        if (!_debug.warningEnabled()) break block20;
                        _debug.warning("ConfigManager->updateCache: SSOException: " + ssoe.toString());
                    }
                }
                try {
                    sNames = this.getServiceComponents(org, SEARCHPATH, true);
                }
                catch (SMSException smse) {
                    if (_debug.warningEnabled()) {
                        _debug.warning("ConfigManager->updateCache: SMSException: " + smse.toString());
                    }
                }
                catch (SSOException ssoe) {
                    if (!_debug.warningEnabled()) break block21;
                    _debug.warning("ConfigManager->updateCache: SSOException: " + ssoe.toString());
                }
            }
            try {
                cNames = this.getServiceComponents(org, CREATIONPATH, true);
            }
            catch (SMSException smse) {
                if (_debug.warningEnabled()) {
                    _debug.warning("ConfigManager->updateCache: SMSException: " + smse.toString());
                }
            }
            catch (SSOException ssoe) {
                if (!_debug.warningEnabled()) break block22;
                _debug.warning("ConfigManager->updateCache: SSOException: " + ssoe.toString());
            }
        }
        if (cNames.isEmpty() && eNames.isEmpty() && sNames.isEmpty()) {
            _checkListCache.put(org.toLowerCase(), "dummy");
            return;
        }
        if (!sNames.isEmpty()) {
            it = sNames.iterator();
            set = new HashSet<String>();
            while (it.hasNext()) {
                s = new String();
                t = (String)it.next();
                count = t.lastIndexOf("/");
                s = t.substring(count + 1);
                set.add(s);
            }
            _cch.put(org + "/" + SEARCH + "Names", set);
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->updateCache: " + org + "/" + SEARCH + "Names :" + set);
            }
        }
        if (!cNames.isEmpty()) {
            it = cNames.iterator();
            set = new HashSet();
            while (it.hasNext()) {
                s = new String();
                t = (String)it.next();
                count = t.lastIndexOf("/");
                s = t.substring(count + 1);
                set.add(s);
            }
            _cch.put(org + "/" + CREATION + "Names", set);
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->updateCache: " + org + "/" + CREATION + "Names :" + set);
            }
        }
        this.loadCache(org, eNames, ENTITY);
        this.loadCache(org, cNames, CREATION);
        this.loadCache(org, sNames, SEARCH);
        _checkListCache.put(org.toLowerCase(), "dummy");
    }

    private Set getServiceComponents(String orgName, String path, boolean b) throws SMSException, SSOException {
        ServiceConfig sc;
        ServiceConfig serviceConfig = sc = orgName.equals(_rootDN) ? _smapi.getGlobalConfig(null) : _smapi.getOrganizationConfig(orgName, null);
        if (sc == null) {
            return new HashSet();
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0 || token.length() == 0) continue;
            sc = sc.getSubConfig(token);
        }
        HashSet<String> answer = new HashSet<String>();
        Iterator comps = sc.getSubConfigNames().iterator();
        while (comps.hasNext()) {
            answer.add(path + "/" + comps.next());
        }
        return answer;
    }

    private Map getServiceAttributes(String orgName, String path) throws SMSException, SSOException {
        ServiceConfig sc = orgName.equals(_rootDN) ? _smapi.getGlobalConfig(null) : _smapi.getOrganizationConfig(orgName, null);
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0 || token.length() == 0) continue;
            if (sc != null) {
                sc = sc.getSubConfig(token);
                continue;
            }
            return Collections.EMPTY_MAP;
        }
        if (sc != null) {
            return sc.getAttributes();
        }
        return Collections.EMPTY_MAP;
    }

    private void replaceServiceAttributes(String orgName, String path, Map attrs) throws SMSException, SSOException {
        ServiceConfig sc = _smapi.getGlobalConfig(null);
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0 || token.length() == 0) continue;
            sc = sc.getSubConfig(token);
        }
        sc.setAttributes(attrs);
    }

    void deleteOrgFromCache(String org) throws ConfigManagerException {
        String fdn = org == null || org.length() == 0 ? _rootDN : new DN(org).toRFCString().toLowerCase();
        String cchPartialKey1 = fdn + "/" + ENTITY;
        String cchPartialKey2 = fdn + "/" + CREATION;
        String cchPartialKey3 = fdn + "/" + SEARCH;
        if (_debug.messageEnabled()) {
            _debug.message("ConfigManager->deleteOrgFromCache: Deleting " + org + " from cache");
        }
        _checkListCache.remove(org.toLowerCase());
        Enumeration e = _cch.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(cchPartialKey1) != 0 && key.indexOf(cchPartialKey2) != 0 && key.indexOf(cchPartialKey3) != 0) continue;
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->deleteOrgFromCache:  Deleting..." + key);
            }
            _cch.remove(key);
        }
        if (org.length() == 0 && _cch.containsKey(OBJECTRESOLVERPATH)) {
            _cch.remove(OBJECTRESOLVERPATH);
            _oc_jc_map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConfigData(Guid guid, String name, String template, int lookup) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        DN dn = new DN(guid.getDn());
        while (true) {
            String fdn = _rootDN;
            boolean inCache = false;
            boolean checkedDS = false;
            String cacheKey = null;
            fdn = dn.toRFCString().toLowerCase();
            cacheKey = template.equals(OBJECTRESOLVER) ? OBJECTRESOLVERPATH : fdn + "/" + template + "/" + name;
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->getConfigData: fdn=" + fdn + "   cacheKey=" + cacheKey);
            }
            if (inCache = _cch.containsKey(cacheKey)) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigData: get from cache for " + dn);
                }
                return _cch.get(cacheKey);
            }
            checkedDS = _checkListCache.containsKey(fdn.toLowerCase());
            if (!checkedDS) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigData: updating cache for " + dn);
                }
                Hashtable hashtable = _cch;
                synchronized (hashtable) {
                    this.updateCache(fdn);
                }
                if (_cch.containsKey(cacheKey)) {
                    return _cch.get(cacheKey);
                }
            }
            switch (lookup) {
                case 0: {
                    return null;
                }
                case 2: {
                    dn = new DN(_rootDN);
                    break;
                }
                case 1: {
                    dn = dn.getParent();
                    if (dn.isDescendantOf(_root) || dn.equals(_root)) break;
                    return null;
                }
            }
            if (!_debug.messageEnabled()) continue;
            _debug.message("ConfigManager->getConfigData: Traversing parent: " + dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConfigTemplateNames(Guid guid, String template, int lookup) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        if (!guid.getDn().startsWith("o=")) {
            guid = GuidUtils.getOrgGuid(guid);
        }
        DN dn = new DN(guid.getDn());
        while (true) {
            String fdn = "";
            boolean inCache = false;
            boolean checkedDS = false;
            String cacheKey = null;
            fdn = dn.toRFCString().toLowerCase();
            cacheKey = fdn + "/" + template + "Names";
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->getConfigTemplateNames: Looking for: " + cacheKey);
            }
            if (inCache = _cch.containsKey(cacheKey)) {
                return (Set)_cch.get(cacheKey);
            }
            checkedDS = _checkListCache.containsKey(fdn.toLowerCase());
            if (!checkedDS) {
                if (_debug.messageEnabled()) {
                    _debug.message("ConfigManager->getConfigTemplateNames: updating " + dn);
                }
                Hashtable hashtable = _cch;
                synchronized (hashtable) {
                    this.updateCache(fdn);
                }
                if (_cch.containsKey(cacheKey)) {
                    return (Set)_cch.get(cacheKey);
                }
            }
            switch (lookup) {
                case 0: {
                    return Collections.EMPTY_SET;
                }
                case 2: {
                    dn = new DN(_rootDN);
                    break;
                }
                case 1: {
                    dn = dn.getParent();
                    if (dn.isDescendantOf(_root) || dn.equals(_root)) break;
                    return Collections.EMPTY_SET;
                }
            }
            _debug.message("ConfigManager->getConfigTemplateNames: Traversing parent: " + dn);
        }
    }

    public Set getEntity(Guid guid, String name) throws ConfigManagerException {
        Set ret = (Set)this.getConfigData(guid, name, ENTITY, 1);
        return ret == null ? Collections.EMPTY_SET : ret;
    }

    public AttrSet getSearchTemplate(Guid guid, String templateName, int lookup) throws ConfigManagerException {
        AttrSet ret = (AttrSet)this.getConfigData(guid, templateName, SEARCH, lookup);
        return ret == null ? AttrSet.EMPTY_ATTR_SET : ret;
    }

    public AttrSet getCreationTemplate(Guid guid, String templateName, int lookup) throws ConfigManagerException {
        AttrSet ret = (AttrSet)this.getConfigData(guid, templateName, CREATION, lookup);
        if (ret == null) {
            return AttrSet.EMPTY_ATTR_SET;
        }
        return ret;
    }

    public AttrSet getCreationTemplateForClass(Guid guid, String className, int lookup) throws ConfigManagerException {
        AttrSet ret = (AttrSet)this.getConfigData(guid, className, CREATION, lookup);
        if (ret == null) {
            return AttrSet.EMPTY_ATTR_SET;
        }
        return ret;
    }

    public Set getCreationTemplateNames(Guid guid) throws ConfigManagerException {
        return this.getConfigTemplateNames(guid, CREATION, 0);
    }

    public Set getSearchTemplateNames(Guid guid) throws ConfigManagerException {
        return this.getConfigTemplateNames(guid, SEARCH, 0);
    }

    public String[][] getClassResolver() throws ConfigManagerException {
        if (_oc_jc_map == null) {
            _oc_jc_map = (String[][])this.getConfigData(null, OBJECTRESOLVER, OBJECTRESOLVER, 0);
        }
        return _oc_jc_map;
    }

    public void replaceCreationTemplate(Guid guid, String templateName, AttrSet attrSet) throws ConfigManagerException {
        if (guid == null) {
            guid = new Guid(_rootDN);
        }
        DN dn = new DN(guid.getDn());
        String org = null;
        String[] dns = dn.explodeDN(true);
        for (int k = 0; k < dns.length - 1; ++k) {
            org = org + "/" + dns[k];
        }
        String service = "/templates/CreationTemplates/" + templateName;
        Map map = this.convertToMap(attrSet);
        try {
            this.replaceServiceAttributes(org, service, map);
        }
        catch (SMSException e) {
            Object[] args = new String[]{e.toString()};
            throw new ConfigManagerException(i18n.getString("ums-cm", args));
        }
        catch (SSOException se) {
            Object[] args = new String[]{se.toString()};
            throw new ConfigManagerException(i18n.getString("ums-cm", args));
        }
    }

    private Map convertToMap(AttrSet attrs) {
        HashMap map = new HashMap();
        String[] names = attrs.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            Attr attr = attrs.getAttribute(names[i]);
            String[] values = attr.getStringValues();
            HashSet<String> set = new HashSet<String>();
            for (int j = 0; j < values.length; ++j) {
                set.add(values[j]);
            }
            map.put(names[i], set);
        }
        return map;
    }

    private String[][] getOC_JC_MAP(String oc_jc_map_string) {
        StringTokenizer st = new StringTokenizer(oc_jc_map_string, ";");
        int tokencount = st.countTokens();
        String[][] oc_jc_map = new String[tokencount][2];
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int index = s.indexOf(61);
            if (index < 0) continue;
            String oc = s.substring(0, index);
            String jc = s.substring(index + 1, s.length());
            oc_jc_map[i][0] = oc;
            oc_jc_map[i][1] = jc;
            ++i;
        }
        return oc_jc_map;
    }

    private ConfigManagerUMS() throws ConfigManagerException {
        _cch = new Hashtable();
        _checkListCache = new Cache(10000);
        Object[] args = new String[1];
        try {
            DSConfigMgr dm = DSConfigMgr.getDSConfigMgr();
            ServerInstance si = dm.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            _rootDN = si.getBaseDN();
            _root = new DN(_rootDN);
            _rootDN = _root.toRFCString().toLowerCase();
            if (_debug.messageEnabled()) {
                _debug.message("ConfigManager->Constructor: root DN " + _rootDN);
            }
            String p = si.getAuthID();
            _principal = new AuthPrincipal(p);
            String psswd = (String)AccessController.doPrivileged(new ServerInstanceAction(si));
            AuthContext ac = new AuthContext(_principal, psswd.toCharArray());
            SSOToken token = ac.getSSOToken();
            try {
                SSOTokenManager.getInstance().validateToken(token);
            }
            catch (SSOException e) {
                args[0] = e.toString();
                throw new ConfigManagerException(i18n.getString("ums-invalidssotoken", args));
            }
            _smapi = new ServiceConfigManager(token, UMS_SRVC, UMS_VERSION);
            _listener = new CMListener();
            _lid = _smapi.addListener(_listener);
        }
        catch (Exception e) {
            _debug.error("ConfigManager->Constructor: Caught exception " + e);
            e.printStackTrace();
            args[0] = e.toString();
            throw new ConfigManagerException(i18n.getString("ums-cm", args));
        }
    }

    static {
        _debug = Debug.getInstance((String)"amSDK");
    }
}

