/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.service.NamingService;
import com.iplanet.services.naming.share.NamingBundle;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.debug.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebtopNaming {
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    public static final String NODE_SEPARATOR = "|";
    private static final String AM_NAMING_PREFIX = "iplanet-am-naming-";
    private static final String FAM_NAMING_PREFIX = "sun-naming-";
    private static Hashtable namingTable = null;
    private static Hashtable serverIdTable = null;
    private static Hashtable siteIdTable = null;
    private static Hashtable lbCookieValuesTable = null;
    private static Vector platformServers = new Vector();
    private static Vector lcPlatformServers = new Vector();
    private static String[] namingServiceURL = null;
    private static Vector platformServerIDs = new Vector();
    protected static Debug debug;
    private static boolean serverMode;
    private static String amServerProtocol;
    private static String amServer;
    private static String amServerPort;
    private static String amServerURI;
    private static SiteMonitor monitorThread;

    public static boolean isServerMode() {
        return serverMode;
    }

    public static boolean isSiteEnabled(String protocol, String host, String port, String uri) throws Exception {
        String serverid = WebtopNaming.getServerID(protocol, host, port, uri);
        return WebtopNaming.isSiteEnabled(serverid);
    }

    public static boolean isSiteEnabled(String serverid) throws Exception {
        String siteid = (String)siteIdTable.get(serverid);
        return !serverid.equals(siteid);
    }

    public static String getAMServerID() throws ServerEntryNotFoundException {
        return WebtopNaming.getServerID(amServerProtocol, amServer, amServerPort, amServerURI);
    }

    private static void getAMServer() {
        amServer = SystemProperties.get("com.iplanet.am.server.host");
        amServerPort = SystemProperties.get("com.iplanet.am.server.port");
        amServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
        amServerURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
    }

    private static void initializeNamingService() {
        try {
            WebtopNaming.getNamingServiceURL();
            if (!serverMode && namingServiceURL.length > 1) {
                WebtopNaming.startSiteMonitor(namingServiceURL);
            }
        }
        catch (Exception ex) {
            debug.error("Failed to initialize naming service", (Throwable)ex);
        }
    }

    public static URL getServiceURL(String service, String protocol, String host, String port, String uri) throws URLNotFoundException {
        return WebtopNaming.getServiceURL(service, protocol, host, port, uri, serverMode);
    }

    public static URL getServiceURL(String service, URL url, boolean validate) throws URLNotFoundException {
        return WebtopNaming.getServiceURL(service, url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), url.getPath(), validate);
    }

    public static URL getServiceURL(String service, String protocol, String host, String port, boolean validate) throws URLNotFoundException {
        String namingURL = SystemProperties.get("com.iplanet.am.naming.url");
        try {
            String uri = WebtopNaming.getURI(new URL(namingURL));
            return WebtopNaming.getServiceURL(service, protocol, host, port, uri, validate);
        }
        catch (MalformedURLException ex) {
            throw new URLNotFoundException(ex.getMessage());
        }
    }

    public static URL getServiceURL(String service, String protocol, String host, String port, String uri, boolean validate) throws URLNotFoundException {
        try {
            if (protocol == null || host == null || port == null || uri == null || protocol.length() == 0 || host.length() == 0 || port.length() == 0) {
                throw new Exception(NamingBundle.getString("noServiceURL") + service);
            }
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String url = null;
            String name = AM_NAMING_PREFIX + service.toLowerCase() + "-url";
            url = (String)namingTable.get(name);
            if (url == null) {
                name = FAM_NAMING_PREFIX + service.toLowerCase() + "-url";
                url = (String)namingTable.get(name);
            }
            if (url != null) {
                int idx;
                if (validate && url.indexOf("%") != -1) {
                    WebtopNaming.validate(protocol, host, port, uri);
                }
                if ((idx = url.indexOf("%protocol")) != -1) {
                    url = url.substring(0, idx) + protocol + url.substring(idx + "%protocol".length(), url.length());
                }
                if ((idx = url.indexOf("%host")) != -1) {
                    url = url.substring(0, idx) + host + url.substring(idx + "%host".length(), url.length());
                }
                if ((idx = url.indexOf("%port")) != -1) {
                    url = url.substring(0, idx) + port + url.substring(idx + "%port".length(), url.length());
                }
                if (uri != null && (idx = url.indexOf("%uri")) != -1) {
                    int test = uri.lastIndexOf(47);
                    while (test > 0) {
                        uri = uri.substring(0, test);
                        test = uri.lastIndexOf(47);
                    }
                    url = url.substring(0, idx) + uri + url.substring(idx + "%uri".length(), url.length());
                }
                return new URL(url);
            }
            throw new Exception(NamingBundle.getString("noServiceURL") + service);
        }
        catch (Exception e) {
            throw new URLNotFoundException(e.getMessage());
        }
    }

    public static Vector getServiceAllURLs(String service) throws URLNotFoundException {
        Vector<URL> allurls = null;
        try {
            String name;
            String url;
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            if ((url = (String)namingTable.get(name = AM_NAMING_PREFIX + service.toLowerCase() + "-url")) == null) {
                name = FAM_NAMING_PREFIX + service.toLowerCase() + "-url";
                url = (String)namingTable.get(name);
            }
            if (url != null) {
                allurls = new Vector<URL>();
                if (monitorThread == null) {
                    allurls.add(WebtopNaming.getServiceURL(service, amServerProtocol, amServer, amServerPort, amServerURI));
                } else if (url.indexOf("%") != -1) {
                    Vector servers = SiteMonitor.getAvailableSites();
                    Iterator it = servers.iterator();
                    while (it.hasNext()) {
                        String server = WebtopNaming.getServerFromID((String)it.next());
                        URL serverURL = new URL(server);
                        allurls.add(WebtopNaming.getServiceURL(service, serverURL.getProtocol(), serverURL.getHost(), String.valueOf(serverURL.getPort()), serverURL.getPath()));
                    }
                } else {
                    allurls.add(new URL(url));
                }
            }
            return allurls;
        }
        catch (Exception e) {
            throw new URLNotFoundException(e.getMessage());
        }
    }

    public static Vector getPlatformServerList() throws Exception {
        return WebtopNaming.getPlatformServerList(true);
    }

    public static Vector getPlatformServerList(boolean update) throws Exception {
        WebtopNaming.getNamingProfile(update);
        return platformServers;
    }

    private static String getValueFromTable(Hashtable table, String key) {
        if (table.contains(key)) {
            return (String)table.get(key);
        }
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String tmpKey = (String)keys.nextElement();
            if (!tmpKey.equalsIgnoreCase(key)) continue;
            return (String)table.get(tmpKey);
        }
        return null;
    }

    public static String getLocalServer() {
        String server = null;
        try {
            server = WebtopNaming.getServerFromID(WebtopNaming.getAMServerID());
        }
        catch (ServerEntryNotFoundException e) {
            debug.error("Failed to get local server entry.", (Throwable)e);
        }
        return server;
    }

    public static String getServerID(String protocol, String host, String port, String uri) throws ServerEntryNotFoundException {
        return WebtopNaming.getServerID(protocol, host, port, uri, true);
    }

    public static String getServerID(String protocol, String host, String port, String uri, boolean updatetbl) throws ServerEntryNotFoundException {
        try {
            if (protocol == null || host == null || port == null || protocol.length() == 0 || host.length() == 0 || port.length() == 0) {
                debug.error("WebtopNaming.getServerId():noServerId");
                throw new Exception(NamingBundle.getString("noServerID"));
            }
            String serverWithoutURI = protocol + ":" + "//" + host + ":" + port;
            String server = uri != null ? protocol + ":" + "//" + host + ":" + port + uri : serverWithoutURI;
            String serverID = null;
            if (serverIdTable != null && (serverID = WebtopNaming.getValueFromTable(serverIdTable, server)) == null) {
                serverID = WebtopNaming.getValueFromTable(serverIdTable, serverWithoutURI);
            }
            if (serverID == null && updatetbl) {
                WebtopNaming.getNamingProfile(true);
                serverID = WebtopNaming.getValueFromTable(serverIdTable, server);
                if (serverID == null) {
                    serverID = WebtopNaming.getValueFromTable(serverIdTable, serverWithoutURI);
                }
            }
            if (serverID == null) {
                debug.error("WebtopNaming.getServerId():serverId null for server: " + server);
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServerID"));
            }
            return serverID;
        }
        catch (Exception e) {
            debug.error("WebtopNaming.getServerId()", (Throwable)e);
            throw new ServerEntryNotFoundException(e);
        }
    }

    public static String getServerFromID(String serverID) throws ServerEntryNotFoundException {
        String server = null;
        try {
            if (namingTable != null) {
                server = WebtopNaming.getValueFromTable(namingTable, serverID);
            }
            if (server == null) {
                WebtopNaming.getNamingProfile(true);
                server = WebtopNaming.getValueFromTable(namingTable, serverID);
            }
            if (server == null) {
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServer"));
            }
        }
        catch (Exception e) {
            debug.error("WebtopNaming.getServerFromID() can not find server name for server ID : " + serverID, (Throwable)e);
            throw new ServerEntryNotFoundException(e);
        }
        return server;
    }

    public static Vector getAllServerIDs() throws Exception {
        if (namingTable == null) {
            WebtopNaming.getNamingProfile(false);
        }
        return platformServerIDs;
    }

    private static void updateLBCookieValueMappings() {
        Hashtable<String, String> lbcookieTbl = new Hashtable<String, String>();
        String serverSet = (String)namingTable.get("iplanet-am-platform-lb-cookie-value-list");
        if (serverSet == null || serverSet.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(serverSet, ",");
        while (tok.hasMoreTokens()) {
            String serverid;
            String lbCookieValue = serverid = tok.nextToken();
            int idx = serverid.indexOf(NODE_SEPARATOR);
            if (idx != -1) {
                lbCookieValue = serverid.substring(idx + 1, serverid.length());
                serverid = serverid.substring(0, idx);
            }
            lbcookieTbl.put(serverid, lbCookieValue);
        }
        lbCookieValuesTable = lbcookieTbl;
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming.updateLBCookieValueMappings():LBCookieValues table -> " + lbCookieValuesTable.toString());
        }
    }

    public static String getLBCookieValue(String serverid) {
        String lbCookieValue = null;
        if (serverid == null) {
            if (debug.messageEnabled()) {
                debug.message("WebtopNaming.getLBCookieValue(): server id is null, returning null ");
            }
            return null;
        }
        if (lbCookieValuesTable == null) {
            if (debug.messageEnabled()) {
                debug.message("WebtopNaming.getLBCookieValue(): lbCookieValues table is null, returning server id: " + serverid);
            }
            return serverid;
        }
        lbCookieValue = (String)lbCookieValuesTable.get(serverid);
        if (lbCookieValue == null) {
            if (debug.messageEnabled()) {
                debug.message("WebtopNaming.getLBCookieValue(): lbCookieValue from table is null, returning server id: " + serverid);
            }
            return serverid;
        }
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming.getLBCookieValue(): lbCookieValuefor " + serverid + " is " + lbCookieValue);
        }
        return lbCookieValue;
    }

    public static String getSiteID(String protocol, String host, String port, String uri) throws ServerEntryNotFoundException {
        String serverid = WebtopNaming.getServerID(protocol, host, port, uri);
        return WebtopNaming.getSiteID(serverid);
    }

    public static String getSiteID(String serverid) {
        String primary_site = null;
        String sitelist = null;
        if (siteIdTable == null) {
            return null;
        }
        sitelist = (String)siteIdTable.get(serverid);
        StringTokenizer tok = new StringTokenizer(sitelist, NODE_SEPARATOR);
        if (tok != null) {
            primary_site = tok.nextToken();
        }
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming : SiteID for " + serverid + " is " + primary_site);
        }
        return primary_site;
    }

    public static String getSecondarySites(String serverid) {
        String sitelist = null;
        String secondarysites = null;
        if (siteIdTable == null) {
            return null;
        }
        sitelist = (String)siteIdTable.get(serverid);
        if (sitelist == null) {
            return null;
        }
        int index = sitelist.indexOf(NODE_SEPARATOR);
        if (index != -1) {
            secondarysites = sitelist.substring(index + 1, sitelist.length());
        }
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming : SecondarySites for " + serverid + " is " + secondarysites);
        }
        return secondarysites;
    }

    public static Set getSiteNodes(String serverid) throws Exception {
        HashSet<String> nodeset = new HashSet<String>();
        if (namingTable == null) {
            WebtopNaming.getNamingProfile(false);
        }
        String siteid = WebtopNaming.getSiteID(serverid);
        Enumeration e = siteIdTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            if (siteid.equalsIgnoreCase(node) || !siteid.equalsIgnoreCase(WebtopNaming.getSiteID(node))) continue;
            nodeset.add(node);
        }
        return nodeset;
    }

    public static String getServiceClass(String service) throws ClassNotFoundException {
        try {
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String cls = null;
            String name = AM_NAMING_PREFIX + service.toLowerCase() + "-class";
            cls = (String)namingTable.get(name);
            if (cls == null) {
                name = FAM_NAMING_PREFIX + service.toLowerCase() + "-class";
                cls = (String)namingTable.get(name);
            }
            if (cls == null) {
                throw new Exception(NamingBundle.getString("noServiceClass") + service);
            }
            return cls;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    public static synchronized URL getNotificationURL() throws URLNotFoundException {
        try {
            String url = System.getProperty("com.sun.identity.client.notification.url", SystemProperties.get("com.sun.identity.client.notification.url"));
            if (url == null) {
                throw new URLNotFoundException(NamingBundle.getString("noNotificationURL"));
            }
            return new URL(url);
        }
        catch (Exception e) {
            throw new URLNotFoundException(e.getMessage());
        }
    }

    private static synchronized void getNamingProfile(boolean update) throws Exception {
        if (update || namingTable == null) {
            WebtopNaming.updateNamingTable();
        }
    }

    private static void updateServerProperties(URL url) {
        amServerProtocol = url.getProtocol();
        amServer = url.getHost();
        amServerPort = Integer.toString(url.getPort());
        amServerURI = url.getPath();
        amServerURI = amServerURI.replaceAll("//", "/");
        int idx = amServerURI.lastIndexOf("/");
        while (idx > 0) {
            amServerURI = amServerURI.substring(0, idx);
            idx = amServerURI.lastIndexOf("/");
        }
        SystemProperties.initializeProperties("com.iplanet.am.server.protocol", amServerProtocol);
        SystemProperties.initializeProperties("com.iplanet.am.server.host", amServer);
        SystemProperties.initializeProperties("com.iplanet.am.server.port", amServerPort);
        SystemProperties.initializeProperties("com.iplanet.am.services.deploymentDescriptor", amServerURI);
        if (debug.messageEnabled()) {
            debug.message("Server Properties are changed : ");
            debug.message("com.iplanet.am.server.protocol : " + SystemProperties.get("com.iplanet.am.server.protocol", null));
            debug.message("com.iplanet.am.server.host : " + SystemProperties.get("com.iplanet.am.server.host", null));
            debug.message("com.iplanet.am.server.port : " + SystemProperties.get("com.iplanet.am.server.port", null));
            debug.message("com.iplanet.am.services.deploymentDescriptor : " + SystemProperties.get("com.iplanet.am.services.deploymentDescriptor", null));
        }
    }

    private static Hashtable getNamingTable(URL nameurl) throws Exception {
        Hashtable nametbl = null;
        NamingRequest nrequest = new NamingRequest("3.0");
        Request request = new Request(nrequest.toXMLString());
        RequestSet set = new RequestSet(NAMING_SERVICE);
        set.addRequest(request);
        Vector responses = null;
        try {
            responses = PLLClient.send(nameurl, set);
            if (responses.size() != 1) {
                throw new Exception(NamingBundle.getString("unexpectedResponse"));
            }
            Response res = (Response)responses.elementAt(0);
            NamingResponse nres = NamingResponse.parseXML(res.getContent());
            if (nres.getException() != null) {
                throw new Exception(nres.getException());
            }
            nametbl = nres.getNamingTable();
        }
        catch (SendRequestException sre) {
            debug.error("Naming service connection failed for " + nameurl, (Throwable)sre);
        }
        catch (Exception e) {
            debug.error("getNamingTable: ", (Throwable)e);
        }
        return nametbl;
    }

    private static void updateNamingTable() throws Exception {
        if (!serverMode) {
            if (namingServiceURL == null) {
                WebtopNaming.initializeNamingService();
            }
            Hashtable namingtbl = null;
            URL tempNamingURL = null;
            for (int i = 0; namingtbl == null && i < namingServiceURL.length; ++i) {
                tempNamingURL = new URL(namingServiceURL[i]);
                namingtbl = WebtopNaming.getNamingTable(tempNamingURL);
            }
            if (namingtbl == null) {
                debug.error("updateNamingTable : " + NamingBundle.getString("noNamingServiceAvailable"));
                throw new Exception(NamingBundle.getString("noNamingServiceAvailable"));
            }
            namingTable = namingtbl;
            WebtopNaming.updateServerProperties(tempNamingURL);
        } else {
            namingTable = NamingService.getNamingTable();
        }
        String servers = (String)namingTable.get("iplanet-am-platform-server-list");
        if (servers != null) {
            StringTokenizer st = new StringTokenizer(servers, ",");
            Vector<String> platformServersNEW = new Vector<String>();
            Vector<String> lcPlatformServersNEW = new Vector<String>();
            while (st.hasMoreTokens()) {
                String svr = st.nextToken();
                lcPlatformServersNEW.add(svr.toLowerCase());
                platformServersNEW.add(svr);
            }
            platformServers = platformServersNEW;
            lcPlatformServers = lcPlatformServersNEW;
        }
        WebtopNaming.updateServerIdMappings();
        WebtopNaming.updateSiteIdMappings();
        WebtopNaming.updatePlatformServerIDs();
        WebtopNaming.updateLBCookieValueMappings();
        if (debug.messageEnabled()) {
            debug.message("Naming table -> " + namingTable.toString());
            debug.message("Server Id Table -> " + serverIdTable.toString());
            debug.message("Site Id Table -> " + siteIdTable.toString());
            debug.message("Platform Servers -> " + platformServers.toString());
            debug.message("Platform Server IDs -> " + platformServerIDs.toString());
        }
    }

    private static void updateServerIdMappings() {
        Hashtable<String, String> serverIdTbl = new Hashtable<String, String>();
        Enumeration e = namingTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)namingTable.get(key);
            if (key == null || value == null || key.equals("iplanet-am-platform-server-list")) continue;
            serverIdTbl.put(value, key);
        }
        serverIdTable = serverIdTbl;
    }

    private static void updateSiteIdMappings() {
        Hashtable<String, String> siteIdTbl = new Hashtable<String, String>();
        String serverSet = (String)namingTable.get("iplanet-am-platform-site-id-list");
        if (serverSet == null || serverSet.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(serverSet, ",");
        while (tok.hasMoreTokens()) {
            String serverid;
            String siteid = serverid = tok.nextToken();
            int idx = serverid.indexOf(NODE_SEPARATOR);
            if (idx != -1) {
                siteid = serverid.substring(idx + 1, serverid.length());
                serverid = serverid.substring(0, idx);
            }
            siteIdTbl.put(serverid, siteid);
        }
        siteIdTable = siteIdTbl;
        if (debug.messageEnabled()) {
            debug.message("SiteID table -> " + siteIdTable.toString());
        }
    }

    private static void updatePlatformServerIDs() throws MalformedURLException, ServerEntryNotFoundException {
        Iterator it = platformServers.iterator();
        while (it.hasNext()) {
            String plaformURL = (String)it.next();
            URL url = new URL(plaformURL);
            String serverID = WebtopNaming.getServerID(url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), url.getPath());
            if (platformServerIDs.contains(serverID)) continue;
            platformServerIDs.add(serverID);
        }
    }

    private static void validate(String protocol, String host, String port, String uri) throws URLNotFoundException {
        String server = uri != null ? protocol + "://" + host + ":" + port + uri : protocol + "://" + host + ":" + port;
        server = server.toLowerCase();
        try {
            if (protocol.equalsIgnoreCase(amServerProtocol) && host.equalsIgnoreCase(amServer) && port.equals(amServerPort) && (uri == null || uri.equalsIgnoreCase(amServerURI))) {
                return;
            }
            if (debug.messageEnabled()) {
                debug.message("WebtopNaming.validate: platformServers= " + platformServers);
            }
            if (!lcPlatformServers.contains(server)) {
                WebtopNaming.getNamingProfile(true);
                if (!platformServers.contains(server)) {
                    throw new URLNotFoundException(NamingBundle.getString("invalidServiceHost") + " " + server);
                }
            }
        }
        catch (Exception e) {
            debug.error("platformServers: " + platformServers, (Throwable)e);
            throw new URLNotFoundException(e.getMessage());
        }
    }

    public static synchronized String[] getNamingServiceURL() throws Exception {
        if (!serverMode && namingServiceURL == null) {
            ArrayList<String> urlList = new ArrayList<String>();
            String configURLListString = SystemProperties.get("com.iplanet.am.naming.url");
            if (configURLListString != null) {
                StringTokenizer stok = new StringTokenizer(configURLListString);
                while (stok.hasMoreTokens()) {
                    String nextURL = stok.nextToken();
                    if (urlList.contains(nextURL)) {
                        if (!debug.warningEnabled()) continue;
                        debug.warning("Duplicate naming service URL specified " + nextURL + ", will be ignored.");
                        continue;
                    }
                    urlList.add(nextURL);
                }
            }
            if (urlList.size() == 0) {
                throw new Exception(NamingBundle.getString("noNamingServiceURL"));
            }
            if (debug.messageEnabled()) {
                debug.message("Naming service URL list: " + urlList);
            }
            namingServiceURL = new String[urlList.size()];
            System.arraycopy(urlList.toArray(), 0, namingServiceURL, 0, urlList.size());
        }
        return namingServiceURL;
    }

    private static synchronized void startSiteMonitor(String[] urlList) {
        if (monitorThread != null) {
            return;
        }
        if (urlList.length > 1) {
            monitorThread = new SiteMonitor(urlList);
            SystemTimer.getTimer().schedule((TaskRunnable)monitorThread, new Date(System.currentTimeMillis() / 1000L * 1000L));
        } else if (debug.messageEnabled()) {
            debug.message("Only one naming service URL specified. NamingServiceMonitor will be disabled.");
        }
    }

    public static void removeFailedSite(String server) {
        if (monitorThread != null) {
            try {
                URL url = new URL(server);
                WebtopNaming.removeFailedSite(url);
            }
            catch (MalformedURLException e) {
                debug.error("Server URL is not valid : ", (Throwable)e);
            }
        }
    }

    public static void removeFailedSite(URL url) {
        if (monitorThread != null) {
            try {
                String serverid = WebtopNaming.getServerID(url.getProtocol(), url.getHost(), String.valueOf(url.getPort()), url.getPath());
                SiteMonitor.removeFailedSite(serverid);
            }
            catch (ServerEntryNotFoundException e) {
                debug.error("Can not find server ID : ", (Throwable)e);
            }
        }
    }

    public static String getURI(URL url) {
        String uri = url.getPath();
        int idx = uri.lastIndexOf(47);
        while (idx > 0) {
            uri = uri.substring(0, idx);
            idx = uri.lastIndexOf(47);
        }
        return uri;
    }

    static {
        amServerProtocol = null;
        amServer = null;
        amServerPort = null;
        monitorThread = null;
        serverMode = Boolean.valueOf(System.getProperty("com.iplanet.am.serverMode", SystemProperties.get("com.iplanet.am.serverMode", "false")));
        try {
            WebtopNaming.getAMServer();
            debug = Debug.getInstance((String)"amNaming");
        }
        catch (Exception ex) {
            debug.error("Failed to initialize server properties", (Throwable)ex);
        }
    }

    public static interface SiteStatusCheck {
        public boolean doCheckSiteStatus(URL var1);
    }

    public static class SiteMonitor
    extends GeneralTaskRunnable {
        static long sleepInterval;
        static Vector availableSiteList;
        static String currentSiteID;
        static SiteStatusCheck siteChecker;
        static String[] siteUrlList;
        public static boolean keepMonitoring;

        public SiteMonitor(String[] urlList) {
            siteUrlList = urlList;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public long getRunPeriod() {
            return sleepInterval;
        }

        public void run() {
            keepMonitoring = true;
            try {
                SiteMonitor.runCheckValidSite();
            }
            catch (Exception e) {
                debug.error("SiteMonitor run failed : ", (Throwable)e);
            }
        }

        static void runCheckValidSite() {
            Vector siteList = SiteMonitor.checkAvailableSiteList();
            SiteMonitor.updateSiteList(siteList);
            SiteMonitor.updateCurrentSite(siteList);
        }

        public static boolean checkSiteStatus(URL siteurl) {
            return siteChecker.doCheckSiteStatus(siteurl);
        }

        private static Vector checkAvailableSiteList() {
            Vector<String> siteList = new Vector<String>();
            for (int i = 0; i < siteUrlList.length; ++i) {
                try {
                    URL siteurl = new URL(siteUrlList[i]);
                    if (!siteChecker.doCheckSiteStatus(siteurl)) continue;
                    String serverid = WebtopNaming.getServerID(siteurl.getProtocol(), siteurl.getHost(), String.valueOf(siteurl.getPort()), siteurl.getPath());
                    siteList.add(serverid);
                    continue;
                }
                catch (MalformedURLException ex) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("SiteMonitor: Site URL " + siteUrlList[i] + " is not valid.", (Throwable)ex);
                    continue;
                }
                catch (ServerEntryNotFoundException ex) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("SiteMonitor: Site URL " + siteUrlList[i] + " is not available.", (Throwable)ex);
                }
            }
            return siteList;
        }

        public static boolean isAvailable(URL url) throws Exception {
            if (namingTable == null || !keepMonitoring) {
                return true;
            }
            String serverID = null;
            try {
                serverID = WebtopNaming.getServerID(url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), url.getPath(), false);
            }
            catch (ServerEntryNotFoundException e) {
                if (debug.messageEnabled()) {
                    debug.message("URL is not part of AM setup.");
                }
                return true;
            }
            Vector sites = SiteMonitor.getAvailableSites();
            boolean available = false;
            Iterator it = sites.iterator();
            while (it.hasNext()) {
                String server = (String)it.next();
                if (!serverID.equalsIgnoreCase(server)) continue;
                available = true;
                break;
            }
            if (debug.messageEnabled()) {
                debug.message("In SiteMonitor.isAvailable()");
                if (available) {
                    debug.message("SiteID " + url.toString() + " is UP.");
                } else {
                    debug.message("SiteID " + url.toString() + " is DOWN.");
                }
            }
            return available;
        }

        public static boolean isCurrentSite(URL url) throws Exception {
            String serverid;
            if (namingTable == null || !keepMonitoring) {
                return true;
            }
            String serverID = null;
            try {
                serverID = WebtopNaming.getServerID(url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), url.getPath(), false);
            }
            catch (ServerEntryNotFoundException e) {
                if (debug.messageEnabled()) {
                    debug.message("URL is not part of AM setup.");
                }
                return true;
            }
            Vector sites = SiteMonitor.getAvailableSites();
            boolean isCurrent = false;
            if (!sites.isEmpty() && (serverid = (String)sites.firstElement()) != null) {
                isCurrent = serverid.equalsIgnoreCase(serverID);
            }
            return isCurrent;
        }

        static Vector getAvailableSites() throws Exception {
            Vector sites = null;
            if (availableSiteList.size() == 0) {
                String[] namingURLs = WebtopNaming.getNamingServiceURL();
                for (int i = 0; i < namingURLs.length; ++i) {
                    URL url = new URL(namingURLs[i]);
                    availableSiteList.add(WebtopNaming.getServerID(url.getProtocol(), url.getHost(), String.valueOf(url.getPort()), url.getPath()));
                }
                SiteMonitor.updateCurrentSite(availableSiteList);
            }
            sites = new Vector(availableSiteList);
            if (debug.messageEnabled()) {
                debug.message("In SiteMonitor.getAvailableSites()");
                debug.message("availableSiteList : " + sites.toString());
            }
            return sites;
        }

        static void removeFailedSite(String site) {
            if (keepMonitoring && availableSiteList.contains(site)) {
                availableSiteList.remove(site);
            }
        }

        private static void updateSiteList(Vector list) {
            availableSiteList = list;
            if (debug.messageEnabled()) {
                debug.message("In SiteMonitor.updateSiteList()");
                debug.message("availableSiteList : " + availableSiteList.toString());
            }
        }

        private static void updateCurrentSite(Vector list) {
            if (serverMode) {
                return;
            }
            if (list == null || list.size() == 0) {
                return;
            }
            String sid = (String)list.firstElement();
            if (!currentSiteID.equalsIgnoreCase(sid)) {
                if (debug.messageEnabled()) {
                    debug.message("Invoke updateServerProperties() : Server properties are changed for service failover");
                }
                try {
                    currentSiteID = sid;
                    String serverurl = WebtopNaming.getServerFromID(currentSiteID);
                    WebtopNaming.updateServerProperties(new URL(serverurl));
                }
                catch (Exception e) {
                    debug.error("SiteMonitor: ", (Throwable)e);
                }
            }
        }

        static {
            availableSiteList = new Vector();
            currentSiteID = null;
            siteChecker = null;
            siteUrlList = null;
            keepMonitoring = false;
            try {
                String checkClass = SystemProperties.get("com.sun.identity.sitemonitor.SiteStatusCheck.class", "com.iplanet.services.naming.SiteStatusCheckThreadImpl");
                if (debug.messageEnabled()) {
                    debug.message("SiteMonitor : SiteStatusCheck class = " + checkClass);
                }
                siteChecker = (SiteStatusCheck)Class.forName(checkClass).newInstance();
                sleepInterval = Long.valueOf(SystemProperties.get("com.sun.identity.sitemonitor.interval", "60000"));
                WebtopNaming.getNamingProfile(false);
                currentSiteID = WebtopNaming.getServerID(amServerProtocol, amServer, amServerPort, amServerURI);
            }
            catch (Exception e) {
                debug.message("SiteMonitor initialization failed : ", (Throwable)e);
            }
        }
    }
}

