/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOToken;
import netscape.ldap.LDAPConnection;

class Request {
    private int _id;
    private String _reqID;
    private SSOToken _requester;
    private String _baseDn;
    private int _scope;
    private String _filter;
    private String[] _attrs;
    private int _operations;
    private IDSEventListener _listener;
    private LDAPConnection _connection;
    private long _lastUpdatedTime;

    Request(int id, String reqID, SSOToken requester, String baseDn, int scope, String filter, String[] attrs, int operations, IDSEventListener listener, LDAPConnection connection, long lastResponseTime) {
        this._id = id;
        this._reqID = reqID;
        this._requester = requester;
        this._baseDn = baseDn;
        this._scope = scope;
        this._filter = filter;
        this._attrs = attrs;
        this._operations = operations;
        this._listener = listener;
        this._connection = connection;
        this._lastUpdatedTime = lastResponseTime;
    }

    int getId() {
        return this._id;
    }

    String getRequestID() {
        return this._reqID;
    }

    SSOToken getRequester() {
        return this._requester;
    }

    String getBaseDn() {
        return this._baseDn;
    }

    int getScope() {
        return this._scope;
    }

    String getFilter() {
        return this._filter;
    }

    String[] getattrs() {
        return this._attrs;
    }

    int getOperations() {
        return this._operations;
    }

    synchronized IDSEventListener getListener() {
        return this._listener;
    }

    protected LDAPConnection getLDAPConnection() {
        return this._connection;
    }

    protected long getLastUpdatedTime() {
        return this._lastUpdatedTime;
    }

    protected void setLastUpdatedTime(long time) {
        this._lastUpdatedTime = time;
    }

    public String toString() {
        String str = "[EventEntry] base=" + this._baseDn + " scope=" + this._scope + " filter=" + this._filter + " attrs={";
        for (int i = 0; i < this._attrs.length; ++i) {
            if (i > 0) {
                str = str + " ";
            }
            str = str + this._attrs[i];
        }
        str = str + "} operations=" + this._operations;
        str = str + " listener=" + this._listener.toString();
        str = str + " id=" + this._id + " last updated time: " + this._lastUpdatedTime;
        return str;
    }
}

