/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.Request;
import com.sun.identity.common.PeriodicGroupMap;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import java.util.Date;
import java.util.Map;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;

public class EventServicePolling
extends EventService {
    private Map map;

    protected EventServicePolling() throws EventException {
        this.map = this._requestList;
        this._requestList = new PeriodicGroupMap(new ScheduleableGroupAction(){

            public void doGroupAction(Object obj) {
                Request req = (Request)EventServicePolling.this.map.remove(obj);
                if (req != null) {
                    try {
                        EventServicePolling.this.addListener(req.getRequester(), req.getListener(), req.getBaseDn(), req.getScope(), req.getFilter(), req.getOperations());
                        EventServicePolling.this.removeListener(req);
                    }
                    catch (LDAPServiceException le) {
                        if (EventService.debugger.messageEnabled()) {
                            EventService.debugger.message("EventServicePolling:  LDAPServiceException occurred while re-establishinglisteners. ", (Throwable)le);
                        }
                        int errorCode = le.getLDAPExceptionErrorCode();
                        EventServicePolling.this.processExceptionErrorCodes((Exception)le, errorCode);
                    }
                    catch (LDAPException e) {
                        if (EventService.debugger.messageEnabled()) {
                            EventService.debugger.message("EventServicePolling.resetAllSearches(): LDAPException occurred, while trying to re-establish persistent searches.", (Throwable)e);
                        }
                        int errorCode = e.getLDAPResultCode();
                        EventServicePolling.this.processExceptionErrorCodes((Exception)((Object)e), errorCode);
                    }
                }
            }
        }, _idleTimeOutMills, _idleTimeOutMills, true, this.map);
        SystemTimer.getTimer().schedule((TaskRunnable)this._requestList, new Date((System.currentTimeMillis() + _idleTimeOutMills) / 1000L * 1000L));
    }

    protected static String getName() {
        return "EventServicePolling";
    }

    private boolean processExceptionErrorCodes(Exception ex, int errorCode) {
        boolean successState = true;
        if (_retryErrorCodes.contains(Integer.toString(errorCode))) {
            this.resetErrorSearches(true);
        } else {
            this.processNetworkError(ex);
        }
        return successState;
    }

    protected boolean processResponse(LDAPMessage message) {
        if (message == null && !this._requestList.isEmpty()) {
            debugger.warning("EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches");
            this.resetErrorSearches(false);
            return true;
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processResponse() - received DS message  => " + message.toString());
        }
        boolean successState = true;
        Request request = this.getRequestEntry(message.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponse() - Received ldap message with unknown id = " + message.getMessageID());
            }
        } else if (message instanceof LDAPSearchResult) {
            this.processSearchResultMessage((LDAPSearchResult)message, request);
            TaskRunnable taskList = (TaskRunnable)this._requestList;
            taskList.removeElement((Object)request.getRequestID());
            taskList.addElement((Object)request.getRequestID());
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (message instanceof LDAPResponse) {
            LDAPResponse rsp = (LDAPResponse)message;
            successState = this.processResponseMessage(rsp, request);
        } else if (message instanceof LDAPSearchResultReference) {
            this.processSearchResultRef((LDAPSearchResultReference)message, request);
        }
        return successState;
    }

    protected Thread getServiceThread() {
        return _monitorThread;
    }
}

