/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACIParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class BindRule {
    Collection _users;
    Collection _groups;
    Collection _roles;
    Collection _authMethods;
    Collection _clientIP;
    Collection _clientHostNames;
    Collection _timesOfDay;
    String _todOp;
    Collection _daysOfWeek;
    String _previousTodOperator;
    Collection _userDNAttrs;
    Collection _groupDNAttrs;
    Collection _userAttrs;

    BindRule() {
    }

    void addUsers(String value) throws ACIParseException {
        if (this._users == null) {
            this._users = new ArrayList();
        }
        Iterator c = ACIParser.getTokens(value, "||").iterator();
        while (c.hasNext()) {
            String str = ((String)c.next()).trim();
            if (str.indexOf("ldap:///") == 0) {
                this._users.add(str.substring("ldap:///".length()));
                continue;
            }
            if (str.toLowerCase().indexOf("ldap:///") == 0) {
                this._users.add(str.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed userDN : " + str);
        }
    }

    Collection getUsers() {
        return this._users;
    }

    void addGroups(String value) throws ACIParseException {
        if (this._groups == null) {
            this._groups = new ArrayList();
        }
        Iterator c = ACIParser.getTokens(value, "||").iterator();
        while (c.hasNext()) {
            String str = (String)c.next();
            if (str.indexOf("ldap:///") == 0) {
                this._groups.add(str.substring("ldap:///".length()));
                continue;
            }
            if (str.toLowerCase().indexOf("ldap:///") == 0) {
                this._groups.add(str.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed groupDN : " + value);
        }
    }

    Collection getGroups() {
        return this._groups;
    }

    void addRoles(String value) throws ACIParseException {
        if (this._roles == null) {
            this._roles = new ArrayList();
        }
        Iterator c = ACIParser.getTokens(value, "||").iterator();
        while (c.hasNext()) {
            String str = (String)c.next();
            if (str.indexOf("ldap:///") == 0) {
                this._roles.add(str.substring("ldap:///".length()));
                continue;
            }
            if (str.toLowerCase().indexOf("ldap:///") == 0) {
                this._roles.add(str.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed roleDN : " + value);
        }
    }

    Collection getRoles() {
        return this._roles;
    }

    void addUserDNAttr(String value) {
        if (this._userDNAttrs == null) {
            this._userDNAttrs = new ArrayList();
        }
        this._userDNAttrs.add(value);
    }

    Collection getUserDNAttrs() {
        return this._userDNAttrs;
    }

    void addGroupDNAttr(String value) {
        if (this._groupDNAttrs == null) {
            this._groupDNAttrs = new ArrayList();
        }
        this._groupDNAttrs.add(value);
    }

    Collection getGroupDNAttrs() {
        return this._groupDNAttrs;
    }

    void addAuthMethod(String value) {
        if (this._authMethods == null) {
            this._authMethods = new ArrayList();
        }
        this._authMethods.add(value);
    }

    Collection getAuthMethods() {
        return this._authMethods;
    }

    void addClientIP(String value) {
        if (this._clientIP == null) {
            this._clientIP = new ArrayList();
        }
        this._clientIP.add(value);
    }

    Collection getClientIP() {
        return this._clientIP;
    }

    void addClientHostName(String value) {
        if (this._clientHostNames == null) {
            this._clientHostNames = new ArrayList();
        }
        this._clientHostNames.add(value);
    }

    Collection getClientHostNames() {
        return this._clientHostNames;
    }

    void addTimeOfDay(String value, String operator) throws ACIParseException {
        if (this._timesOfDay == null) {
            this._timesOfDay = new ArrayList();
        }
        if (!operator.equals(">=") && !operator.equals("<=")) {
            throw new ACIParseException("Illegal operator for timeofday : " + operator);
        }
        if (this._previousTodOperator == null && !operator.equals(">=")) {
            throw new ACIParseException("Illegal first operator for timeofday : " + operator);
        }
        if (operator.equals(this._previousTodOperator)) {
            throw new ACIParseException("Illegal operator sequence for timeofday : " + operator);
        }
        this._timesOfDay.add(value);
        this._previousTodOperator = operator;
    }

    Collection getTimesOfDay() {
        return this._timesOfDay;
    }

    void addDaysOfWeek(String value) {
        if (this._daysOfWeek == null) {
            this._daysOfWeek = new ArrayList();
        }
        this._daysOfWeek.addAll(ACIParser.getTokens(value, ","));
    }

    Collection getDaysOfWeek() {
        return this._daysOfWeek;
    }

    void addUserAttr(String value) {
        if (this._userAttrs == null) {
            this._userAttrs = new ArrayList();
        }
        this._userAttrs.add(value);
    }

    Collection getUserAttrs() {
        return this._userAttrs;
    }
}

