/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm.clientschema;

import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class AMClientCapData
implements IDSEventListener {
    private static final String SERVICE_VERSION = "1.0";
    private static final String SERVICE_NAME = "SunAMClientData";
    private static final String BUNDLE_NAME = "amClientData";
    private static String OBJECTCLASS = "objectclass";
    private static String CLIENT_OBJECTCLASS = "sunAMClient";
    private static String UMS_ADD_TEMPLATE_NAME = "Client";
    private static String UMS_SRCH_TEMPLATE_NAME = "BasicClientSearch";
    private static String CLIENT_PREFIX = "sunamclient";
    private static final String CREATE_FAILED = "901";
    private static final String MISSING_PROP_CT = "903";
    private static final String CT_EXISTS = "904";
    private static final String ADD_FAILED = "905";
    private static final String CANNOT_MOD_INT_DB = "906";
    private static final String MODIFY_FAILED = "907";
    private static final String DELETE_FAILED = "908";
    private static final String[] dsameAttributeNames = new String[]{"generalPropertyNames", "hardwarePlatformNames", "softwarePlatformNames", "networkCharacteristicsNames", "browserUANames", "wapCharacteristicsNames", "pushCharacteristicsNames", "additionalPropertiesNames"};
    private static final String DBSTORE_SUBSCHEMA_ID = "clientDBStore";
    private static final String CLIENT_SUBSCHEMA_ID = "clientData";
    private static final String INTERNAL_DB = "internalData";
    private static final String EXTERNAL_DB = "externalData";
    private static final String INTERNAL_DATA = "ou=internalData";
    private static final String EXTERNAL_DATA = "ou=externalData";
    public static final int INTERNAL = 1;
    public static final int EXTERNAL = 2;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int MODIFIED = 4;
    private static final String CLIENT_TYPE = "clientType";
    private static final String USER_AGENT = "userAgent";
    private static final String PARENT_ID = "parentId";
    private static final String ADD_PROPS = "additionalProperties";
    private static final String EQUALS = "=";
    private static final String COMMA = ",";
    private static String CLIENTTYPE_ATTR = "ou";
    public static final String ADD_PROP_SEPARATOR = "=";
    public static final String ADDITIONAL_PROPERTIES_ATTR = CLIENT_PREFIX + "additionalProperties";
    private static final String PROFILE_MANAGER_XML_ATTR = "profileManagerXML";
    private static final String ENABLE_CLIENT_CREATION_ATTR = "enableClientCreation";
    private static SSOToken adminToken = null;
    private static Debug debug = Debug.getInstance((String)"amClientSchema");
    private static AMStoreConnection amConnection = null;
    private static ServiceManager sManager = null;
    private static String topLevelDN = null;
    private static String clientDataDN = null;
    private static String CLIENT_DATA_DN_PREFIX = "ou=1.0,ou=SunAMClientData,ou=ClientData";
    private static AMClientCapData internalInstance = null;
    private static AMClientCapData externalInstance = null;
    private static Set wholeClient = new HashSet();
    private static Set minClient = new HashSet();
    private static ServiceSchema clientServiceSchema = null;
    private static ServiceSchema clientSchema = null;
    private static Map schemaMap = null;
    private static Map schemaToLDAP = new HashMap();
    private static Map LDAPToSchema = new HashMap();
    protected static final String SEARCH_FILTER = "(" + OBJECTCLASS + "=" + CLIENT_OBJECTCLASS + ")";
    protected static final int OPERATIONS = 7;
    private int databaseType = 0;
    private String dbStr = null;
    private AMOrganizationalUnit amClientOrg = null;
    private List listeners = new ArrayList(2);
    private String databaseDN = null;

    private AMClientCapData(int dbType) throws Exception {
        String dbName = null;
        this.databaseType = dbType;
        if (this.isInternalInstance()) {
            dbName = INTERNAL_DATA;
            this.dbStr = "InternalDB:: ";
        } else {
            dbName = EXTERNAL_DATA;
            this.dbStr = "ExternalDB:: ";
        }
        this.init(dbName);
    }

    private synchronized void init(String instanceRDN) throws Exception {
        String srvcName = this.getServiceName();
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            sManager = new ServiceManager(adminToken);
            ServiceSchemaManager schemaManager = sManager.getSchemaManager(srvcName, SERVICE_VERSION);
            clientServiceSchema = schemaManager.getGlobalSchema();
            clientSchema = clientServiceSchema.getSubSchema(DBSTORE_SUBSCHEMA_ID);
            clientSchema = clientSchema.getSubSchema(CLIENT_SUBSCHEMA_ID);
            amConnection = new AMStoreConnection(adminToken);
            topLevelDN = amConnection.getOrganizationDN(null, null);
            AMClientCapData.initClientSchema();
            this.initConfigurationInfo(clientServiceSchema);
            clientDataDN = CLIENT_DATA_DN_PREFIX + COMMA + topLevelDN;
        }
        this.databaseDN = instanceRDN + COMMA + clientDataDN;
        this.amClientOrg = amConnection.getOrganizationalUnit(this.databaseDN);
    }

    private void initConfigurationInfo(ServiceSchema schema) {
        Set vals = this.getServiceAttribute(schema, "configInfo");
        if (vals == null) {
            vals = Collections.EMPTY_SET;
        }
        Iterator iter = vals.iterator();
        while (iter.hasNext()) {
            String val = (String)iter.next();
            int index = val.indexOf("=");
            String key = val.substring(0, index);
            String value = val.substring(index + 1);
            if (key.equalsIgnoreCase(OBJECTCLASS)) {
                CLIENT_OBJECTCLASS = value;
                continue;
            }
            if (key.equalsIgnoreCase("umsAddTemplateName")) {
                UMS_ADD_TEMPLATE_NAME = value;
                continue;
            }
            if (key.equalsIgnoreCase("umsSearchTemplateName")) {
                UMS_SRCH_TEMPLATE_NAME = value;
                continue;
            }
            if (key.equalsIgnoreCase("prefixForAttr")) {
                CLIENT_PREFIX = value;
                continue;
            }
            if (key.equalsIgnoreCase("rdn")) {
                CLIENTTYPE_ATTR = value;
                continue;
            }
            if (key.equalsIgnoreCase("clientDN")) {
                CLIENT_DATA_DN_PREFIX = value;
                continue;
            }
            if (!key.equalsIgnoreCase("minimalClientAttrs")) continue;
            this.addToSet(value, minClient);
        }
        if (minClient.size() == 0) {
            String DEF_MIN_CLIENTS = CLIENTTYPE_ATTR + COMMA + USER_AGENT + COMMA + PARENT_ID;
            this.addToSet(DEF_MIN_CLIENTS, minClient);
        }
    }

    private void addToSet(String val, Set s) {
        StringTokenizer st = new StringTokenizer(val, COMMA);
        while (st.hasMoreElements()) {
            String str = st.nextToken();
            str = str.equalsIgnoreCase("rdn") ? CLIENTTYPE_ATTR : CLIENT_PREFIX + str;
            s.add(str);
        }
    }

    private boolean isInternalInstance() {
        return this.databaseType == 1;
    }

    private static void initClientSchema() {
        Set props = AMClientCapData.getSchemaElements();
        Iterator itr = props.iterator();
        while (itr.hasNext()) {
            String propName = (String)itr.next();
            String attrName = CLIENT_PREFIX + propName;
            if (propName.equals(CLIENT_TYPE)) {
                attrName = CLIENTTYPE_ATTR;
            }
            wholeClient.add(attrName);
            String attrNameLC = attrName.toLowerCase();
            LDAPToSchema.put(attrNameLC, propName);
            schemaToLDAP.put(propName, attrName);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public static synchronized AMClientCapData getInternalInstance() throws AMClientCapException {
        if (internalInstance == null) {
            try {
                internalInstance = new AMClientCapData(1);
            }
            catch (Exception e) {
                internalInstance = null;
                debug.error("InternalDB:: Create instance object failed: ", (Throwable)e);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return internalInstance;
    }

    public static synchronized AMClientCapData getExternalInstance() throws AMClientCapException {
        if (externalInstance == null) {
            try {
                externalInstance = new AMClientCapData(2);
            }
            catch (Exception e) {
                externalInstance = null;
                debug.error("ExternalDB:: Create instance object failed: ", (Throwable)e);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return externalInstance;
    }

    private String generateClientDN(String clientType) {
        StringBuffer dn = new StringBuffer();
        dn.append(CLIENTTYPE_ATTR);
        dn.append("=");
        dn.append(clientType);
        dn.append(COMMA);
        dn.append(this.databaseDN);
        return dn.toString();
    }

    public Map getProperties(String clientType) {
        Map props = null;
        String dn = this.generateClientDN(clientType);
        try {
            AMEntity amEntity = amConnection.getEntity(dn);
            if (amEntity.isExists()) {
                Map attrsMap = amEntity.getAttributes();
                props = this.parsePropertyNames(attrsMap);
            }
        }
        catch (Exception e) {
            debug.warning(this.dbStr + "Could not get Client: " + clientType, (Throwable)e);
        }
        return props;
    }

    public Map loadMinimalClient(String clientType) {
        Map props = null;
        String dn = this.generateClientDN(clientType);
        try {
            AMEntity amEntity = amConnection.getEntity(dn);
            if (amEntity.isExists()) {
                Map attrsMap = amEntity.getAttributes(minClient);
                props = this.parsePropertyNames(attrsMap);
            }
        }
        catch (Exception e) {
            debug.warning(this.dbStr + "Could not get Client: " + clientType, (Throwable)e);
        }
        return props;
    }

    private Map parsePropertyNames(Map m) {
        HashMap props = new HashMap();
        Iterator allKeys = m.keySet().iterator();
        while (allKeys.hasNext()) {
            String attrName = (String)allKeys.next();
            Set vals = (Set)m.get(attrName);
            if (vals.size() == 0) continue;
            if (attrName.equalsIgnoreCase(ADDITIONAL_PROPERTIES_ATTR)) {
                Iterator attrs = vals.iterator();
                while (attrs.hasNext()) {
                    String compositeVal = (String)attrs.next();
                    int index = compositeVal.indexOf("=");
                    String propName = compositeVal.substring(0, index);
                    String propVal = compositeVal.substring(index + 1);
                    this.addToMap(props, propName, propVal);
                }
                continue;
            }
            String propertyName = (String)LDAPToSchema.get(attrName);
            if (propertyName == null) continue;
            this.addToMap(props, propertyName, vals);
        }
        return props;
    }

    private void addToMap(Map m, String key, String val) {
        HashSet<String> s = (HashSet<String>)m.get(key);
        if (s == null) {
            s = new HashSet<String>(2);
            m.put(key, s);
        }
        s.add(val);
    }

    private void addToMap(Map m, String key, Set vals) {
        Set s = (Set)m.get(key);
        if (s == null) {
            m.put(key, vals);
        } else {
            s.addAll(vals);
        }
    }

    public String getProfileManagerXML() {
        String profileManagerXML = null;
        Set vals = this.getServiceAttribute(PROFILE_MANAGER_XML_ATTR);
        if (vals != null) {
            Iterator iter = vals.iterator();
            profileManagerXML = (String)iter.next();
        }
        return profileManagerXML;
    }

    private Set getServiceAttribute(String attributeName) {
        Set set = this.getServiceAttribute(clientServiceSchema, attributeName);
        return set;
    }

    private Set getServiceAttribute(ServiceSchema schema, String attributeName) {
        Set set = null;
        Map map = schema.getAttributeDefaults();
        if (map != null) {
            set = (Set)map.get(attributeName);
        }
        return set;
    }

    public Set getPropertyNames(String classification) {
        Set names = null;
        if (classification != null) {
            names = this.getServiceAttribute(classification);
        }
        return names;
    }

    public boolean isClientPresent(String clientType) {
        String dn = this.generateClientDN(clientType);
        boolean exists = false;
        try {
            AMEntity amEntity = amConnection.getEntity(dn);
            exists = amEntity.isExists();
        }
        catch (SSOException ssoe) {
            // empty catch block
        }
        return exists;
    }

    private String getClientType(Map props) {
        String clientType = null;
        Set tmpVals = (Set)props.get(CLIENT_TYPE);
        if (tmpVals != null && tmpVals.size() > 0) {
            Iterator itr = tmpVals.iterator();
            clientType = (String)itr.next();
        }
        return clientType;
    }

    private Map getKnownProperties(Map allProps) {
        HashMap<String, Set> newPropsMap = new HashMap<String, Set>();
        HashSet<String> addProps = new HashSet<String>(5);
        Iterator itr = allProps.keySet().iterator();
        while (itr.hasNext()) {
            String propName = (String)itr.next();
            String ldapAttrName = (String)schemaToLDAP.get(propName);
            Set vals = (Set)allProps.get(propName);
            if (ldapAttrName == null) {
                if (vals == null || vals.size() == 0) continue;
                String val = null;
                Iterator innerItr = vals.iterator();
                while (innerItr.hasNext()) {
                    String prop = (String)innerItr.next();
                    val = val == null ? prop : val + COMMA + prop;
                }
                addProps.add(propName + "=" + val);
                continue;
            }
            newPropsMap.put(ldapAttrName, vals);
        }
        if (addProps.size() > 0) {
            Set e = (Set)allProps.get(ADD_PROPS);
            if (e != null) {
                addProps.addAll(e);
            }
            newPropsMap.put(ADDITIONAL_PROPERTIES_ATTR, addProps);
        }
        return newPropsMap;
    }

    public int addClient(SSOToken token, Map props) throws AMClientCapException {
        int status = 0;
        String ct = this.getClientType(props);
        Map m = this.getKnownProperties(props);
        HashMap<String, Map> entityMap = new HashMap<String, Map>(1);
        entityMap.put(ct, m);
        try {
            AMStoreConnection conn = new AMStoreConnection(token);
            AMOrganizationalUnit amOU = conn.getOrganizationalUnit(this.databaseDN);
            amOU.createEntities(UMS_ADD_TEMPLATE_NAME, entityMap);
        }
        catch (Exception e) {
            Object[] errArgs = new String[]{ct};
            AMClientCapException ace = new AMClientCapException(BUNDLE_NAME, ADD_FAILED, errArgs);
            String msg = ace.getMessage();
            debug.error(this.dbStr + msg, (Throwable)e);
            throw ace;
        }
        return status;
    }

    public int modifyClient(SSOToken token, Map props) throws AMClientCapException {
        int status = 0;
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        String ct = this.getClientType(props);
        try {
            AMStoreConnection localConn = new AMStoreConnection(token);
            String dn = this.generateClientDN(ct);
            AMEntity amEntity = localConn.getEntity(dn);
            if (amEntity.isExists()) {
                Map m = this.getKnownProperties(props);
                m.remove(CLIENTTYPE_ATTR);
                amEntity.setAttributes(m);
                amEntity.store();
            } else {
                status = this.addClient(token, props);
            }
        }
        catch (Exception e) {
            Object[] errArgs = new String[]{ct};
            AMClientCapException ace = new AMClientCapException(BUNDLE_NAME, MODIFY_FAILED, errArgs);
            String msg = ace.getMessage();
            debug.error(this.dbStr + msg, (Throwable)e);
            throw ace;
        }
        return status;
    }

    public int removeClient(SSOToken token, String clientType) throws AMClientCapException {
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        try {
            AMStoreConnection localConn = new AMStoreConnection(token);
            String dn = this.generateClientDN(clientType);
            AMEntity amEntity = localConn.getEntity(dn);
            amEntity.delete();
        }
        catch (Exception e) {
            Object[] errArgs = new String[]{clientType};
            AMClientCapException ace = new AMClientCapException(BUNDLE_NAME, DELETE_FAILED, errArgs);
            String msg = ace.getMessage();
            debug.error(this.dbStr + msg, (Throwable)e);
            throw ace;
        }
        return 0;
    }

    public static synchronized Set getSchemaElements() {
        Map map = AMClientCapData.getSchemaMap();
        Set set = map.keySet();
        return set;
    }

    public AttributeSchema getAttributeSchema(String propName) {
        Map map = AMClientCapData.getSchemaMap();
        AttributeSchema attrSchema = (AttributeSchema)map.get(propName);
        return attrSchema;
    }

    private static synchronized Map getSchemaMap() {
        if (schemaMap == null) {
            Set set = clientSchema.getAttributeSchemas();
            schemaMap = new HashMap();
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                AttributeSchema prop = (AttributeSchema)itr.next();
                String name = prop.getName();
                schemaMap.put(name, prop);
            }
        }
        return schemaMap;
    }

    public boolean canCreateInternalClients() {
        boolean allow = false;
        Set vals = this.getServiceAttribute(ENABLE_CLIENT_CREATION_ATTR);
        if (vals != null) {
            Iterator iter = vals.iterator();
            Boolean perms = Boolean.valueOf((String)iter.next());
            allow = perms;
        }
        return allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AMClientDataListener cdl) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(cdl)) {
                this.listeners.add(cdl);
            }
        }
    }

    public void eventError(String err) {
        debug.warning("Handled eventError() Notification: " + err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryChanged(DSEvent event) {
        String dn = event.getID();
        DN dnObject = new DN(dn);
        String[] dnComps = dnObject.explodeDN(true);
        if (debug.messageEnabled()) {
            debug.message("entryChanged() Notification for: " + dn);
        }
        if (dnComps == null || dnComps.length < 2) {
            return;
        }
        String ct = dnComps[0];
        String db = dnComps[1];
        int type = event.getEventType();
        if (db == null || ct == null) {
            return;
        }
        int dbType = -1;
        if (db.equalsIgnoreCase(INTERNAL_DB)) {
            dbType = 1;
        } else if (db.equalsIgnoreCase(EXTERNAL_DB)) {
            dbType = 2;
        } else {
            debug.warning("Unknown db: " + db + " : client = " + ct);
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("Notifying Listeners:: ClientType = " + ct + " : DB = " + dbType + " : OP = " + type);
        }
        List list = this.listeners;
        synchronized (list) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                AMClientDataListener cdl = (AMClientDataListener)this.listeners.get(i);
                try {
                    cdl.clientChanged(ct, dbType, type);
                    continue;
                }
                catch (Throwable t) {
                    debug.warning("Event Notification failed: ", t);
                }
            }
        }
    }

    public void allEntriesChanged() {
    }

    public String[] getClassifications() {
        return dsameAttributeNames;
    }

    public Set getMinimalClientInfo() {
        HashSet<Map> clients = new HashSet<Map>();
        AMSearchControl amsrchCntrl = new AMSearchControl();
        amsrchCntrl.setReturnAttributes(minClient);
        try {
            long st = System.currentTimeMillis();
            AMSearchResults results = this.amClientOrg.searchEntities("*", amsrchCntrl, null, UMS_SRCH_TEMPLATE_NAME);
            long end = System.currentTimeMillis();
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + "getMinimalClientInfo() Srch Time (ms) = " + (end - st));
            }
            st = System.currentTimeMillis();
            Map m = results.getResultAttributes();
            Iterator keys = m.keySet().iterator();
            while (keys.hasNext()) {
                String dn = (String)keys.next();
                Map attrsMap = (Map)m.get(dn);
                Map data = this.parsePropertyNames(attrsMap);
                clients.add(data);
            }
            end = System.currentTimeMillis();
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + "getMinimalClientInfo() Parse Time (ms) = " + (end - st));
            }
        }
        catch (Exception e) {
            debug.error(this.dbStr + " getMinimalClientInfo(): Search Error: ", (Throwable)e);
        }
        return clients;
    }

    public String getBase() {
        return clientDataDN;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 7;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map listener) {
    }
}

