/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Map;
import java.util.Set;

public class SessionConfigListener
implements ServiceListener {
    private static String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String SESSION_RETRIEVAL_TIMEOUT = "iplanet-am-session-session-list-retrieval-timeout";
    private static final String MAX_SESSION_LIST_SIZE = "iplanet-am-session-max-session-list-size";
    private static long defSessionRetrievalTimeout;
    private static int defMaxSessionListSize;
    private static Debug debug;
    private static ServiceSchemaManager sSchemaMgr;
    public static long defSessionRetrievalTimeoutLong;
    public static int defMaxSessionListSizeInt;
    public static String defSessionRetrievalTimeoutStr;
    public static String defMaxSessionListSizeStr;
    private static String enablePropertyNotificationStr;

    public SessionConfigListener(ServiceSchemaManager ssm) {
        sSchemaMgr = ssm;
    }

    public void schemaChanged(String serviceName, String version) {
        if (serviceName != null && !serviceName.equalsIgnoreCase(SESSION_SERVICE_NAME)) {
            return;
        }
        try {
            ServiceSchema schema = sSchemaMgr.getGlobalSchema();
            Map attrs = schema.getAttributeDefaults();
            defSessionRetrievalTimeoutStr = CollectionHelper.getMapAttr((Map)attrs, (String)SESSION_RETRIEVAL_TIMEOUT, (String)defSessionRetrievalTimeoutStr);
            defMaxSessionListSizeStr = CollectionHelper.getMapAttr((Map)attrs, (String)MAX_SESSION_LIST_SIZE, (String)defMaxSessionListSizeStr);
            enablePropertyNotificationStr = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-property-change-notification", (String)"OFF");
            if (enablePropertyNotificationStr.equalsIgnoreCase("ON")) {
                SessionService.setPropertyNotificationEnabled(true);
                Set notProp = (Set)attrs.get("iplanet-am-session-notification-property-list");
                SessionService.setNotificationProperties(notProp);
            } else {
                SessionService.setPropertyNotificationEnabled(false);
            }
        }
        catch (Exception e) {
            debug.error("SessionConfigListener : Unable to get Timeout & ListSize values", (Throwable)e);
        }
        try {
            defSessionRetrievalTimeout = Long.parseLong(defSessionRetrievalTimeoutStr) * 1000L;
        }
        catch (Exception e) {
            defSessionRetrievalTimeout = defSessionRetrievalTimeoutLong * 1000L;
            debug.error("SessionConfigListener : Unable to parse Timeout values", (Throwable)e);
        }
        try {
            defMaxSessionListSize = Integer.parseInt(defMaxSessionListSizeStr);
        }
        catch (Exception e) {
            defMaxSessionListSize = defMaxSessionListSizeInt;
            debug.error("SessionConfigListener : Unable to parse ListSize values", (Throwable)e);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public static long getTimeout() {
        return defSessionRetrievalTimeout;
    }

    public static int getMaxsize() {
        return defMaxSessionListSize;
    }

    static {
        debug = Debug.getInstance((String)"amSession");
        sSchemaMgr = null;
        defSessionRetrievalTimeoutLong = 5L;
        defMaxSessionListSizeInt = 200;
        defSessionRetrievalTimeoutStr = Long.toString(defSessionRetrievalTimeoutLong);
        defMaxSessionListSizeStr = Integer.toString(defMaxSessionListSizeInt);
        enablePropertyNotificationStr = "OFF";
    }
}

