/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class AMGenerateServerID {
    private static char[] alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    static String delimiter = "|";
    static Debug debug = Debug.getInstance((String)"amMultiInstall");

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println(" Usage: AMGenerateServerID create|delete <serverurl> amadminDN amadminPassword");
            System.exit(1);
        }
        String opt = args[0];
        String serverUrl = args[1];
        try {
            String bindDN = args[2];
            String password = args[3];
            SSOTokenManager ssom = SSOTokenManager.getInstance();
            SSOToken token = ssom.createSSOToken(new AuthPrincipal(bindDN), password);
            Set servers = ServerConfiguration.getServerInfo(token);
            Iterator iter = servers.iterator();
            while (iter.hasNext()) {
                String server = (String)iter.next();
                if (!server.startsWith(serverUrl)) continue;
                debug.message("server already exists., exiting");
                System.exit(0);
            }
            if (opt.equalsIgnoreCase("create")) {
                if (debug.messageEnabled()) {
                    debug.message("New server entry:" + serverUrl);
                }
                ServerConfiguration.createServerInstance(token, serverUrl, Collections.EMPTY_SET, "");
            } else if (opt.equalsIgnoreCase("delete")) {
                if (ServerConfiguration.deleteServerInstance(token, serverUrl)) {
                    debug.message("Server entry to be removed:" + serverUrl);
                } else {
                    debug.message("Can not find server in server's list:" + serverUrl);
                    System.exit(1);
                }
            } else {
                debug.message("Unknown option in AMGenerateServerID");
                System.exit(1);
            }
        }
        catch (Exception e) {
            debug.error("Exception occured:", (Throwable)e);
        }
    }

    public static String returnId(Set servers, String server) {
        String serverId = null;
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            int index;
            String serverEntry = (String)iter.next();
            if (!serverEntry.startsWith(server) || (index = serverEntry.indexOf(delimiter)) == -1) continue;
            serverId = serverEntry.substring(index + 1, serverEntry.length());
            return serverId;
        }
        return serverId;
    }

    public static String getTwoByteString(Set skip) {
        for (int i = 0; i < alphabet.length; ++i) {
            char[] out = new char[2];
            out[0] = alphabet[i];
            for (int j = 1; j < alphabet.length; ++j) {
                out[1] = alphabet[j];
                String temp = new String(out);
                if (skip != null && skip.contains(temp)) continue;
                return temp;
            }
        }
        return "xx";
    }
}

