/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.SearchFilterManager;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Map;

class ObjectClassManager {
    static Debug debug = CommonUtils.getDebugInstance();
    private static final String DEFAULT_USER_OBJECT_CLASS = "inetorgperson";
    private static final String DEFAULT_RESOURCE_OBJECT_CLASS = "inetcalresource";
    private static final String DEFAULT_ROLE_OBJECT_CLASS = "nsmanagedroledefinition";
    private static final String DEFAULT_FILTERED_ROLE_OBJECT_CLASS = "nsfilteredroledefinition";
    private static final String DEFAULT_ORGANIZATION_OBJECT_CLASS = "organization";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS = "organizationalunit";
    private static final String DEFAULT_GROUP_OBJECT_CLASS = "iplanet-am-managed-group";
    private static final String DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS = "groupofurls";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS = "iplanet-am-managed-assignable-group";
    private static final String DEFAULT_GROUP_CONTAINER_OBJECT_CLASS = "iplanet-am-managed-group-container";
    private static final String DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS = "nsManagedPeopleContainer";
    public static Map objectClassMap = new HashMap();
    public static Map objectTypeMap = new HashMap();

    ObjectClassManager() {
    }

    public static String getObjectClass(int objectType) {
        String type = Integer.toString(objectType);
        String oc = (String)objectClassMap.get(type);
        if (oc == null && (oc = ObjectClassManager.getObjectClassFromDS(objectType)).length() != 0) {
            objectClassMap.put(type, oc);
        }
        return oc;
    }

    private static String getObjectClassFromDS(int objectType) {
        String searchFilter = SearchFilterManager.getGlobalSearchFilter(objectType);
        String pattern = "objectclass=";
        int index = searchFilter.indexOf(pattern);
        String objectClass = null;
        if (index != -1) {
            int startIndex = index + pattern.length();
            int endIndex = searchFilter.indexOf(41, startIndex);
            if (endIndex != -1) {
                objectClass = searchFilter.substring(startIndex, endIndex);
            }
        } else {
            objectClass = ObjectClassManager.getDefaultObjectClass(objectType);
        }
        if (debug.messageEnabled()) {
            debug.message("ObjectClassManager.getObjectClassFromDS()- objectType: " + objectType + " objectclass: " + objectClass.toLowerCase());
        }
        return objectClass.toLowerCase();
    }

    public static int getObjectType(String objectClass) {
        String typeS = (String)objectTypeMap.get(objectClass.toLowerCase());
        if (typeS != null) {
            return Integer.parseInt(typeS);
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(1))) {
            return 1;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(6))) {
            return 6;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(8))) {
            return 8;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(2))) {
            return 2;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(9))) {
            return 9;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(12))) {
            return 12;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(11))) {
            return 11;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(5))) {
            return 5;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(4))) {
            return 4;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(3))) {
            return 3;
        }
        if (objectClass.equalsIgnoreCase(ObjectClassManager.getObjectClass(21))) {
            return 21;
        }
        return -1;
    }

    private static String getDefaultObjectClass(int objectType) {
        switch (objectType) {
            case 1: {
                return DEFAULT_USER_OBJECT_CLASS;
            }
            case 6: {
                return DEFAULT_ROLE_OBJECT_CLASS;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_OBJECT_CLASS;
            }
            case 9: {
                return DEFAULT_GROUP_OBJECT_CLASS;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_OBJECT_CLASS;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_OBJECT_CLASS;
            }
            case 21: {
                return DEFAULT_RESOURCE_OBJECT_CLASS;
            }
        }
        return "";
    }
}

