/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Map;

class NamingAttributeManager {
    private static final String DEFAULT_USER_NAMING_ATTR = "uid";
    private static final String DEFAULT_RESOURCE_NAMING_ATTR = "uid";
    private static final String DEFAULT_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_ORG_NAMING_ATTR = "o";
    private static final String DEFAULT_ORG_UNIT_NAMING_ATTR = "ou";
    private static final String DEFAULT_PEOPLE_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_GROUP_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_FILTERED_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String USER_CREATION_TEMPLATE = "BasicUser";
    private static final String GROUP_CREATION_TEMPLATE = "BasicGroup";
    private static final String MANAGED_ROLE_CREATION_TEMPLATE = "BasicManagedRole";
    private static final String RESOURCE_CREATION_TEMPLATE = "BasicResource";
    private static final String FILTERED_ROLE_CREATION_TEMPLATE = "BasicFilteredRole";
    private static final String ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicAssignableDynamicGroup";
    private static final String DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicDynamicGroup";
    private static final String ORGANIZATION_CREATION_TEMPLATE = "BasicOrganization";
    private static final String PEOPLE_CONTAINTER_CREATION_TEMPLATE = "BasicPeopleContainer";
    private static final String ORGANIZATIONAL_UNIT_CREATION_TEMPLATE = "BasicOrganizationalUnit";
    private static final String GROUP_CONTAINER_CREATION_TEMPLATE = "BasicGroupContainer";
    private static TemplateManager templateMgr = null;
    private static Debug debug = CommonUtils.getDebugInstance();
    private static Map namingAttrMap = new HashMap();

    NamingAttributeManager() {
    }

    static String getNamingAttribute(int objectType) {
        return NamingAttributeManager.getNamingAttribute(objectType, null);
    }

    static String getNamingAttribute(int objectType, String orgDN) {
        String key = new Integer(objectType).toString() + ":" + MiscUtils.formatToRFC(orgDN);
        String namingAttribute = (String)namingAttrMap.get(key);
        if (namingAttribute == null && (namingAttribute = NamingAttributeManager.getNamingAttributeFromTemplate(objectType, orgDN)) != null) {
            namingAttrMap.put(key, namingAttribute);
        }
        return namingAttribute;
    }

    private static String getNamingAttributeFromTemplate(int objectType, String orgDN) {
        try {
            String templateName;
            if (templateMgr == null) {
                templateMgr = TemplateManager.getTemplateManager();
            }
            if ((templateName = NamingAttributeManager.getCreationTemplateName(objectType)) == null) {
                debug.warning("AMNamingAttrMgr.getNamingAttr(objectType, orgDN): (" + objectType + "," + orgDN + ") Could not determine creation template name. " + "Returning <empty> value");
                return "";
            }
            Guid orgGuid = orgDN == null ? null : new Guid(orgDN);
            CreationTemplate creationTemp = templateMgr.getCreationTemplate(templateName, orgGuid, 1);
            String namingAttr = creationTemp.getNamingAttribute();
            if (namingAttr == null) {
                debug.error("AMNamingAttrManager.getNamingAttr() Naming attribute for Object Type:" + objectType + " Org DN: " + orgDN + " is null");
            } else if (debug.messageEnabled()) {
                debug.message("AMNamingAttrManager.getNamingAttr(): Naming attribute for Object type= " + objectType + ": " + namingAttr);
            }
            return namingAttr;
        }
        catch (UMSException ue) {
            String defaultAttr = NamingAttributeManager.getDefaultNamingAttr(objectType);
            debug.warning("Unable to get the naming attribute for " + objectType + " Using default " + defaultAttr);
            return defaultAttr;
        }
    }

    private static String getDefaultNamingAttr(int objectType) {
        switch (objectType) {
            case 1: {
                return "uid";
            }
            case 6: {
                return "cn";
            }
            case 8: {
                return "cn";
            }
            case 9: {
                return "cn";
            }
            case 12: {
                return "cn";
            }
            case 11: {
                return "cn";
            }
            case 2: {
                return DEFAULT_ORG_NAMING_ATTR;
            }
            case 5: {
                return "ou";
            }
            case 3: {
                return "ou";
            }
            case 4: {
                return "ou";
            }
            case 21: {
                return "uid";
            }
        }
        debug.warning("AMNamingAttrMgr.getDefaultNamingAttr(): Unknown object type is passed. Returning <empty> value");
        return "";
    }

    static String getCreationTemplateName(int objectType) {
        String templateName = (String)CommonUtils.creationtemplateMap.get(Integer.toString(objectType));
        if (templateName != null) {
            return templateName;
        }
        switch (objectType) {
            case 1: {
                return USER_CREATION_TEMPLATE;
            }
            case 6: {
                return MANAGED_ROLE_CREATION_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_CREATION_TEMPLATE;
            }
            case 9: {
                return GROUP_CREATION_TEMPLATE;
            }
            case 12: {
                return ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_CREATION_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINTER_CREATION_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_CREATION_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_CREATION_TEMPLATE;
            }
            case 21: {
                return RESOURCE_CREATION_TEMPLATE;
            }
        }
        debug.warning("AMNamingAttrMgr.getCreationTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }
}

