/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPreCallBackException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserEntryProcessed;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.ldap.CallBackHelper;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.ComplianceServicesImpl;
import com.iplanet.am.sdk.ldap.DCTreeServicesImpl;
import com.iplanet.am.sdk.ldap.EmailNotificationHelper;
import com.iplanet.am.sdk.ldap.EventManager;
import com.iplanet.am.sdk.ldap.NamingAttributeManager;
import com.iplanet.am.sdk.ldap.ObjectClassManager;
import com.iplanet.am.sdk.ldap.SearchFilterManager;
import com.iplanet.am.sdk.ldap.UserPasswordValidationHelper;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.FilteredRole;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.OrganizationalUnit;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.SchemaManager;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class DirectoryServicesImpl
implements AMConstants,
IDirectoryServices {
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static HashSet retryErrorCodes = new HashSet();
    protected static final String EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR = "iplanet-am-admin-console-external-attribute-fetch-enabled";
    protected static String NSROLEDN_ATTR = "nsroledn";
    protected static String NSROLE_ATTR = "nsrole";
    public static Debug debug = CommonUtils.debug;
    public static boolean isUserPluginInitialized = false;
    private static AMUserEntryProcessed userEntry = null;
    private String[] aName = new String[]{"objectclass"};
    private SearchControl scontrol = new SearchControl();
    private static IDirectoryServices instance;
    private static EventManager eventManager;
    private static Map listeners;
    protected DCTreeServicesImpl dcTreeImpl;
    protected ComplianceServicesImpl complianceImpl;
    protected CallBackHelper callBackHelper;
    protected SSOToken internalToken = CommonUtils.getInternalToken();

    public DirectoryServicesImpl() {
        this.scontrol.setSearchScope(0);
        this.dcTreeImpl = new DCTreeServicesImpl();
        this.complianceImpl = new ComplianceServicesImpl();
        this.callBackHelper = new CallBackHelper();
    }

    protected static synchronized IDirectoryServices getInstance() {
        if (instance == null) {
            debug.message("DirectoryServicesImpl.getInstance(): Creating a new Instance of DirectoryServicesImpl()");
            instance = new DirectoryServicesImpl();
        }
        return instance;
    }

    protected String getEntryName(UMSException e) {
        DN dn = this.getExceptionDN(e);
        String entryName = "";
        if (dn != null) {
            entryName = ((RDN)dn.getRDNs().firstElement()).getValues()[0];
        }
        return entryName;
    }

    private DN getExceptionDN(UMSException e) {
        String errorDN;
        int index;
        DN dn = null;
        String msg = e.getMessage();
        if (msg != null && (index = msg.indexOf("::")) != -1 && DN.isDN((String)(errorDN = msg.substring(0, index)))) {
            dn = new DN(errorDN);
        }
        return dn;
    }

    private String getEntryNotFoundMsgID(int objectType) {
        switch (objectType) {
            case 6: 
            case 7: 
            case 8: {
                return "465";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "466";
            }
            case 2: {
                return "467";
            }
            case 1: {
                return "468";
            }
            case 3: {
                return "469";
            }
            case 5: {
                return "470";
            }
            case 4: {
                return "471";
            }
        }
        return "461";
    }

    private String getEntryExistsMsgID(int objectType) {
        switch (objectType) {
            case 6: 
            case 7: 
            case 8: {
                return "472";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "473";
            }
            case 2: {
                return "474";
            }
            case 1: {
                return "475";
            }
            case 3: {
                return "476";
            }
            case 5: {
                return "477";
            }
            case 4: {
                return "483";
            }
        }
        return "462";
    }

    private void processInternalException(SSOToken token, UMSException ue, String defaultErrorCode) throws AMException {
        try {
            LDAPException lex = (LDAPException)ue.getRootCause();
            if (lex != null) {
                int errorCode = lex.getLDAPResultCode();
                switch (errorCode) {
                    case 19: {
                        throw new AMException(token, "19", ue);
                    }
                    case 3: {
                        throw new AMException(token, "3", ue);
                    }
                    case 4: {
                        throw new AMException(token, "4", ue);
                    }
                    case 67: {
                        throw new AMException(token, "967", ue);
                    }
                    case 11: {
                        throw new AMException(token, "968", ue);
                    }
                }
                throw new AMException(token, defaultErrorCode, ue);
            }
            throw new AMException(token, defaultErrorCode, ue);
        }
        catch (Throwable ex) {
            if (ex instanceof AMException) {
                throw (AMException)ex;
            }
            if (debug.messageEnabled()) {
                debug.message("Unknown exception in process internal exception", ex);
            }
            throw new AMException(token, defaultErrorCode);
        }
    }

    protected static boolean isExternalGetAttributesEnabled(String orgDN) {
        Set attrVal;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfig sc = AMServiceUtils.getOrgConfig(token, orgDN, "iPlanetAMAdminConsoleService");
            if (sc != null) {
                Map attributes = sc.getAttributes();
                attrVal = (Set)attributes.get(EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            } else {
                attrVal = DirectoryServicesImpl.getDefaultGlobalConfig(token, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            }
        }
        catch (Exception ee) {
            attrVal = DirectoryServicesImpl.getDefaultGlobalConfig(token, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
        }
        boolean enabled = false;
        if (attrVal != null && !attrVal.isEmpty()) {
            String val = (String)attrVal.iterator().next();
            enabled = val.equalsIgnoreCase("true");
        }
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.isExternalGetAttributeEnabled() = " + enabled);
        }
        return enabled;
    }

    private static Set getDefaultGlobalConfig(SSOToken token, String attrName) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getDefaultGlobalConfig() Organization config for service (iPlanetAMAdminConsoleService," + attrName + ") not found. Obtaining default service " + "config values ..");
            }
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (defaultValues != null) {
                    return (Set)defaultValues.get(attrName);
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMCommonUtils.getDefaultGlobalConfig(): Unable to get default global config information", (Throwable)e);
            }
        }
        return null;
    }

    public static AMUserEntryProcessed getUserPostPlugin() {
        if (!isUserPluginInitialized) {
            String implClassName = SystemProperties.get("com.iplanet.am.sdk.userEntryProcessingImpl");
            if (implClassName != null && implClassName.length() != 0) {
                try {
                    userEntry = (AMUserEntryProcessed)Class.forName(implClassName).newInstance();
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryServicesImpl.getUserPostPlugin: Class " + implClassName + " instantiated.");
                    }
                }
                catch (ClassNotFoundException c) {
                    debug.error("DirectoryServicesImpl.getUserPostPlugin(): Class not found: " + implClassName, (Throwable)c);
                }
                catch (InstantiationException ie) {
                    debug.error("DirectoryServicesImpl.getUserPostPlugin(): Unable to instantiate: " + implClassName, (Throwable)ie);
                }
                catch (IllegalAccessException le) {
                    debug.error("DirectoryServicesImpl.getUserPostPlugin(): IllegalAccessException: " + implClassName, (Throwable)le);
                }
            }
            isUserPluginInitialized = true;
        }
        return userEntry;
    }

    public IDCTreeServices getDCTreeServicesImpl() {
        return this.dcTreeImpl;
    }

    public IComplianceServices getComplianceServicesImpl() {
        return this.complianceImpl;
    }

    public boolean doesEntryExists(SSOToken token, String entryDN) {
        try {
            PersistentObject po = UMSObject.getObject(this.internalToken, new Guid(entryDN));
        }
        catch (UMSException ue) {
            if (entryDN.indexOf("agents") < 0 && debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.doesProfileExist(): + Exception caught: ", (Throwable)ue);
            }
            return false;
        }
        return true;
    }

    public int getObjectType(SSOToken token, String dn) throws AMException, SSOException {
        return this.getObjectType(token, dn, null);
    }

    public int getObjectType(SSOToken token, String dn, Map cachedAttributes) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.getObjectType() Getting object type for: " + dn);
        }
        if (!DN.isDN((String)dn)) {
            throw new AMInvalidDNException(AMSDKBundle.getString("157"), "157");
        }
        SSOTokenManager.getInstance().validateToken(token);
        Set objectClasses = null;
        if (cachedAttributes == null || (objectClasses = (Set)cachedAttributes.get("objectclass")) == null) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.getObjectType() Making  LDAP call to get objectclass attributes for DN: " + dn);
            }
            HashSet<String> attrNames = new HashSet<String>(1);
            attrNames.add("objectclass");
            Map attributes = this.getAttributes(token, dn, attrNames, -9999);
            if (attributes.size() == 1) {
                objectClasses = (Set)attributes.get("objectclass");
            }
        }
        if (objectClasses != null) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.getObjectType()- DN: " + dn + " cachedAttributes: " + objectClasses);
            }
            Iterator itr = objectClasses.iterator();
            int possibleOT = -1;
            while (itr.hasNext()) {
                String tStr = (String)itr.next();
                int objectType = this.getObjectType(tStr);
                if (objectType == 6) {
                    possibleOT = objectType;
                    continue;
                }
                if (objectType == -1) continue;
                if (debug.messageEnabled()) {
                    debug.message("DirectoryServicesImpl.getObjectType(token, entryDN, cachedAttributes)- DN: " + dn + " objectType: " + objectType);
                }
                return objectType;
            }
            if (possibleOT != -1) {
                if (debug.messageEnabled()) {
                    debug.message("DirectoryServicesImpl.getObjectType(token, entryDN, cachedAttributes)- DN: " + dn + " objectType: " + possibleOT);
                }
                return possibleOT;
            }
            throw new AMException(AMSDKBundle.getString("156"), "156");
        }
        throw new AMException(AMSDKBundle.getString("151"), "151");
    }

    public Map getDCTreeAttributes(SSOToken token, String entryDN, Set attrNames, boolean byteValues, int objectType) throws AMException, SSOException {
        String dcNode;
        String rootDN = AMStoreConnection.getAMSdkBaseDN();
        if (this.dcTreeImpl.isRequired() && objectType == 2 && !CommonUtils.formatToRFC(entryDN).equalsIgnoreCase(rootDN) && (dcNode = this.dcTreeImpl.getCanonicalDomain(this.internalToken, entryDN)) != null) {
            String[] names = attrNames == null ? null : attrNames.toArray(new String[attrNames.size()]);
            AttrSet dcAttrSet = this.dcTreeImpl.getDomainAttributes(this.internalToken, entryDN, names);
            return CommonUtils.attrSetToMap(dcAttrSet, byteValues);
        }
        return null;
    }

    private void checkComplianceAttributes(AttrSet attrSet, boolean ignoreCompliance) throws AMException {
        if (!ignoreCompliance && ComplianceServicesImpl.isComplianceUserDeletionEnabled()) {
            this.complianceImpl.verifyAttributes(attrSet);
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        boolean ignoreCompliance = true;
        boolean byteValues = false;
        return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        boolean ignoreCompliance = true;
        boolean byteValues = false;
        return this.getAttributes(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesFromDS(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        boolean ignoreCompliance = true;
        boolean byteValues = false;
        return this.getAttributesFromDS(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, int profileType) throws AMException, SSOException {
        boolean byteValues = true;
        boolean ignoreCompliance = true;
        return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesByteValues(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException, SSOException {
        boolean byteValues = true;
        boolean ignoreCompliance = true;
        return this.getAttributes(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributes(SSOToken token, String entryDN, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        try {
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            AttrSet attrSet = po.getAttributes(po.getAttributeNames());
            attrSet.add(new Attr("dn", entryDN));
            this.checkComplianceAttributes(attrSet, ignoreCompliance);
            AMHashMap attributes = (AMHashMap)CommonUtils.attrSetToMap(attrSet, byteValues);
            Map dcAttributes = this.getDCTreeAttributes(token, entryDN, null, byteValues, profileType);
            attributes.copy(dcAttributes);
            return attributes;
        }
        catch (IllegalArgumentException ie) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.getAttributes(): Unable to get attributes: ", (Throwable)ie);
            }
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("330", locale), "330");
        }
        catch (UMSException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.getAttributes(): Unable to get attributes: ", (Throwable)e);
            }
            throw new AMException(token, "330", e);
        }
    }

    public Map getAttributes(SSOToken token, String entryDN, Set attrNames, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        return this.getAttributesFromDS(token, entryDN, attrNames, ignoreCompliance, byteValues, profileType);
    }

    public Map getAttributesFromDS(SSOToken token, String entryDN, Set attrNames, boolean ignoreCompliance, boolean byteValues, int profileType) throws AMException, SSOException {
        if (attrNames == null) {
            return this.getAttributes(token, entryDN, ignoreCompliance, byteValues, profileType);
        }
        try {
            String[] names = attrNames.toArray(new String[attrNames.size()]);
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            AttrSet attrSet = !ignoreCompliance && ComplianceServicesImpl.isComplianceUserDeletionEnabled() ? this.complianceImpl.verifyAndGetAttributes(po, names) : po.getAttributes(names);
            AMHashMap attributes = (AMHashMap)CommonUtils.attrSetToMap(attrSet, byteValues);
            Map dcAttributes = this.getDCTreeAttributes(token, entryDN, attrNames, byteValues, profileType);
            attributes.copy(dcAttributes);
            return attributes;
        }
        catch (UMSException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.getAttributes(): Unable to get attributes: ", (Throwable)e);
            }
            throw new AMException(token, "330", e);
        }
    }

    public String getOrgSearchFilter(String entryDN) {
        String orgSearchFilter = SearchFilterManager.getSearchFilter(2, entryDN, null, true);
        String orgUnitSearchFilter = SearchFilterManager.getSearchFilter(3, entryDN, null, true);
        StringBuffer sb = new StringBuffer();
        sb.append("(|").append(orgSearchFilter).append(orgUnitSearchFilter);
        sb.append(")");
        return sb.toString();
    }

    public String getOrganizationDN(SSOToken token, String entryDN) throws AMException {
        if (entryDN.length() == 0 || !DN.isDN((String)entryDN)) {
            debug.error("DirectoryServicesImpl.getOrganizationDN() Invalid DN: " + entryDN);
            throw new AMException(token, "157");
        }
        DN dnObject = new DN(entryDN);
        String organizationDN = null;
        while (organizationDN == null || organizationDN.length() == 0) {
            String childDN = dnObject.toString();
            organizationDN = this.verifyAndGetOrgDN(token, entryDN, childDN);
            dnObject = dnObject.getParent();
        }
        return organizationDN;
    }

    public Map getExternalAttributes(SSOToken token, String entryDN, Set attrNames, int profileType) throws AMException {
        SSOToken internalToken = CommonUtils.getInternalToken();
        String eDN = profileType == 1 ? new DN(entryDN).getParent().toString() : entryDN;
        String orgDN = this.getOrganizationDN(internalToken, eDN);
        return this.callBackHelper.getAttributes(token, entryDN, attrNames, orgDN);
    }

    public void updateUserAttribute(SSOToken token, Set members, String staticGroupDN, boolean toAdd) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.updateUserAttribute(): groupDN:" + staticGroupDN + ", toAdd: " + toAdd + " members: " + members);
        }
        Attr attr = new Attr("iplanet-am-static-group-dn", staticGroupDN);
        Iterator itr = members.iterator();
        while (itr.hasNext()) {
            String userDN = (String)itr.next();
            try {
                PersistentObject po = UMSObject.getObjectHandle(token, new Guid(userDN));
                if (toAdd) {
                    po.modify(attr, 0);
                } else {
                    po.modify(attr, 1);
                }
                po.save();
            }
            catch (UMSException e) {
                debug.error("DirectoryServicesImpl.updateUserAttribute(): Failed while trying to set the static groupDN " + staticGroupDN + " for user: " + userDN, (Throwable)e);
                throw new AMException(token, "351", e);
            }
        }
    }

    private void makeNamingFirst(AttrSet attrSet, String namingAttr, String namingValue) {
        int index = attrSet.indexOf(namingAttr);
        if (index == -1) {
            attrSet.add(new Attr(namingAttr, namingValue));
        } else {
            Attr attr = attrSet.elementAt(index);
            attr.removeValue(namingValue);
            String[] values = attr.getStringValues();
            attr = new Attr(namingAttr, namingValue);
            attr.addValues(values);
            attrSet.replace(attr);
        }
    }

    private AttrSet combineOCs(CreationTemplate ct, AttrSet aSet) {
        Attr attr = aSet.getAttribute("objectclass");
        Attr defAttr = ct.getAttribute("objectclass");
        Set addOCs = attr != null ? CommonUtils.stringArrayToSet(attr.getStringValues()) : new HashSet();
        Set ctOCs = CommonUtils.stringArrayToSet(defAttr.getStringValues());
        Set finalOCs = CommonUtils.combineOCs(addOCs, ctOCs);
        aSet.remove("objectclass");
        Attr finalOCAttr = new Attr("objectclass", finalOCs.toArray(new String[finalOCs.size()]));
        aSet.add(finalOCAttr);
        return aSet;
    }

    private void createUser(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMEntryExistsException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(1) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 1, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(1), profileName);
        UserPasswordValidationHelper pluginImpl = new UserPasswordValidationHelper(token, orgDN);
        try {
            pluginImpl.validate(CommonUtils.attrSetToMap(attrSet));
        }
        catch (AMException ame) {
            debug.error("DirectoryServicesImpl.createUser(): Invalid characters for user", (Throwable)ame);
            throw ame;
        }
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicUser", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        PersistentObject user = new PersistentObject(creationTemp, attrSet);
        try {
            parentObj.addChild(user);
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createUser(): Insufficient Access rights to create user", (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (EntryAlreadyExistsException ee) {
            if (ComplianceServicesImpl.isComplianceUserDeletionEnabled()) {
                this.complianceImpl.checkIfDeletedUser(token, user.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createUser() User already exists: ", (Throwable)ee);
            }
            throw new AMEntryExistsException(token, "328", (UMSException)ee);
        }
        catch (UMSException ue) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createUser(): Internal Error occurred. Unable to create User Entry", (Throwable)ue);
            }
            this.processInternalException(token, ue, "324");
        }
        this.callBackHelper.postProcess(token, user.getDN(), orgDN, null, attributes, 1, 1, false);
        AMUserEntryProcessed postPlugin = DirectoryServicesImpl.getUserPostPlugin();
        if (postPlugin != null) {
            Map attrMap = CommonUtils.attrSetToMap(attrSet);
            postPlugin.processUserAdd(token, user.getDN(), attrMap);
        }
        EmailNotificationHelper mailerObj = new EmailNotificationHelper(user.getDN());
        mailerObj.setUserCreateNotificationList();
        mailerObj.sendUserCreateNotification(attributes);
    }

    private void createEntity(SSOToken token, PersistentObject parentObj, int objectType, Map attributes, String profileName) throws UMSException, AMEntryExistsException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(objectType), profileName);
        String ctName = this.getCreationTemplateName(objectType);
        if (ctName == null) {
            ctName = "BasicUser";
        }
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate(ctName, new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        PersistentObject user = new PersistentObject(creationTemp, attrSet);
        try {
            parentObj.addChild(user);
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntity(): Insufficient Access rights to create entity", (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (EntryAlreadyExistsException ee) {
            if (ComplianceServicesImpl.isComplianceUserDeletionEnabled()) {
                this.complianceImpl.checkIfDeletedUser(token, user.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntity() Entity already exists: ", (Throwable)ee);
            }
            throw new AMEntryExistsException(token, "462", (UMSException)ee);
        }
        catch (UMSException ue) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntity(): Internal Error occurred. Unable to create User Entry", (Throwable)ue);
            }
            this.processInternalException(token, ue, "324");
        }
    }

    private void createResource(PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(21), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicResource", new Guid(orgDN), 1);
        Resource resource = new Resource(creationTemp, attrSet);
        parentObj.addChild(resource);
    }

    private void createRole(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(6) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 6, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(6), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicManagedRole", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        ManagedRole role = new ManagedRole(creationTemp, attrSet);
        parentObj.addChild(role);
        this.callBackHelper.postProcess(token, role.getDN(), orgDN, null, attributes, 1, 6, false);
    }

    private void createOrganization(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException, SSOException {
        Organization org;
        String orgDN;
        block17: {
            String entryDN;
            block16: {
                orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
                entryDN = this.getNamingAttribute(2) + "=" + profileName + "," + parentObj.getDN();
                attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 2, false);
                AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
                this.makeNamingFirst(attrSet, this.getNamingAttribute(2), profileName);
                TemplateManager tempMgr = TemplateManager.getTemplateManager();
                org = null;
                CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicOrganization", new Guid(orgDN), 1);
                attrSet = this.combineOCs(creationTemp, attrSet);
                if (this.dcTreeImpl.isRequired()) {
                    AttrSet[] attrSetArray = this.dcTreeImpl.splitAttrSet(parentObj.getDN(), attrSet);
                    org = new Organization(creationTemp, attrSetArray[0]);
                    this.dcTreeImpl.createDomain(token, new Guid(entryDN), attrSet);
                } else {
                    org = new Organization(creationTemp, attrSet);
                }
                try {
                    parentObj.addChild(org);
                }
                catch (UMSException ue) {
                    if (this.dcTreeImpl.isRequired()) {
                        this.dcTreeImpl.removeDomain(token, entryDN);
                    }
                    if (ComplianceServicesImpl.isComplianceUserDeletionEnabled()) {
                        this.complianceImpl.checkIfDeletedOrg(token, org.getDN());
                    }
                    throw ue;
                }
                if (ComplianceServicesImpl.isAdminGroupsEnabled(org.getDN())) {
                    this.complianceImpl.createAdminGroups(token, org);
                }
                if (ServiceManager.isCoexistenceMode() && ServiceManager.isRealmEnabled()) {
                    try {
                        new OrganizationConfigManager(token, entryDN);
                    }
                    catch (SMSException smse) {
                        if (debug.messageEnabled()) {
                            debug.message("DirectoryServicesImpl::createOrganization creating realm: " + org.getDN());
                        }
                        try {
                            OrganizationConfigManager ocm = new OrganizationConfigManager(token, orgDN);
                            ocm.createSubOrganization(profileName, null);
                        }
                        catch (SMSException se) {
                            if (!debug.messageEnabled()) break block16;
                            debug.message("DirectoryServicesImpl::createOrganization unable to create realm: " + org.getDN(), (Throwable)se);
                        }
                    }
                }
            }
            if (ServiceManager.isCoexistenceMode()) {
                try {
                    OrganizationConfigManager ocm = new OrganizationConfigManager(token, entryDN);
                    OrganizationConfigManager.loadDefaultServices(token, ocm);
                }
                catch (SMSException smse) {
                    if (!debug.warningEnabled()) break block17;
                    debug.warning("DirectoryServicesImpl::createOrganization Unable to load services: " + org.getDN());
                }
            }
        }
        this.callBackHelper.postProcess(token, org.getDN(), orgDN, null, attributes, 1, 2, false);
    }

    private void createGroup(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(9) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 9, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(9), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicGroup", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        StaticGroup sgroup = new StaticGroup(creationTemp, attrSet);
        parentObj.addChild(sgroup);
        Attr um = attrSet.getAttribute("uniquemember");
        if (um != null) {
            String[] values = um.getStringValues();
            HashSet<String> members = new HashSet<String>();
            for (int i = 0; i < values.length; ++i) {
                members.add(values[i]);
            }
            this.updateUserAttribute(token, members, sgroup.getDN(), true);
        }
        this.callBackHelper.postProcess(token, sgroup.getDN(), orgDN, null, attributes, 1, 9, false);
    }

    private void createAssignDynamicGroup(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(9) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 12, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(12), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicAssignableDynamicGroup", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        AssignableDynamicGroup adgroup = new AssignableDynamicGroup(creationTemp, attrSet);
        adgroup.setSearchFilter("(memberof=" + entryDN + ")");
        adgroup.setSearchScope(2);
        adgroup.setSearchBase(new Guid(orgDN));
        parentObj.addChild(adgroup);
        this.callBackHelper.postProcess(token, adgroup.getDN(), orgDN, null, attributes, 1, 12, false);
    }

    private void createDynamicGroup(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(9) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 11, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(11), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicDynamicGroup", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        DynamicGroup dgroup = new DynamicGroup(creationTemp, attrSet);
        String filter = dgroup.getSearchFilter();
        if (LDAPUrl.defaultFilter.equalsIgnoreCase(filter)) {
            dgroup.setSearchFilter(SearchFilterManager.getSearchFilter(1, orgDN));
        }
        dgroup.setSearchScope(2);
        dgroup.setSearchBase(new Guid(orgDN));
        parentObj.addChild(dgroup);
        this.callBackHelper.postProcess(token, dgroup.getDN(), orgDN, null, attributes, 1, 11, false);
    }

    private void createPeopleContainer(PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(5), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicPeopleContainer", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        PeopleContainer pc = new PeopleContainer(creationTemp, attrSet);
        parentObj.addChild(pc);
    }

    private void createOrganizationalUnit(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(3) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 3, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(3), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicOrganizationalUnit", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        OrganizationalUnit ou = new OrganizationalUnit(creationTemp, attrSet);
        parentObj.addChild(ou);
        this.callBackHelper.postProcess(token, ou.getDN(), orgDN, null, attributes, 1, 3, false);
    }

    private void createGroupContainer(PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(4), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicGroupContainer", new Guid(orgDN), 1);
        OrganizationalUnit gc = new OrganizationalUnit(creationTemp, attrSet);
        parentObj.addChild(gc);
    }

    private void createFilteredRole(SSOToken token, PersistentObject parentObj, Map attributes, String profileName) throws UMSException, AMException {
        String orgDN = this.getOrganizationDN(this.internalToken, parentObj.getDN());
        String entryDN = this.getNamingAttribute(8) + "=" + profileName + "," + parentObj.getDN();
        attributes = this.callBackHelper.preProcess(token, entryDN, orgDN, null, attributes, 1, 8, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
        this.makeNamingFirst(attrSet, this.getNamingAttribute(8), profileName);
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate creationTemp = tempMgr.getCreationTemplate("BasicFilteredRole", new Guid(orgDN), 1);
        attrSet = this.combineOCs(creationTemp, attrSet);
        if (!attrSet.contains("nsRoleFilter")) {
            Attr attr = new Attr("nsRoleFilter", SearchFilterManager.getSearchFilter(1, orgDN));
            attrSet.add(attr);
        }
        FilteredRole frole = new FilteredRole(creationTemp, attrSet);
        parentObj.addChild(frole);
        this.callBackHelper.postProcess(token, frole.getDN(), orgDN, null, attributes, 1, 8, false);
    }

    public void createEntry(SSOToken token, String entryName, int objectType, String parentDN, Map attributes) throws AMEntryExistsException, AMException, SSOException {
        try {
            if (entryName == null || entryName.length() == 0) {
                throw new AMException(token, "320");
            }
            if (parentDN == null) {
                throw new AMException(token, "322");
            }
            String tmpDN = this.getNamingAttribute(objectType) + "=" + entryName + "," + parentDN;
            this.validateAttributeUniqueness(tmpDN, objectType, true, attributes);
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(parentDN));
            switch (objectType) {
                case 1: {
                    this.createUser(token, po, attributes, entryName);
                    break;
                }
                case 6: 
                case 7: {
                    this.createRole(token, po, attributes, entryName);
                    break;
                }
                case 2: {
                    this.createOrganization(token, po, attributes, entryName);
                    break;
                }
                case 9: 
                case 10: {
                    this.createGroup(token, po, attributes, entryName);
                    break;
                }
                case 12: {
                    this.createAssignDynamicGroup(token, po, attributes, entryName);
                    break;
                }
                case 11: {
                    this.createDynamicGroup(token, po, attributes, entryName);
                    break;
                }
                case 5: {
                    this.createPeopleContainer(po, attributes, entryName);
                    break;
                }
                case 3: {
                    this.createOrganizationalUnit(token, po, attributes, entryName);
                    break;
                }
                case 4: {
                    this.createGroupContainer(po, attributes, entryName);
                    break;
                }
                case 8: {
                    this.createFilteredRole(token, po, attributes, entryName);
                    break;
                }
                case 21: {
                    this.createResource(po, attributes, entryName);
                    break;
                }
                case -9999: 
                case -1: {
                    throw new AMException(token, "326");
                }
                default: {
                    this.createEntity(token, po, objectType, attributes, entryName);
                    break;
                }
            }
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntry() Insufficient access rights to create entry: " + entryName, (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (EntryAlreadyExistsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntry() Entry: " + entryName + "already exists: ", (Throwable)e);
            }
            String msgid = this.getEntryExistsMsgID(objectType);
            String name = this.getEntryName(e);
            Object[] args = new Object[]{name};
            throw new AMException(AMSDKBundle.getString(msgid, args), msgid, args);
        }
        catch (UMSException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createEntry() Unable to create entry: " + entryName, (Throwable)e);
            }
            throw new AMException(token, "324", e);
        }
    }

    private void processPreDeleteCallBacks(SSOToken token, String entryDN, Map attributes, String organizationDN, int objectType, boolean softDelete) throws AMException, SSOException {
        if (objectType != 5 && objectType != 4) {
            DN currentOrgDN;
            DN rootDN;
            String parentOrgDN = organizationDN;
            if (!(objectType != 2 && objectType != 3 || (rootDN = new DN(AMStoreConnection.getAMSdkBaseDN())).equals(currentOrgDN = new DN(organizationDN)))) {
                String parentDN = new DN(organizationDN).getParent().toString();
                parentOrgDN = this.getOrganizationDN(this.internalToken, parentDN);
            }
            if (attributes == null) {
                attributes = this.getAttributes(token, entryDN, objectType);
            }
            this.callBackHelper.preProcess(token, entryDN, parentOrgDN, attributes, null, 2, objectType, softDelete);
        }
    }

    private void processPostDeleteCallBacks(SSOToken token, String entryDN, Map attributes, String organizationDN, int objectType, boolean softDelete) throws AMException {
        if (objectType != 5 && objectType != 4) {
            DN currentOrgDN;
            DN rootDN;
            String parentOrgDN = organizationDN;
            if (!(objectType != 2 && objectType != 3 || (rootDN = new DN(AMStoreConnection.getAMSdkBaseDN())).equals(currentOrgDN = new DN(organizationDN)))) {
                String parentDN = new DN(organizationDN).getParent().toString();
                parentOrgDN = this.getOrganizationDN(this.internalToken, parentDN);
            }
            this.callBackHelper.postProcess(token, entryDN, parentOrgDN, attributes, null, 2, objectType, softDelete);
        }
    }

    public void removeEntry(SSOToken token, String entryDN, int objectType, boolean recursive, boolean softDelete) throws AMException, SSOException {
        block6: {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.removeEntry(): Removing: " + entryDN + " & recursive: " + recursive);
            }
            if (recursive) {
                this.removeSubtree(token, entryDN, softDelete);
            } else {
                this.removeSingleEntry(token, entryDN, objectType, softDelete);
            }
            if (objectType == 2 && ServiceManager.isCoexistenceMode() && ServiceManager.isRealmEnabled()) {
                try {
                    OrganizationConfigManager ocm = new OrganizationConfigManager(token, entryDN);
                    ocm.deleteSubOrganization(null, recursive);
                }
                catch (SMSException smse) {
                    if (!debug.messageEnabled()) break block6;
                    debug.message("DirectoryServicesImpl::removeEntry unable to delete corresponding realm: " + entryDN);
                }
            }
        }
    }

    private void removeSingleEntry(SSOToken token, String entryDN, int objectType, boolean softDelete) throws AMException, SSOException {
        Map attributes = null;
        EmailNotificationHelper mailer = null;
        String eDN = entryDN;
        if (objectType == 1) {
            eDN = new DN(entryDN).getParent().toRFCString();
        }
        String orgDN = this.getOrganizationDN(this.internalToken, eDN);
        try {
            if (objectType == 1) {
                mailer = new EmailNotificationHelper(entryDN);
                mailer.setUserDeleteNotificationList();
            }
            if (DirectoryServicesImpl.getUserPostPlugin() != null || mailer != null && mailer.isPresentUserDeleteNotificationList()) {
                attributes = this.getAttributes(token, entryDN, objectType);
            }
            this.processPreDeleteCallBacks(token, entryDN, attributes, orgDN, objectType, softDelete);
            if (this.dcTreeImpl.isRequired()) {
                String rfcDN = CommonUtils.formatToRFC(entryDN);
                this.dcTreeImpl.removeDomain(this.internalToken, rfcDN);
            }
            Guid guid = new Guid(entryDN);
            UMSObject.removeObject(token, guid);
        }
        catch (AccessRightsException e) {
            debug.error("DirectoryServicesImpl.removeEntry() Insufficient access rights to remove entry: " + entryDN, (Throwable)e);
            throw new AMException(token, "460");
        }
        catch (EntryNotFoundException e) {
            String entry = this.getEntryName(e);
            debug.error("DirectoryServicesImpl.removeEntry() Entry not found: " + entry, (Throwable)e);
            String msgid = this.getEntryNotFoundMsgID(objectType);
            Object[] args = new Object[]{entry};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString(msgid, args, locale), msgid, args);
        }
        catch (UMSException e) {
            debug.error("DirectoryServicesImpl.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)e);
            throw new AMException(token, "325", e);
        }
        this.processPostDeleteCallBacks(token, entryDN, attributes, orgDN, objectType, softDelete);
        if (objectType == 1) {
            AMUserEntryProcessed postPlugin = DirectoryServicesImpl.getUserPostPlugin();
            if (postPlugin != null) {
                postPlugin.processUserDelete(token, entryDN, attributes);
            }
            if (mailer != null && mailer.isPresentUserDeleteNotificationList()) {
                mailer.sendUserDeleteNotification(attributes);
            }
        }
    }

    private void removeSubtree(SSOToken token, String entryDN, boolean softDelete) throws AMException, SSOException {
        int type = -1;
        try {
            int entryRDNs;
            Guid guid = new Guid(entryDN);
            PersistentObject po = UMSObject.getObjectHandle(this.internalToken, guid);
            SearchControl control = new SearchControl();
            control.setSearchScope(2);
            String searchFilter = "(|(objectclass=*)(objectclass=ldapsubEntry))";
            ArrayList<DN> list = new ArrayList<DN>();
            int maxRDNCount = entryRDNs = new DN(entryDN).countRDNs();
            SearchResults children = po.getChildren(searchFilter, control);
            while (children.hasMoreElements()) {
                int count;
                PersistentObject object = children.next();
                DN dn = new DN(object.getDN());
                if (debug.messageEnabled()) {
                    debug.message("DirectoryServicesImpl.removeEntry(): found child: " + object.getDN());
                }
                if ((count = dn.countRDNs()) > maxRDNCount) {
                    maxRDNCount = count;
                }
                list.add(dn);
            }
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.removeEntry(): max RDNs: " + maxRDNCount);
            }
            int len = list.size();
            for (int i = maxRDNCount; i >= entryRDNs; --i) {
                for (int j = 0; j < len; ++j) {
                    DN dn = (DN)list.get(j);
                    if (dn.countRDNs() != i) continue;
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryServicesImpl.removeEntry(): del " + dn.toRFCString());
                    }
                    String rfcDN = dn.toRFCString();
                    type = -1;
                    try {
                        type = this.getObjectType(this.internalToken, rfcDN);
                    }
                    catch (AMException ae) {
                        Guid g = new Guid(rfcDN);
                        UMSObject.removeObject(token, g);
                    }
                    if (type != -1 && type != -9999) {
                        try {
                            this.removeSingleEntry(token, rfcDN, type, softDelete);
                        }
                        catch (AMPreCallBackException amp) {
                            debug.error("DirectoryServicesImpl.removeSubTree: Aborting delete of: " + rfcDN + " due to pre-callback exception", (Throwable)amp);
                        }
                    }
                    list.remove(j);
                    --j;
                    --len;
                }
            }
        }
        catch (AccessRightsException e) {
            debug.error("DirectoryServicesImpl.removeEntry() Insufficient access rights to remove entry: " + entryDN, (Throwable)e);
            throw new AMException(token, "460");
        }
        catch (EntryNotFoundException e) {
            String entry = this.getEntryName(e);
            debug.error("DirectoryServicesImpl.removeEntry() Entry not found: " + entry, (Throwable)e);
            String msgid = this.getEntryNotFoundMsgID(type);
            Object[] args = new Object[]{entry};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString(msgid, args, locale), msgid, args);
        }
        catch (UMSException e) {
            debug.error("DirectoryServicesImpl.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)e);
            throw new AMException(token, "325", e);
        }
    }

    public void removeAdminRole(SSOToken token, String dn, boolean recursive) throws SSOException, AMException {
        SSOTokenManager.getInstance().validateToken(token);
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.removeAdminRole() dn: " + dn + " recursive: " + recursive);
        }
        DN ldapDN = new DN(dn);
        String orgDN = this.getOrganizationDN(token, ldapDN.getParent().toString());
        String newdn = dn.replace(',', '_');
        String roleNameAttr = this.getNamingAttribute(6);
        String roleDN = roleNameAttr + "=" + newdn + "," + orgDN;
        Set<String> adminRoles = Collections.EMPTY_SET;
        if (recursive) {
            String roleSearchFilter = SearchFilterManager.getSearchFilter(6, orgDN);
            StringBuffer sb = new StringBuffer();
            sb.append("(&").append(roleSearchFilter).append("(");
            sb.append(roleNameAttr).append("=*").append(newdn).append("))");
            adminRoles = this.search(token, orgDN, sb.toString(), 1);
        } else {
            adminRoles = new HashSet<String>();
            adminRoles.add(roleDN);
        }
        Iterator iter = adminRoles.iterator();
        while (iter.hasNext()) {
            String adminRoleDN = (String)iter.next();
            try {
                ManagedRole roleObj = (ManagedRole)UMSObject.getObject(token, new Guid(adminRoleDN));
                roleObj.removeAllMembers();
                AMStoreConnection amsc = new AMStoreConnection(this.internalToken);
                AMRole role = amsc.getRole(adminRoleDN);
                role.delete(recursive);
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) continue;
                debug.message("DirectoryServicesImpl.removeAdminRole() Unable to admin roles:", (Throwable)e);
            }
        }
    }

    private Set searchResultsToSet(SearchResults results) throws UMSException {
        OrderedSet set = new OrderedSet();
        if (results != null) {
            while (results.hasMoreElements()) {
                PersistentObject one = results.next();
                set.add(one.getGuid().toString());
            }
        }
        return set;
    }

    public Set search(SSOToken token, String entryDN, String searchFilter, int searchScope) throws AMException {
        Set resultSet = Collections.EMPTY_SET;
        try {
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            SearchControl control = new SearchControl();
            control.setSearchScope(searchScope);
            SearchResults results = po.search(searchFilter, control);
            resultSet = this.searchResultsToSet(results);
        }
        catch (UMSException ue) {
            LDAPException lex = (LDAPException)ue.getRootCause();
            int errorCode = lex.getLDAPResultCode();
            if (retryErrorCodes.contains("" + errorCode)) {
                throw new AMException(token, Integer.toString(errorCode), ue);
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.search(token:, entryDN: " + entryDN + ", searchFilter: " + searchFilter + "searchScope: " + searchScope + " error occurred: ", (Throwable)ue);
            }
            this.processInternalException(token, ue, "341");
        }
        return resultSet;
    }

    private AMSearchResults getSearchResults(SearchResults results, SortKey skey, String[] attrNames, Collator collator, boolean getAllAttrs) throws UMSException {
        TreeMap<Object, Object> tm = null;
        TreeSet<String> tmpTreeSet = null;
        if (skey != null) {
            tm = new TreeMap<Object, Object>(collator);
            tmpTreeSet = new TreeSet<String>();
        }
        OrderedSet set = new OrderedSet();
        HashMap<String, Map> map = new HashMap<String, Map>();
        int errorCode = 0;
        try {
            if (results != null) {
                while (results.hasMoreElements()) {
                    PersistentObject po = results.next();
                    String dn = po.getGuid().toString();
                    if (tm != null) {
                        Attr attr = po.getAttribute(skey.attributeName);
                        if (attr != null) {
                            String attrValue = attr.getStringValues()[0];
                            Object obj = tm.get(attrValue);
                            if (obj == null) {
                                tm.put(attrValue, dn);
                            } else if (obj instanceof String) {
                                TreeSet<Object> tmpSet = new TreeSet<Object>();
                                tmpSet.add(obj);
                                tmpSet.add(dn);
                                tm.put(attrValue, tmpSet);
                            } else {
                                ((TreeSet)obj).add(dn);
                            }
                        } else {
                            tmpTreeSet.add(dn);
                        }
                    } else {
                        set.add(dn);
                    }
                    AttrSet attrSet = new AttrSet();
                    if (attrNames != null) {
                        attrSet = po.getAttributes(attrNames, true);
                    } else if (getAllAttrs) {
                        attrSet = po.getAttributes(po.getAttributeNames(), true);
                    }
                    map.put(dn, CommonUtils.attrSetToMap(attrSet));
                }
            }
        }
        catch (SizeLimitExceededException slee) {
            errorCode = 1;
        }
        catch (TimeLimitExceededException tlee) {
            errorCode = 2;
        }
        Integer count = (Integer)results.get("vlvContentCount");
        int countValue = count == null ? -1 : count;
        if (tm != null) {
            Object obj;
            int i;
            Object[] values = tm.values().toArray();
            int len = values.length;
            if (skey.reverse) {
                for (i = len - 1; i >= 0; --i) {
                    obj = values[i];
                    if (obj instanceof String) {
                        set.add(obj);
                        continue;
                    }
                    set.addAll((Collection)obj);
                }
            } else {
                for (i = 0; i < len; ++i) {
                    obj = values[i];
                    if (obj instanceof String) {
                        set.add(obj);
                        continue;
                    }
                    set.addAll((Collection)obj);
                }
            }
            Iterator iter = tmpTreeSet.iterator();
            while (iter.hasNext()) {
                set.add(iter.next());
            }
        }
        AMSearchResults searchResults = new AMSearchResults(countValue, (Set)set, errorCode, map);
        return searchResults;
    }

    public AMSearchResults search(SSOToken token, String entryDN, String searchFilter, SearchControl searchControl, String[] attrNames) throws AMException {
        AMSearchResults amResults = null;
        try {
            SearchResults results;
            SearchControl sc;
            SortKey[] skeys = searchControl.getSortKeys();
            SortKey skey = null;
            if (skeys != null && skeys.length > 0 && skeys[0].attributeName != null) {
                skey = skeys[0];
            }
            String userLocale = CommonUtils.getUserLocale(token);
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.search() search with searchcontrol locale = " + userLocale);
            }
            Collator collator = Collator.getInstance(Locale.getLocale((String)userLocale));
            if (skey != null) {
                sc = new SearchControl();
                sc.setMaxResults(searchControl.getMaxResults());
                sc.setSearchScope(searchControl.getSearchScope());
                sc.setTimeOut(searchControl.getTimeOut());
            } else {
                sc = searchControl;
            }
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            if (attrNames == null) {
                if (skey == null) {
                    results = po.search(searchFilter, sc);
                } else {
                    String[] tmpAttrNames = new String[]{skey.attributeName};
                    results = po.search(searchFilter, tmpAttrNames, sc);
                }
            } else if (skey == null) {
                results = po.search(searchFilter, attrNames, sc);
            } else {
                String[] tmpAttrNames = new String[attrNames.length + 1];
                System.arraycopy(attrNames, 0, tmpAttrNames, 0, attrNames.length);
                tmpAttrNames[attrNames.length] = skey.attributeName;
                results = po.search(searchFilter, tmpAttrNames, sc);
            }
            amResults = this.getSearchResults(results, skey, attrNames, collator, sc.isGetAllReturnAttributesEnabled());
        }
        catch (UMSException ue) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.search() with search control entryDN: " + entryDN + " Search Filter: " + searchFilter + " Error occurred: ", (Throwable)ue);
            }
            this.processInternalException(token, ue, "341");
        }
        return amResults;
    }

    public Set getMembers(SSOToken token, String entryDN, int objectType) throws AMException {
        try {
            switch (objectType) {
                case 6: 
                case 7: {
                    ManagedRole role = (ManagedRole)UMSObject.getObject(token, new Guid(entryDN));
                    SearchResults results = role.getMemberIDs();
                    return this.searchResultsToSet(results);
                }
                case 8: {
                    FilteredRole filteredRole = (FilteredRole)UMSObject.getObject(token, new Guid(entryDN));
                    SearchResults results = filteredRole.getMemberIDs();
                    return this.searchResultsToSet(results);
                }
                case 9: 
                case 10: {
                    StaticGroup group = (StaticGroup)UMSObject.getObject(token, new Guid(entryDN));
                    SearchResults results = group.getMemberIDs();
                    return this.searchResultsToSet(results);
                }
                case 11: {
                    DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(token, new Guid(entryDN));
                    SearchResults results = dynamicGroup.getMemberIDs();
                    return this.searchResultsToSet(results);
                }
                case 12: {
                    AssignableDynamicGroup adgroup = (AssignableDynamicGroup)UMSObject.getObject(token, new Guid(entryDN));
                    SearchResults results = adgroup.getMemberIDs();
                    return this.searchResultsToSet(results);
                }
            }
            throw new AMException(token, "114");
        }
        catch (EntryNotFoundException e) {
            debug.error("DirectoryServicesImpl.getMembers() entryDN " + entryDN + " objectType: " + objectType + " Unable to get members: ", (Throwable)e);
            String msgid = this.getEntryNotFoundMsgID(objectType);
            String entryName = this.getEntryName(e);
            Object[] args = new Object[]{entryName};
            throw new AMException(AMSDKBundle.getString(msgid, args), msgid, args);
        }
        catch (UMSException e) {
            debug.error("DirectoryServicesImpl.getMembers() entryDN " + entryDN + " objectType: " + objectType + " Unable to get members: ", (Throwable)e);
            LDAPException le = (LDAPException)e.getRootCause();
            if (le != null && (le.getLDAPResultCode() == 4 || le.getLDAPResultCode() == 11)) {
                throw new AMException(token, "505", e);
            }
            throw new AMException(token, "454", e);
        }
    }

    public String renameEntry(SSOToken token, int objectType, String entryDN, String newName, boolean deleteOldName) throws AMException {
        try {
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            String newRDN = this.getNamingAttribute(objectType) + "=" + newName;
            po.rename(newRDN, deleteOldName);
            return po.getDN();
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.renameEntry(): User does not have sufficient access rights ", (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (EntryNotFoundException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.renameEntry(): Entry not found: ", (Throwable)e);
            }
            String msgid = this.getEntryNotFoundMsgID(objectType);
            String entryName = this.getEntryName(e);
            Object[] args = new Object[]{entryName};
            throw new AMException(AMSDKBundle.getString(msgid, args), msgid, args);
        }
        catch (UMSException ume) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.renameEntry(): Unable to rename entry: ", (Throwable)ume);
            }
            throw new AMException(token, "360", ume);
        }
    }

    private Map setDCTreeAttributes(SSOToken token, String entryDN, Map attributes, int objectType) throws AMException, SSOException {
        if (objectType == 2 && this.dcTreeImpl.isRequired() && !entryDN.equals(AMStoreConnection.getAMSdkBaseDN())) {
            AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
            String status = attrSet.getValue("inetdomainstatus");
            if (status != null) {
                this.dcTreeImpl.updateDomainStatus(token, entryDN, status);
            }
            AttrSet[] attrArray = this.dcTreeImpl.splitAttrSet(entryDN, attrSet);
            attrSet = attrArray[0];
            attributes = CommonUtils.attrSetToMap(attrSet);
            AttrSet domAttrSet = attrArray[1];
            this.dcTreeImpl.setDomainAttributes(token, entryDN, domAttrSet);
        }
        return attributes;
    }

    private void processPostModifyCallBacks(SSOToken token, String entryDN, Map oldAttributes, Map attributes, String organizationDN, int objectType) throws AMException {
        if (objectType != 5 && objectType != 4) {
            DN currentOrgDN;
            DN rootDN;
            String parentOrgDN = organizationDN;
            if (!(objectType != 2 && objectType != 3 || (rootDN = new DN(AMStoreConnection.getAMSdkBaseDN())).equals(currentOrgDN = new DN(organizationDN)))) {
                String parentDN = new DN(organizationDN).getParent().toString();
                parentOrgDN = this.getOrganizationDN(this.internalToken, parentDN);
            }
            this.callBackHelper.postProcess(token, entryDN, parentOrgDN, oldAttributes, attributes, 3, objectType, false);
        }
    }

    private Map processPreModifyCallBacks(SSOToken token, String entryDN, Map oldAttributes, Map attributes, String organizationDN, int objectType) throws AMException, SSOException {
        if (objectType != 5 && objectType != 4) {
            DN currentOrgDN;
            DN rootDN;
            String parentOrgDN = organizationDN;
            if (!(objectType != 2 && objectType != 3 || (rootDN = new DN(AMStoreConnection.getAMSdkBaseDN())).equals(currentOrgDN = new DN(organizationDN)))) {
                String parentDN = new DN(organizationDN).getParent().toString();
                parentOrgDN = this.getOrganizationDN(this.internalToken, parentDN);
            }
            if (oldAttributes == null) {
                Set attrNames = attributes.keySet();
                oldAttributes = this.getAttributes(token, entryDN, attrNames, objectType);
            }
            attributes = this.callBackHelper.preProcess(token, entryDN, parentOrgDN, oldAttributes, attributes, 3, objectType, false);
        }
        return attributes;
    }

    private void modifyPersistentObject(PersistentObject po, Attr attr, boolean isAdd, boolean isDelete) {
        if (isAdd) {
            po.modify(attr, 0);
        } else if (isDelete) {
            po.modify(attr, 1);
        } else {
            po.modify(attr, 2);
        }
    }

    private void modifyAndSaveEntry(SSOToken token, String entryDN, Map stringAttributes, Map byteAttributes, boolean isAdd) throws AccessRightsException, EntryNotFoundException, UMSException {
        String attrName;
        Iterator itr;
        PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
        if (stringAttributes != null && !stringAttributes.isEmpty()) {
            itr = stringAttributes.keySet().iterator();
            while (itr.hasNext()) {
                attrName = (String)itr.next();
                if (attrName.equalsIgnoreCase("dn")) continue;
                Set set = (Set)stringAttributes.get(attrName);
                String[] attrValues = set == null ? null : set.toArray(new String[set.size()]);
                Attr attr = new Attr(attrName, attrValues);
                this.modifyPersistentObject(po, attr, isAdd, set == AMConstants.REMOVE_ATTRIBUTE);
            }
        }
        if (byteAttributes != null && !byteAttributes.isEmpty()) {
            itr = byteAttributes.keySet().iterator();
            while (itr.hasNext()) {
                attrName = (String)itr.next();
                byte[][] attrValues = (byte[][])byteAttributes.get(attrName);
                Attr attr = new Attr(attrName, attrValues);
                this.modifyPersistentObject(po, attr, isAdd, false);
            }
        }
        po.save();
    }

    public void setAttributes(SSOToken token, String entryDN, int objectType, Map stringAttributes, Map byteAttributes, boolean isAdd) throws AMException, SSOException {
        Map oldAttributes = null;
        EmailNotificationHelper mailer = null;
        this.validateAttributeUniqueness(entryDN, objectType, false, stringAttributes);
        String eDN = entryDN;
        if (objectType == 1) {
            eDN = new DN(entryDN).getParent().toString();
        }
        String orgDN = this.getOrganizationDN(this.internalToken, eDN);
        try {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.setAttributes() entryDN: " + entryDN);
            }
            if (objectType == 1) {
                UserPasswordValidationHelper pluginImpl = new UserPasswordValidationHelper(token, orgDN);
                try {
                    pluginImpl.validate(stringAttributes);
                }
                catch (AMException ame) {
                    debug.error("DirectoryServicesImpl.setAttributes(): Invalid characters for user", (Throwable)ame);
                    throw ame;
                }
                mailer = new EmailNotificationHelper(entryDN);
                mailer.setUserModifyNotificationList();
            }
            if (DirectoryServicesImpl.getUserPostPlugin() != null || mailer != null && mailer.isPresentUserModifyNotificationList()) {
                Set attrNames = stringAttributes.keySet();
                oldAttributes = this.getAttributes(token, entryDN, attrNames, objectType);
            }
            stringAttributes = this.processPreModifyCallBacks(token, entryDN, oldAttributes, stringAttributes, orgDN, objectType);
            this.setDCTreeAttributes(token, entryDN, stringAttributes, objectType);
            this.modifyAndSaveEntry(token, entryDN, stringAttributes, byteAttributes, isAdd);
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.setAttributes() User does not have sufficient access rights: ", (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (EntryNotFoundException ee) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.setAttributes() Entry not found: ", (Throwable)ee);
            }
            String msgid = this.getEntryNotFoundMsgID(objectType);
            String entryName = this.getEntryName(ee);
            Object[] args = new Object[]{entryName};
            throw new AMException(AMSDKBundle.getString(msgid, args), msgid, args);
        }
        catch (UMSException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.setAttributes() Internal error occurred", (Throwable)e);
            }
            this.processInternalException(token, e, "452");
        }
        this.processPostModifyCallBacks(token, entryDN, oldAttributes, stringAttributes, orgDN, objectType);
        if (objectType == 1) {
            AMUserEntryProcessed postPlugin = DirectoryServicesImpl.getUserPostPlugin();
            if (postPlugin != null) {
                postPlugin.processUserModify(token, entryDN, oldAttributes, stringAttributes);
            }
            if (mailer != null && mailer.isPresentUserModifyNotificationList()) {
                mailer.sendUserModifyNotification(token, stringAttributes, oldAttributes);
            }
        }
    }

    public String[] getGroupFilterAndScope(SSOToken token, String entryDN, int profileType) throws SSOException, AMException {
        String[] result = new String[3];
        try {
            DynamicGroup dg = (DynamicGroup)UMSObject.getObject(token, new Guid(entryDN));
            int scope = dg.getSearchScope();
            String base = dg.getSearchBase().getDn();
            String gfilter = dg.getSearchFilter();
            result[0] = Integer.toString(scope);
            result[1] = base;
            result[2] = gfilter;
        }
        catch (EntryNotFoundException e) {
            debug.error("AMGroupImpl.searchUsers", (Throwable)e);
            String msgid = this.getEntryNotFoundMsgID(profileType);
            String expectionEntryName = this.getEntryName(e);
            Object[] args = new Object[]{expectionEntryName};
            throw new AMException(AMSDKBundle.getString(msgid, args), msgid, args);
        }
        catch (UMSException e) {
            debug.message("AMGroupImpl.searchUsers", (Throwable)e);
            throw new AMException(AMSDKBundle.getString("341"), "341", e);
        }
        return result;
    }

    public void setGroupFilter(SSOToken token, String entryDN, String filter) throws AMException, SSOException {
        try {
            DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(token, new Guid(entryDN));
            dynamicGroup.setSearchFilter(filter);
            dynamicGroup.save();
        }
        catch (UMSException ume) {
            debug.message("AMDynamicGroup.setSearchFilter() - Unable to setFilter()", (Throwable)ume);
            throw new AMException(token, "352", ume);
        }
    }

    private void modifyRoleMembership(SSOToken token, String target, Set members, int operation, int profileType) throws UMSException, AMException {
        ManagedRole role;
        try {
            role = (ManagedRole)UMSObject.getObject(token, new Guid(target));
        }
        catch (ClassCastException e) {
            debug.message("DirectoryServicesImpl.modifyRoleMembership() - Unable to modify role membership", (Throwable)e);
            throw new AMException(token, "350");
        }
        String parentDN = role.getParentGuid().getDn();
        String orgDN = this.getOrganizationDN(token, parentDN);
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN) && ((members = this.callBackHelper.preProcessModifyMemberShip(token, target, orgDN, members, operation, profileType)) == null || members.isEmpty())) {
            return;
        }
        switch (operation) {
            case 1: {
                Guid[] membersGuid = CommonUtils.toGuidArray(members);
                role.addMembers(membersGuid);
                if (!ComplianceServicesImpl.isAdminGroupsEnabled(parentDN)) break;
                this.complianceImpl.verifyAndLinkRoleToGroup(token, membersGuid, target);
                break;
            }
            case 2: {
                Object[] entries = members.toArray();
                for (int i = 0; i < entries.length; ++i) {
                    role.removeMember(new Guid((String)entries[i]));
                }
                if (!ComplianceServicesImpl.isAdminGroupsEnabled(parentDN)) break;
                this.complianceImpl.verifyAndUnLinkRoleToGroup(token, members, target);
                break;
            }
            default: {
                throw new AMException(token, "114");
            }
        }
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN)) {
            this.callBackHelper.postProcessModifyMemberShip(token, target, orgDN, members, operation, profileType);
        }
    }

    private void modifyGroupMembership(SSOToken token, String target, Set members, int operation, int profileType) throws UMSException, AMException {
        StaticGroup group = (StaticGroup)UMSObject.getObject(token, new Guid(target));
        String parentDN = group.getParentGuid().getDn();
        String orgDN = this.getOrganizationDN(token, parentDN);
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN) && ((members = this.callBackHelper.preProcessModifyMemberShip(token, target, orgDN, members, operation, profileType)) == null || members.isEmpty())) {
            return;
        }
        switch (operation) {
            case 1: {
                group.addMembers(CommonUtils.toGuidArray(members));
                this.updateUserAttribute(token, members, target, true);
                break;
            }
            case 2: {
                Object[] entries = members.toArray();
                for (int i = 0; i < entries.length; ++i) {
                    group.removeMember(new Guid((String)entries[i]));
                }
                this.updateUserAttribute(token, members, target, false);
                break;
            }
            default: {
                throw new AMException(token, "114");
            }
        }
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN)) {
            this.callBackHelper.postProcessModifyMemberShip(token, target, orgDN, members, operation, profileType);
        }
    }

    private void modifyAssignDynamicGroupMembership(SSOToken token, String target, Set members, int operation, int profileType) throws UMSException, AMException {
        AssignableDynamicGroup tmpgroup = new AssignableDynamicGroup();
        AssignableDynamicGroup adgroup = (AssignableDynamicGroup)UMSObject.getObject(token, new Guid(target));
        String parentDN = adgroup.getParentGuid().getDn();
        String orgDN = this.getOrganizationDN(token, parentDN);
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN) && ((members = this.callBackHelper.preProcessModifyMemberShip(token, target, orgDN, members, operation, profileType)) == null || members.isEmpty())) {
            return;
        }
        switch (operation) {
            case 1: {
                Guid[] membersGuid = CommonUtils.toGuidArray(members);
                adgroup.addMembers(CommonUtils.toGuidArray(members));
                if (!ComplianceServicesImpl.isAdminGroupsEnabled(AMStoreConnection.getAMSdkBaseDN())) break;
                this.complianceImpl.verifyAndLinkGroupToRole(token, membersGuid, target);
                break;
            }
            case 2: {
                Object[] entries = members.toArray();
                for (int i = 0; i < entries.length; ++i) {
                    adgroup.removeMember(new Guid((String)entries[i]));
                }
                if (!ComplianceServicesImpl.isAdminGroupsEnabled(AMStoreConnection.getAMSdkBaseDN())) break;
                this.complianceImpl.verifyAndUnLinkGroupToRole(token, members, target);
                break;
            }
            default: {
                throw new AMException(token, "114");
            }
        }
        if (this.callBackHelper.isExistsPrePostPlugins(orgDN)) {
            this.callBackHelper.postProcessModifyMemberShip(token, target, orgDN, members, operation, profileType);
        }
    }

    private AMException generateMemberShipException(SSOToken token, String target, int objectType, EntryNotFoundException e) {
        DN errorDN = this.getExceptionDN(e);
        DN targetDN = new DN(target);
        if (errorDN == null) {
            debug.error("DirectoryServicesImpl.modMemberShip", (Throwable)e);
            Object[] args = new Object[]{target};
            String locale = CommonUtils.getUserLocale(token);
            return new AMException(AMSDKBundle.getString("461", args, locale), "461", args);
        }
        String entryName = ((RDN)errorDN.getRDNs().firstElement()).getValues()[0];
        String errorCode = null;
        if (errorDN.equals(targetDN)) {
            switch (objectType) {
                case 6: 
                case 7: {
                    errorCode = "465";
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    errorCode = "466";
                }
            }
        } else {
            errorCode = "468";
        }
        debug.error("DirectoryServicesImpl.modMemberShip() - Entry not found " + target, (Throwable)e);
        Object[] args = new Object[]{entryName};
        return new AMException(AMSDKBundle.getString(errorCode, args), errorCode, args);
    }

    public void modifyMemberShip(SSOToken token, Set members, String target, int type, int operation) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.modifyMemberShip: targetDN = <" + target + ">, Members: " + members + ", object Type = " + type + ", Operation = " + operation);
        }
        Iterator itr = members.iterator();
        while (itr.hasNext()) {
            String userDN = (String)itr.next();
            if (userDN.length() != 0 && DN.isDN((String)userDN)) continue;
            debug.error("DirectoryServicesImpl.modifyMemberShip() Invalid DN: " + userDN);
            throw new AMException(token, "157");
        }
        try {
            switch (type) {
                case 6: 
                case 7: {
                    this.modifyRoleMembership(token, target, members, operation, type);
                    break;
                }
                case 9: 
                case 10: {
                    this.modifyGroupMembership(token, target, members, operation, type);
                    break;
                }
                case 12: {
                    this.modifyAssignDynamicGroupMembership(token, target, members, operation, type);
                    break;
                }
                default: {
                    throw new AMException(token, "114");
                }
            }
        }
        catch (AccessRightsException e) {
            debug.error("DirectoryServicesImpl.modMemberShip() - Insufficient access rights: ", (Throwable)e);
            throw new AMException(token, "460");
        }
        catch (EntryNotFoundException e) {
            throw this.generateMemberShipException(token, target, type, e);
        }
        catch (UMSException e) {
            debug.message("DirectoryServicesImpl.modMemberShip() - Unable to modify membership", (Throwable)e);
            throw new AMException(token, "350", e);
        }
    }

    public Set getRegisteredServiceNames(SSOToken token, String entryDN) throws AMException {
        try {
            HashSet<String> attrNames = new HashSet<String>(1);
            attrNames.add("sunRegisteredServiceName");
            Map attributes = this.getAttributes(this.internalToken, entryDN, attrNames, -9999);
            Set resultSet = Collections.EMPTY_SET;
            if (attributes.size() == 1) {
                resultSet = (Set)attributes.get("sunRegisteredServiceName");
            }
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.getRegisteredServiceNames() Registered Service Names for entryDN: " + entryDN + " are: " + resultSet);
            }
            return resultSet;
        }
        catch (Exception e) {
            debug.error("DirectoryServicesImpl.getRegisteredService", (Throwable)e);
            throw new AMException(token, "455");
        }
    }

    public void registerService(SSOToken token, String orgDN, String serviceName) throws AMException, SSOException {
        try {
            Set attrNames = this.getServiceAttributesWithQualifier(token, serviceName);
            if (attrNames != null && !attrNames.isEmpty()) {
                PersistentObject po = UMSObject.getObjectHandle(token, new Guid(orgDN));
                DirectCOSDefinition dcos = this.createCOSDefinition(serviceName, attrNames);
                COSManager cm = COSManager.getCOSManager(token, po.getGuid());
                cm.addDefinition(dcos);
            }
        }
        catch (AccessRightsException e) {
            debug.error("DirectoryServicesImpl.registerService() Insufficient access rights to register service: " + serviceName, (Throwable)e);
            throw new AMException(token, "460");
        }
        catch (EntryAlreadyExistsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.registerService() Service " + serviceName + " already registered", (Throwable)e);
            }
            Object[] args = new Object[]{serviceName};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("464", args, locale), "464", args);
        }
        catch (SMSException e) {
            debug.error("DirectoryServicesImpl.registerService() Unable to register service: " + serviceName, (Throwable)e);
            throw new AMException(token, "914");
        }
        catch (UMSException e) {
            debug.error("DirectoryServicesImpl.registerService() Unable to register service: " + serviceName, (Throwable)e);
            throw new AMException(token, "914", e);
        }
    }

    private Set getServiceAttributesWithQualifier(SSOToken token, String serviceName) throws SMSException, SSOException {
        ServiceSchema ss;
        block4: {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
            ss = null;
            try {
                ss = ssm.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sme) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("DirectoryServicesImpl.getServiceNames(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (ss == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> attrNames = new HashSet<String>();
        Set attrSchemaNames = ss.getAttributeSchemaNames();
        Iterator itr = attrSchemaNames.iterator();
        while (itr.hasNext()) {
            String attrSchemaName = (String)itr.next();
            AttributeSchema attrSchema = ss.getAttributeSchema(attrSchemaName);
            String name = attrSchemaName + " " + attrSchema.getCosQualifier();
            attrNames.add(name);
        }
        return attrNames;
    }

    private DirectCOSDefinition createCOSDefinition(String serviceID, Set attrNames) throws UMSException {
        AttrSet attrs = new AttrSet();
        Attr attr = new Attr("cn", serviceID);
        attrs.add(attr);
        attr = new Attr("cosSpecifier", "nsrole");
        attrs.add(attr);
        attr = new Attr("cosAttribute");
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String attrName = (String)iter.next();
            attr.addValue(attrName);
        }
        attrs.add(attr);
        return new DirectCOSDefinition(attrs);
    }

    public void unRegisterService(SSOToken token, String entryDN, int objectType, String serviceName, int type) throws AMException {
        if (type == 301) {
            try {
                DirectCOSDefinition dcos;
                PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
                COSManager cm = null;
                switch (objectType) {
                    case 6: 
                    case 8: {
                        cm = COSManager.getCOSManager(token, po.getParentGuid());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        cm = COSManager.getCOSManager(token, po.getGuid());
                        break;
                    }
                    default: {
                        throw new AMException(token, "450");
                    }
                }
                try {
                    dcos = (DirectCOSDefinition)cm.getDefinition(serviceName);
                }
                catch (COSNotFoundException e) {
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryServicesImpl.unRegisterService() No COSDefinition found for service: " + serviceName);
                    }
                    Object[] args = new Object[]{serviceName};
                    String locale = CommonUtils.getUserLocale(token);
                    throw new AMException(AMSDKBundle.getString("463", args, locale), "463", args);
                }
                dcos.removeCOSTemplates();
                cm.removeDefinition(serviceName);
            }
            catch (AccessRightsException e) {
                debug.error("DirectoryServicesImpl.unRegisterService() Insufficient Access rights to unRegister service: ", (Throwable)e);
                throw new AMException(token, "460");
            }
            catch (UMSException e) {
                debug.error("DirectoryServicesImpl.unRegisterService: Unable to unregister service ", (Throwable)e);
                throw new AMException(token, "855", e);
            }
        }
    }

    public String getAMTemplateDN(SSOToken token, String entryDN, int objectType, String serviceName, int type) throws AMException {
        String roleDN = null;
        try {
            switch (objectType) {
                case 6: 
                case 8: {
                    roleDN = entryDN;
                    PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
                    return "cn=\"" + roleDN + "\",cn=" + serviceName + "," + po.getParentGuid().toString();
                }
                case 2: 
                case 3: 
                case 5: {
                    roleDN = "cn=ContainerDefaultTemplateRole," + entryDN;
                    return "cn=\"" + roleDN + "\",cn=" + serviceName + "," + entryDN;
                }
            }
            throw new AMException(token, "450");
        }
        catch (UMSException e) {
            debug.error("DirectoryServicesImpl.getAMTemplateDN() Unable to get AMTemplate DN for service: " + serviceName + " entryDN: " + entryDN, (Throwable)e);
            throw new AMException(token, "349", e);
        }
    }

    public String createAMTemplate(SSOToken token, String entryDN, int objectType, String serviceName, Map attributes, int priority) throws AMException {
        COSManager cm = null;
        DirectCOSDefinition dCOS = null;
        String roleDN = null;
        try {
            PersistentObject po = UMSObject.getObjectHandle(token, new Guid(entryDN));
            switch (objectType) {
                case 6: 
                case 8: {
                    roleDN = entryDN;
                    cm = COSManager.getCOSManager(token, po.getParentGuid());
                    dCOS = (DirectCOSDefinition)cm.getDefinition(serviceName);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    roleDN = "cn=ContainerDefaultTemplateRole," + entryDN;
                    cm = COSManager.getCOSManager(token, po.getGuid());
                    dCOS = (DirectCOSDefinition)cm.getDefinition(serviceName);
                    break;
                }
                default: {
                    throw new AMException(token, "450");
                }
            }
            AttrSet attrSet = CommonUtils.mapToAttrSet(attributes);
            if (priority != -1) {
                Attr attr = new Attr("cospriority");
                attr.addValue("" + priority);
                attrSet.add(attr);
            }
            COSTemplate template = this.createCOSTemplate(serviceName, attrSet, roleDN);
            dCOS.addCOSTemplate(template);
            return template.getGuid().toString();
        }
        catch (COSNotFoundException e) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.createAMTemplate() COSDefinition for service: " + serviceName + " not found: ", (Throwable)e);
            }
            Object[] args = new Object[]{serviceName};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("459", locale), "459", args);
        }
        catch (EntryAlreadyExistsException e) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.createAMTemplate: template already exists for " + serviceName, (Throwable)e);
            }
            Object[] params = new String[]{serviceName};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("854", params, locale), "854", params);
        }
        catch (AccessRightsException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createAMTemplate() Insufficient access rights to create template for: " + serviceName + " & entryDN: " + entryDN, (Throwable)e);
            }
            throw new AMException(token, "460");
        }
        catch (UMSException e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createAMTemplate() Unable to create AMTemplate for: " + serviceName + " & entryDN: " + entryDN, (Throwable)e);
            }
            Object[] args = new Object[]{serviceName};
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("459", locale), "459", args, e);
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryServicesImpl.createAMTemplate", (Throwable)e);
            }
            throw new AMException(token, "451");
        }
    }

    private COSTemplate createCOSTemplate(String serviceID, AttrSet attrset, String entryDN) throws UMSException {
        TemplateManager tempMgr = TemplateManager.getTemplateManager();
        CreationTemplate basicCOSTemplate = tempMgr.getCreationTemplate("BasicCOSTemplate", null);
        COSTemplate cosTemplate = new COSTemplate(basicCOSTemplate, "\"" + entryDN + "\"");
        cosTemplate.addTemplateAttribute("objectclass", "extensibleObject");
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.newCOSTemplate: cn = " + entryDN + " COSTemplate = " + cosTemplate);
        }
        int size = attrset.size();
        for (int i = 0; i < size; ++i) {
            Attr attr = attrset.elementAt(i);
            cosTemplate.modify(attr, 0);
        }
        return cosTemplate;
    }

    protected String getNamingAttribute(int objectType) {
        return NamingAttributeManager.getNamingAttribute(objectType);
    }

    public String getNamingAttribute(int objectType, String orgDN) {
        return NamingAttributeManager.getNamingAttribute(objectType, orgDN);
    }

    public String getCreationTemplateName(int objectType) {
        return NamingAttributeManager.getCreationTemplateName(objectType);
    }

    public String getObjectClassFromDS(int objectType) {
        return this.getObjectClass(objectType);
    }

    public String getObjectClass(int objectType) {
        return ObjectClassManager.getObjectClass(objectType);
    }

    public int getObjectType(String objectClass) {
        return ObjectClassManager.getObjectType(objectClass);
    }

    public String getSearchFilterFromTemplate(int objectType, String orgDN, String searchTemplateName) {
        return SearchFilterManager.getSearchFilterFromTemplate(objectType, orgDN, searchTemplateName);
    }

    public Set getAttributesForSchema(String objectclass) {
        try {
            SchemaManager sm = SchemaManager.getSchemaManager(this.internalToken);
            return new HashSet(sm.getAttributes(objectclass));
        }
        catch (UMSException ue) {
            return Collections.EMPTY_SET;
        }
    }

    void validateAttributeUniqueness(String entryDN, int profileType, boolean newEntry, Map modMap) throws AMException {
        block31: {
            boolean attrExists = false;
            if (modMap == null || modMap.isEmpty()) {
                return;
            }
            try {
                if (profileType == 301 || profileType == 302 || profileType == 300) {
                    return;
                }
                String[] rdns = LDAPDN.explodeDN((String)entryDN, (boolean)false);
                int size = rdns.length;
                if (size < 2) {
                    return;
                }
                String orgDN = rdns[size - 1];
                AMStoreConnection amsc = new AMStoreConnection(CommonUtils.getInternalToken());
                DN rootDN = new DN(AMStoreConnection.getAMSdkBaseDN());
                DN thisDN = new DN(orgDN);
                for (int i = size - 2; i >= 0; --i) {
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.validateAttributeUniqueness: try DN = " + orgDN);
                    }
                    int type = -1;
                    if (!rootDN.isDescendantOf(thisDN)) {
                        try {
                            type = amsc.getAMObjectType(orgDN);
                        }
                        catch (AMException ame) {
                            if (debug.warningEnabled()) {
                                debug.warning("AMObjectImpl.validateAttributeUniqueness: Unable to determine object type of " + orgDN + " :Attribute uniqueness check aborted..", (Throwable)ame);
                            }
                            return;
                        }
                    }
                    Set list = null;
                    AMObject amobj = null;
                    if (type == 2) {
                        AMOrganization amorg = amsc.getOrganization(orgDN);
                        list = amorg.getAttribute("sunnamespaceuniqueattrs");
                        amobj = amorg;
                    } else if (type == 3) {
                        AMOrganizationalUnit amorgu = amsc.getOrganizationalUnit(orgDN);
                        list = amorgu.getAttribute("sunnamespaceuniqueattrs");
                        amobj = amorgu;
                    }
                    if (list != null && !list.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.validateAttributeUniqueness: list =" + list);
                        }
                        Iterator iter = list.iterator();
                        StringBuffer filterSB = new StringBuffer();
                        StringBuffer newEntrySB = new StringBuffer();
                        filterSB.append("(|");
                        while (iter.hasNext()) {
                            String[] attrList = this.getAttrList((String)iter.next());
                            Set attr = this.getAttrValues(attrList, modMap);
                            for (int j = 0; j < attrList.length; ++j) {
                                String attrName = attrList[j];
                                if (attrName.equals(this.getNamingAttribute(profileType)) && newEntry) {
                                    if (profileType == 6 || profileType == 7 || profileType == 8) {
                                        newEntrySB.append("(&");
                                        newEntrySB.append("(objectclass=ldapsubentry)");
                                        newEntrySB.append("(objectclass=nsroledefinition)");
                                        attrExists = true;
                                    } else if (profileType == 9 || profileType == 10 || profileType == 12 || profileType == 11) {
                                        newEntrySB.append("(&");
                                        newEntrySB.append("(objectclass=iplanet-am-managed-group)");
                                        newEntrySB.append("(objectclass=groupofuniquenames)");
                                        attrExists = true;
                                    } else if (profileType == 2) {
                                        newEntrySB.append("(&(!");
                                        newEntrySB.append("(objectclass=");
                                        newEntrySB.append("sunRealmService");
                                        newEntrySB.append("))");
                                        attrExists = true;
                                    }
                                    filterSB.append("(").append(rdns[0]).append(")");
                                }
                                if (attr == null || attr.isEmpty()) continue;
                                Iterator itr = attr.iterator();
                                while (itr.hasNext()) {
                                    filterSB.append("(").append(attrName);
                                    filterSB.append("=").append((String)itr.next());
                                    filterSB.append(")");
                                }
                            }
                        }
                        if (filterSB.length() > 2) {
                            String dn;
                            DN dnObject;
                            Set users;
                            if (attrExists) {
                                newEntrySB.append(filterSB.toString()).append("))");
                                filterSB = newEntrySB;
                            } else {
                                filterSB.append(")");
                            }
                            if (debug.messageEnabled()) {
                                debug.message("AMObjectImpl.validateAttributeUniqueness: filter = " + filterSB.toString());
                            }
                            if ((users = amobj.search(2, filterSB.toString())) != null && users.size() == 1 && (dnObject = new DN(dn = (String)users.iterator().next())).equals(new DN(entryDN))) {
                                return;
                            }
                            if (users != null && !users.isEmpty()) {
                                throw new AMException(AMSDKBundle.getString("162"), "162");
                            }
                        }
                    }
                    orgDN = rdns[i] + "," + orgDN;
                    thisDN = new DN(orgDN);
                }
            }
            catch (SSOException ex) {
                if (!debug.warningEnabled()) break block31;
                debug.warning("Unable to validate attribute uniqneness", (Throwable)((Object)ex));
            }
        }
    }

    private String[] getAttrList(String attrNames) {
        StringTokenizer tzer = new StringTokenizer(attrNames, ",");
        int size = tzer.countTokens();
        String[] attrList = new String[size];
        for (int i = 0; i < size; ++i) {
            String tmps = tzer.nextToken();
            attrList[i] = tmps.trim();
        }
        return attrList;
    }

    private Set getAttrValues(String[] attrList, Map modMap) {
        HashSet retSet = new HashSet();
        int size = attrList.length;
        for (int i = 0; i < size; ++i) {
            Set tmpSet = (Set)modMap.get(attrList[i]);
            if (tmpSet == null || tmpSet.isEmpty()) continue;
            retSet.addAll(tmpSet);
        }
        return retSet;
    }

    public Set getTopLevelContainers(SSOToken token) throws AMException, SSOException {
        String userDN = token.getPrincipal().getName();
        AMStoreConnection amsc = new AMStoreConnection(this.internalToken);
        AMUser auser = amsc.getUser(userDN);
        Set set = new HashSet();
        Set roleDNs = auser.getRoleDNs();
        Iterator iter = roleDNs.iterator();
        while (iter.hasNext()) {
            String roleDN = (String)iter.next();
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesImpl.getTopLevelContainers: roleDN=" + roleDN);
            }
            AMRole role = amsc.getRole(roleDN);
            set.addAll(role.getAttribute("iplanet-am-role-managed-container-dn"));
        }
        if (set.isEmpty()) {
            String filter = "(|" + SearchFilterManager.getGlobalSearchFilter(2) + SearchFilterManager.getGlobalSearchFilter(3) + SearchFilterManager.getGlobalSearchFilter(5) + SearchFilterManager.getGlobalSearchFilter(11) + SearchFilterManager.getGlobalSearchFilter(12) + SearchFilterManager.getGlobalSearchFilter(9) + ")";
            set = this.search(token, AMStoreConnection.getAMSdkBaseDN(), filter, 2);
        }
        HashSet resultSet = new HashSet();
        iter = set.iterator();
        while (iter.hasNext()) {
            String containerDN = (String)iter.next();
            DN cDN = new DN(containerDN);
            Iterator iter2 = resultSet.iterator();
            HashSet<String> tmpSet = new HashSet<String>();
            boolean toAdd = true;
            while (iter2.hasNext()) {
                String resultDN = (String)iter2.next();
                DN rDN = new DN(resultDN);
                if (cDN.isDescendantOf(rDN)) {
                    toAdd = false;
                    tmpSet.add(resultDN);
                    break;
                }
                if (rDN.isDescendantOf(cDN)) continue;
                tmpSet.add(resultDN);
            }
            if (toAdd) {
                tmpSet.add(containerDN);
            }
            resultSet = tmpSet;
        }
        if (debug.messageEnabled()) {
            debug.message("DirectoryServicesImpl.getTopLevelContainers");
            iter = resultSet.iterator();
            StringBuffer tmpBuffer = new StringBuffer();
            while (iter.hasNext()) {
                String tmpDN = (String)iter.next();
                tmpBuffer.append(tmpDN).append("\n");
            }
            debug.message("containerDNs\n" + tmpBuffer.toString());
        }
        return resultSet;
    }

    public String verifyAndGetOrgDN(SSOToken token, String entryDN, String childDN) throws AMException {
        boolean errorCondition;
        String organizationDN;
        block8: {
            if (entryDN.length() == 0 || !DN.isDN((String)entryDN)) {
                debug.error("DirectoryServicesImpl.verifyAndGetOrgDN() Invalid DN: " + entryDN);
                throw new AMException(token, "157");
            }
            organizationDN = null;
            errorCondition = false;
            try {
                PersistentObject po = UMSObject.getObjectHandle(this.internalToken, new Guid(childDN));
                String searchFilter = this.getOrgSearchFilter(entryDN);
                SearchResults result = po.search(searchFilter, this.aName, this.scontrol);
                if (result.hasMoreElements()) {
                    while (result.hasMoreElements()) {
                        result.next();
                    }
                    organizationDN = po.getGuid().toString().toLowerCase();
                }
            }
            catch (InvalidSearchFilterException e) {
                errorCondition = true;
                debug.error("DirectoryServicesImpl.verifyAndGetOrgDN(): Invalid search filter, unable to get Parent Organization: ", (Throwable)e);
            }
            catch (UMSException ue) {
                errorCondition = true;
                if (debug.warningEnabled()) {
                    debug.warning("DirectoryServicesImpl.verifyAndGetOrgDN(): Unable to Obtain Parent Organization", (Throwable)ue);
                }
                LDAPException lex = (LDAPException)ue.getRootCause();
                int errorCode = lex.getLDAPResultCode();
                if (!retryErrorCodes.contains("" + errorCode)) break block8;
                throw new AMException(token, Integer.toString(errorCode), ue);
            }
        }
        if (errorCondition) {
            String locale = CommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("124", locale), "124");
        }
        return organizationDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SSOToken token, AMObjectListener listener, Map configMap) throws AMEventManagerException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException ssoe) {
            throw new AMEventManagerException(ssoe.getMessage(), "902");
        }
        Map map = listeners;
        synchronized (map) {
            listeners.put(listener, configMap);
            if (eventManager == null) {
                eventManager = new EventManager();
                eventManager.addListeners(listeners);
            }
        }
    }

    static {
        listeners = new HashMap();
        String retryErrs = SystemProperties.get(LDAP_CONNECTION_ERROR_CODES);
        if (retryErrs != null) {
            StringTokenizer stz = new StringTokenizer(retryErrs, ",");
            while (stz.hasMoreTokens()) {
                retryErrorCodes.add(stz.nextToken().trim());
            }
        }
    }
}

