/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.ldap.CachedDirectoryServicesImpl;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.DirectoryServicesImpl;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;

class DirectoryServicesFactory {
    private static final String GLOBAL_CACHE_ENABLED_DISABLED_KEY = "com.iplanet.am.sdk.caching.enabled";
    private static final String UM_CACHE_ENABLED_DISABLED_KEY = "com.sun.identity.amsdk.cache.enabled";
    private static Debug debug = CommonUtils.getDebugInstance();
    private static boolean cachingEnabled;
    private static IDirectoryServices dsServicesImpl;

    DirectoryServicesFactory() {
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public static IDirectoryServices getInstance() {
        return dsServicesImpl;
    }

    static {
        dsServicesImpl = null;
        String cachingMode = System.getProperty(GLOBAL_CACHE_ENABLED_DISABLED_KEY);
        if (cachingMode == null || cachingMode.length() == 0) {
            cachingMode = SystemProperties.get(GLOBAL_CACHE_ENABLED_DISABLED_KEY, "true");
        }
        if (cachingEnabled = cachingMode.equalsIgnoreCase("true") ? true : ((cachingMode = SystemProperties.get(UM_CACHE_ENABLED_DISABLED_KEY)) != null && cachingMode.length() > 0 ? cachingMode.equalsIgnoreCase("true") : false)) {
            dsServicesImpl = CachedDirectoryServicesImpl.getInstance();
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesFactory.static{} - Caching Mode: " + cachingEnabled + "Using implementation " + "Class CachedDirectoryServicesImpl");
            }
        } else {
            dsServicesImpl = DirectoryServicesImpl.getInstance();
            if (debug.messageEnabled()) {
                debug.message("DirectoryServicesFactory.static{} - Caching Mode: " + cachingEnabled + "Using implementation " + "Class DirectoryServicesImpl");
            }
        }
    }
}

