/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class MiscUtils {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE = "amProfile";
    private static SSOToken internalToken = null;
    static Debug debug = Debug.getInstance((String)"amProfile");
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    protected static boolean integrateLocale = true;

    public static Debug getDebugInstance() {
        return debug;
    }

    public static SSOToken getInternalToken() {
        if (internalToken == null) {
            internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return internalToken;
    }

    public static String getUserLocale(SSOToken token) {
        try {
            String locale = token.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("MiscUtils.getUserLocale(): locale = " + locale);
            }
            return locale;
        }
        catch (SSOException ssoe) {
            debug.error("MiscUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    public static AttrSet combineAttrSets(AttrSet attrSet1, AttrSet attrSet2) {
        Attr attr;
        int i;
        int count;
        AttrSet retAttrSet = new AttrSet();
        if (attrSet1 != null) {
            count = attrSet1.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet1.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        if (attrSet2 != null) {
            count = attrSet2.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet2.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        return retAttrSet;
    }

    public static Map mergeMaps(Map mapA, Map mapB) {
        if (mapA == null && mapB == null) {
            return null;
        }
        if (mapA == null || mapA.isEmpty()) {
            return mapB;
        }
        if (mapB == null || mapB.isEmpty()) {
            return mapA;
        }
        Map bigMap = mapA.size() > mapB.size() ? mapA : mapB;
        Map smallMap = mapA.size() <= mapB.size() ? mapA : mapB;
        Iterator itr = smallMap.keySet().iterator();
        while (itr.hasNext()) {
            String attrName = (String)itr.next();
            Set values = (Set)bigMap.get(attrName);
            if (values != null) {
                values.addAll((Set)smallMap.get(attrName));
                continue;
            }
            bigMap.put(attrName, (Set)smallMap.get(attrName));
        }
        return bigMap;
    }

    public static String mapSetToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values.toString());
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    public static String mapByteToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values);
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    public static Set getSetCopy(Set values) {
        HashSet<String> copyValues = Collections.EMPTY_SET;
        if (!values.isEmpty()) {
            copyValues = new HashSet<String>(values.size());
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                copyValues.add(value);
            }
        }
        return copyValues;
    }

    public static Set stringArrayToSet(String[] strs) {
        int count = strs.length;
        HashSet<String> set = count > 0 ? new HashSet<String>(count) : new HashSet();
        for (int i = 0; i < count; ++i) {
            set.add(strs[i]);
        }
        return set;
    }

    public static Map attrSetToMap(AttrSet attrSet) {
        return MiscUtils.attrSetToMap(attrSet, false);
    }

    public static Map attrSetToMap(AttrSet attrSet, boolean fetchByteValues) {
        AMHashMap attributesMap = new AMHashMap(fetchByteValues);
        if (attrSet == null) {
            return attributesMap;
        }
        int attrSetSize = attrSet.size();
        if (!fetchByteValues) {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                String[] values = attr.getStringValues();
                attributesMap.put(attr.getName(), MiscUtils.stringArrayToSet(values));
            }
        } else {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                attributesMap.put(attr.getName(), attr.getByteValues());
            }
        }
        return attributesMap;
    }

    public static AttrSet mapToAttrSet(Map map) {
        return MiscUtils.mapToAttrSet(map, false);
    }

    public static AttrSet mapToAttrSet(Map map, boolean byteValues) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!byteValues) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = (String)itr.next();
                Set set = (Set)map.get(attrName);
                String[] attrValues = set == null ? null : set.toArray(new String[set.size()]);
                attrSet.replace(new Attr(attrName, attrValues));
            }
        } else {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = (String)itr.next();
                byte[][] attrValues = (byte[][])map.get(attrName);
                attrSet.replace(new Attr(attrName, attrValues));
            }
        }
        return attrSet;
    }

    public static String formatToRFC(String dn) {
        return new DN(dn).toRFCString().toLowerCase();
    }

    public static String getPrincipalDN(SSOToken token) throws SSOException {
        String principalName = token.getPrincipal().getName();
        return MiscUtils.formatToRFC(principalName);
    }

    public static Set combineOCs(Set one, Set two) {
        if (one == null || one.isEmpty()) {
            return two;
        }
        if (two == null || two.isEmpty()) {
            return one;
        }
        HashSet<String> resultSet = new HashSet<String>();
        Iterator itr1 = one.iterator();
        while (itr1.hasNext()) {
            String value1 = (String)itr1.next();
            resultSet.add(value1.toLowerCase());
        }
        Iterator itr2 = two.iterator();
        while (itr2.hasNext()) {
            String value2 = (String)itr2.next();
            resultSet.add(value2.toLowerCase());
        }
        return resultSet;
    }

    public static boolean isObjectClassPresent(Set objectClasses, String objectClass) {
        if (objectClasses != null && !objectClasses.isEmpty()) {
            Iterator itr = objectClasses.iterator();
            while (itr.hasNext()) {
                String serviceOC = (String)itr.next();
                if (!serviceOC.equalsIgnoreCase(objectClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set updateAndGetRemovableOCs(Set origSet, Set removeOCs) {
        HashSet<String> returnOCs = removeOCs;
        if (removeOCs != null && !removeOCs.isEmpty()) {
            returnOCs = new HashSet<String>();
            Iterator itr1 = origSet.iterator();
            block0: while (itr1.hasNext()) {
                String origOC = (String)itr1.next();
                Iterator itr2 = removeOCs.iterator();
                while (itr2.hasNext()) {
                    String removeOC = (String)itr2.next();
                    if (!origOC.equalsIgnoreCase(removeOC)) continue;
                    returnOCs.add(origOC);
                    continue block0;
                }
            }
            origSet.removeAll(returnOCs);
        }
        return returnOCs;
    }

    public static Map removeEmptyValues(Map attrMap) {
        HashMap finalMap = new HashMap();
        Iterator iter = attrMap.keySet().iterator();
        while (iter.hasNext()) {
            String tStr = (String)iter.next();
            Set s = (Set)attrMap.get(tStr);
            if (s.isEmpty()) continue;
            finalMap.put(tStr, attrMap.get(tStr));
        }
        return finalMap;
    }

    public static Guid[] toGuidArray(Set set) {
        Object[] obj = set.toArray();
        Guid[] ss = new Guid[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ss[i] = new Guid((String)obj[i]);
        }
        return ss;
    }

    public static Guid[] getGuidArray(Set set) {
        return set.toArray(new Guid[set.size()]);
    }

    static {
        String cCaller = SystemProperties.get(LOCALE_INTEGRATION_PROPERTY);
        if (cCaller == null || cCaller.equalsIgnoreCase("true")) {
            integrateLocale = true;
            if (debug.messageEnabled()) {
                debug.message("MiscUtils.static{}: Locale integration enabled.");
            }
        } else {
            integrateLocale = false;
        }
    }
}

