/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMFilteredRoleImpl;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMGroupContainerImpl;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMOrganizationalUnitImpl;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMPreCallBackException;
import com.iplanet.am.sdk.AMResource;
import com.iplanet.am.sdk.AMResourceImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.DNUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public final class AMStoreConnection
implements AMConstants {
    public static String rootSuffix;
    protected static String defaultOrg;
    protected static Map orgMapCache;
    protected static Debug debug;
    private IDirectoryServices dsServices;
    private SSOToken token;
    private String locale = "en_US";

    public AMStoreConnection(SSOToken ssoToken) throws SSOException {
        SSOTokenManager.getInstance().validateToken(ssoToken);
        this.token = ssoToken;
        this.locale = AMCommonUtils.getUserLocale(ssoToken);
        this.dsServices = AMDirectoryAccessFactory.getDirectoryServices();
    }

    public static String getAMSdkBaseDN() {
        defaultOrg = rootSuffix = DNUtils.normalizeDN(SMSEntry.getAMSdkBaseDN());
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection:getAMSdkBaseDN():rootsuffix " + rootSuffix);
        }
        if (debug.messageEnabled()) {
            debug.message("default org: " + defaultOrg);
            debug.message("AMStoreConnection:getAMSdkBaseDN():default org " + defaultOrg);
        }
        return defaultOrg;
    }

    public static String getFilteredRoleNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(8);
    }

    public static String getGroupContainerNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(4);
    }

    public static String getGroupNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(9);
    }

    public static String getNamingAttribute(int objectType) throws AMException {
        return AMNamingAttrManager.getNamingAttr(objectType);
    }

    public static String getOrganizationNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(2);
    }

    public static String getOrganizationalUnitNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(3);
    }

    public static String getPeopleContainerNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(5);
    }

    public static String getRoleNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(6);
    }

    public static String getUserNamingAttribute() {
        return AMNamingAttrManager.getNamingAttr(1);
    }

    public int getAMObjectType(String dn) throws AMException, SSOException {
        return this.dsServices.getObjectType(this.token, dn);
    }

    public String getAMObjectName(int type) {
        return (String)AMCommonUtils.supportedNames.get(Integer.toString(type));
    }

    public static String getObjectName(int type) {
        return (String)AMCommonUtils.supportedNames.get(Integer.toString(type));
    }

    public AMAssignableDynamicGroup getAssignableDynamicGroup(String assignableDynamicGroupDN) throws SSOException {
        AMAssignableDynamicGroupImpl assignableDynamicGroup = new AMAssignableDynamicGroupImpl(this.token, assignableDynamicGroupDN);
        return assignableDynamicGroup;
    }

    public Set getAttributeNames(String serviceName, AMSchema.Type schemaType) throws AMException {
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
            SchemaType st = schemaType.getInternalSchemaType();
            return ssm.getServiceAttributeNames(st);
        }
        catch (SSOException se) {
            debug.message("AMStoreConnection.getAttributeNames(String, AMSchema.Type)", (Throwable)((Object)se));
            throw new AMException(AMSDKBundle.getString("902", this.locale), "902");
        }
        catch (SMSException se) {
            debug.message("AMStoreConnection.getAttributeNames(String, AMSchema.Type)", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("911", this.locale), "911");
        }
    }

    public AMDynamicGroup getDynamicGroup(String dynamicGroupDN) throws SSOException {
        AMDynamicGroupImpl dynamicGroup = new AMDynamicGroupImpl(this.token, dynamicGroupDN);
        return dynamicGroup;
    }

    public AMFilteredRole getFilteredRole(String roleDN) throws SSOException {
        AMFilteredRoleImpl role = new AMFilteredRoleImpl(this.token, roleDN);
        return role;
    }

    public AMGroupContainer getGroupContainer(String groupContainerDN) throws SSOException {
        AMGroupContainerImpl groupContainer = new AMGroupContainerImpl(this.token, groupContainerDN);
        return groupContainer;
    }

    public String getI18NPropertiesFileName(String serviceName) throws AMException {
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, this.token);
            return scm.getI18NFileName();
        }
        catch (SSOException so) {
            debug.error("AMStoreConnection.getI18NPropertiesFileName(): ", (Throwable)((Object)so));
            throw new AMException(AMSDKBundle.getString("902", this.locale), "902");
        }
        catch (SMSException se) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("909", this.locale), "909");
        }
    }

    public AMOrganization getOrganization(String orgDN) throws SSOException {
        AMOrganizationImpl organization = new AMOrganizationImpl(this.token, orgDN);
        return organization;
    }

    public String getOrganizationDN(String domainname, String orgSearchTemplate) throws AMException, SSOException {
        Set orgSet;
        String orgdn;
        if (domainname == null) {
            return rootSuffix;
        }
        if (DN.isDN((String)domainname) && this.isValidEntry(domainname) && this.getAMObjectType(domainname) == 2) {
            return domainname;
        }
        if (!domainname.startsWith("http://") && domainname.indexOf("/") > -1) {
            String orgdn2 = AMStoreConnection.orgNameToDN(domainname);
            if (this.isValidEntry(orgdn2) && this.getAMObjectType(orgdn2) == 2) {
                return orgdn2;
            }
            Object[] args = new Object[]{orgdn2};
            String locale = AMCommonUtils.getUserLocale(this.token);
            throw new AMException(AMSDKBundle.getString("467", args, locale), "467", args);
        }
        try {
            if (AMDCTree.isRequired() && (orgdn = AMDCTree.getOrganizationDN(this.token, domainname)) != null) {
                return orgdn;
            }
        }
        catch (AMException ae) {
            debug.error("AMStoreConnection.getOrganizationDN-> In DC tree mode, unabe to find organization  for domain: " + domainname);
        }
        orgdn = (String)orgMapCache.get(domainname.toLowerCase());
        if (orgdn != null) {
            return orgdn;
        }
        String searchFilter = AMSearchFilterManager.getSearchFilter(2, null, orgSearchTemplate, false);
        if (orgSearchTemplate != null && searchFilter.indexOf("%V") > -1) {
            searchFilter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), searchFilter, domainname);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("(|(&").append(searchFilter).append("(").append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(domainname).append(")").append(")(&").append(searchFilter).append("(").append("sunPreferredDomain=").append(domainname).append(")").append(")(&").append(searchFilter).append("(").append("associatedDomain=").append(domainname).append(")").append(")(&").append(searchFilter).append("(").append("sunOrganizationAlias=").append(domainname).append(")").append("))");
            searchFilter = sb.toString();
        }
        if (debug.messageEnabled()) {
            debug.message("AMSC:getOrgDN-> using searchfilter " + searchFilter);
        }
        if ((orgSet = this.dsServices.search(this.token, rootSuffix, searchFilter, 2)) == null || orgSet.size() > 1 || orgSet.isEmpty()) {
            Object[] args = new Object[]{domainname};
            String locale = AMCommonUtils.getUserLocale(this.token);
            throw new AMException(AMSDKBundle.getString("971", args, locale), "971", args);
        }
        Iterator it = orgSet.iterator();
        orgdn = (String)it.next();
        AMStoreConnection.addToOrgMapCache(this.token, orgdn);
        return orgdn;
    }

    public AMOrganizationalUnit getOrganizationalUnit(String orgUnitDN) throws SSOException {
        AMOrganizationalUnitImpl organizationalUnit = new AMOrganizationalUnitImpl(this.token, orgUnitDN);
        return organizationalUnit;
    }

    public AMPeopleContainer getPeopleContainer(String peopleContainerDN) throws SSOException {
        AMPeopleContainerImpl peopleContainer = new AMPeopleContainerImpl(this.token, peopleContainerDN);
        return peopleContainer;
    }

    public AMTemplate getPolicyTemplate(String templateDN) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public String getPropertiesViewBeanURL(String serviceName) throws AMException {
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, this.token);
            return scm.getPropertiesViewBeanURL();
        }
        catch (SSOException so) {
            debug.error("AMStoreConnection.getPropertiesViewBeanURL(): ", (Throwable)((Object)so));
            throw new AMException(AMSDKBundle.getString("902", this.locale), "902");
        }
        catch (SMSException se) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("910", this.locale), "910");
        }
    }

    public AMResource getResource(String resourceDN) throws SSOException {
        AMResourceImpl res = new AMResourceImpl(this.token, resourceDN);
        return res;
    }

    public AMRole getRole(String roleDN) throws SSOException {
        AMRoleImpl role = new AMRoleImpl(this.token, roleDN);
        return role;
    }

    public AMSchema getSchema(String serviceName, AMSchema.Type schemaType) throws AMException {
        throw new UnsupportedOperationException();
    }

    public Set getSchemaTypes(String serviceName) throws AMException {
        throw new UnsupportedOperationException();
    }

    public Set getServiceHierarchy() throws AMException {
        try {
            HashSet<String> retSet = new HashSet<String>();
            ServiceManager sm = new ServiceManager(this.token);
            Set serviceNames = sm.getServiceNames();
            Iterator itr = serviceNames.iterator();
            while (itr.hasNext()) {
                String st = (String)itr.next();
                ServiceSchemaManager scm = new ServiceSchemaManager(st, this.token);
                String sh = scm.getServiceHierarchy();
                if (sh == null || sh.length() == 0) continue;
                retSet.add(sh);
            }
            return retSet;
        }
        catch (SSOException so) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)((Object)so));
            throw new AMException(AMSDKBundle.getString("902", this.locale), "902");
        }
        catch (SMSException se) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("905", this.locale), "905");
        }
    }

    public Set getServiceNames() throws AMException {
        try {
            ServiceManager sm = new ServiceManager(this.token);
            return sm.getServiceNames();
        }
        catch (SSOException so) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)((Object)so));
            throw new AMException(AMSDKBundle.getString("902", this.locale), "902");
        }
        catch (SMSException se) {
            debug.error("AMStoreConnection.getServiceNames(): ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("906", this.locale), "906");
        }
    }

    public AMStaticGroup getStaticGroup(String groupDN) throws SSOException {
        AMStaticGroupImpl group = new AMStaticGroupImpl(this.token, groupDN);
        return group;
    }

    public Set getTopLevelContainers() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsServices.getTopLevelContainers(this.token);
    }

    public Set getTopLevelOrganizations() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        return this.dsServices.search(this.token, rootSuffix, AMSearchFilterManager.getGlobalSearchFilter(2), 1);
    }

    public AMUser getUser(String userDN) throws SSOException {
        AMUserImpl user = new AMUserImpl(this.token, userDN);
        return user;
    }

    public AMEntity getEntity(String eDN) throws SSOException {
        AMEntityImpl entity = null;
        try {
            entity = new AMEntityImpl(this.token, eDN, this.getAMObjectType(eDN));
        }
        catch (AMException ame) {
            entity = new AMEntityImpl(this.token, eDN);
        }
        return entity;
    }

    public boolean isValidEntry(String dn) throws SSOException {
        if (!DN.isDN((String)dn)) {
            return false;
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.isValidEntry(): DN=" + dn);
        }
        return this.dsServices.doesEntryExists(this.token, dn);
    }

    public AMOrganization createTopOrganization(String orgName, Map avPairs) throws AMException, SSOException {
        StringBuffer orgDNSB = new StringBuffer();
        orgDNSB.append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(orgName).append(",").append(rootSuffix);
        AMOrganizationImpl orgImpl = new AMOrganizationImpl(this.token, orgDNSB.toString());
        orgImpl.setAttributes(avPairs);
        orgImpl.create();
        return orgImpl;
    }

    public void purge(String domainName, int graceperiod) throws AMException, SSOException {
        Set orgSet;
        String orgDN;
        boolean deleted = false;
        if (AMDCTree.isRequired()) {
            orgDN = AMDCTree.getOrganizationDN(this.token, domainName);
            orgSet = new HashSet<String>();
            orgSet.add(orgDN);
        } else {
            String filter = AMCompliance.getDeletedObjectFilter(2);
            filter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), filter, domainName);
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purgeOrg: Using org filter= " + filter);
            }
            if ((orgSet = this.dsServices.search(this.token, rootSuffix, filter, 2)) == null || orgSet.isEmpty()) {
                orgSet = this.getOrganizations(domainName, null);
                deleted = false;
            } else {
                deleted = true;
            }
        }
        if (orgSet == null || orgSet.isEmpty()) {
            return;
        }
        Iterator delIter = orgSet.iterator();
        while (delIter.hasNext()) {
            int entryRDNs;
            Set deletedObjs;
            orgDN = (String)delIter.next();
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: Organization= " + orgDN);
            }
            AMOrganization org = this.getOrganization(orgDN);
            if (deleted && graceperiod < AMStoreConnection.daysSinceModified(this.token, orgDN)) {
                org.purge(true, -1);
                continue;
            }
            String filter = AMCompliance.getDeletedObjectFilter(-1);
            if (debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: Searching deleted objects. Filter: " + filter);
            }
            if ((deletedObjs = this.dsServices.search(this.token, orgDN, filter, 2)) == null && debug.messageEnabled()) {
                debug.message("AMStoreConnection.purge: No objects to be deleted found for " + orgDN);
            }
            Iterator iter = deletedObjs.iterator();
            ArrayList<DN> list = new ArrayList<DN>();
            int maxRDNCount = entryRDNs = new DN(orgDN).countRDNs();
            while (iter.hasNext()) {
                String thisDN = (String)iter.next();
                DN dn = new DN(thisDN);
                int count = dn.countRDNs();
                if (count > maxRDNCount) {
                    maxRDNCount = count;
                }
                list.add(dn);
            }
            int len = list.size();
            for (int i = maxRDNCount; i >= entryRDNs; --i) {
                for (int j = 0; j < len; ++j) {
                    DN thisdn = (DN)list.get(j);
                    if (thisdn.countRDNs() != i) continue;
                    String thisDN = thisdn.toRFCString();
                    int objType = this.getAMObjectType(thisDN);
                    if (debug.messageEnabled()) {
                        debug.message("AMStoreConnection:purgeOrg: deleting child " + thisDN);
                    }
                    try {
                        switch (objType) {
                            case 1: {
                                AMObject thisObj = this.getUser(thisDN);
                                thisObj.purge(false, graceperiod);
                                break;
                            }
                            case 12: {
                                AMObject thisObj = this.getAssignableDynamicGroup(thisDN);
                                thisObj.purge(false, graceperiod);
                                break;
                            }
                            case 11: {
                                AMObject thisObj = this.getDynamicGroup(thisDN);
                                thisObj.purge(false, graceperiod);
                                break;
                            }
                            case 9: 
                            case 10: {
                                AMObject thisObj = this.getStaticGroup(thisDN);
                                thisObj.purge(false, graceperiod);
                                break;
                            }
                            case 21: {
                                AMObject thisObj = this.getResource(thisDN);
                                thisObj.purge(false, -1);
                                break;
                            }
                            case 2: {
                                AMObject thisObj = this.getOrganization(thisDN);
                                if (new DN(thisDN).equals(new DN(orgDN))) break;
                                thisObj.purge(true, graceperiod);
                                break;
                            }
                        }
                        continue;
                    }
                    catch (AMPreCallBackException amp) {
                        debug.error("AMStoreConnection.purge: Aborting delete of: " + thisDN + " due to pre-callback exception", (Throwable)amp);
                    }
                }
            }
        }
    }

    public void purgeUser(String uid, String domainName, int graceperiod) throws AMException, SSOException {
        Set uSet;
        String orgDN = this.getOrganizationDN(domainName, null);
        String filter = AMCompliance.getDeletedObjectFilter(1);
        filter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(1), filter, uid);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted user filter= " + filter);
        }
        if ((uSet = this.dsServices.search(this.token, orgDN, filter, 2)) == null || uSet.size() > 1 || uSet.isEmpty()) {
            Object[] args = new Object[]{uid};
            throw new AMException(AMSDKBundle.getString("971", args, this.locale), "971", args);
        }
        String uDN = (String)uSet.iterator().next();
        AMUser user = this.getUser(uDN);
        user.purge(false, graceperiod);
    }

    public void purgeResource(String rid, String domainName, int graceperiod) throws AMException, SSOException {
        Set uSet;
        String orgDN = this.getOrganizationDN(domainName, null);
        String filter = AMCompliance.getDeletedObjectFilter(21);
        filter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(21), filter, rid);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted user filter= " + filter);
        }
        if ((uSet = this.dsServices.search(this.token, orgDN, filter, 2)) == null || uSet.size() > 1 || uSet.isEmpty()) {
            Object[] args = new Object[]{rid};
            throw new AMException(AMSDKBundle.getString("971", args, this.locale), "971", args);
        }
        String uDN = (String)uSet.iterator().next();
        AMResource resource = this.getResource(uDN);
        resource.purge(false, graceperiod);
    }

    public void purgeGroup(String gid, String domainName, int graceperiod) throws AMException, SSOException {
        Set gSet;
        String orgDN = this.getOrganizationDN(domainName, null);
        String filter = AMCompliance.getDeletedObjectFilter(9);
        filter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(9), filter, gid);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.purgeGroup: Using deleted group filter= " + filter);
        }
        if ((gSet = this.dsServices.search(this.token, orgDN, filter, 2)) == null || gSet.size() > 1 || gSet.isEmpty()) {
            Object[] args = new Object[]{gid};
            throw new AMException(AMSDKBundle.getString("971", args, this.locale), "971", args);
        }
        String uDN = (String)gSet.iterator().next();
        AMObject g = null;
        int type = this.getAMObjectType(uDN);
        switch (type) {
            case 9: 
            case 10: {
                g = new AMStaticGroupImpl(this.token, uDN);
                break;
            }
            case 12: {
                g = new AMAssignableDynamicGroupImpl(this.token, uDN);
                break;
            }
            case 11: {
                g = new AMDynamicGroupImpl(this.token, uDN);
                break;
            }
        }
        if (g != null) {
            g.purge(false, graceperiod);
        }
    }

    public Set getEntityTypes() {
        return AMCommonUtils.getSupportedEntityTypes();
    }

    protected String getBaseDN(ServiceConfig sc) {
        if (sc != null) {
            Map attrMap = sc.getAttributes();
            Set vals = (Set)attrMap.get("baseDN");
            if (vals == null || vals.isEmpty()) {
                return null;
            }
            Iterator it = vals.iterator();
            return (String)it.next();
        }
        return null;
    }

    protected boolean isRFC2247(ServiceConfig sc) {
        if (sc != null) {
            Map attrMap = sc.getAttributes();
            Set vals = (Set)attrMap.get("rfc2247flag");
            if (vals == null || vals.isEmpty()) {
                return false;
            }
            Iterator it = vals.iterator();
            return ((String)it.next()).equalsIgnoreCase("true");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addToOrgMapCache(SSOToken stoken, String dn) throws AMException, SSOException {
        if (dn == null || !DN.isDN((String)dn)) {
            return;
        }
        String rfcDN = dn;
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add("objectclass");
        attrNames.add("sunpreferreddomain");
        attrNames.add("associateddomain");
        attrNames.add("sunorganizationalias");
        Map attributes = AMDirectoryAccessFactory.getDirectoryServices().getAttributes(stoken, dn, attrNames, 2);
        String rdn = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
        Set prefDomain = (Set)attributes.get("sunpreferreddomain");
        Set associatedDomain = (Set)attributes.get("associateddomain");
        Set orgAlias = (Set)attributes.get("sunorganizationalias");
        Map map = orgMapCache;
        synchronized (map) {
            String value;
            Iterator itr;
            orgMapCache.put(rdn.toLowerCase(), rfcDN);
            if (prefDomain != null && prefDomain.size() == 1) {
                String preferredDomain = (String)prefDomain.iterator().next();
                orgMapCache.put(preferredDomain, rfcDN);
            }
            if (associatedDomain != null && !associatedDomain.isEmpty()) {
                itr = associatedDomain.iterator();
                while (itr.hasNext()) {
                    value = (String)itr.next();
                    orgMapCache.put(value, rfcDN);
                }
            }
            if (orgAlias != null && !orgAlias.isEmpty()) {
                itr = orgAlias.iterator();
                while (itr.hasNext()) {
                    value = (String)itr.next();
                    orgMapCache.put(value, rfcDN);
                }
            }
        }
    }

    protected static int daysSinceModified(SSOToken stoken, String entryDN) throws AMException, SSOException {
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
        ParsePosition pp = new ParsePosition(0);
        HashSet<String> attrNames = new HashSet<String>(1);
        attrNames.add("modifytimestamp");
        Map attributes = AMDirectoryAccessFactory.getDirectoryServices().getAttributes(stoken, entryDN, attrNames, -9999);
        Set values = (Set)attributes.get("modifytimestamp");
        if (values == null || values.isEmpty()) {
            return -1;
        }
        String value = (String)values.iterator().next();
        if (value == null || value.length() == 0) {
            return -1;
        }
        try {
            n = nf.parse(value);
        }
        catch (ParseException pe) {
            if (debug.warningEnabled()) {
                debug.warning("AMStoreConnection.daysSinceModified: unable to parse date: " + value + " :Returning default= -1", (Throwable)pe);
            }
            return -1;
        }
        Date d = df.parse(n.toString(), pp);
        int days = (int)(d.getTime() / 86400000L);
        if (debug.messageEnabled()) {
            debug.message("AMStoreConnection.daysSinceModified() for dn: " + entryDN + ", days: " + days + "days");
        }
        return days;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateCache(String dn, int eventType) {
        if (dn == null || !DN.isDN((String)dn)) {
            return;
        }
        String rfcDN = AMCommonUtils.formatToRFC(dn);
        switch (eventType) {
            case 1: {
                return;
            }
            case 8: {
                Map map = orgMapCache;
                synchronized (map) {
                    orgMapCache.clear();
                }
                return;
            }
            case 2: 
            case 4: {
                Map map = orgMapCache;
                synchronized (map) {
                    Iterator<Object> keys = orgMapCache.keySet().iterator();
                    HashSet<String> removeKeys = new HashSet<String>();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        String val = (String)orgMapCache.get(key);
                        if (!val.equalsIgnoreCase(rfcDN)) continue;
                        removeKeys.add(key);
                    }
                    if (removeKeys != null) {
                        keys = removeKeys.iterator();
                        while (keys.hasNext()) {
                            String removeKey = (String)keys.next();
                            orgMapCache.remove(removeKey);
                        }
                    }
                    break;
                }
            }
        }
    }

    private Set getOrganizations(String domainname, String orgSearchTemplate) throws AMException, SSOException {
        if (domainname == null) {
            return Collections.EMPTY_SET;
        }
        String searchFilter = AMSearchFilterManager.getSearchFilter(2, null, orgSearchTemplate, false);
        if (orgSearchTemplate != null && searchFilter.indexOf("%V") > -1) {
            searchFilter = AMObjectImpl.constructFilter(AMNamingAttrManager.getNamingAttr(2), searchFilter, domainname);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("(|(&(").append(AMNamingAttrManager.getNamingAttr(2)).append("=").append(domainname).append(")").append(searchFilter).append(")(&(").append("sunPreferredDomain=").append(domainname).append(")").append(searchFilter).append(")(&(").append("associatedDomain=").append(domainname).append(")").append(searchFilter).append(")(&(").append("sunOrganizationAlias=").append(domainname).append(")").append(searchFilter).append("))");
            searchFilter = sb.toString();
        }
        if (debug.messageEnabled()) {
            debug.message("AMSC:getOrgDN-> using searchfilter " + searchFilter);
        }
        Set orgSet = this.dsServices.search(this.token, rootSuffix, searchFilter, 2);
        return orgSet;
    }

    private static String orgNameToDN(String orgName) {
        if (orgName == null || orgName.length() == 0) {
            return rootSuffix;
        }
        if (DN.isDN((String)orgName)) {
            return orgName;
        }
        StringBuffer buf = new StringBuffer();
        ArrayList<String> arr = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(orgName, "/");
        while (strtok.hasMoreElements()) {
            arr.add(strtok.nextToken());
        }
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            String theOrg = (String)arr.get(i);
            buf.append(AMNamingAttrManager.getNamingAttr(2));
            buf.append('=').append(theOrg).append(',');
        }
        if (rootSuffix.length() > 0) {
            buf.append(rootSuffix);
        } else {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    static {
        orgMapCache = new AMHashMap();
        debug = AMCommonUtils.debug;
    }
}

