/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMServiceUtils {
    private static Debug debug = AMCommonUtils.debug;

    protected static Set getServiceAttributeNames(SSOToken token, String serviceName, SchemaType type) throws SMSException, SSOException {
        ServiceSchema ss;
        block3: {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
            ss = null;
            try {
                ss = ssm.getSchema(type);
            }
            catch (SMSException sme) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMServiceUtils.getServiceAttributeNames(): No schema defined for " + type);
            }
        }
        if (ss == null || type == SchemaType.POLICY) {
            return Collections.EMPTY_SET;
        }
        return ss.getAttributeSchemaNames();
    }

    protected static Set getServiceAttributesWithQualifier(SSOToken token, String serviceName) throws SMSException, SSOException {
        ServiceSchema ss;
        block4: {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
            ss = null;
            try {
                ss = ssm.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sme) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMServiceUtils.getServiceAttributesWithQualifier(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (ss == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> attrNames = new HashSet<String>();
        Set attrSchemaNames = ss.getAttributeSchemaNames();
        Iterator itr = attrSchemaNames.iterator();
        while (itr.hasNext()) {
            String attrSchemaName = (String)itr.next();
            AttributeSchema attrSchema = ss.getAttributeSchema(attrSchemaName);
            String name = attrSchemaName + " " + attrSchema.getCosQualifier();
            attrNames.add(name);
        }
        return attrNames;
    }

    public static boolean serviceHasSubSchema(SSOToken token, String serviceName, SchemaType schemaType) throws SMSException, SSOException {
        boolean schemaTypeFlg;
        block3: {
            schemaTypeFlg = false;
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                Set types = ssm.getSchemaTypes();
                if (debug.messageEnabled()) {
                    debug.message("AMServiceUtils.serviceHasSubSchema() SchemaTypes types for " + serviceName + " are: " + types);
                }
                schemaTypeFlg = types.contains(schemaType);
            }
            catch (ServiceNotFoundException ex) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("AMServiceUtils.serviceHasSubSchema() Service does not exist : " + serviceName);
            }
        }
        return schemaTypeFlg;
    }

    public static Map getServiceConfig(SSOToken token, String serviceName, SchemaType type) throws SMSException, SSOException {
        Map attrMap = null;
        if (type != SchemaType.POLICY) {
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, token);
            ServiceSchema gsc = scm.getSchema(type);
            attrMap = gsc.getAttributeDefaults();
        }
        return attrMap;
    }

    protected static ServiceConfig createOrgConfig(SSOToken token, String orgDN, String serviceName, Map avPair) throws SSOException, AMException {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, token);
            ServiceConfig sc = scm.createOrganizationConfig(orgDN, avPair);
            return sc;
        }
        catch (ServiceNotFoundException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("481", args, locale), "481", args);
        }
        catch (ServiceAlreadyExistsException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("479", args, locale), "479", args);
        }
        catch (SMSException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("482", args, locale), "482", args);
        }
    }

    public static ServiceConfig getOrgConfig(SSOToken token, String orgDN, String serviceName) throws SSOException, AMException {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, token);
            ServiceConfig sc = scm.getOrganizationConfig(orgDN, null);
            DN theOrgDN = new DN(orgDN);
            if (theOrgDN.equals(new DN(AMStoreConnection.getAMSdkBaseDN())) && sc != null) {
                Map avPair = sc.getAttributes();
                Set subConfigs = sc.getSubConfigNames();
                if (avPair.isEmpty() && (subConfigs == null || subConfigs.isEmpty())) {
                    return null;
                }
            }
            return sc;
        }
        catch (ServiceNotFoundException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("481", args, locale), "481", args);
        }
        catch (ServiceAlreadyExistsException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("479", args, locale), "479", args);
        }
        catch (SMSException ex) {
            Object[] args = new Object[]{serviceName};
            String locale = AMCommonUtils.getUserLocale(token);
            throw new AMException(AMSDKBundle.getString("482", args, locale), "482", args);
        }
    }

    static Set getServiceObjectClasses(SSOToken token, Set serviceNames) throws SSOException, AMException {
        HashSet result = new HashSet();
        try {
            Iterator it = serviceNames.iterator();
            while (it.hasNext()) {
                Map attrs;
                Set vals;
                String serviceName = (String)it.next();
                if (!AMServiceUtils.serviceHasSubSchema(token, serviceName, SchemaType.GLOBAL) || (vals = (Set)(attrs = AMServiceUtils.getServiceConfig(token, serviceName, SchemaType.GLOBAL)).get("serviceObjectClasses")) == null) continue;
                result.addAll(vals);
            }
        }
        catch (SMSException smsex) {
            debug.error("AMServiceUtils.getServiceObjectClasses() Unable to get them: ", (Throwable)smsex);
            throw new AMException(token, "161");
        }
        return result;
    }
}

