/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectClassManager;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMCommonUtils
implements AMConstants {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE = "amProfile";
    static Debug debug;
    protected static Map supportedTypes;
    protected static Map supportedEntitiesBasedOnType;
    protected static Map supportedEntitiesBasedOnName;
    protected static Map supportedNames;
    protected static Map creationtemplateMap;
    protected static Map statusAttributeMap;
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    private static final String EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR = "iplanet-am-admin-console-external-attribute-fetch-enabled";
    protected static boolean integrateLocale;
    private static Set supportedEntities;

    protected static String getUserLocale(SSOToken token) {
        try {
            String locale = token.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getUserLocale(): locale = " + locale);
            }
            return locale;
        }
        catch (SSOException ssoe) {
            debug.error("AMCommonUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet1, AttrSet attrSet2) {
        Attr attr;
        int i;
        int count;
        AttrSet retAttrSet = new AttrSet();
        if (attrSet1 != null) {
            count = attrSet1.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet1.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        if (attrSet2 != null) {
            count = attrSet2.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet2.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        return retAttrSet;
    }

    protected static Map mergeMaps(Map mapA, Map mapB) {
        if (mapA == null && mapB == null) {
            return null;
        }
        if (mapA == null || mapA.isEmpty()) {
            return mapB;
        }
        if (mapB == null || mapB.isEmpty()) {
            return mapA;
        }
        Map bigMap = mapA.size() > mapB.size() ? mapA : mapB;
        Map smallMap = mapA.size() <= mapB.size() ? mapA : mapB;
        Iterator itr = smallMap.keySet().iterator();
        while (itr.hasNext()) {
            String attrName = (String)itr.next();
            Set values = (Set)bigMap.get(attrName);
            if (values != null) {
                values.addAll((Set)smallMap.get(attrName));
                continue;
            }
            bigMap.put(attrName, (Set)smallMap.get(attrName));
        }
        return bigMap;
    }

    protected static String mapSetToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values.toString());
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    protected static String mapByteToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values);
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    protected static Set getSetCopy(Set values) {
        HashSet<String> copyValues = Collections.EMPTY_SET;
        if (!values.isEmpty()) {
            copyValues = new HashSet<String>(values.size());
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                copyValues.add(value);
            }
        }
        return copyValues;
    }

    protected static Set stringArrayToSet(String[] strs) {
        int count = strs.length;
        HashSet<String> set = count > 0 ? new HashSet<String>(count) : new HashSet();
        for (int i = 0; i < count; ++i) {
            set.add(strs[i]);
        }
        return set;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        return AMCommonUtils.attrSetToMap(attrSet, false);
    }

    protected static Map attrSetToMap(AttrSet attrSet, boolean fetchByteValues) {
        AMHashMap attributesMap = new AMHashMap(fetchByteValues);
        if (attrSet == null) {
            return attributesMap;
        }
        int attrSetSize = attrSet.size();
        if (!fetchByteValues) {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                String[] values = attr.getStringValues();
                attributesMap.put(attr.getName(), AMCommonUtils.stringArrayToSet(values));
            }
        } else {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                attributesMap.put(attr.getName(), attr.getByteValues());
            }
        }
        return attributesMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        return AMCommonUtils.mapToAttrSet(map, false);
    }

    protected static AttrSet mapToAttrSet(Map map, boolean byteValues) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!byteValues) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = (String)itr.next();
                Set set = (Set)map.get(attrName);
                String[] attrValues = set == null ? null : set.toArray(new String[set.size()]);
                attrSet.replace(new Attr(attrName, attrValues));
            }
        } else {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = (String)itr.next();
                byte[][] attrValues = (byte[][])map.get(attrName);
                attrSet.replace(new Attr(attrName, attrValues));
            }
        }
        return attrSet;
    }

    protected static String formatToRFC(String dn) {
        return new DN(dn).toRFCString().toLowerCase();
    }

    protected static String getPrincipalDN(SSOToken token) throws SSOException {
        String principalName = token.getPrincipal().getName();
        return AMCommonUtils.formatToRFC(principalName);
    }

    public static Set combineOCs(Set one, Set two) {
        if (one == null || one.isEmpty()) {
            return two;
        }
        if (two == null || two.isEmpty()) {
            return one;
        }
        HashSet<String> resultSet = new HashSet<String>();
        Iterator itr1 = one.iterator();
        while (itr1.hasNext()) {
            String value1 = (String)itr1.next();
            resultSet.add(value1.toLowerCase());
        }
        Iterator itr2 = two.iterator();
        while (itr2.hasNext()) {
            String value2 = (String)itr2.next();
            resultSet.add(value2.toLowerCase());
        }
        return resultSet;
    }

    protected static boolean isObjectClassPresent(Set objectClasses, String objectClass) {
        if (objectClasses != null && !objectClasses.isEmpty()) {
            Iterator itr = objectClasses.iterator();
            while (itr.hasNext()) {
                String serviceOC = (String)itr.next();
                if (!serviceOC.equalsIgnoreCase(objectClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set updateAndGetRemovableOCs(Set origSet, Set removeOCs) {
        HashSet<String> returnOCs = removeOCs;
        if (removeOCs != null && !removeOCs.isEmpty()) {
            returnOCs = new HashSet<String>();
            Iterator itr1 = origSet.iterator();
            block0: while (itr1.hasNext()) {
                String origOC = (String)itr1.next();
                Iterator itr2 = removeOCs.iterator();
                while (itr2.hasNext()) {
                    String removeOC = (String)itr2.next();
                    if (!origOC.equalsIgnoreCase(removeOC)) continue;
                    returnOCs.add(origOC);
                    continue block0;
                }
            }
            origSet.removeAll(returnOCs);
        }
        return returnOCs;
    }

    public static Map removeEmptyValues(Map attrMap) {
        HashMap finalMap = new HashMap();
        Iterator iter = attrMap.keySet().iterator();
        while (iter.hasNext()) {
            String tStr = (String)iter.next();
            Set s = (Set)attrMap.get(tStr);
            if (s.isEmpty()) continue;
            finalMap.put(tStr, attrMap.get(tStr));
        }
        return finalMap;
    }

    protected static boolean populateManagedObjects() {
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager scm = new ServiceConfigManager("DAI", token);
            ServiceConfig gc = scm.getGlobalConfig(null);
            Set managedObjects = gc.getSubConfigNames("*", "ManagedObjects");
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.populateManagedObjects. managedObjects=" + managedObjects);
            }
            if (managedObjects == null || managedObjects.isEmpty()) {
                return false;
            }
            Iterator mIter = managedObjects.iterator();
            while (mIter.hasNext()) {
                String mo = (String)mIter.next();
                ServiceConfig sc = gc.getSubConfig(mo = mo.toLowerCase());
                if (sc == null) continue;
                Map attrs = sc.getAttributes();
                String oc = AMCommonUtils.getValue((Set)attrs.get("objectclass"), mo);
                String ct = AMCommonUtils.getValue((Set)attrs.get("creationtemplatename"), mo);
                String st = AMCommonUtils.getValue((Set)attrs.get("searchtemplatename"), mo);
                String stAttrName = AMCommonUtils.getValue((Set)attrs.get("statusattribute"), mo);
                String serviceName = AMCommonUtils.getValue((Set)attrs.get("servicename"), mo);
                String parentRDN = AMCommonUtils.getValue((Set)attrs.get("parentcontainerdn"), mo);
                String parentType = AMCommonUtils.getValue((Set)attrs.get("parentcontainertype"), mo);
                int parentTypeInt = parentType != null && parentType.length() > 0 ? Integer.parseInt(parentType) : 2;
                String typeS = AMCommonUtils.getValue((Set)attrs.get("type"), mo);
                int type = Integer.parseInt(typeS);
                supportedTypes.put(mo, typeS);
                supportedNames.put(typeS, mo);
                if (oc != null) {
                    AMObjectClassManager.objectClassMap.put(typeS, oc);
                    AMObjectClassManager.objectTypeMap.put(oc, typeS);
                }
                if (st != null) {
                    AMSearchFilterManager.searchtemplateMap.put(typeS, st);
                }
                if (ct != null) {
                    creationtemplateMap.put(typeS, ct);
                }
                if (stAttrName != null) {
                    statusAttributeMap.put(typeS, stAttrName);
                }
                AMEntityType newType = new AMEntityType(mo, type, serviceName, st, ct, parentRDN, parentTypeInt, null, stAttrName, oc);
                supportedEntities.add(newType);
                supportedEntitiesBasedOnType.put(typeS, newType);
                supportedEntitiesBasedOnName.put(mo, newType);
            }
            if (debug.messageEnabled()) {
                debug.message("CreationTemplae MAP = " + creationtemplateMap.toString());
                debug.message("SearchTemplate Map = " + AMSearchFilterManager.searchtemplateMap.toString());
                debug.message("ObjectClass-Type Map = " + AMObjectClassManager.objectClassMap.toString());
                debug.message("Type-ObjectClass MAP = " + AMObjectClassManager.objectTypeMap.toString());
                debug.message("Supported names-type = " + supportedTypes.toString());
                debug.message("Status Attributes= " + statusAttributeMap.toString());
            }
        }
        catch (SMSException se) {
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.populateManagedObjects:  Got SMSException :", (Throwable)se);
            }
            return false;
        }
        catch (SSOException ssoe) {
            return false;
        }
        return true;
    }

    protected static Set getSupportedEntityTypes() {
        return supportedEntities;
    }

    protected static boolean isExternalGetAttributesEnabled(String orgDN) {
        Set attrVal;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfig sc = AMServiceUtils.getOrgConfig(token, orgDN, "iPlanetAMAdminConsoleService");
            if (sc != null) {
                Map attributes = sc.getAttributes();
                attrVal = (Set)attributes.get(EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            } else {
                attrVal = AMCommonUtils.getDefaultGlobalConfig(token, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            }
        }
        catch (Exception ee) {
            attrVal = AMCommonUtils.getDefaultGlobalConfig(token, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
        }
        boolean enabled = false;
        if (attrVal != null && !attrVal.isEmpty()) {
            String val = (String)attrVal.iterator().next();
            enabled = val.equalsIgnoreCase("true");
        }
        if (debug.messageEnabled()) {
            debug.message("AMCommonUtils.isExternalGetAttributeEnabled() = " + enabled);
        }
        return enabled;
    }

    private static Set getDefaultGlobalConfig(SSOToken token, String attrName) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getDefaultGlobalConfig() Organization config for service (iPlanetAMAdminConsoleService," + attrName + ") not found. Obtaining default service " + "config values ..");
            }
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (defaultValues != null) {
                    return (Set)defaultValues.get(attrName);
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMCommonUtils.getDefaultGlobalConfig(): Unable to get default global config information", (Throwable)e);
            }
        }
        return null;
    }

    protected static void populateManagedObjectsWithDefaults() {
    }

    private static String getValue(Set ocSet, String objectName) {
        if (ocSet == null || ocSet.isEmpty()) {
            return null;
        }
        return (String)ocSet.iterator().next();
    }

    static {
        block5: {
            supportedTypes = new HashMap();
            supportedEntitiesBasedOnType = new HashMap();
            supportedEntitiesBasedOnName = new HashMap();
            supportedNames = new HashMap();
            creationtemplateMap = new HashMap();
            statusAttributeMap = new HashMap();
            integrateLocale = true;
            supportedEntities = new HashSet();
            debug = Debug.getInstance((String)AM_SDK_DEBUG_FILE);
            String cCaller = SystemProperties.get(LOCALE_INTEGRATION_PROPERTY);
            if (cCaller == null || cCaller.equalsIgnoreCase("true")) {
                integrateLocale = true;
                if (debug.messageEnabled()) {
                    debug.message("AM SDK: Locale integration enabled");
                }
            } else {
                integrateLocale = false;
            }
            try {
                AMCommonUtils.populateManagedObjects();
            }
            catch (Throwable t) {
                if (!debug.messageEnabled()) break block5;
                debug.message("AMCommonUtils:Initial:  Caught exception in static block", t);
            }
        }
    }
}

