/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.saml2.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.RequestAbstractImpl;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionQuery;
import java.text.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XACMLAuthzDecisionQueryImpl
extends RequestAbstractImpl
implements XACMLAuthzDecisionQuery {
    private boolean inputContextOnly = false;
    private boolean returnContext = false;
    private Request request;
    private String xmlString;

    public XACMLAuthzDecisionQueryImpl() {
        this.isMutable = true;
    }

    public XACMLAuthzDecisionQueryImpl(Element element) throws SAML2Exception {
        this.parseDOMElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print(element);
        }
    }

    public XACMLAuthzDecisionQueryImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document != null) {
            Element rootElement = document.getDocumentElement();
            this.parseDOMElement(rootElement);
            this.xmlString = xml;
            if (this.isSigned) {
                this.signedXMLString = xml;
            }
        } else {
            XACMLSDKUtils.debug.error("XACMLAuthzDecisionQueryImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
    }

    public boolean getInputContextOnly() {
        return this.inputContextOnly;
    }

    public void setInputContextOnly(boolean inputContextOnly) throws XACMLException {
        this.inputContextOnly = inputContextOnly;
    }

    public boolean getReturnContext() {
        return this.returnContext;
    }

    public void setReturnContext(boolean returnContext) throws XACMLException {
        this.returnContext = returnContext;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) throws XACMLException {
        if (request == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.request = request;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        StringBuffer sb = new StringBuffer(1000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (declareNS) {
            nsDeclaration = XACMLConstants.SAMLP_NS_DECLARATION;
        }
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.SAMLP_NS_PREFIX;
        }
        sb.append("\n<").append(XACMLConstants.SAMLP_NS_PREFIX).append(XACMLConstants.REQUEST_ABSTRACT).append(XACMLConstants.SAMLP_NS_DECLARATION).append(" xsi:type=\"xacml-samlp:XACMLAuthzDecisionQuery\"").append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append(XACMLConstants.XACML_SAMLP_NS_DECLARATION).append(XACMLConstants.SPACE).append(XACMLConstants.XACML_SAMLP_NS_PREFIX).append(XACMLConstants.INPUT_CONTEXT_ONLY).append("=").append(XACMLSDKUtils.quote(Boolean.toString(this.inputContextOnly))).append(XACMLConstants.SPACE).append(XACMLConstants.XACML_SAMLP_NS_PREFIX).append(XACMLConstants.RETURN_CONTEXT).append("=").append(XACMLSDKUtils.quote(Boolean.toString(this.returnContext))).append(XACMLConstants.SPACE).append("ID").append("=").append(XACMLSDKUtils.quote(this.requestId)).append(XACMLConstants.SPACE).append("Version").append("=").append(XACMLSDKUtils.quote(this.version)).append(XACMLConstants.SPACE).append("IssueInstant").append("=").append(XACMLSDKUtils.quote(DateUtils.toUTCDateFormat(this.issueInstant)));
        if (this.destinationURI != null && this.destinationURI.trim().length() != 0) {
            sb.append(" Destination=\"").append(this.destinationURI).append("\"");
        }
        if (this.consent != null && this.consent.trim().length() != 0) {
            sb.append(" Consent=\"").append(this.consent).append("\"");
        }
        sb.append(">\n");
        try {
            if (this.nameID != null) {
                sb.append(this.nameID.toXMLString(includeNSPrefix, declareNS));
            }
            if (this.signatureString != null) {
                sb.append(this.signatureString);
            }
            if (this.extensions != null) {
                sb.append(this.extensions.toXMLString(includeNSPrefix, declareNS));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.request != null) {
            sb.append(this.request.toXMLString(true, true)).append("\n");
        }
        sb.append("\n</").append(XACMLConstants.SAMLP_NS_PREFIX).append(XACMLConstants.REQUEST_ABSTRACT).append(">\n");
        return sb.toString();
    }

    protected void parseDOMElement(Element element) throws SAML2Exception {
        String inputContextOnlyString;
        Object value = null;
        if (element == null) {
            XACMLSDKUtils.debug.error("XACMLAuthzDecisionQueryImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        if (!element.getLocalName().equals(XACMLConstants.REQUEST_ABSTRACT)) {
            XACMLSDKUtils.debug.error("XACMLAuthzDecisionQueryImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        ContextFactory factory = ContextFactory.getInstance();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 && node.getNodeType() != 2 || !node.getLocalName().equals(XACMLConstants.REQUEST) || this.request != null) continue;
            this.request = factory.getInstance().createRequest((Element)node);
        }
        if (this.request == null) {
            // empty if block
        }
        System.out.println("ReturnContex:" + element.getAttributeNS(XACMLConstants.XACML_SAMLP_NS_URI, XACMLConstants.RETURN_CONTEXT));
        System.out.println("InputContextOnly:" + element.getAttributeNS(XACMLConstants.XACML_SAMLP_NS_URI, XACMLConstants.INPUT_CONTEXT_ONLY));
        String returnContextString = element.getAttributeNS(XACMLConstants.XACML_SAMLP_NS_URI, XACMLConstants.RETURN_CONTEXT);
        if (returnContextString != null) {
            this.returnContext = Boolean.valueOf(returnContextString);
        }
        if ((inputContextOnlyString = element.getAttributeNS(XACMLConstants.XACML_SAMLP_NS_URI, XACMLConstants.INPUT_CONTEXT_ONLY)) != null) {
            this.inputContextOnly = Boolean.valueOf(inputContextOnlyString);
        }
        NamedNodeMap attrs = element.getAttributes();
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)atts.item(i);
                String attrName = attr.getName();
                String attrValue = attr.getValue().trim();
                if (attrName.equals("ID")) {
                    this.requestId = attrValue;
                    continue;
                }
                if (attrName.equals("Version")) {
                    this.version = attrValue;
                    continue;
                }
                if (attrName.equals("IssueInstant")) {
                    try {
                        this.issueInstant = DateUtils.stringToDate(attrValue);
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new XACMLException(pe.getMessage());
                    }
                }
                if (!attrName.equals("Destination")) continue;
                this.destinationURI = attrValue;
            }
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Issuer")) {
                if (this.nameID != null) {
                    if (XACMLSDKUtils.debug.messageEnabled()) {
                        XACMLSDKUtils.debug.message("ArtifactResolveImpl.parseElement: included more than one Issuer.");
                    }
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_duplicate_element"));
                }
                if (this.signatureString != null || this.extensions != null) {
                    if (XACMLSDKUtils.debug.messageEnabled()) {
                        XACMLSDKUtils.debug.message("ArtifactResolveImpl.parseElement:wrong sequence.");
                    }
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("schemaViolation"));
                }
                this.nameID = AssertionFactory.getInstance().createIssuer((Element)child);
                continue;
            }
            if (childName.equals("Signature")) {
                if (this.signatureString != null) {
                    if (XACMLSDKUtils.debug.messageEnabled()) {
                        XACMLSDKUtils.debug.message("ArtifactResolveImpl.parseElement:included more than one Signature.");
                    }
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_duplicate_element"));
                }
                if (this.extensions != null) {
                    if (XACMLSDKUtils.debug.messageEnabled()) {
                        XACMLSDKUtils.debug.message("ArtifactResolveImpl.parseElement:wrong sequence.");
                    }
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("schemaViolation"));
                }
                this.signatureString = XMLUtils.print((Element)child);
                this.isSigned = true;
                continue;
            }
            if (childName.equals("Extensions")) {
                if (this.extensions != null) {
                    if (XACMLSDKUtils.debug.messageEnabled()) {
                        XACMLSDKUtils.debug.message("ArtifactResolveImpl.parseElement:included more than one Extensions.");
                    }
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_duplicate_element"));
                }
                this.extensions = ProtocolFactory.getInstance().createExtensions((Element)child);
                continue;
            }
            if (childName.equals("Request")) continue;
            if (XACMLSDKUtils.debug.messageEnabled()) {
                XACMLSDKUtils.debug.message("XACMLAuthzDecisionQueryImpl.parseDOMElementElement: Invalid element:" + childName);
            }
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalidElement"));
        }
        this.validateData();
    }

    public void makeImmutable() {
    }

    protected void validateData() throws SAML2Exception {
        super.validateData();
    }
}

