/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.StatusMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StatusMessageImpl
implements StatusMessage {
    private boolean mutable = true;
    private String value = null;

    public StatusMessageImpl() throws XACMLException {
    }

    public StatusMessageImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public StatusMessageImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (value == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        if (!XACMLSDKUtils.isValidStatusMessage(value)) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
        }
        this.value = value;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsDeclaration = "";
        String nsPrefix = "";
        if (declareNS) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_DECLARATION;
        }
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(nsPrefix).append("StatusMessage").append(nsDeclaration).append(">").append(this.value).append("</").append(nsPrefix).append("StatusMessage").append(">\n");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("StatusMessage")) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        String elementValue = element.getTextContent();
        if (elementValue == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        if (!XACMLSDKUtils.isValidStatusMessage(elementValue.trim())) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
        }
        this.value = elementValue;
    }
}

