/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryClient;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.handler.SOAPRequestHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageProcessor {
    private ProviderConfig _config = null;
    private String correlationId = null;

    private MessageProcessor() {
    }

    public MessageProcessor(ProviderConfig config) {
        this._config = config;
    }

    public Object validateRequest(SOAPMessage soapMessage, Subject subject, Map sharedData, HttpServletRequest httpRequest) throws SOAPBindingException {
        WSSUtils.debug.message("SOAPProvider.validateRequest : Init");
        Message req = null;
        try {
            req = new Message(soapMessage);
            sharedData.put("LibertyRequest", req);
            if (req.getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage(req)) {
                WSSUtils.debug.error("MessageProcessor.validateRequest: SignatureVerification failed.");
                throw new SOAPBindingException(WSSUtils.bundle.getString("cannotVerifySignature"));
            }
            Utils.enforceProcessingRules(req, null, true);
            if (this._config != null) {
                String authMech = req.getAuthenticationMechanism();
                if (authMech == null || !this._config.getSecurityMechanisms().contains(authMech)) {
                    throw new SOAPBindingException(WSSUtils.bundle.getString("unsupportedAuthMech"));
                }
            } else {
                throw new SOAPBindingException(WSSUtils.bundle.getString("nullConfiguration"));
            }
            return SOAPRequestHandler.getAuthenticator().authenticate(subject, null, null, this._config, req, true);
        }
        catch (SecurityException se) {
            WSSUtils.debug.error("MessageProcessor.validateRequest: RequestValidation has failed.", se);
            throw new SOAPBindingException(se.getMessage());
        }
        catch (Exception sfe) {
            WSSUtils.debug.error("MessageProcessor.validateRequest: SOAPFaultException.", sfe);
            throw new SOAPBindingException(sfe.getMessage());
        }
    }

    public SOAPMessage secureResponse(SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        WSSUtils.debug.message("MessageProcessor.secureResponse : Init");
        try {
            Message req = (Message)sharedData.get("LibertyRequest");
            this.addCorrelationHeader(soapMessage, req);
            if (this._config.isResponseSignEnabled()) {
                soapMessage = this.signMessage(soapMessage, null, null);
            }
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("MessageProcessor.secureResponse: " + XMLUtils.print((Node)soapMessage.getSOAPPart().getEnvelope()));
            }
            return soapMessage;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.secureResponse: Failed in securing the response", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("secureResponseFailed"));
        }
    }

    public SOAPMessage secureRequest(ResourceOffering offering, List credentials, String serviceType, SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        WSSUtils.debug.message("MessageProcessor.secureRequest:Init");
        try {
            List offerings;
            SOAPHeader header = this.addCorrelationHeader(soapMessage, null);
            QueryResponse discoResponse = this.getWebserviceOffering(offering, credentials, serviceType);
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("MessageProcessor.secureRequest: Discovery Response: " + discoResponse.toString());
            }
            if ((offerings = discoResponse.getResourceOffering()) == null || offerings.size() == 0) {
                WSSUtils.debug.error("MessageProcessor.secureRequest:: service offerings are null.");
                throw new SOAPBindingException(WSSUtils.bundle.getString("noServiceOfferings"));
            }
            ResourceOffering serviceOffering = (ResourceOffering)discoResponse.getResourceOffering().get(0);
            List creds = discoResponse.getCredentials();
            String securityProfile = this.processResourceOffering(serviceOffering);
            SecurityAssertion securityAssertion = null;
            if ((securityProfile.equals("urn:liberty:security:2003-08:null:SAML") || securityProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2004-04:null:Bearer") || securityProfile.equals("urn:liberty:security:2004-04:TLS:Bearer") || securityProfile.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:null:SAML") || securityProfile.equals("urn:liberty:security:2005-02:TLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:null:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:TLS:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) && creds != null && creds.size() != 0) {
                securityAssertion = (SecurityAssertion)creds.get(0);
                securityAssertion.addToParent((Element)header);
            }
            if (securityProfile.equals("urn:liberty:security:2003-08:null:SAML") || securityProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:null:X509") || securityProfile.equals("urn:liberty:security:2003-08:TLS:X509") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || securityProfile.equals("urn:liberty:security:2005-02:null:SAML") || securityProfile.equals("urn:liberty:security:2005-02:TLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:null:X509") || securityProfile.equals("urn:liberty:security:2005-02:TLS:X509") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                soapMessage = this.signMessage(soapMessage, securityProfile, securityAssertion);
            }
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("MessageProcessor.secureRequest: " + XMLUtils.print((Node)soapMessage.getSOAPPart().getEnvelope()));
            }
            return soapMessage;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.secureRequest: Failure in Securing the request.", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("secureRequestFailed"));
        }
    }

    public SOAPMessage validateResponse(SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        try {
            Message msg = new Message(soapMessage);
            if (this._config.isResponseSignEnabled() && !SecurityUtils.verifyMessage(msg)) {
                throw new SOAPBindingException(WSSUtils.bundle.getString("cannotVerifySignature"));
            }
            Utils.enforceProcessingRules(msg, null, true);
            return soapMessage;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.validateResponse:  Response validation failed.", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("validateResponseFailed"));
        }
    }

    private SOAPMessage signMessage(SOAPMessage soapMessage, String profile, SecurityAssertion assertion) throws SOAPBindingException {
        try {
            SOAPBody soapBody;
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (soapHeader == null) {
                soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            if ((soapBody = soapMessage.getSOAPPart().getEnvelope().getBody()) == null) {
                throw new SOAPBindingException(WSSUtils.bundle.getString("nullSOAPBody"));
            }
            String bodyId = SAMLUtils.generateID();
            soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", bodyId);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(bodyId);
            if (this.correlationId != null) {
                ids.add(this.correlationId);
            }
            Certificate cert = null;
            Element sigElem = null;
            ByteArrayInputStream bin = null;
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            Document doc = null;
            if (profile == null || profile.equals("urn:liberty:security:2003-08:null:X509") || profile.equals("urn:liberty:security:2003-08:TLS:X509") || profile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || profile.equals("urn:liberty:security:2005-02:null:X509") || profile.equals("urn:liberty:security:2005-02:TLS:X509") || profile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                BinarySecurityToken binaryToken = this.addBinaryToken(soapMessage);
                cert = SecurityUtils.getCertificate(binaryToken);
                soapMessage.writeTo((OutputStream)bop);
                bin = new ByteArrayInputStream(bop.toByteArray());
                doc = XMLUtils.toDOMDocument(bin, WSSUtils.debug);
                sigElem = SecurityUtils.getSignatureManager().signWithWSSX509TokenProfile(doc, cert, "", ids, "1.1");
            } else if (profile.equals("urn:liberty:security:2003-08:null:SAML") || profile.equals("urn:liberty:security:2003-08:TLS:SAML") || profile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || profile.equals("urn:liberty:security:2005-02:null:SAML") || profile.equals("urn:liberty:security:2005-02:TLS:SAML") || profile.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                cert = SecurityUtils.getCertificate(assertion);
                soapMessage.writeTo((OutputStream)bop);
                new ByteArrayInputStream(bop.toByteArray());
                bin = new ByteArrayInputStream(bop.toByteArray());
                doc = XMLUtils.toDOMDocument(bin, WSSUtils.debug);
                sigElem = SecurityUtils.getSignatureManager().signWithWSSSAMLTokenProfile(doc, cert, assertion.getAssertionID(), "", ids, "1.1");
            }
            if (sigElem == null) {
                WSSUtils.debug.error("MessageProcessor.signMessage: SigElement is null");
                throw new SOAPBindingException(WSSUtils.bundle.getString("cannotSignMessage"));
            }
            Element securityHeader = this.getSecurityHeader(soapMessage);
            securityHeader.appendChild(securityHeader.getOwnerDocument().importNode(sigElem, true));
            return Utils.DocumentToSOAPMessage(sigElem.getOwnerDocument());
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.signMessage: Signing failed.", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("cannotSignMessage"));
        }
    }

    private SOAPHeader addCorrelationHeader(SOAPMessage msg, Message req) throws SOAPBindingException {
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                header = msg.getSOAPPart().getEnvelope().addHeader();
            }
            CorrelationHeader cHeader = new CorrelationHeader();
            this.correlationId = cHeader.getId();
            if (req != null) {
                cHeader.setRefToMessageID(req.getCorrelationHeader().getMessageID());
            }
            cHeader.addToParent((Element)header);
            return header;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.addCorrealtionHeader: Could not add correlation header", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("canotAddCorrelationHeader"));
        }
    }

    private BinarySecurityToken addBinaryToken(SOAPMessage msg) throws SOAPBindingException {
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                header = msg.getSOAPPart().getEnvelope().addHeader();
            }
            SecurityTokenManager manager = new SecurityTokenManager(MessageProcessor.getAdminToken());
            BinarySecurityToken binaryToken = manager.getX509CertificateToken();
            binaryToken.setWSFVersion("1.1");
            binaryToken.addToParent((Element)header);
            return binaryToken;
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.addBinaryToken: Could not add binary security token", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("cannotAddCorrelationHeader"));
        }
    }

    private QueryResponse getWebserviceOffering(ResourceOffering offering, List credentials, String serviceType) throws SOAPBindingException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(serviceType);
        try {
            DiscoveryClient client = new DiscoveryClient(offering, MessageProcessor.getAdminToken(), null, credentials);
            return client.getResourceOffering(list);
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.getWebserviceOffering : Failed in discovery query.", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("discoveryQueryFailed"));
        }
    }

    private String processResourceOffering(ResourceOffering offering) throws SOAPBindingException {
        try {
            ServiceInstance si = offering.getServiceInstance();
            List descriptions = si.getDescription();
            if (descriptions == null || descriptions.isEmpty()) {
                WSSUtils.debug.error("MessageProcessor:processResourceOffering:descriptions are null.");
                throw new SOAPBindingException(WSSUtils.bundle.getString("noDescriptions"));
            }
            Iterator iter = descriptions.iterator();
            if (iter.hasNext()) {
                Description desc = (Description)iter.next();
                List secMechIDs = desc.getSecurityMechID();
                if (secMechIDs == null || secMechIDs.isEmpty()) {
                    WSSUtils.debug.error("MessageProcessor.processResourceOffering: security Mechs are empty");
                    throw new SOAPBindingException(WSSUtils.bundle.getString("noSecurityMechs"));
                }
                return (String)secMechIDs.iterator().next();
            }
            throw new SOAPBindingException(WSSUtils.bundle.getString("noSecurityMechs"));
        }
        catch (Exception ex) {
            WSSUtils.debug.error("MessageProcessor.processResourceOffering: Failed in processing the resource offering.", ex);
            throw new SOAPBindingException(WSSUtils.bundle.getString("processOfferingFailed"));
        }
    }

    private static SSOToken getAdminToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private Element getSecurityHeader(SOAPMessage soapMessage) throws SOAPBindingException {
        try {
            SOAPHeader header = soapMessage.getSOAPPart().getEnvelope().getHeader();
            NodeList headerChildNodes = header.getChildNodes();
            if (headerChildNodes == null || headerChildNodes.getLength() == 0) {
                throw new SOAPBindingException(WSSUtils.bundle.getString("noSecurityHeader"));
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1 || !"Security".equals(currentNode.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentNode.getNamespaceURI())) continue;
                return (Element)currentNode;
            }
            return null;
        }
        catch (SOAPException se) {
            WSSUtils.debug.error("MessageProcess.getSecurityHeader:: SOAPException", se);
            throw new SOAPBindingException(WSSUtils.bundle.getString("noSecurityHeader"));
        }
    }
}

