/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reference {
    private String uri = null;
    private String valueType = null;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static Debug debug = WSSUtils.debug;

    public Reference(String uri) {
        this.uri = uri;
    }

    public Reference(Element element) throws SecurityException {
        if (element == null) {
            throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
        }
        if (!"Reference".equals(element.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(element.getNamespaceURI())) {
            debug.error("Reference: Invalid element");
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        this.uri = element.getAttribute("URI");
        this.valueType = element.getAttribute("ValueType");
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void addToParent(Element parent) throws SecurityException {
        try {
            if (parent == null) {
                throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
            }
            Document doc = parent.getOwnerDocument();
            Element reference = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
            reference.setPrefix("wsse");
            if (this.uri == null) {
                throw new SecurityException(bundle.getString("invalidReference"));
            }
            reference.setAttributeNS(null, "URI", this.uri);
            if (this.valueType != null) {
                reference.setAttributeNS(null, "ValueType", this.valueType);
            }
            parent.appendChild(reference);
        }
        catch (Exception ex) {
            debug.error("Reference.addToParent:: can not add to parent", ex);
            throw new SecurityException(bundle.getString("cannotAddElement"));
        }
    }
}

