/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider;

import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.DiscoveryConfig;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.provider.plugins.DiscoveryAgent;
import com.sun.identity.wss.provider.plugins.STSAgent;
import com.sun.identity.wss.security.WSSUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class ProviderUtils {
    static ResourceBundle bundle = null;
    private static final String AGENT_CONFIG_ATTR = "AgentType";
    public static Debug debug = Debug.getInstance("fmWSSProvider");

    public static List getAllSTSConfig() {
        ArrayList<STSAgent> stsConfigs = new ArrayList<STSAgent>();
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add("STSAgent");
            kvPairMap.put(AGENT_CONFIG_ATTR, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            for (AMIdentity provider : agents) {
                STSAgent stsConfig = new STSAgent(provider);
                stsConfigs.add(stsConfig);
            }
        }
        catch (Exception e) {
            debug.error("ProviderUtils.getAllSTSConfig:ERROR: ", e);
        }
        return stsConfigs;
    }

    public static List getAllDiscoveryConfig() {
        ArrayList<DiscoveryAgent> discoConfigs = new ArrayList<DiscoveryAgent>();
        try {
            SSOToken adminToken = WSSUtils.getAdminToken();
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add("DiscoveryAgent");
            kvPairMap.put(AGENT_CONFIG_ATTR, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            for (AMIdentity provider : agents) {
                DiscoveryAgent discoConfig = new DiscoveryAgent(provider);
                discoConfigs.add(discoConfig);
            }
        }
        catch (Exception e) {
            debug.error("ProviderUtils.getAllDiscoSConfig:ERROR: ", e);
        }
        return discoConfigs;
    }

    public static STSConfig getLocalSTSConfig() {
        STSAgent stsConfig = new STSAgent();
        stsConfig.setName("defaultSTS");
        stsConfig.setType("STSAgent");
        stsConfig.setEndpoint(ProviderUtils.getLocalSTSEndpoint());
        stsConfig.setMexEndpoint(ProviderUtils.getLocalSTSMexEndpoint());
        ArrayList<String> secMech = new ArrayList<String>();
        secMech.add("urn:sun:wss:security:null:X509Token");
        stsConfig.setSecurityMechs(secMech);
        return stsConfig;
    }

    public static DiscoveryConfig getLocalDiscoveryConfig() {
        return null;
    }

    private static String getLocalSTSEndpoint() {
        String protocol = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol");
        String host = SystemConfigurationUtil.getProperty("com.iplanet.am.server.host");
        String port = SystemConfigurationUtil.getProperty("com.iplanet.am.server.port");
        String deployuri = SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor");
        return protocol + "://" + host + ":" + port + deployuri + "/sts";
    }

    private static String getLocalSTSMexEndpoint() {
        return ProviderUtils.getLocalSTSEndpoint() + "/mex";
    }

    static {
        bundle = Locale.getInstallResourceBundle("fmWSSProvider");
    }
}

