/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AuthenticationServiceNameProvider;
import com.sun.identity.sm.AuthenticationServiceNameProviderFactory;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceManager {
    private static boolean initialized;
    private static boolean loadedAuthServices;
    protected static final String serviceDN;
    protected static final String COEXISTENCE_ATTR_NAME = "coexistenceMode";
    protected static final String REALM_ATTR_NAME = "realmMode";
    public static final String REALM_SERVICE = "sunidentityrepositoryservice";
    protected static final String DEFAULT_SERVICES_FOR_REALMS = "serviceNamesForAutoAssignment";
    protected static final String SERVICE_VERSION = "1.0";
    protected static final String REALM_ENTRY;
    protected static final String PLATFORM_SERVICE = "iPlanetAMPlatformService";
    protected static final String ATTR_SERVER_LIST = "iplanet-am-platform-server-list";
    private static boolean realmCache;
    private static boolean coexistenceCache;
    private static boolean ditUpgradedCache;
    protected static Set defaultServicesToLoad;
    private static final String SERVICE_OC_ATTR_NAME = "serviceObjectClasses";
    private static final String ALL_SERVICES = "null";
    private static Map serviceNameAndOCs;
    private static Map schemaAndServiceNames;
    protected static SMSEntry smsEntry;
    protected static CachedSubEntries serviceNames;
    protected static HashMap serviceVersions;
    protected static HashMap serviceNameDefaultVersion;
    protected static Set accessManagerServers;
    private SSOToken token;
    private CachedSubEntries subEntries = null;
    protected HashMap serviceSchemaMgrs = new HashMap();
    protected HashMap serviceConfigMgrs = new CaseInsensitiveHashMap();
    protected HashMap organizationConfigMgrs = new CaseInsensitiveHashMap();
    private static Debug debug;

    public ServiceManager(SSOToken token) throws SSOException, SMSException {
        ServiceManager.initialize(token);
        SSOTokenManager.getInstance().validateToken(token);
        this.token = token;
    }

    public ServiceSchemaManager getSchemaManager(String serviceName, String version) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String cacheName = ServiceManager.getCacheIndex(serviceName, version);
        ServiceSchemaManager ssm = (ServiceSchemaManager)this.serviceSchemaMgrs.get(cacheName);
        if (ssm == null) {
            ssm = new ServiceSchemaManager(this.token, serviceName, version);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceSchemaMgrs.put(cacheName, ssm);
            }
        }
        return ssm;
    }

    public ServiceConfigManager getConfigManager(String serviceName, String version) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String cacheName = ServiceManager.getCacheIndex(serviceName, version);
        ServiceConfigManager scm = (ServiceConfigManager)this.serviceConfigMgrs.get(cacheName);
        if (scm == null) {
            scm = new ServiceConfigManager(this.token, serviceName, version);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceConfigMgrs.put(cacheName, scm);
            }
        }
        return scm;
    }

    public OrganizationConfigManager getOrganizationConfigManager(String orgName) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        OrganizationConfigManager ocm = (OrganizationConfigManager)this.organizationConfigMgrs.get(orgName);
        if (ocm == null) {
            ocm = new OrganizationConfigManager(this.token, orgName);
            if (SMSEntry.cacheSMSEntries) {
                this.organizationConfigMgrs.put(orgName, ocm);
            }
        }
        return ocm;
    }

    public Set getServiceNames() throws SMSException {
        try {
            if (serviceNames == null) {
                serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
            }
            return serviceNames.getSubEntries(this.token);
        }
        catch (SSOException s) {
            debug.error("ServiceManager: Unable to get service names", s);
            throw new SMSException(s, "sms-service-not-found");
        }
    }

    public Map getServiceNamesAndOCs() {
        return this.getServiceNamesAndOCs(null);
    }

    public Map getServiceNamesAndOCs(String schemaType) {
        HashMap answer;
        block12: {
            if (schemaType == null) {
                schemaType = ALL_SERVICES;
            } else if (schemaType.equalsIgnoreCase("realm")) {
                schemaType = "filteredrole";
            }
            answer = (HashMap)serviceNameAndOCs.get(schemaType);
            if (answer == null) {
                try {
                    answer = new HashMap();
                    Set serviceNames = this.getServiceNames();
                    if (serviceNames != null && !serviceNames.isEmpty()) {
                        Iterator it = serviceNames.iterator();
                        while (it.hasNext()) {
                            try {
                                Map attrs;
                                ServiceSchemaImpl ss;
                                String service = (String)it.next();
                                ServiceSchemaManagerImpl ssm = ServiceSchemaManagerImpl.getInstance(this.token, service, ServiceManager.serviceDefaultVersion(this.token, service));
                                if (ssm == null || schemaType != ALL_SERVICES && ssm.getSchema(new SchemaType(schemaType)) == null && (schemaType.equalsIgnoreCase("User") && ssm.getSchema(SchemaType.DYNAMIC) == null || schemaType.toLowerCase().indexOf("role") != -1 && ssm.getSchema(SchemaType.DYNAMIC) == null) || (ss = ssm.getSchema(SchemaType.GLOBAL)) == null || !(attrs = ss.getAttributeDefaults()).containsKey(SERVICE_OC_ATTR_NAME)) continue;
                                answer.put(service, attrs.get(SERVICE_OC_ATTR_NAME));
                            }
                            catch (SMSException smse) {
                                if (!debug.messageEnabled()) continue;
                                debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", smse);
                            }
                        }
                    }
                    serviceNameAndOCs.put(schemaType, answer);
                }
                catch (SMSException smse) {
                    if (debug.messageEnabled()) {
                        debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", smse);
                    }
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block12;
                    debug.message("ServiceManager.getServiceNamesandOCs caught SSOException ", ssoe);
                }
            }
        }
        return SMSUtils.copyAttributes(answer);
    }

    public Set getServiceVersions(String serviceName) throws SMSException {
        try {
            return ServiceManager.getVersions(this.token, serviceName);
        }
        catch (SSOException s) {
            debug.error("ServiceManager: Unable to get service versions", s);
            throw new SMSException(s, "sms-version-not-found");
        }
    }

    public Set registerServices(InputStream xmlServiceSchema) throws SMSException, SSOException {
        return this.registerServices(xmlServiceSchema, null);
    }

    public Set registerServices(InputStream xmlServiceSchema, AMEncryption decryptObj) throws SMSException, SSOException {
        String version;
        String name;
        SMSEntry.validateToken(this.token);
        HashSet<String> sNames = new HashSet<String>();
        ArrayList<Node> serviceNodes = new ArrayList<Node>();
        Document doc = SMSSchema.getXMLDocument(xmlServiceSchema);
        if (!this.validSMSDtdDocType(doc)) {
            throw new SMSException("amSDK", "sms-invalid-doctype", null);
        }
        ServiceManager.checkAndEncryptPasswordSyntax(doc, true, decryptObj);
        NodeList nodes = doc.getElementsByTagName("Service");
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node serviceNode = nodes.item(i);
            name = XMLUtils.getNodeAttributeValue(serviceNode, "name");
            version = XMLUtils.getNodeAttributeValue(serviceNode, "version");
            SMSSchema smsSchema = new SMSSchema(name, version, doc);
            if (XMLUtils.getChildNode(serviceNode, "Schema") != null) {
                ServiceManager.validateServiceSchema(serviceNode);
                ServiceSchemaManager.createService(this.token, smsSchema);
                if (serviceNames == null) {
                    serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
                }
                serviceNames.add(name);
                CachedSubEntries sVersions = (CachedSubEntries)serviceVersions.get(name);
                if (sVersions == null) {
                    sVersions = CachedSubEntries.getInstance(this.token, ServiceManager.getServiceNameDN(name));
                    serviceVersions.put(name, sVersions);
                }
                sVersions.add(version);
                sNames.add(name);
            }
            Iterator pluginNodes = XMLUtils.getChildNodes(serviceNode, "PluginSchema").iterator();
            while (pluginNodes.hasNext()) {
                Node pluginNode = (Node)pluginNodes.next();
                PluginSchema.createPluginSchema(this.token, pluginNode, smsSchema);
            }
            if (XMLUtils.getChildNode(serviceNode, "Configuration") == null) continue;
            serviceNodes.add(serviceNode);
        }
        this.clearCache();
        Iterator i = serviceNodes.iterator();
        while (i.hasNext()) {
            Node svcNode = (Node)i.next();
            name = XMLUtils.getNodeAttributeValue(svcNode, "name");
            version = XMLUtils.getNodeAttributeValue(svcNode, "version");
            Node configNode = XMLUtils.getChildNode(svcNode, "Configuration");
            CreateServiceConfig.createService(this, name, version, configNode, true);
        }
        return sNames;
    }

    private boolean validSMSDtdDocType(Document doc) {
        String dtdPath;
        boolean valid = false;
        DocumentType docType = doc.getDoctype();
        if (docType != null && (dtdPath = docType.getSystemId()) != null) {
            int idx = dtdPath.lastIndexOf(47);
            if (idx != -1) {
                dtdPath = dtdPath.substring(idx + 1);
            }
            valid = dtdPath.equals("sms.dtd");
        }
        return valid;
    }

    public void removeService(String serviceName, String version) throws SMSException, SSOException {
        if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new Object[]{serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        SMSEntry.validateToken(this.token);
        String[] objs = new String[]{serviceName};
        Iterator results = SMSEntry.search(MessageFormat.format("(&(objectclass=top)(ou={0}))", objs)).iterator();
        while (results.hasNext()) {
            CachedSMSEntry smse;
            SMSEntry e;
            Iterator versions;
            String dn = (String)results.next();
            String configdn = "ou=" + version + "," + dn;
            CachedSMSEntry configsmse = CachedSMSEntry.getInstance(this.token, configdn, null);
            SMSEntry confige = configsmse.getClonedSMSEntry();
            if (!confige.isNewEntry()) {
                confige.delete(this.token);
                configsmse.refresh(confige);
            }
            if ((versions = (e = (smse = CachedSMSEntry.getInstance(this.token, dn, null)).getSMSEntry()).subEntries(this.token, "*", 0, false, false).iterator()).hasNext()) continue;
            e.delete(this.token);
            smse.refresh(e);
        }
    }

    public void deleteService(String serviceName) throws SMSException, SSOException {
        if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new Object[]{serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        Iterator versions = this.getServiceVersions(serviceName).iterator();
        while (versions.hasNext()) {
            String version = (String)versions.next();
            CachedSMSEntry ce = CachedSMSEntry.getInstance(this.token, ServiceManager.getServiceNameDN(serviceName, version), null);
            SMSEntry e = ce.getClonedSMSEntry();
            String[] values = new String[]{SMSSchema.getDummyXML(serviceName, version)};
            e.setAttribute("sunServiceSchema", values);
            e.save(this.token);
            ce.refresh(e);
        }
    }

    public static String getBaseDN() {
        return SMSEntry.baseDN;
    }

    public static Set getAMServerInstances() {
        block6: {
            if (accessManagerServers == null) {
                try {
                    SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    accessManagerServers = ServerConfiguration.getServers(token);
                    if (debug.messageEnabled()) {
                        debug.message("ServiceManager.getAMServerInstances: server list: " + accessManagerServers);
                    }
                }
                catch (SMSException e) {
                    if (debug.warningEnabled()) {
                        debug.warning("ServiceManager.getAMServerInstances: Unable to get server list", e);
                    }
                }
                catch (SSOException e) {
                    if (!debug.warningEnabled()) break block6;
                    debug.warning("ServiceManager.getAMServerInstances: Unable to get server list", e);
                }
            }
        }
        return accessManagerServers == null ? new HashSet() : new HashSet(accessManagerServers);
    }

    public Set searchOrganizationNames(String serviceName, String attrName, Set values) throws SMSException, SSOException {
        try {
            if (this.subEntries == null) {
                this.subEntries = CachedSubEntries.getInstance(this.token, "ou=services," + SMSEntry.baseDN);
            }
            return this.subEntries.searchOrgNames(this.token, serviceName.toLowerCase(), attrName, values);
        }
        catch (SSOException ssoe) {
            debug.error("OrganizationConfigManagerImpl: Unable to get sub organization names", ssoe);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public synchronized void clearCache() {
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        schemaAndServiceNames = new CaseInsensitiveHashMap();
        serviceVersions = new CaseInsensitiveHashMap();
        serviceNameDefaultVersion = new CaseInsensitiveHashMap();
        this.serviceSchemaMgrs = new HashMap();
        this.serviceConfigMgrs = new HashMap();
        CachedSMSEntry.clearCache();
        CachedSubEntries.clearCache();
        ServiceSchemaManagerImpl.clearCache();
        PluginSchemaImpl.clearCache();
        ServiceInstanceImpl.clearCache();
        ServiceConfigImpl.clearCache();
        ServiceConfigManagerImpl.clearCache();
        OrgConfigViaAMSDK.clearCache();
        try {
            ServiceManager.checkFlags(this.token);
            OrganizationConfigManager.initializeFlags();
            DNMapper.clearCache();
        }
        catch (Exception e) {
            debug.error("ServiceManager::clearCache unable to re-initialize global flags", e);
        }
    }

    public static boolean isCoexistenceMode() {
        ServiceManager.isRealmEnabled();
        return coexistenceCache;
    }

    public static boolean isRealmEnabled() {
        if (!initialized) {
            try {
                ServiceManager.initialize((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
            }
            catch (Exception ssme) {
                debug.error("ServiceManager::isRealmEnabled unable to initialize", ssme);
            }
        }
        return realmCache;
    }

    public static boolean isAMSDKConfigured() throws SMSException {
        if (!ServiceManager.isRealmEnabled() || OrgConfigViaAMSDK.isAMSDKConfigured("/")) {
            return true;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Set realms = new OrganizationConfigManager(token, "/").getSubOrganizationNames("*", true);
        Iterator items = realms.iterator();
        while (items.hasNext()) {
            String realm = items.next().toString();
            if (!OrgConfigViaAMSDK.isAMSDKConfigured(realm)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigMigratedTo70() {
        ServiceManager.isRealmEnabled();
        return ditUpgradedCache;
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected static String getCacheIndex(String serviceName, String version) {
        StringBuffer sb = new StringBuffer(20);
        return sb.append(serviceName).append(version).toString().toLowerCase();
    }

    protected static String getServiceNameDN(String serviceName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou").append("=").append(serviceName).append(",").append(serviceDN);
        return sb.toString();
    }

    protected static String getServiceNameDN(String serviceName, String version) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou").append("=").append(version).append(",").append(ServiceManager.getServiceNameDN(serviceName));
        return sb.toString();
    }

    protected static Set getVersions(SSOToken token, String serviceName) throws SMSException, SSOException {
        CachedSubEntries sVersions = (CachedSubEntries)serviceVersions.get(serviceName);
        if (sVersions == null) {
            sVersions = CachedSubEntries.getInstance(token, ServiceManager.getServiceNameDN(serviceName));
            if (sVersions == null || sVersions.getSMSEntry().isNewEntry() || sVersions.getSubEntries(token).isEmpty()) {
                Object[] msgs = new String[]{serviceName};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
            }
            serviceVersions.put(serviceName, sVersions);
        }
        return sVersions.getSubEntries(token);
    }

    protected static String serviceDefaultVersion(SSOToken token, String serviceName) throws SMSException, SSOException {
        String version = (String)serviceNameDefaultVersion.get(serviceName);
        if (version == null) {
            Iterator iter = ServiceManager.getVersions(token, serviceName).iterator();
            if (!iter.hasNext()) {
                Object[] msgs = new String[]{serviceName};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
            }
            version = (String)iter.next();
            serviceNameDefaultVersion.put(serviceName, version);
        }
        return version;
    }

    protected static void checkServiceNameAndVersion(SSOToken t, String serviceName, String version) throws SMSException, SSOException {
        Set versions = ServiceManager.getVersions(t, serviceName);
        if (versions == null || !versions.contains(version)) {
            Object[] msgs = new String[]{serviceName};
            throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
        }
    }

    protected static void checkAndEncryptPasswordSyntax(Document doc, boolean encrypt) throws SMSException {
        ServiceManager.checkAndEncryptPasswordSyntax(doc, encrypt, null);
    }

    protected static void checkAndEncryptPasswordSyntax(Document doc, boolean encrypt, AMEncryption encryptObj) throws SMSException {
        NodeList nl = doc.getElementsByTagName("AttributeSchema");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node defaultNode;
            Node node = nl.item(i);
            String syntax = XMLUtils.getNodeAttributeValue(node, "syntax");
            if (!syntax.equals(AttributeSchema.Syntax.PASSWORD.toString())) continue;
            if (debug.messageEnabled()) {
                debug.message("ServiceManager: encrypting password syntax");
            }
            if ((defaultNode = XMLUtils.getChildNode(node, "DefaultValues")) == null) continue;
            Iterator items = XMLUtils.getChildNodes(defaultNode, "Value").iterator();
            while (items.hasNext()) {
                String encValue;
                byte[] b;
                Node valueNode = (Node)items.next();
                String value = XMLUtils.getValueOfValueNode(valueNode);
                if (encrypt) {
                    if (encryptObj != null && (value = (String)AccessController.doPrivileged(new DecodeAction(value, encryptObj))).equals("&amp;#160;")) {
                        try {
                            b = new byte[]{-96};
                            value = new String(b, "ISO-8859-1");
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                    }
                    encValue = (String)AccessController.doPrivileged(new EncodeAction(value));
                } else {
                    encValue = (String)AccessController.doPrivileged(new DecodeAction(value));
                    try {
                        b = encValue.getBytes("ISO-8859-1");
                        if (b.length == 1 && b[0] == -96) {
                            encValue = "&amp;#160;";
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    if (encryptObj != null) {
                        encValue = (String)AccessController.doPrivileged(new EncodeAction(encValue, encryptObj));
                    }
                }
                StringBuffer sb = new StringBuffer(100);
                sb.append("<Value>").append(encValue).append("</Value>");
                Document newDoc = SMSSchema.getXMLDocument(sb.toString(), false);
                Node newValueNode = XMLUtils.getRootNode(newDoc, "Value");
                Node nValueNode = doc.importNode(newValueNode, true);
                defaultNode.replaceChild(nValueNode, valueNode);
            }
        }
    }

    protected static boolean validateServiceSchema(Node serviceNode) throws SMSException {
        Node schemaRoot = XMLUtils.getChildNode(serviceNode, "Schema");
        String[] schemaNames = new String[]{"Global", "Organization", "Dynamic", "User", "Policy", "Group", "Domain"};
        for (int i = 0; i < schemaNames.length; ++i) {
            Node childNode = XMLUtils.getChildNode(schemaRoot, schemaNames[i]);
            if (childNode == null) continue;
            ServiceSchemaImpl ssi = new ServiceSchemaImpl(null, childNode);
            Map attrs = ssi.getAttributeDefaults();
            ssi.validateAttributes(attrs, false);
        }
        return true;
    }

    protected static void schemaChanged() {
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        schemaAndServiceNames = new CaseInsensitiveHashMap();
        serviceNames = null;
    }

    public static Set servicesAssignedByDefault() {
        if (!loadedAuthServices) {
            AuthenticationServiceNameProvider provider = AuthenticationServiceNameProviderFactory.getProvider();
            defaultServicesToLoad.addAll(provider.getAuthenticationServiceNames());
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::servicesAssignedByDefault:defaultServicesToLoad = " + defaultServicesToLoad);
            }
            loadedAuthServices = true;
            defaultServicesToLoad = Collections.unmodifiableSet(defaultServicesToLoad);
        }
        return defaultServicesToLoad;
    }

    static void initialize(SSOToken token) throws SMSException, SSOException {
        SMSEntry.validateToken(token);
        if (initialized) {
            return;
        }
        try {
            serviceNames = CachedSubEntries.getInstance(token, serviceDN);
            if (serviceNames.getSMSEntry().isNewEntry()) {
                if (debug.warningEnabled()) {
                    debug.warning("SeviceManager:: Root service node does not exists: " + serviceDN);
                }
                Object[] msgs = new String[]{serviceDN};
                throw new SMSException("amSDK", "sms-services_node_does_not_exist", msgs);
            }
        }
        catch (SMSException e) {
            debug.error("ServiceManager::unable to get services node: " + serviceDN, e);
            throw e;
        }
        ServiceManager.checkFlags(token);
        initialized = true;
    }

    static void checkFlags(SSOToken token) throws SMSException, SSOException {
        try {
            CachedSMSEntry entry = CachedSMSEntry.getInstance(token, REALM_ENTRY, null);
            if (!entry.isNewEntry()) {
                Set realmEntry;
                ditUpgradedCache = true;
                ServiceConfigManagerImpl ssm = ServiceConfigManagerImpl.getInstance(token, REALM_SERVICE, SERVICE_VERSION);
                ServiceConfigImpl sc = null;
                Map map = null;
                if (ssm == null || (sc = ssm.getGlobalConfig(token, null)) == null || (map = sc.getAttributes()) == null) {
                    return;
                }
                Set coexistEntry = (Set)map.get(COEXISTENCE_ATTR_NAME);
                if (coexistEntry != null && coexistEntry.contains("false")) {
                    coexistenceCache = false;
                }
                if ((realmEntry = (Set)map.get(REALM_ATTR_NAME)) != null && realmEntry.contains("true")) {
                    realmCache = true;
                }
                defaultServicesToLoad = (Set)map.get(DEFAULT_SERVICES_FOR_REALMS);
                loadedAuthServices = false;
            }
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::checkFlags:realmEnabled=" + realmCache);
                debug.message("ServiceManager::checkFlags:coexistenceMode=" + coexistenceCache);
            }
        }
        catch (SMSException e) {
            debug.error("ServiceManager::unable to check if Realm is enabled: ", e);
            throw e;
        }
    }

    public String toXML(AMEncryption encryptObj) throws SMSException, SSOException {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n").append("\n").append("<!DOCTYPE ServicesConfiguration\n").append("PUBLIC \"=//iPlanet//Service Management Services (SMS) 1.0 DTD//EN\"\n").append("\"jar://com/sun/identity/sm/sms.dtd\">\n\n");
        buff.append("<ServicesConfiguration>\n");
        Set serviceNames = this.getServiceNames();
        Iterator i = serviceNames.iterator();
        while (i.hasNext()) {
            String serviceName = (String)i.next();
            Set versions = this.getServiceVersions(serviceName);
            Iterator j = versions.iterator();
            while (j.hasNext()) {
                String version = (String)j.next();
                ServiceSchemaManager ssm = new ServiceSchemaManager(this.token, serviceName, version);
                String xml = ssm.toXML(encryptObj);
                ServiceConfigManager scm = new ServiceConfigManager(serviceName, this.token);
                int idx = xml.lastIndexOf("</Service>");
                xml = xml.substring(0, idx) + scm.toXML() + "</" + "Service" + ">";
                buff.append(xml).append("\n");
            }
        }
        buff.append("</ServicesConfiguration>\n");
        return buff.toString().replaceAll("&amp;#160;", "&#160;");
    }

    static {
        serviceDN = "ou=services," + SMSEntry.baseDN;
        REALM_ENTRY = "ou=1.0,ou=sunidentityrepositoryservice," + serviceDN;
        coexistenceCache = true;
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        schemaAndServiceNames = new CaseInsensitiveHashMap();
        serviceVersions = new CaseInsensitiveHashMap();
        serviceNameDefaultVersion = new CaseInsensitiveHashMap();
        debug = SMSEntry.debug;
    }
}

